/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.sim.common.service.InvoiceCheckService;

public class VehicleInvoiceValidUtil {
    public static void checkNullAndLength(String val, int length, String description) {
        VehicleInvoiceValidUtil.checkNull(val, description);
        VehicleInvoiceValidUtil.checkLength(val, length, description);
    }

    public static void checkNull(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidUtil_0", (String)"imc-sim-common", (Object[])new Object[0]), description));
        }
    }

    public static void checkLength(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return;
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            throw new MsgException(String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), description, length));
        }
    }

    public static String checkNullAndLengthMessage(String val, int length, String description) {
        return VehicleInvoiceValidUtil.checkNullMessage(val, description) + VehicleInvoiceValidUtil.checkLengthMessage(val, length, description);
    }

    public static String checkNullMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a;", (String)"VehicleInvoiceValidUtil_1", (String)"imc-sim-common", (Object[])new Object[0]), description);
        }
        return "";
    }

    public static String checkLengthMessage(String val, int length, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return "";
        }
        if (GBKUtils.getGBKLength((String)val) > length) {
            return String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), description, length) + ";";
        }
        return "";
    }

    public static String checkIsNumberMessage(String val, String description) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInvoiceValidUtil_0", (String)"imc-sim-common", (Object[])new Object[0]), description);
        }
        if (!BigDecimalUtil.isNumber((String)val)) {
            return String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b", (String)"VehicleInvoiceValidUtil_2", (String)"imc-sim-common", (Object[])new Object[0]), description);
        }
        return "";
    }

    public static void checkNullAndCharLength(String val, int length, String description) {
        VehicleInvoiceValidUtil.checkNull(val, description);
        VehicleInvoiceValidUtil.checkCharLength(val, length, description);
    }

    public static void checkCharLength(String val, int length, String description) {
        if (null == val) {
            return;
        }
        if (val.length() > length) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b571\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"VehicleInvoiceValidator_43", (String)"imc-sim-formplugin", (Object[])new Object[0]), description, length));
        }
    }

    public static String checkNullAndCharLengthMsg(String val, int length, String description) {
        try {
            VehicleInvoiceValidUtil.checkNullAndCharLength(val, length, description);
            return "";
        }
        catch (MsgException e) {
            return e.getErrorMsg();
        }
    }

    public static String checkCharLengthMsg(String val, int length, String description) {
        try {
            VehicleInvoiceValidUtil.checkCharLength(val, length, description);
            return "";
        }
        catch (MsgException e) {
            return e.getErrorMsg();
        }
    }
}

