/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.async;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.async.IAsyncIssueHandler;
import kd.imc.sim.async.LqAsyncIssueHandlerImpl;
import kd.imc.sim.async.RpaAsyncIssueHandlerImpl;
import kd.imc.sim.async.TgAsyncIssueHandlerImpl;
import kd.imc.sim.common.helper.IssueInvoiceFailHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;

public abstract class AbstractAsyncIssueHandler
implements IAsyncIssueHandler {
    protected static final Log LOGGER = LogFactory.getLog(AbstractAsyncIssueHandler.class);

    public static IAsyncIssueHandler getAsyncIssueHandler(String issueChannel) {
        if ("rpa".equals(issueChannel)) {
            return new RpaAsyncIssueHandlerImpl();
        }
        if ("lqpt".equals(issueChannel)) {
            return new LqAsyncIssueHandlerImpl();
        }
        return new TgAsyncIssueHandlerImpl();
    }

    public DynamicObject checkInvoiceIssue(DynamicObject asyncInvoice) {
        asyncInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_async_issue_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_async_issue_invoice"), (QFilter[])new QFilter("id", "=", asyncInvoice.getPkValue()).toArray());
        if (asyncInvoice == null) {
            return null;
        }
        DynamicObject invoice = InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(asyncInvoice.getString("invoicetype")) ? BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)String.join((CharSequence)",", "salertaxno", "orderno", "result", "govuuid", "invoiceamount", "invoiceno", "invoicetype", "specialtype", "issuetime", "issuestatus", "account"), (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray()) : BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "salertaxno", "orderno", "result", "govuuid", "invoiceamount", "invoiceno", "invoicetype", "specialtype", "issuetime", "issuestatus", "salername", "infocode", "account"), (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
        if (invoice == null || IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")) || IssueStatusEnum.failed.getCode().equals(invoice.getString("issuestatus"))) {
            DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)asyncInvoice.getString("orderno")).toArray());
            return null;
        }
        return invoice;
    }

    protected void addUpdateCount(DynamicObject asyncInvoice, List<DynamicObject> updateList) {
        if (asyncInvoice != null) {
            asyncInvoice.set("querycount", (Object)(asyncInvoice.getInt("querycount") + 1));
            updateList.add(asyncInvoice);
        }
    }

    public void handleTGInvoiceFailed(JSONObject jsonObject) {
        this.updateInvoiceStatus(jsonObject, IssueStatusEnum.failed.getCode(), true);
        DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray());
    }

    protected void updateInvoiceStatus(JSONObject jsonObject, String issueStatus, boolean clearInvoiceNo) {
        String invoiceType = jsonObject.getString("invoicetype");
        DynamicObject invoice = InvoiceUtils.isAllEVehicleInv((String)invoiceType) ? BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles"), (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray()) : BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray());
        if (invoice == null) {
            DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)jsonObject.getString("orderno")).toArray());
            return;
        }
        invoice.set("issuestatus", (Object)issueStatus);
        if (clearInvoiceNo) {
            invoice.set("invoicecode", (Object)"");
            invoice.set("invoiceno", (Object)"");
            invoice.set("issuetime", null);
        }
        invoice.set("result", (Object)jsonObject.getString("errormsg"));
        ImcSaveServiceHelper.save((DynamicObject)invoice);
        if (IssueStatusEnum.failed.getCode().equals(issueStatus) && !InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            IssueInvoiceFailHelper.createFailAutoIssueRecord((DynamicObject)invoice, (String)jsonObject.getString("errormsg"), (String)jsonObject.getString("errcode"));
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
            CallbackHelperUtil.sendErrorCallbackMessage((String)jsonObject.getString("errormsg"), (DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        }
    }

    protected void handleLqptInvoiceFailed(DynamicObject invoice, String errCode) {
        JSONObject json = new JSONObject();
        json.put("orderno", (Object)invoice.getString("orderno"));
        json.put("errormsg", (Object)invoice.getString("result"));
        json.put("errcode", (Object)errCode);
        json.put("invoicetype", (Object)invoice.getString("invoicetype"));
        this.updateRedConfirmBillStatus(invoice, IssueStatusEnum.failed.getCode());
        this.handleTGInvoiceFailed(json);
    }

    protected void updateRedConfirmBillStatus(DynamicObject invoice, String issueStatus) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "issuestatus", "failreason", "invoiceno"), (QFilter[])new QFilter("govuuid", "=", (Object)invoice.getString("govuuid")).toArray());
        if (redConfirmBill != null) {
            redConfirmBill.set("issuestatus", (Object)issueStatus);
            if (IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                redConfirmBill.set("invoiceno", (Object)"");
                RedConfirmBillHelper.setFailReason(redConfirmBill, invoice.getString("result"));
            } else {
                redConfirmBill.set("invoiceno", (Object)invoice.getString("invoiceno"));
                redConfirmBill.set("failreason", (Object)"");
            }
            ImcSaveServiceHelper.update((DynamicObject)redConfirmBill);
        }
    }
}

