/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.billcenter.domain.ApprovalProcessFlowVO;
import kd.imc.sim.common.constant.BillCenterInvoiceEnum;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import org.apache.commons.lang3.StringUtils;

public class BillCenterInvoiceLogService {
    private static final Log LOGGER = LogFactory.getLog(BillCenterInvoiceLogService.class);

    public void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNo, String paramContent, String result, String billStatus) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_log");
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)billStatus);
        dynamicObject.set("inner_param_tag", (Object)paramContent);
        dynamicObject.set("outter_param_tag", (Object)result);
        dynamicObject.set("deal_type", (Object)BillCenterInvoiceEnum.ACTIVE_DATA_TYPE.getValue());
        dynamicObject.set("system_code", (Object)systemCode);
        dynamicObject.set("operate_type", (Object)opType);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNo, String paramContent, String result) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_log");
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)BillCenterLogEnum.RECEIVE_DEAL_TYPE.getBillStatus());
        dynamicObject.set("inner_param_tag", (Object)paramContent);
        dynamicObject.set("outter_param_tag", (Object)result);
        dynamicObject.set("deal_type", (Object)BillCenterInvoiceEnum.ACTIVE_DATA_TYPE.getValue());
        dynamicObject.set("system_code", (Object)systemCode);
        dynamicObject.set("operate_type", (Object)opType);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static DynamicObject loadSingle(Object pkId) {
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_bill_log");
    }

    public DynamicObject dealLoadInvoiceLogMethod(String systemCode, String billNo) {
        QFilter qFilter = new QFilter("billno", "like", (Object)billNo).and("system_code", "=", (Object)systemCode);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_log", (boolean)true);
        DynamicObject[] invoiceLogObjects = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"createtime desc");
        if (invoiceLogObjects != null && invoiceLogObjects.length > 0) {
            return invoiceLogObjects[0];
        }
        return null;
    }

    public DynamicObject dealLoadInvoiceLogByCondition(QFilter qFilter) {
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_log", (boolean)true);
        DynamicObject[] invoiceLogObjects = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"createtime desc");
        if (invoiceLogObjects != null && invoiceLogObjects.length > 0) {
            return invoiceLogObjects[0];
        }
        return null;
    }

    public DynamicObject[] dealLoadBillCenterLogMethod(QFilter qFilter) {
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_log", (boolean)true);
        DynamicObject[] invoiceLogObjects = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"createtime desc");
        return invoiceLogObjects;
    }

    public void dealNoticeApprovalRejectMethod(JSONObject paramObject) {
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isBlank((CharSequence)paramContent)) {
            String errorMsg = ResManager.loadKDString((String)"\u9a73\u56de\u8fd4\u56de\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CenterElectronicsDataImpl_18", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        LOGGER.info("dealSaveApprovalRejectMethod, systemCode:{}, paramContent:{}", (Object)systemCode, (Object)paramContent);
        ApprovalProcessFlowVO approvalProcessFlowVo = (ApprovalProcessFlowVO)JSONObject.parseObject((String)paramContent, ApprovalProcessFlowVO.class);
        if (approvalProcessFlowVo != null) {
            approvalProcessFlowVo.setSystemCode(systemCode);
            this.dealClearApprovalDataMethod(approvalProcessFlowVo);
            this.dealSaveApprovalRejectMethod(approvalProcessFlowVo, paramContent);
            LOGGER.info("\u9a73\u56de\u901a\u77e5\u7684\u64cd\u4f5c\u7ed3\u679c\u5df2\u7ecf\u5b8c\u6210\uff01");
        }
    }

    private void dealSaveApprovalRejectMethod(ApprovalProcessFlowVO approvalProcessFlowVO, String paramContent) {
        String wxOpenId = approvalProcessFlowVO.getWxOpenId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            String systemCode = approvalProcessFlowVO.getSystemCode();
            String flowNo = approvalProcessFlowVO.getFlowNo();
            String billNoParam = wxOpenId + "-" + flowNo;
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus(), billNoParam, paramContent, null);
        }
    }

    private void dealSaveApprovalProcessMethod(ApprovalProcessFlowVO approvalProcessFlowVO, String paramContent) {
        String wxOpenId = approvalProcessFlowVO.getWxOpenId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            String systemCode = approvalProcessFlowVO.getSystemCode();
            String flowNo = approvalProcessFlowVO.getFlowNo();
            String billNoParam = wxOpenId + "-" + flowNo;
            this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.PROCESS_RESULT_OP_TYPE.getBillStatus(), billNoParam, paramContent, null);
        }
    }

    public void dealNoticeApprovalProcessMethod(JSONObject paramObject) {
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isBlank((CharSequence)paramContent)) {
            String errorMsg = ResManager.loadKDString((String)"\u8fdb\u5165\u5ba1\u6279\u4e2d\u8fd4\u56de\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CenterElectronicsDataImpl_20", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        LOGGER.info("dealNoticeApprovalProcessMethod, systemCode:{}, paramContent:{}", (Object)systemCode, (Object)paramContent);
        ApprovalProcessFlowVO approvalProcessFlowVo = (ApprovalProcessFlowVO)JSONObject.parseObject((String)paramContent, ApprovalProcessFlowVO.class);
        if (approvalProcessFlowVo != null) {
            approvalProcessFlowVo.setSystemCode(systemCode);
            this.dealSaveApprovalProcessMethod(approvalProcessFlowVo, paramContent);
            LOGGER.info("\u4fdd\u5b58\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01");
        }
    }

    public void dealNoticeApprovalSuccessMethod(JSONObject paramObject) {
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isBlank((CharSequence)paramContent)) {
            String errorMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7\u8fd4\u56de\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"CenterElectronicsDataImpl_19", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        LOGGER.info("dealNoticeApprovalSuccessMethod, paramContent:{}", (Object)paramContent);
        ApprovalProcessFlowVO approvalProcessFlowVO = (ApprovalProcessFlowVO)JSONObject.parseObject((String)paramContent, ApprovalProcessFlowVO.class);
        if (approvalProcessFlowVO != null) {
            approvalProcessFlowVO.setSystemCode(systemCode);
            this.dealClearApprovalDataMethod(approvalProcessFlowVO);
            LOGGER.info("\u6e05\u7406\u4e4b\u524d\u8fdb\u5165\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u5df2\u7ecf\u5b8c\u6210\uff01");
        }
    }

    public void dealClearApprovalDataMethod(ApprovalProcessFlowVO approvalProcessFlowVO) {
        String wxOpenId = approvalProcessFlowVO.getWxOpenId();
        if (StringUtils.isNotBlank((CharSequence)wxOpenId)) {
            String systemCode = approvalProcessFlowVO.getSystemCode();
            String flowNo = approvalProcessFlowVO.getFlowNo();
            String billNoParam = wxOpenId + "-" + flowNo;
            String opType = BillCenterLogEnum.PROCESS_RESULT_OP_TYPE.getBillStatus();
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("operate_type", "=", (Object)opType).and("billno", "=", (Object)billNoParam);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_bill_log", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                QFilter pkFilter = new QFilter("id", "=", dynamicObject.getPkValue());
                DeleteServiceHelper.delete((String)"sim_bill_log", (QFilter[])pkFilter.toArray());
            }
        }
    }

    public void dealClearApprovalDataMethod(List<String> wxOpenIdList, String systemCode) {
        String opType = BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus();
        for (String wxOpenId : wxOpenIdList) {
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("operate_type", "=", (Object)opType).and("billno", "like", (Object)(wxOpenId + "%"));
            DynamicObject[] billLogArray = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)"id", (QFilter[])qFilter.toArray());
            if (billLogArray == null || billLogArray.length == 0) continue;
            ArrayList<Long> billLogIdList = new ArrayList<Long>(billLogArray.length);
            for (DynamicObject billLogObject : billLogArray) {
                billLogIdList.add(billLogObject.getLong("id"));
            }
            LOGGER.info("dealClearApprovalDataMethod, billLogIdList\u5927\u5c0f:{}", (Object)billLogIdList.size());
            QFilter billLogFilter = new QFilter("id", "in", billLogIdList);
            DeleteServiceHelper.delete((String)"sim_bill_log", (QFilter[])billLogFilter.toArray());
            LOGGER.info("dealClearApprovalDataMethod, \u6e05\u7406\u9a73\u56de\u6570\u636e\u6210\u529f\uff01");
        }
    }
}

