/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.issuecallback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.callback.ApiCallBackHelper;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillCenterCallBackServiceImpl {
    private static final Log LOG = LogFactory.getLog(IssueInvoiceService.class);

    public void callbackByOpType(Object invoiceId, Long originalId, String opType) {
        LOG.info("callbackByOpType, \u63a5\u6536\u56de\u586b\u5904\u7406\u7684\u53d1\u7968id\u503c\u662f:{}, \u5f00\u7968\u7533\u8bf7\u5355id:{}, \u64cd\u4f5c\u7c7b\u578b:{}", new Object[]{invoiceId, originalId, opType});
        DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"sim_vatinvoice");
        if (invoiceObject == null) {
            LOG.error("callbackByOpType, \u53d1\u7968\u4e3a\u7a7a\uff0c\u4e0d\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968id\u662f%s", invoiceId);
            return;
        }
        this.dealCallBackByOpType(invoiceObject, originalId, opType);
    }

    private void dealCallBackByOpType(DynamicObject invoiceObject, Long originalId, String opType) {
        InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo((DynamicObject)invoiceObject, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_FILL_IN.getCode());
        Long[] billIds = new Long[]{originalId};
        Map targetBills = BFTrackerServiceHelper.findSourceBills((String)"sim_original_bill", (Long[])billIds);
        HashSet hashSet = (HashSet)targetBills.get("sim_isomerism_bill_data");
        if (hashSet == null) {
            LOG.error("dealCallBackByOpType, \u672a\u67e5\u8be2\u8d26\u5355\u4e2d\u5fc3\u7684\u4e3b\u952eid\u96c6\u5408\u503c\u3002");
            return;
        }
        DynamicObject[] billCenterObjects = BusinessDataServiceHelper.load((Object[])hashSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_isomerism_bill_data"));
        if (billCenterObjects == null || billCenterObjects.length == 0) {
            LOG.error("dealCallBackByOpType, \u672a\u67e5\u8be2\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u5217\u8868\u3002");
            return;
        }
        if ("callbackByFillIn".equals(opType)) {
            this.fillInvoiceDataToBillCenter(invoiceVo, billCenterObjects, invoiceObject);
            this.dealUpdateBillInvoiceDataMethod(invoiceVo, billCenterObjects);
        } else if ("callbackByCancel".equals(opType)) {
            this.dealCancelFillInMethod(invoiceVo, billCenterObjects);
        }
    }

    private void dealCancelFillInMethod(InvoiceVo invoiceVo, DynamicObject[] billCenterObjects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject billCenterObject : billCenterObjects) {
            stringBuilder.append(billCenterObject.getString("billno")).append(",");
            billCenterObject.set("invoice_amount", (Object)BigDecimal.ZERO);
            billCenterObject.set("remain_amount", (Object)billCenterObject.getBigDecimal("invoicable_amount"));
            billCenterObject.set("invoice_status", (Object)"0");
            DynamicObjectCollection invoiceList = billCenterObject.getDynamicObjectCollection("invoice");
            if (invoiceList == null) continue;
            invoiceList.clear();
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
        LOG.info("dealCancelFillInMethod\uff0c\u66f4\u65b0\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u6210\u529f\uff01");
        String systemCode = billCenterObjects[0].getString("system_code");
        String opType = BillCenterLogEnum.INVOICE_CANCEL_IN_OP_TYPE.getBillStatus();
        String billNoParam = stringBuilder.toString();
        String paramContent = this.createParamContentMethod(invoiceVo);
        this.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, null);
    }

    private String createParamContentMethod(InvoiceVo invoiceVo) {
        JSONObject paramObject = new JSONObject();
        paramObject.put("invoiceCode", (Object)invoiceVo.getInvoiceCode());
        paramObject.put("invoiceNo", (Object)invoiceVo.getInvoiceNum());
        paramObject.put("invoiceProperty", (Object)invoiceVo.getInvoiceProperty());
        paramObject.put("invoiceType", (Object)invoiceVo.getInvoiceType());
        paramObject.put("includeTaxAmount", (Object)invoiceVo.getIncludeTaxAmount());
        paramObject.put("totalTax", (Object)invoiceVo.getTotalTaxAmount());
        paramObject.put("totalAmount", (Object)invoiceVo.getTotalAmount());
        paramObject.put("invoiceDate", (Object)DateUtils.format((Date)invoiceVo.getInvoiceDate()));
        return paramObject.toJSONString();
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        try {
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u63a5\u53e3\u4ea4\u4e92\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private void fillInvoiceDataToBillCenter(InvoiceVo invoiceVo, DynamicObject[] billCenterObjects, DynamicObject dynamicObject) {
        String invoiceNo = dynamicObject.getString("invoiceno");
        String invoiceCode = dynamicObject.getString("invoicecode");
        LOG.info("fillInvoiceToBillCenter, invoiceNo:{}, invoiceCode:{}", (Object)invoiceNo, (Object)invoiceCode);
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject billCenterObject : billCenterObjects) {
            stringBuilder.append(billCenterObject.getString("billno")).append(",");
            billCenterObject.set("invoice_amount", (Object)dynamicObject.getBigDecimal("totalamount"));
            billCenterObject.set("remain_amount", (Object)BigDecimal.ZERO);
            billCenterObject.set("invoice_status", (Object)"1");
            DynamicObjectCollection invoiceList = billCenterObject.getDynamicObjectCollection("invoice");
            boolean flag = false;
            for (DynamicObject invoiceObject : invoiceList) {
                String invoiceNoDB = invoiceObject.getString("invoiceno");
                if (!StringUtils.isNotEmpty((CharSequence)invoiceNo) || !invoiceNo.equals(invoiceNoDB)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject item = invoiceList.addNew();
            item.set("invoiceno", (Object)invoiceNo);
            item.set("invoicecode", (Object)invoiceCode);
            item.set("issuetime", dynamicObject.get("issuetime"));
            item.set("invoiceamount", dynamicObject.get("invoiceamount"));
            item.set("totaltax", dynamicObject.get("totaltax"));
            item.set("totalamount", dynamicObject.get("totalamount"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
        LOG.info("fillInvoiceToBillCenter\uff0c\u66f4\u65b0\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u6210\u529f\uff01");
        String systemCode = billCenterObjects[0].getString("system_code");
        String opType = BillCenterLogEnum.INVOICE_FILL_IN_OP_TYPE.getBillStatus();
        String billNoParam = stringBuilder.toString();
        String paramContent = this.createParamContentMethod(invoiceVo);
        this.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, null);
    }

    public void callback(Object invoiceId) {
        LOG.info("\u63a5\u6536\u56de\u8c03\u5904\u7406\u7684\u53d1\u7968id\u503c\u662f:{}", invoiceId);
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])new QFilter("id", "=", invoiceId).toArray());
        if (invoice == null) {
            LOG.error("\u53d1\u7968\u4e3a\u7a7a\uff0c\u4e0d\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968id\u662f%s", invoiceId);
            return;
        }
        try {
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"sim_vatinvoice");
            this.dealPushResultStatusToSystem(invoice);
        }
        catch (Exception e) {
            LOG.error(String.format("\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\u5931\u8d25\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoice.getString("orderno")), (Throwable)e);
        }
    }

    public void callbackToSystem(String billNo, String invoice_no) {
        QFilter qFilter;
        LOG.info("callbackToSystem, billNo:{}, invoiceNo:{}", (Object)billNo, (Object)invoice_no);
        if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)invoice_no)) {
            qFilter = new QFilter("billno", "=", (Object)billNo).and("invoiceno", "=", (Object)invoice_no);
        } else if (StringUtils.isNotEmpty((CharSequence)invoice_no) && StringUtils.isEmpty((CharSequence)billNo)) {
            qFilter = new QFilter("invoiceno", "=", (Object)invoice_no);
        } else if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isEmpty((CharSequence)invoice_no)) {
            qFilter = new QFilter("billno", "=", (Object)billNo);
        } else {
            LOG.error("\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            LOG.error("\u53d1\u7968\u4e3a\u7a7a\uff0c\u4e0d\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u8ba2\u5355\u7f16\u53f7\u662f:{}", (Object)billNo);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u8ba2\u5355\u7f16\u53f7\u662f:%1$s", (String)"BillCenterCallBack_0", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        Long pkId = dynamicObject.getLong("id");
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_vatinvoice");
        this.dealPushResultStatusToSystem(invoice);
    }

    private void dealPushResultStatusToSystem(DynamicObject invoice) {
        LOG.info("\u5c06\u72b6\u6001\u56de\u4f20\u7ed9\u5230\u5916\u56f4\u5f02\u6784\u7cfb\u7edf\u5f00\u59cb\u3002\u3002\u3002");
        boolean isGiftReceipt = "12".equals(invoice.getString("buyertype"));
        String issueType = invoice.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            String buyerType = this.dealGetBlueInvoiceBuyerType(invoice);
            isGiftReceipt = "12".equals(buyerType);
        }
        LOG.info("dealPushResultStatusToSystem, isGiftReceipt:{}", (Object)isGiftReceipt);
        InvoiceVo invoiceVo = ApiCallBackHelper.invoiceDynamicConvert2InvoiceVo((DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        HashSet hashSet = new HashSet(4);
        if (isGiftReceipt) {
            DynamicObject giftReceipt = QueryServiceHelper.queryOne((String)"sim_gift_receipt", (String)"billcenterid", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
            if (giftReceipt == null) {
                DynamicObject blueInvoiceObject = this.dealGetBlueInvoiceObject(invoice);
                if (IssueType.RED_INVOICE.getTypeCode().equals(issueType) && blueInvoiceObject != null) {
                    giftReceipt = QueryServiceHelper.queryOne((String)"sim_gift_receipt", (String)"billcenterid", (QFilter[])new QFilter("orderno", "=", (Object)blueInvoiceObject.getString("orderno")).toArray());
                }
                if (giftReceipt == null) {
                    LOG.error(String.format("\u5c0f\u7968\u7801\u6ca1\u6709\u5173\u8054\u7684\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\uff0c\u4e0d\u56de\u5199\uff0c\u53d1\u7968\u4ee3\u7801[%s], \u53d1\u7968\u53f7\u7801[%s]\uff0c\u6d41\u6c34\u53f7[%s]", invoiceVo.getInvoiceCode(), invoiceVo.getInvoiceNum(), invoice.getString("orderno")));
                    return;
                }
            }
            hashSet.add(giftReceipt.getLong("billcenterid"));
        } else {
            DynamicObject[] billInvRelations = ApiCallBackHelper.getOriBillRelation((DynamicObject)invoice);
            String billNo = billInvRelations == null || billInvRelations.length == 0 ? invoiceVo.getBatch() : Stream.of(billInvRelations).map(relation -> relation.getString("sbillno")).distinct().collect(Collectors.joining(","));
            invoiceVo.setBatch(billNo);
            LOG.info("\u72b6\u6001\u56de\u4f20\u7684\u8ba2\u5355\u7f16\u53f7\u662f\uff1a{}", (Object)billNo);
            if (billInvRelations == null) {
                LOG.error(String.format("\u6ca1\u6709\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u4e0d\u56de\u5199\uff0c\u53d1\u7968\u4ee3\u7801[%s], \u53d1\u7968\u53f7\u7801[%s]\uff0c\u5355\u636e\u7f16\u53f7[%s]", invoiceVo.getInvoiceCode(), invoiceVo.getInvoiceNum(), billNo));
                return;
            }
            Map targetBills = BFTrackerServiceHelper.findSourceBills((String)"sim_original_bill", (Long[])((Long[])Arrays.stream(billInvRelations).map(relation -> relation.getLong("sbillid")).toArray(Long[]::new)));
            hashSet = (HashSet)targetBills.get("sim_isomerism_bill_data");
        }
        if (hashSet == null) {
            LOG.error("dealPushResultStatusToSystem, \u672a\u67e5\u8be2\u8d26\u5355\u4e2d\u5fc3\u7684\u4e3b\u952eid\u96c6\u5408\u503c\u3002");
            return;
        }
        DynamicObject[] billCenterObjects = BusinessDataServiceHelper.load((Object[])hashSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_isomerism_bill_data"));
        if (isGiftReceipt) {
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
                this.dealUpdateGiftReceiveDataByBlueInvoice(billCenterObjects);
                this.dealUpdateBillInvoiceDataMethod(invoiceVo, billCenterObjects);
            } else if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
                this.dealUpdateBillCenterDataByRedInvoice(invoice, billCenterObjects);
                this.dealUpdateGiftReceiveDataByRedInvoice(billCenterObjects);
            }
        } else if ("6".equals(invoice.getString("invoicestatus"))) {
            for (DynamicObject billCenterDO : billCenterObjects) {
                this.redOrCancelBillCenter(billCenterDO);
            }
            ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
        } else if (IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            this.writeBackBillCenterData(billCenterObjects);
            this.writeBackInvoiceDataMethod(invoice, billCenterObjects);
            this.dealUpdateBillInvoiceDataMethod(invoiceVo, billCenterObjects);
        } else {
            this.writeBackBillCenterRedData(invoice, billCenterObjects);
        }
        for (DynamicObject billCenterObject : billCenterObjects) {
            String billno = billCenterObject.getString("billno");
            invoiceVo.setBillNo(billno);
            String systemCode = billCenterObject.getString("system_code");
            invoiceVo.setSystemSource(systemCode);
            invoice.set("systemsource", (Object)systemCode);
            if (IssueStatusEnum.failed.getCode().equals(invoice.getString("issuestatus")) && BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode().equals(systemCode)) {
                invoiceVo.setInvoiceStatus("9999");
                new ExternalSystemDataHandler().dealUpdateOpenInvoiceStatus(invoice, invoiceVo);
                return;
            }
            LOG.info("\u72b6\u6001\u56de\u4f20\uff0c\u539f\u59cb\u8ba2\u5355\u53f7billno:{}, \u539f\u59cb\u7cfb\u7edf\u7f16\u7801systemCode:{}, \u53d1\u7968\u5bf9\u8c61invoiceVo:{}", new Object[]{billno, systemCode, SerializationUtils.toJsonString((Object)invoiceVo)});
            new ExternalSystemDataHandler().dealUpdateOpenInvoiceStatus(invoice, invoiceVo);
        }
    }

    private void dealUpdateGiftReceiveDataByBlueInvoice(DynamicObject[] billCenterObjects) {
        for (DynamicObject bill : billCenterObjects) {
            DynamicObjectCollection centerItems = bill.getDynamicObjectCollection("sim_isomerism_item_data");
            for (DynamicObject centerItem : centerItems) {
                centerItem.set("invoicedamount", centerItem.get("avg_amount"));
                centerItem.set("invoicedtax", centerItem.get("tax_amount"));
            }
            bill.set("invoice_amount", bill.get("total_amount"));
            bill.set("remain_amount", (Object)BigDecimal.ZERO);
            bill.set("invoice_status", (Object)"1");
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
    }

    private void writeBackInvoiceDataMethod(DynamicObject invoiceVo, DynamicObject[] billCenterObjects) {
        String invoiceNo = invoiceVo.getString("invoiceno");
        String invoiceCode = invoiceVo.getString("invoicecode");
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            LOG.info("writeBackInvoiceDataMethod, \u53d1\u7968\u53f7\u7801\u4e3a\u7a7a\u4e0d\u4f1a\u586b");
            return;
        }
        LOG.info("writeBackInvoiceDataMethod, invoiceNo:{}, invoiceCode:{}", (Object)invoiceNo, (Object)invoiceCode);
        for (DynamicObject billCenterDO : billCenterObjects) {
            DynamicObjectCollection invoiceList = billCenterDO.getDynamicObjectCollection("invoice");
            boolean flag = false;
            for (DynamicObject invoiceObject : invoiceList) {
                String invoiceNoDB = invoiceObject.getString("invoiceno");
                if (!StringUtils.isNotEmpty((CharSequence)invoiceNo) || !invoiceNo.equals(invoiceNoDB)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject item = invoiceList.addNew();
            item.set("invoiceno", (Object)invoiceNo);
            item.set("invoicecode", (Object)invoiceCode);
            item.set("issuetime", invoiceVo.get("issuetime"));
            item.set("invoiceamount", invoiceVo.get("invoiceamount"));
            item.set("totaltax", invoiceVo.get("totaltax"));
            item.set("totalamount", invoiceVo.get("totalamount"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
    }

    private void dealUpdateGiftReceiveDataByRedInvoice(DynamicObject[] billCenterObjects) {
        ArrayList<String> giftReceiveNoList = new ArrayList<String>(billCenterObjects.length);
        for (DynamicObject billCenterObject : billCenterObjects) {
            String giftBillNo = billCenterObject.getString("giftbillno");
            giftReceiveNoList.add(giftBillNo);
            billCenterObject.set("giftbillno", null);
            billCenterObject.set("giftstatus", (Object)"1");
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
        LOG.info("dealUpdateGiftReceiveDataByRedInvoice\uff0c\u66f4\u65b0\u8d26\u5355\u4e2d\u5fc3\u7684\u5c0f\u7968\u7801\u6570\u636e\u6210\u529f\uff01");
        if (giftReceiveNoList.size() > 0) {
            QFilter qFilter = new QFilter("billno", "in", giftReceiveNoList);
            DeleteServiceHelper.delete((String)"sim_gift_receipt", (QFilter[])qFilter.toArray());
            LOG.info("dealUpdateGiftReceiveDataByRedInvoice\uff0c\u6e05\u7406\u5c0f\u7968\u7801\u5355\u636e\u6570\u636e\u6210\u529f\uff01");
        }
    }

    private void dealUpdateBillCenterDataByRedInvoice(DynamicObject redInvoice, DynamicObject[] billCenterObjects) {
        String redInvoiceNo = redInvoice.getString("invoiceno");
        String redInvoiceCode = redInvoice.getString("invoicecode");
        LOG.info("dealUpdateBillCenterDataByRedInvoice, redInvoiceNo:{}, redInvoiceCode:{}", (Object)redInvoiceNo, (Object)redInvoiceCode);
        for (DynamicObject billCenterObject : billCenterObjects) {
            billCenterObject.set("pushamount", (Object)BigDecimal.ZERO);
            billCenterObject.set("invoice_amount", (Object)BigDecimal.ZERO);
            BigDecimal remain_amount = billCenterObject.getBigDecimal("remain_amount");
            if (remain_amount == null) {
                remain_amount = BigDecimal.ZERO;
            }
            billCenterObject.set("remain_amount", (Object)remain_amount.add(redInvoice.getBigDecimal("totalamount").abs()));
            billCenterObject.set("pushstatus", (Object)"-1");
            billCenterObject.set("invoice_status", (Object)"0");
            DynamicObjectCollection centerItems = billCenterObject.getDynamicObjectCollection("sim_isomerism_item_data");
            for (DynamicObject centerItem : centerItems) {
                String rowPushStatus = centerItem.getString("rowpushstatus");
                if ("-1".equals(rowPushStatus)) continue;
                centerItem.set("unpushamount", (Object)centerItem.getBigDecimal("avg_amount"));
                centerItem.set("unpushtax", (Object)centerItem.getBigDecimal("tax_amount"));
                centerItem.set("unpushnum", (Object)1);
                centerItem.set("rowpushstatus", (Object)"-1");
                centerItem.set("invoicedamount", (Object)BigDecimal.ZERO);
                centerItem.set("invoicedtax", (Object)BigDecimal.ZERO);
                centerItem.set("openinvoicetype", null);
            }
            DynamicObjectCollection invoiceList = billCenterObject.getDynamicObjectCollection("invoice");
            boolean flag = false;
            for (DynamicObject invoiceObject : invoiceList) {
                String invoiceNo = invoiceObject.getString("invoiceno");
                if (!StringUtils.isNotEmpty((CharSequence)redInvoiceNo) || !redInvoiceNo.equals(invoiceNo)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject item = invoiceList.addNew();
            item.set("invoiceno", (Object)redInvoiceNo);
            item.set("invoicecode", (Object)redInvoiceCode);
            item.set("issuetime", redInvoice.get("issuetime"));
            item.set("invoiceamount", redInvoice.get("invoiceamount"));
            item.set("totaltax", redInvoice.get("totaltax"));
            item.set("totalamount", redInvoice.get("totalamount"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
        LOG.info("dealUpdateBillCenterDataByRedInvoice\uff0c\u66f4\u65b0\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e\u6210\u529f\uff01");
    }

    private DynamicObject dealGetBlueInvoiceObject(DynamicObject redInvoice) {
        String infocode = redInvoice.getString("infocode");
        LOG.info("dealGetBlueInvoiceObject, infocode:{}", (Object)infocode);
        if (StringUtils.isNotBlank((CharSequence)infocode)) {
            QFilter qFilter = new QFilter("number", "=", (Object)infocode);
            DynamicObject redConfirmBillObject = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"originalinvoiceno", (QFilter[])qFilter.toArray());
            if (redConfirmBillObject == null) {
                qFilter = new QFilter("infocode", "=", (Object)infocode);
                redConfirmBillObject = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"originalinvoiceno", (QFilter[])qFilter.toArray());
            }
            if (redConfirmBillObject != null) {
                String originalinvoiceno = redConfirmBillObject.getString("originalinvoiceno");
                LOG.info("dealGetBlueInvoiceObject, originalinvoiceno:{}", (Object)originalinvoiceno);
                QFilter invoiceFilter = new QFilter("invoiceno", "=", (Object)originalinvoiceno);
                DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])invoiceFilter.toArray());
                if (blueInvoiceObject != null) {
                    LOG.info("dealGetBlueInvoiceObject\uff0c \u84dd\u7968\u4e3b\u952eid\u662f:{}, \u8d2d\u65b9\u5f00\u7968\u65b9\u5f0f:{}", blueInvoiceObject.getPkValue(), (Object)blueInvoiceObject.getString("buyertype"));
                    return blueInvoiceObject;
                }
                String blueInvoiceNo = redInvoice.getString("originalinvoiceno");
                LOG.info("dealGetBlueInvoiceObject, blueInvoiceNo:{}", (Object)blueInvoiceNo);
                blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])new QFilter("invoiceno", "=", (Object)blueInvoiceNo).toArray());
                return blueInvoiceObject;
            }
        }
        return null;
    }

    private String dealGetBlueInvoiceBuyerType(DynamicObject redInvoice) {
        DynamicObject blueInvoiceObject = this.dealGetBlueInvoiceObject(redInvoice);
        if (blueInvoiceObject != null) {
            return blueInvoiceObject.getString("buyertype");
        }
        return "0";
    }

    private void dealUpdateBillInvoiceDataMethod(InvoiceVo invoiceVo, DynamicObject[] billCenterObjects) {
        LOG.info("dealUpdateBillInvoiceDataMethod, billCenterObjects\u7684\u5927\u5c0f\u662f:{}", (Object)(billCenterObjects == null ? 0 : billCenterObjects.length));
        if (billCenterObjects == null || billCenterObjects.length == 0) {
            return;
        }
        for (DynamicObject billDataObject : billCenterObjects) {
            String buyerBankAndAccount;
            String[] bankAndAccountArray;
            if (billDataObject == null) continue;
            billDataObject.set("buyername", (Object)invoiceVo.getBuyerName());
            billDataObject.set("buyertaxno", (Object)invoiceVo.getBuyerTaxpayerId());
            String buyerAddressAndTel = invoiceVo.getBuyerAddressAndTel();
            String[] addressAndTelArray = buyerAddressAndTel.split(",");
            if (addressAndTelArray != null) {
                if (addressAndTelArray.length == 1) {
                    billDataObject.set("buyeraddr", (Object)addressAndTelArray[0]);
                } else if (addressAndTelArray.length == 2) {
                    billDataObject.set("buyeraddr", (Object)addressAndTelArray[0]);
                    billDataObject.set("buyertelno", (Object)addressAndTelArray[1]);
                }
            }
            if ((bankAndAccountArray = (buyerBankAndAccount = invoiceVo.getBuyerBankAndAccount()).split(",")) != null) {
                if (bankAndAccountArray.length == 1) {
                    billDataObject.set("buyerbank", (Object)bankAndAccountArray[0]);
                } else if (bankAndAccountArray.length == 2) {
                    billDataObject.set("buyerbank", (Object)bankAndAccountArray[0]);
                    billDataObject.set("buyerbankacc", (Object)bankAndAccountArray[1]);
                }
            }
            String buyerRecipientMail = invoiceVo.getBuyerRecipientMail();
            billDataObject.set("user_email", (Object)buyerRecipientMail);
            String invoiceType = invoiceVo.getInvoiceType();
            billDataObject.set("invoicetype", (Object)invoiceType);
            int buyerProperty = invoiceVo.getBuyerProperty();
            billDataObject.set("buyerproperty", (Object)buyerProperty);
            billDataObject.set("billstatus", (Object)"C");
            String buyerRecipientPhone = invoiceVo.getBuyerRecipientPhone();
            if (!StringUtils.isNotEmpty((CharSequence)buyerRecipientPhone)) continue;
            billDataObject.set("user_phone", (Object)buyerRecipientPhone);
        }
        SaveServiceHelper.update((DynamicObject[])billCenterObjects);
        LOG.info("\u66f4\u65b0\u8d26\u5355\u4e2d\u5fc3\u7684\u6570\u636e(\u8d2d\u4e70\u65b9\u4fe1\u606f\u548c\u7968\u79cd)\u6210\u529f\uff01");
    }

    private void writeBackBillCenterRedData(DynamicObject invoice, DynamicObject[] billCenterList) {
        String redInvoiceNo = invoice.getString("invoiceno");
        String redInvoiceCode = invoice.getString("invoicecode");
        LOG.info("writeBackBillCenterRedData, redInvoiceNo:{}, redInvoiceCode:{}", (Object)redInvoiceNo, (Object)redInvoiceCode);
        for (DynamicObject billCenterDO : billCenterList) {
            this.redOrCancelBillCenter(billCenterDO);
            DynamicObjectCollection invoiceList = billCenterDO.getDynamicObjectCollection("invoice");
            boolean flag = false;
            for (DynamicObject invoiceObject : invoiceList) {
                String invoiceNo = invoiceObject.getString("invoiceno");
                if (!StringUtils.isNotEmpty((CharSequence)redInvoiceNo) || !redInvoiceNo.equals(invoiceNo)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject item = invoiceList.addNew();
            item.set("invoiceno", (Object)redInvoiceNo);
            item.set("invoicecode", (Object)redInvoiceCode);
            item.set("issuetime", invoice.get("issuetime"));
            item.set("invoiceamount", invoice.get("invoiceamount"));
            item.set("totaltax", invoice.get("totaltax"));
            item.set("totalamount", invoice.get("totalamount"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterList);
    }

    private void redOrCancelBillCenter(DynamicObject billCenterDO) {
        if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BILL_CENTER_RED_BACK))) {
            List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)"sim_isomerism_bill_data", (Long[])new Long[]{billCenterDO.getLong("id")}, null);
            HashMap<Long, Set> relationMap = new HashMap<Long, Set>();
            HashSet<Long> tBillIds = new HashSet<Long>(bfRows.size());
            for (BFRow bfRow : bfRows) {
                DynamicObject[] tEntryIdSet = relationMap.computeIfAbsent(bfRow.getSId().getEntryId(), k -> new HashSet());
                tEntryIdSet.add(bfRow.getId().getEntryId());
                tBillIds.add(bfRow.getId().getBillId());
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("id", "in", tBillIds).toArray());
            HashMap<Long, DynamicObject> tItemsMap = new HashMap<Long, DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    tItemsMap.put(item.getLong("id"), item);
                }
            }
            boolean allClose = true;
            for (DynamicObject originalBillDO : bills) {
                if (!"0".equals(originalBillDO.getString("confirmstate"))) {
                    allClose = false;
                    continue;
                }
                originalBillDO.set("closestatus", (Object)"1");
            }
            ImcSaveServiceHelper.save((DynamicObject[])bills);
            if (allClose) {
                billCenterDO.set("pushstatus", (Object)"-1");
                billCenterDO.set("pushamount", (Object)BigDecimal.ZERO);
                billCenterDO.set("remain_amount", billCenterDO.get("invoicable_amount"));
                billCenterDO.set("invoice_amount", (Object)BigDecimal.ZERO);
                billCenterDO.set("invoice_status", (Object)"0");
                for (DynamicObject billCenterItem : billCenterDO.getDynamicObjectCollection("sim_isomerism_item_data")) {
                    billCenterItem.set("invoicedamount", (Object)BigDecimal.ZERO);
                    billCenterItem.set("invoicedtax", (Object)BigDecimal.ZERO);
                    billCenterItem.set("unpushamount", billCenterItem.get("avg_amount"));
                    billCenterItem.set("unpushtax", billCenterItem.get("tax_amount"));
                    billCenterItem.set("unpushnum", billCenterItem.get("product_quantity"));
                    billCenterItem.set("rowpushstatus", (Object)"-1");
                }
            } else {
                BigDecimal hasIssueAmount = BigDecimal.ZERO;
                for (DynamicObject billCenterItem : billCenterDO.getDynamicObjectCollection("sim_isomerism_item_data")) {
                    Set tItemIds = (Set)relationMap.get(billCenterItem.getLong("id"));
                    if (CollectionUtils.isEmpty((Collection)tItemIds)) continue;
                    BigDecimal issuedAmount = BigDecimal.ZERO;
                    BigDecimal issuedTax = BigDecimal.ZERO;
                    BigDecimal issuedNum = BigDecimal.ZERO;
                    BigDecimal canApplyAmount = BigDecimal.ZERO;
                    BigDecimal canApplyTax = BigDecimal.ZERO;
                    BigDecimal canApplyNum = BigDecimal.ZERO;
                    for (Long tEntryId : tItemIds) {
                        DynamicObject tItem = (DynamicObject)tItemsMap.get(tEntryId);
                        issuedAmount = issuedAmount.add(tItem.getBigDecimal("issuedamount"));
                        issuedTax = issuedTax.add(tItem.getBigDecimal("issuedtax"));
                        issuedNum = issuedNum.add(tItem.getBigDecimal("issuednum"));
                        canApplyAmount = canApplyAmount.add(tItem.getBigDecimal("remainvalidamount"));
                        canApplyTax = canApplyTax.add(tItem.getBigDecimal("remainvalidtax"));
                        canApplyNum = canApplyNum.add(tItem.getBigDecimal("remainvalidnum"));
                    }
                    hasIssueAmount = hasIssueAmount.add(issuedAmount.add(issuedTax));
                    if (billCenterItem.getBigDecimal("avg_amount").compareTo(issuedAmount.add(issuedTax)) == 0) continue;
                    billCenterItem.set("invoicedamount", (Object)issuedAmount.add(issuedTax));
                    billCenterItem.set("invoicedtax", (Object)issuedTax);
                    billCenterItem.set("unpushamount", (Object)canApplyAmount);
                    billCenterItem.set("unpushtax", (Object)canApplyTax);
                    billCenterItem.set("unpushnum", (Object)canApplyNum);
                    if (MathUtils.isZero((BigDecimal)issuedAmount)) {
                        billCenterItem.set("rowpushstatus", (Object)"-1");
                        continue;
                    }
                    billCenterItem.set("rowpushstatus", (Object)"0");
                }
                billCenterDO.set("pushstatus", (Object)"0");
                billCenterDO.set("pushamount", (Object)hasIssueAmount);
                billCenterDO.set("invoice_amount", (Object)hasIssueAmount);
                billCenterDO.set("remain_amount", (Object)billCenterDO.getBigDecimal("invoicable_amount").subtract(hasIssueAmount));
                billCenterDO.set("invoice_status", (Object)"2");
            }
        }
    }

    private void writeBackBillCenterData(DynamicObject[] billCenterObjects) {
        LOG.info("writeBackBillCenterData, billCenterObjects\u5927\u5c0f:{}", (Object)billCenterObjects.length);
        for (DynamicObject billCenterDO : billCenterObjects) {
            List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)"sim_isomerism_bill_data", (Long[])new Long[]{billCenterDO.getLong("id")}, null);
            HashMap<Long, Set> relationMap = new HashMap<Long, Set>();
            HashSet<Long> tBillIds = new HashSet<Long>(bfRows.size());
            for (BFRow bfRow : bfRows) {
                DynamicObject[] tEntryIdSet = relationMap.computeIfAbsent(bfRow.getSId().getEntryId(), k -> new HashSet());
                tEntryIdSet.add(bfRow.getId().getEntryId());
                tBillIds.add(bfRow.getId().getBillId());
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "billno", "validstate", "sim_original_bill_item.id", "sim_original_bill_item.issuedtotaltaxamount", "sim_original_bill_item.issuedtax"), (QFilter[])new QFilter("id", "in", tBillIds).toArray());
            HashMap<Long, DynamicObject> tItemsMap = new HashMap<Long, DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    tItemsMap.put(item.getLong("id"), item);
                }
            }
            BigDecimal hasIssueAmount = BigDecimal.ZERO;
            DynamicObjectCollection centerItems = billCenterDO.getDynamicObjectCollection("sim_isomerism_item_data");
            for (DynamicObject centerItem : centerItems) {
                Set tItemIds = (Set)relationMap.get(centerItem.getLong("id"));
                if (CollectionUtils.isEmpty((Collection)tItemIds)) continue;
                BigDecimal invoicedAmount = BigDecimal.ZERO;
                BigDecimal invoicedTax = BigDecimal.ZERO;
                for (Long tEntryId : tItemIds) {
                    DynamicObject tItem = (DynamicObject)tItemsMap.get(tEntryId);
                    invoicedAmount = invoicedAmount.add(tItem.getBigDecimal("issuedtotaltaxamount"));
                    invoicedTax = invoicedTax.add(tItem.getBigDecimal("issuedtax"));
                }
                centerItem.set("invoicedamount", (Object)invoicedAmount);
                centerItem.set("invoicedtax", (Object)invoicedTax);
                hasIssueAmount = hasIssueAmount.add(invoicedAmount);
            }
            LOG.info("\u56de\u5199\u8ba2\u5355\u4e2d\u5fc3\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5df2\u5f00\u7968\u91d1\u989d:{}", (Object)billCenterDO.getString("billno"), (Object)hasIssueAmount);
            billCenterDO.set("invoice_amount", (Object)hasIssueAmount);
            billCenterDO.set("remain_amount", (Object)billCenterDO.getBigDecimal("invoicable_amount").subtract(hasIssueAmount));
            if (hasIssueAmount.compareTo(BigDecimal.ZERO) != 0) {
                if (billCenterDO.getBigDecimal("remain_amount").compareTo(BigDecimal.ZERO) == 0) {
                    billCenterDO.set("invoice_status", (Object)"1");
                } else {
                    billCenterDO.set("invoice_status", (Object)"2");
                }
            }
            LOG.info("\u56de\u5199\u8ba2\u5355\u4e2d\u5fc3\u6570\u636e\u6210\u529f:{}", (Object)billCenterDO.getString("billno"));
        }
        ImcSaveServiceHelper.save((DynamicObject[])billCenterObjects);
    }
}

