/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.service.SimClassMappingService;
import org.apache.commons.lang3.StringUtils;

public class ExternalSystemDataHandler {
    private static final Log LOG = LogFactory.getLog(ExternalSystemDataHandler.class);

    public static JSONObject createRequestParam(JSONObject param) {
        JSONObject returnObject = new JSONObject();
        String systemCode = param.getString("sysSource");
        returnObject.put("systemCode", (Object)systemCode);
        String classImpl = ExternalSystemDataHandler.getClassImplMethod(systemCode, param);
        LOG.info("createRequestParam, classImpl:{}", (Object)classImpl);
        if (StringUtils.isEmpty((CharSequence)classImpl)) {
            return null;
        }
        if ("OperaDataImpl".equals(classImpl = classImpl.replace("kd.imc.sim.billcenter.sys.impl.", ""))) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("billNo", (Object)param.getString("ddh"));
            paramContent.put("phoneNumber", (Object)param.getString("phoneNumber"));
            paramContent.put("opKey", (Object)"APP");
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("GalaSysDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("codeNo", (Object)param.getString("ddh"));
            paramContent.put("date", (Object)param.getString("date"));
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("FuJiSysDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            String fphm = param.getString("FPHM");
            if (StringUtils.isEmpty((CharSequence)fphm)) {
                fphm = param.getString("ddh");
            }
            paramContent.put("FPHM", (Object)fphm);
            paramContent.put("SYJH", (Object)param.getString("SYJH"));
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("HeroGourmetSysDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("location", (Object)param.getString("location"));
            paramContent.put("businessDate", (Object)param.getString("businessDate"));
            paramContent.put("checkNumber", (Object)param.getString("checkNumber"));
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("CenterElectronicsDataImpl".equals(classImpl)) {
            String[] ddhs;
            JSONObject paramContent = new JSONObject();
            JSONArray billNoList = new JSONArray();
            String ddh = param.getString("ddh");
            for (String billNo : ddhs = ddh.split(",")) {
                JSONObject noObject = new JSONObject();
                noObject.put("billNo", (Object)billNo);
                billNoList.add((Object)noObject);
            }
            paramContent.put("billNoList", (Object)billNoList);
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("FuShiImageDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("billNo", (Object)param.getString("ddh"));
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("JieShunDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("billNo", (Object)param.getString("ddh"));
            paramContent.put("opKey", (Object)"APP");
            returnObject.put("paramContent", (Object)paramContent);
        } else if ("NewTaxSysDataImpl".equals(classImpl)) {
            JSONObject paramContent = new JSONObject();
            paramContent.put("billNo", (Object)param.getString("ddh"));
            returnObject.put("paramContent", (Object)paramContent);
        } else {
            LOG.info("\u5305\u88c5\u5176\u4ed6\u7cfb\u7edf\u7684\u53c2\u6570\u5f00\u59cb\u3002\u3002\u3002");
            JSONObject paramContent = new JSONObject();
            paramContent.put("billNo", (Object)param.getString("ddh"));
            paramContent.put("opKey", (Object)"APP");
            returnObject.put("paramContent", (Object)paramContent);
        }
        return returnObject;
    }

    private static ExternalSystemsDataService getExternalSystemDataServiceMethod(JSONObject paramObject) {
        String classImpl;
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        if (StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.FAIL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        if (StringUtils.isNotEmpty((CharSequence)paramContent)) {
            JSONObject jsonObject = JSONObject.parseObject((String)paramContent);
            classImpl = ExternalSystemDataHandler.getClassImplMethod(systemCode, jsonObject);
        } else {
            classImpl = ExternalSystemDataHandler.getClassImplMethod(systemCode, null);
        }
        LOG.info("getExternalSystemDataServiceMethod, classImpl:{}", (Object)classImpl);
        try {
            Class<?> clazz = Class.forName(classImpl);
            ExternalSystemsDataService externalSystemsDataService = (ExternalSystemsDataService)clazz.newInstance();
            return externalSystemsDataService;
        }
        catch (Exception e) {
            LOG.error("\u8d26\u5355\u4e2d\u5fc3\u83b7\u53d6\u5904\u7406\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static String getClassImplMethod(String systemCode, JSONObject paramObject) {
        DynamicObject dynamicObject;
        LOG.info("getClassImplMethod, systemCode:{}, paramObject:{}", (Object)systemCode, (Object)paramObject);
        if ("PW".equals(systemCode) && paramObject != null) {
            String conditionParam = null;
            if (paramObject.containsKey((Object)"ddh")) {
                conditionParam = paramObject.getString("ddh");
            } else if (paramObject.containsKey((Object)"codeNo")) {
                conditionParam = paramObject.getString("codeNo");
            } else if (paramObject.containsKey((Object)"billNo")) {
                conditionParam = paramObject.getString("billNo");
            }
            if (conditionParam != null && StringUtils.isNotBlank((CharSequence)conditionParam)) {
                String param = conditionParam.substring(0, 2);
                systemCode = systemCode + "-" + param;
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u63d0\u53d6\u7801\u7684\u89c4\u5219\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u591f\u67e5\u8be2\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"ExternalSystemDataHandler_2", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
        if ((dynamicObject = SimClassMappingService.getInterfaceByCode((String)systemCode)) == null) {
            String errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u7cfb\u7edf\u6765\u6e90\u914d\u7f6e\u6570\u636e\uff01", (String)"ExternalSystemDataHandler_1", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_TYPE_IS_ENDINFUN.getErrcode(), errorMsg), new Object[]{systemCode});
        }
        String class_name = dynamicObject.getString("class_name");
        if (StringUtils.isEmpty((CharSequence)class_name)) {
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_TYPE_IS_ENDINFUN.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        LOG.info("\u8bfb\u53d6\u6620\u5c04\u7684\u5b9e\u73b0\u5b50\u7c7b\u540d\u79f0\u662f:{}", (Object)class_name);
        return class_name;
    }

    public static List<BillVo> getExternalSystemData(JSONObject paramObject) {
        ExternalSystemsDataService externalSystemsDataService = ExternalSystemDataHandler.getExternalSystemDataServiceMethod(paramObject);
        if (externalSystemsDataService != null) {
            List<BillVo> applyBillList = externalSystemsDataService.getData(paramObject);
            return applyBillList;
        }
        LOG.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (Object)paramObject.getString("systemCode"));
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (String)"ExternalSystemDataHandler_0", (String)"imc-sim-service", (Object[])new Object[0]), paramObject.getString("systemCode")));
    }

    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        JSONObject paramObject = new JSONObject();
        String systemSource = dynamicObject.getString("systemsource");
        String systemCode = this.dealSpecialSystemCodeMethod(systemSource, invoiceVo);
        paramObject.put("systemCode", (Object)systemCode);
        ExternalSystemsDataService externalSystemsDataService = ExternalSystemDataHandler.getExternalSystemDataServiceMethod(paramObject);
        if (externalSystemsDataService == null) {
            LOG.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (Object)paramObject.getString("systemCode"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (String)"ExternalSystemDataHandler_0", (String)"imc-sim-service", (Object[])new Object[0]), paramObject.getString("systemCode")));
        }
        externalSystemsDataService.dealUpdateOpenInvoiceStatus(dynamicObject, invoiceVo);
    }

    private String dealSpecialSystemCodeMethod(String systemSource, InvoiceVo invoiceVo) {
        if ("PW".equals(systemSource) && invoiceVo != null && StringUtils.isNotEmpty((CharSequence)systemSource)) {
            String[] array;
            ArrayList<String> queryNos = new ArrayList<String>(8);
            String batch = invoiceVo.getBatch();
            for (String billNo : array = batch.split(",")) {
                queryNos.add(billNo);
            }
            String value = null;
            QFilter filter1 = new QFilter("billno", "in", queryNos);
            QFilter filter2 = new QFilter("systemsource", "=", (Object)systemSource);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"sim_original_bill", (String)"id,billno,textfield1, textfield2,textfield3", (QFilter[])new QFilter[]{filter1, filter2});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                value = dynamicObject.getString("textfield2");
            }
            LOG.info("dealSpecialSystemCodeMethod, value:{}", value);
            if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
                String param = value.substring(0, 2);
                systemSource = systemSource + "-" + param;
            }
        }
        LOG.info("dealSpecialSystemCodeMethod, systemSource:{}", (Object)systemSource);
        return systemSource;
    }

    public static void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        ExternalSystemsDataService externalSystemsDataService = ExternalSystemDataHandler.getExternalSystemDataServiceMethod(paramObject);
        if (externalSystemsDataService == null) {
            LOG.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (Object)paramObject.getString("systemCode"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (String)"ExternalSystemDataHandler_0", (String)"imc-sim-service", (Object[])new Object[0]), paramObject.getString("systemCode")));
        }
        externalSystemsDataService.dealPushCallBackStatusToFrontSystem(paramObject);
    }

    public String dealGetQrCodeMethod(JSONObject paramObject) {
        ExternalSystemsDataService externalSystemsDataService = ExternalSystemDataHandler.getExternalSystemDataServiceMethod(paramObject);
        if (externalSystemsDataService != null) {
            return externalSystemsDataService.dealGetQrCodeMethod(paramObject);
        }
        LOG.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (Object)paramObject.getString("systemCode"));
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (String)"ExternalSystemDataHandler_0", (String)"imc-sim-service", (Object[])new Object[0]), paramObject.getString("systemCode")));
    }

    public void dealPushApprovalResultMethod(JSONObject paramObject) {
        ExternalSystemsDataService externalSystemsDataService = ExternalSystemDataHandler.getExternalSystemDataServiceMethod(paramObject);
        if (externalSystemsDataService == null) {
            LOG.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:{}\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (Object)paramObject.getString("systemCode"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801:%1$s\uff0c\u672a\u5339\u914d\u76f8\u5173\u7684\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7c7b\uff01", (String)"ExternalSystemDataHandler_0", (String)"imc-sim-service", (Object[])new Object[0]), paramObject.getString("systemCode")));
        }
        externalSystemsDataService.dealPushCallBackStatusToFrontSystem(paramObject);
    }
}

