/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.sys.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.domain.NewTaxQueryOrderDataDetailVO;
import kd.imc.sim.billcenter.domain.NewTaxQueryOrderDataVO;
import kd.imc.sim.billcenter.domain.NewTaxQueryOrderVO;
import kd.imc.sim.billcenter.sys.ExternalSystemsDataService;
import kd.imc.sim.billcenter.sys.impl.OperaDataImpl;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.constant.ErrorType;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.utils.SignatureUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;

public class NewTaxSysDataImpl
implements ExternalSystemsDataService {
    private static final Log logger = LogFactory.getLog(OperaDataImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BillVo> getData(JSONObject paramObject) {
        ArrayList<BillVo> applyBillList = new ArrayList<BillVo>();
        String systemCode = paramObject.getString("systemCode");
        String paramContent = paramObject.getString("paramContent");
        logger.info("NewTaxSysDataImpl, paramContent:{}, systemCode:{}", (Object)paramContent, (Object)systemCode);
        if (StringUtils.isEmpty((CharSequence)paramContent) || StringUtils.isEmpty((CharSequence)systemCode)) {
            throw new KDBizException(new ErrorCode(ErrorType.PARAM_IS_NULL.getErrcode(), ErrorType.PARAM_IS_NULL.getDescription()), new Object[]{systemCode});
        }
        try (DLock lock = DLock.create((String)"getNewTaxOrderThread", (String)"getNewTaxOrderLogic");){
            if (lock.tryLock()) {
                block43: {
                    try {
                        String systemSource = this.dealGetSystemSourceMethod(paramContent);
                        logger.info("NewTaxSysDataImpl, dealGetSystemCodeMethod, systemSource:{}", (Object)systemSource);
                        if (StringUtils.isBlank((CharSequence)systemSource)) {
                            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u6765\u6e90\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u591f\u67e5\u8be2\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"NewTaxSysDataImpl_0", (String)"imc-sim-service", (Object[])new Object[0]);
                            throw new KDBizException(errorMsg);
                        }
                        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
                        QFilter qFilter = new QFilter("number", "=", (Object)systemSource);
                        DynamicObject frontSystemObject = orgMappingService.loadSingle(qFilter);
                        if (frontSystemObject != null) {
                            String result;
                            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
                            String client_enc_key = frontSystemObject.getString("client_enc_key");
                            String extractedCode = this.getBillNoParamMethod(paramContent);
                            boolean flag = false;
                            if (StringUtils.isNotEmpty((CharSequence)client_enc_key)) {
                                flag = Boolean.parseBoolean(client_enc_key);
                            }
                            if (flag) {
                                result = this.getTestDemo();
                            } else {
                                DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("extracted_code", extractedCode, systemSource);
                                if (dynamicObject == null) {
                                    result = this.doGetDataService(frontSystemObject, paramContent);
                                } else {
                                    String billno = dynamicObject.getString("billno");
                                    String invoice_status = dynamicObject.getString("invoice_status");
                                    String push_status = dynamicObject.getString("pushstatus");
                                    logger.info("NewTaxSysDataImpl, \u539f\u59cb\u8ba2\u5355\u7f16\u53f7:{}, \u53d1\u7968\u72b6\u6001:{}, \u4e0b\u63a8\u72b6\u6001\uff1a{}", new Object[]{billno, invoice_status, push_status});
                                    if ("1".equals(invoice_status) || "5".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u63d0\u53d6\u7801:%1$s\uff0c\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\u64cd\u4f5c\uff01", (String)"NewTaxSysDataImpl_8", (String)"imc-sim-service", (Object[])new Object[0]), extractedCode);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("2".equals(invoice_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u5177\u5269\u4f59\u53d1\u7968\u91d1\u989d\uff01", (String)"NewTaxSysDataImpl_7", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    if ("1".equals(push_status) || "0".equals(push_status)) {
                                        BillErrorVo billErrorVo = new BillErrorVo();
                                        String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u4e0b\u63a8\u6216\u90e8\u5206\u4e0b\u63a8\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u590d\u62c9\u53d6\u8d26\u5355\u6570\u636e!", (String)"GalaSysDataImpl_13", (String)"imc-sim-service", (Object[])new Object[0]);
                                        billErrorVo.setErrorMsg(errorMsg);
                                        billErrorVo.setFailNum(1);
                                        applyBillList.add((BillVo)billErrorVo);
                                        ArrayList<BillVo> arrayList = applyBillList;
                                        return arrayList;
                                    }
                                    result = this.doGetDataService(frontSystemObject, paramContent);
                                }
                            }
                            this.dealSaveInterfaceLogDataByType(systemCode, "1", extractedCode, paramContent, result);
                            this.dealCreateBillCenterDataMethod(result, systemSource, extractedCode, applyBillList);
                            flag = billCenterInvoiceCommonService.dealCheckAppOpKeyMethod(paramContent);
                            if (flag) {
                                billCenterInvoiceCommonService.dealCheckMoreThan30Method(applyBillList);
                            }
                            break block43;
                        }
                        String errorMsg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u65b0\u7968\u52a1\u7cfb\u7edf\u7684\u914d\u7f6e\u6570\u636e\uff01", (String)"NewTaxSysDataImpl_6", (String)"imc-sim-service", (Object[])new Object[0]);
                        throw new KDBizException(errorMsg);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        logger.error("\u83b7\u53d6\u65b0\u7968\u52a1\u7cfb\u7edf\u7684\u5f85\u7533\u8bf7\u5f00\u7968\u6570\u636e\u51fa\u73b0\u5f02\u5e38:{}", (Object)errorMsg);
                        BillErrorVo billErrorVo = new BillErrorVo();
                        billErrorVo.setErrorMsg(errorMsg);
                        billErrorVo.setFailNum(1);
                        applyBillList.add((BillVo)billErrorVo);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                ArrayList<BillVo> e = applyBillList;
                return e;
            }
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u626b\u7801\u62c9\u5355\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!", (String)"GalaSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private String getTestDemo() {
        String result = "{\"code\":200,\"message\":\"success\",\"traceId\":\"e7609159ccbb40db808acf52a1f1a230.105.17024571355120129\",\"data\":{\"orderTime\":\"2023-12-13 09:25:05\",\"dealCode\":\"202312131015001685\",\"products\":[]}}";
        return result;
    }

    private String dealGetSystemSourceMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String billNo = paramObject.getString("billNo");
        if (StringUtils.isNotEmpty((CharSequence)billNo) && billNo.startsWith("41")) {
            return BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode();
        }
        return null;
    }

    private String getBillNoParamMethod(String paramContent) {
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String billNo = paramObject.getString("billNo");
        return billNo;
    }

    private void dealCreateBillCenterDataMethod(String result, String systemSource, String extractedCode, List<BillVo> applyBillList) {
        NewTaxQueryOrderVO newTaxQueryOrderVO = (NewTaxQueryOrderVO)JSONObject.parseObject((String)result, NewTaxQueryOrderVO.class);
        if (newTaxQueryOrderVO == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u65b0\u7968\u52a1\u7cfb\u7edf\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"NewTaxSysDataImpl_5", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        int code = newTaxQueryOrderVO.getCode();
        String message = newTaxQueryOrderVO.getMessage();
        logger.info("dealCreateBillCenterDataMethod, code:{}, message:{}", (Object)code, (Object)message);
        if (code != 200) {
            throw new KDBizException(message);
        }
        NewTaxQueryOrderDataVO newTaxQueryOrderDataVO = newTaxQueryOrderVO.getData();
        if (newTaxQueryOrderDataVO == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u65b0\u7968\u52a1\u7cfb\u7edf\u8fd4\u56de\u7684\u5f00\u7968\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff01", (String)"NewTaxSysDataImpl_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        List<NewTaxQueryOrderDataDetailVO> products = newTaxQueryOrderDataVO.getProducts();
        if (products == null || products.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u65b0\u7968\u52a1\u7cfb\u7edf\u8fd4\u56de\u7684\u5546\u54c1\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff01", (String)"NewTaxSysDataImpl_3", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        boolean flag = false;
        String billNo = newTaxQueryOrderDataVO.getDealCode();
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        logger.info("dealCreateBillCenterDataMethod, billNo:{}, systemSource:{}", (Object)billNo, (Object)systemSource);
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo).and("system_code", "=", (Object)systemSource);
        DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_isomerism_bill_data");
        } else {
            flag = true;
        }
        logger.info("dealCreateBillCenterDataMethod, NewTaxSysDataImpl, flag:{}", (Object)flag);
        this.dealCreateBillHeaderDataMethod(dynamicObject, billNo, systemSource, extractedCode, newTaxQueryOrderDataVO);
        this.dealCreateBillItemDataMethod(dynamicObject, newTaxQueryOrderDataVO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        billCenterInvoiceCommonService.dealFormatBillDataMethod(dynamicObject, applyBillList);
    }

    private void dealCreateBillItemDataMethod(DynamicObject dynamicObject, NewTaxQueryOrderDataVO newTaxQueryOrderDataVO) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sim_isomerism_item_data");
        if (dynamicObjectCollection == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u5546\u54c1\u660e\u7ec6\u533a\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"NewTaxSysDataImpl_2", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.clear();
        }
        List<NewTaxQueryOrderDataDetailVO> products = newTaxQueryOrderDataVO.getProducts();
        int row = 1;
        String systemCode = dynamicObject.getString("system_code");
        for (NewTaxQueryOrderDataDetailVO orderDataDetailVO : products) {
            DynamicObject itemObject = dynamicObjectCollection.addNew();
            itemObject.set("product_id", (Object)row);
            itemObject.set("product_name", (Object)orderDataDetailVO.getName());
            itemObject.set("product_code", null);
            itemObject.set("product_type", (Object)orderDataDetailVO.getType());
            int quantity = orderDataDetailVO.getQty();
            if (quantity == 0) {
                quantity = 1;
            }
            itemObject.set("product_quantity", (Object)new BigDecimal(quantity));
            BigDecimal productAmount = orderDataDetailVO.getAmount();
            if (productAmount == null) {
                productAmount = BigDecimal.ZERO;
            }
            itemObject.set("product_amount", (Object)productAmount);
            BigDecimal price = orderDataDetailVO.getPrice();
            if (price == null) {
                price = new BigDecimal(((Object)productAmount).toString()).divide(new BigDecimal(quantity)).setScale(2, 4);
            }
            itemObject.set("product_price", (Object)price);
            itemObject.set("avg_amount", (Object)productAmount);
            String taxCode = orderDataDetailVO.getTaxCode();
            itemObject.set("tax_code", (Object)taxCode);
            Object taxRate = orderDataDetailVO.getTaxRate();
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            BigDecimal tax_rate = new BigDecimal(taxRate.toString()).divide(new BigDecimal(100)).setScale(2, 4);
            itemObject.set("tax_rate", (Object)tax_rate);
            boolean hasTaxFlag = orderDataDetailVO.getHasTax() == 1;
            BigDecimal taxAmount = TaxCalcUtil.calTax((BigDecimal)new BigDecimal(((Object)productAmount).toString()), (BigDecimal)BigDecimal.ZERO, (String)tax_rate.toString(), (boolean)hasTaxFlag);
            itemObject.set("tax_amount", (Object)taxAmount);
            itemObject.set("invoicable_switch", (Object)"1");
            String orderTime = newTaxQueryOrderDataVO.getOrderTime();
            Date billDate = StringUtils.isEmpty((CharSequence)orderTime) ? DateUtils.stringToDate((String)orderTime) : new Date();
            itemObject.set("consume_time", (Object)billDate);
            itemObject.set("folio_no", null);
            itemObject.set("tc_group", null);
            itemObject.set("tax_no", (Object)orderDataDetailVO.getSellerTaxId());
            itemObject.set("splitkey", (Object)orderDataDetailVO.getSellerTaxId());
            DynamicObject orgObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)orderDataDetailVO.getSellerTaxId());
            itemObject.set("orgid", (Object)orgObject);
            BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
            DynamicObject itemTypeObject = billCenterInvoiceCommonService.getBillCenterItemType(taxCode);
            itemObject.set("itemtype", (Object)itemTypeObject);
            itemObject.set("unpushamount", (Object)productAmount);
            itemObject.set("unpushtax", (Object)taxAmount);
            itemObject.set("unpushnum", (Object)quantity);
            itemObject.set("rowpushstatus", (Object)"-1");
            this.dealSetItemOpenInvoiceTypeMethod(itemObject, taxCode);
            itemObject.set("apply_no", (Object)systemCode);
            ++row;
        }
    }

    private void dealSetItemOpenInvoiceTypeMethod(DynamicObject itemObject, String taxCode) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject specialInvoiceObject = billCenterInvoiceCommonService.dealGetSpecialInvoiceMethod(null, null, null, taxCode);
        if (specialInvoiceObject == null) {
            itemObject.set("openinvoicetype", (Object)"02");
        } else {
            String is_special_invoice = specialInvoiceObject.getString("is_special_invoice");
            if (StringUtils.isBlank((CharSequence)is_special_invoice) || "0".equals(is_special_invoice)) {
                itemObject.set("openinvoicetype", (Object)"02");
            } else {
                itemObject.set("openinvoicetype", (Object)"01");
            }
        }
    }

    private void dealCreateBillHeaderDataMethod(DynamicObject dynamicObject, String billNo, String systemSource, String extractedCode, NewTaxQueryOrderDataVO newTaxQueryOrderDataVO) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("pushstatus", (Object)"-1");
        dynamicObject.set("system_code", (Object)systemSource);
        String systemName = billCenterInvoiceCommonService.getSystemNameMethod(systemSource);
        dynamicObject.set("system_name", (Object)systemName);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingleBySystemCode(systemSource);
        dynamicObject.set("system", (Object)frontSystemObject);
        dynamicObject.set("org_code", null);
        dynamicObject.set("org_name", null);
        DynamicObject orgObject = billCenterInvoiceCommonService.getOrgMethod(systemSource);
        dynamicObject.set("org", (Object)orgObject);
        dynamicObject.set("custom_name", null);
        dynamicObject.set("bill_create_time", (Object)new Date());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        String sellDate = newTaxQueryOrderDataVO.getOrderTime();
        Date billDate = StringUtils.isNotEmpty((CharSequence)sellDate) ? DateUtils.stringToDate((String)sellDate) : new Date();
        dynamicObject.set("bill_date", (Object)billDate);
        dynamicObject.set("user_phone", null);
        dynamicObject.set("remark", null);
        BigDecimal totalAmount = this.getBillTotalAmountMethod(newTaxQueryOrderDataVO);
        dynamicObject.set("total_amount", (Object)totalAmount);
        dynamicObject.set("invoicable_amount", (Object)totalAmount);
        dynamicObject.set("invoice_amount", (Object)BigDecimal.ZERO);
        dynamicObject.set("remain_amount", (Object)totalAmount);
        dynamicObject.set("invoice_status", (Object)"0");
        dynamicObject.set("extracted_code", (Object)extractedCode);
        dynamicObject.set("hsbz", (Object)"1");
    }

    private BigDecimal getBillTotalAmountMethod(NewTaxQueryOrderDataVO newTaxQueryOrderDataVO) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        List<NewTaxQueryOrderDataDetailVO> products = newTaxQueryOrderDataVO.getProducts();
        for (NewTaxQueryOrderDataDetailVO orderDataDetailVO : products) {
            totalAmount = totalAmount.add(orderDataDetailVO.getAmount());
        }
        return totalAmount;
    }

    private void dealSaveInterfaceLogDataByType(String systemCode, String opType, String billNoParam, String paramContent, String result) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, paramContent, result);
    }

    private Map<String, Object> getSignMethod(DynamicObject frontSystemObject) {
        String client_id = frontSystemObject.getString("client_id");
        String client_secret = frontSystemObject.getString("client_secret");
        HashMap signData = new HashMap();
        Map signatureInfoMap = SignatureUtils.sign((String)client_id, (String)client_secret, signData);
        return signatureInfoMap;
    }

    private String doGetDataService(DynamicObject frontSystemObject, String paramContent) throws Exception {
        String systemUrl = frontSystemObject.getString("system_url");
        Map<String, Object> signatureInfoMap = this.getSignMethod(frontSystemObject);
        String appKey = (String)signatureInfoMap.get("appKey");
        String sign = (String)signatureInfoMap.get("sign");
        String nonce = (String)signatureInfoMap.get("nonce");
        long timestamp = (Long)signatureInfoMap.get("timestamp");
        logger.info("doGetDataService, appKey:{}, sign:{}, nonce:{}, timestamp:{}", new Object[]{appKey, sign, nonce, timestamp});
        String requestUrl = systemUrl + "/aggregationapi/invoice/order/query?appKey=" + appKey + "&sign=" + sign + "&nonce=" + nonce + "&timestamp=" + timestamp;
        logger.info("doGetDataService, requestUrl:{}", (Object)requestUrl);
        JSONObject paramObject = JSONObject.parseObject((String)paramContent);
        String billNo = paramObject.getString("billNo");
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("invExtractNo", billNo);
        logger.info("NewTaxSysDataImpl, doGetDataService, \u8bf7\u6c42\u53c2\u6570\u662f\uff1a{}", (Object)billNo);
        String result = HttpClientUtils.postAppJson((String)requestUrl, null, bodyMap);
        logger.info("NewTaxSysDataImpl, doGetDataService, \u83b7\u53d6\u5f00\u7968\u6570\u636e\uff0cresult\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUpdateOpenInvoiceStatus(DynamicObject dynamicObject, InvoiceVo invoiceVo) {
        block10: {
            if (invoiceVo == null) {
                logger.error("NewTaxSysDataImpl, dealUpdateOpenInvoiceStatus, \u56de\u4f20\u5f00\u7968\u5bf9\u8c61\u4e3a\u7a7a\uff01");
                return;
            }
            BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
            String systemCode = invoiceVo.getSystemSource();
            String billNo = invoiceVo.getBillNo();
            logger.info("NewTaxSysDataImpl, dealUpdateOpenInvoiceStatus, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            String result = "";
            Map<Object, Object> bodyMap = new HashMap();
            try {
                DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
                if (frontSystemObject != null) {
                    String systemUrl = frontSystemObject.getString("system_url");
                    Map<String, Object> signatureInfoMap = this.getSignMethod(frontSystemObject);
                    String appKey = (String)signatureInfoMap.get("appKey");
                    String sign = (String)signatureInfoMap.get("sign");
                    String nonce = (String)signatureInfoMap.get("nonce");
                    long timestamp = (Long)signatureInfoMap.get("timestamp");
                    String requestUrl = systemUrl + "/aggregationapi/invoice/result/notice?appKey=" + appKey + "&sign=" + sign + "&nonce=" + nonce + "&timestamp=" + timestamp;
                    logger.info("NewTaxSysDataImpl, dealUpdateResultStatus, requestUrl:{}", (Object)requestUrl);
                    bodyMap = this.createUpdateResultStatusMethod(invoiceVo, systemCode, billNo);
                    logger.info("NewTaxSysDataImpl, dealUpdateResultStatus, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", bodyMap);
                    result = HttpClientUtils.postAppJson((String)requestUrl, null, bodyMap);
                    logger.info("NewTaxSysDataImpl, dealUpdateResultStatus, \u54cd\u5e94\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
                    break block10;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u5339\u914d\u5230\u65b0\u7968\u52a1\u7cfb\u7edf%1$s\u53c2\u6570\u914d\u7f6e\uff01", (String)"NewTaxSysDataImpl_1", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
            }
            catch (Exception e) {
                logger.error("\u63a8\u9001\u65b0\u7968\u52a1\u7cfb\u7edf\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
            }
            finally {
                JSONObject innerParamObject = new JSONObject(bodyMap);
                int invoiceProperty = invoiceVo.getInvoiceProperty();
                if (0 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParamObject.toJSONString(), result);
                    this.dealStaticsCallbackMethod(billNo, systemCode, result);
                } else if (1 == invoiceProperty) {
                    this.dealSaveInterfaceLogDataByType(systemCode, BillCenterLogEnum.RED_INV_RESULT_OP_TYPE.getBillStatus(), billNo, innerParamObject.toJSONString(), result);
                }
            }
        }
    }

    private void dealStaticsCallbackMethod(String billNo, String systemCode, String result) {
        JSONObject jsonObject;
        String code;
        String callbackStatus = StringUtils.isNotBlank((CharSequence)result) ? ("200".equals(code = (jsonObject = JSONObject.parseObject((String)result)).getString("code")) ? "1" : "2") : "2";
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("2".equals(callbackStatus)) {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, 1, callbackStatus);
        } else {
            billCenterInvoiceCommonService.dealStaticsCallbackMethod(billNo, systemCode, callbackStatus);
        }
    }

    private Map<String, Object> createUpdateResultStatusMethod(InvoiceVo invoiceVo, String systemCode, String billNo) {
        logger.info("NewTaxSysDataImpl, createUpdateResultStatusMethod, billNo:{}, batch:{}", (Object)billNo, (Object)invoiceVo.getBatch());
        String codeNo = this.dealGetCodeNoMethod(systemCode, billNo);
        logger.info("NewTaxSysDataImpl, createUpdateResultStatusMethod, codeNo\u63d0\u53d6\u7801:{}", (Object)codeNo);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("invExtractNo", codeNo);
        bodyMap.put("invInfos", this.getInvoiceInfosMethod(invoiceVo));
        return bodyMap;
    }

    private List<Map<String, String>> getInvoiceInfosMethod(InvoiceVo invoiceVo) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("invCode", invoiceVo.getInvoiceCode());
        dataMap.put("invNumber", invoiceVo.getInvoiceNum());
        dataMap.put("invDate", DateUtils.format((Date)invoiceVo.getInvoiceDate(), (String)"yyyy-MM-dd"));
        String url = invoiceVo.getInvoicePdfFileUrl();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            dataMap.put("pdfUrl", Base64.getEncoder().encodeToString(url.getBytes(StandardCharsets.UTF_8)));
        }
        dataMap.put("invVerCode", invoiceVo.getCheckCode());
        dataMap.put("sellerTaxId", invoiceVo.getSellerTaxpayerId());
        dataMap.put("invType", String.valueOf(invoiceVo.getInvoiceProperty()));
        dataMap.put("originalInvCode", invoiceVo.getOriginalInvoiceCode());
        dataMap.put("originalInvNumber", invoiceVo.getOriginalInvoiceNumber());
        if ("9999".equals(invoiceVo.getInvoiceStatus())) {
            dataMap.put("status", "9999");
            dataMap.put("errorMsg", invoiceVo.getIssueErrorMessage());
        } else {
            dataMap.put("status", "0");
        }
        dataList.add(dataMap);
        return dataList;
    }

    private String dealGetCodeNoMethod(String systemCode, String billNo) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billDataObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billDataObject != null) {
            return billDataObject.getString("extracted_code");
        }
        logger.error("NewTaxSysDataImpl, \u672a\u5339\u914d\u5230\u8d26\u5355\u4e2d\u5fc3\u7684\u539f\u59cb\u8ba2\u5355\u6570\u636e\uff01");
        return null;
    }

    @Override
    public void dealPushCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        if (paramObject.containsKey((Object)"approvalResult")) {
            billCenterInvoiceLogService.dealNoticeApprovalRejectMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalProcess")) {
            billCenterInvoiceLogService.dealNoticeApprovalProcessMethod(paramObject);
        } else if (paramObject.containsKey((Object)"approvalSuccess")) {
            billCenterInvoiceLogService.dealNoticeApprovalSuccessMethod(paramObject);
        } else {
            this.dealNoticeCallBackStatusToFrontSystem(paramObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealNoticeCallBackStatusToFrontSystem(JSONObject paramObject) {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        String systemCode = paramObject.getString("systemCode");
        String billNo = paramObject.getString("billNo");
        String innerParam = paramObject.getString("innerParam");
        String opType = paramObject.getString("opType");
        logger.info("NewTaxSysDataImpl, dealPushCallBackStatusToFrontSystem, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
        DynamicObject frontSystemObject = orgMappingService.loadSingleBySystemCode(systemCode);
        JSONObject bodyMap = new HashMap(8);
        String result = "";
        try {
            if (frontSystemObject != null) {
                JSONObject jsonObject;
                Map<String, Object> signatureInfoMap = this.getSignMethod(frontSystemObject);
                String appKey = (String)signatureInfoMap.get("appKey");
                String sign = (String)signatureInfoMap.get("sign");
                String nonce = (String)signatureInfoMap.get("nonce");
                long timestamp = (Long)signatureInfoMap.get("timestamp");
                String systemUrl = frontSystemObject.getString("system_url");
                String requestUrl = systemUrl + "/aggregationapi/invoice/result/notice?appKey=" + appKey + "&sign=" + sign + "&nonce=" + nonce + "&timestamp=" + timestamp;
                logger.info("NewTaxSysDataImpl, dealPushCallBackStatusToFrontSystem, requestUrl:{}", (Object)requestUrl);
                logger.info("NewTaxSysDataImpl, dealPushCallBackStatusToFrontSystem, innerParam:{}", (Object)innerParam);
                bodyMap = jsonObject = JSONObject.parseObject((String)innerParam);
                logger.info("NewTaxSysDataImpl, dealPushCallBackStatusToFrontSystem, \u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f\uff1a{}", (Object)bodyMap);
                result = HttpClientUtils.postAppJson((String)requestUrl, null, (Map)bodyMap);
                logger.info("NewTaxSysDataImpl, dealPushCallBackStatusToFrontSystem, \u54cd\u5e94\u8fd4\u56de\u5185\u5bb9\u662f\uff1a{}", (Object)result);
            } else {
                logger.error("\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\uff1a{}\uff0c\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u7cfb\u7edf\u914d\u7f6e\u6570\u636e\uff01", (Object)systemCode);
            }
        }
        catch (Exception e) {
            result = e.getMessage();
            logger.error("\u63a8\u9001\u65b0\u7968\u52a1\uff0c\u66f4\u65b0\u72b6\u6001\u4e0e\u7ed3\u679c\u5904\u7406\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)result);
        }
        finally {
            this.dealSaveInterfaceLogDataByType(systemCode, opType, billNo, innerParam, result);
            if (BillCenterLogEnum.BLUE_INV_RESULT_OP_TYPE.getBillStatus().equals(opType)) {
                this.dealStaticsCallbackMethod(billNo, systemCode, result);
            }
        }
    }

    @Override
    public String dealGetQrCodeMethod(JSONObject paramObject) {
        String baseUrl;
        String billNo = paramObject.getString("billNo");
        String systemCode = paramObject.getString("systemCode");
        logger.info("NewTaxSysDataImpl, dealGetQrCodeMethod, billNo:{}, systemCode:{}", (Object)billNo, (Object)systemCode);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObject billCenterDO = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
        if (billCenterDO == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7\uff1a%1$s\uff0c\u8d26\u5355\u4e2d\u5fc3\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01", (String)"HeroGourmetSysDataImpl_18", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
            throw new KDBizException(errorMsg);
        }
        BigDecimal remainAmount = billCenterDO.getBigDecimal("remain_amount");
        if (remainAmount == null || remainAmount.compareTo(BigDecimal.ZERO) == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8ba2\u5355\u5269\u4f59\u53ef\u5f00\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u60c5\u51b5\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801!", (String)"HeroGourmetSysDataImpl_19", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String ddh = billCenterDO.getString("extracted_code");
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u539f\u59cb\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        String pushStatus = billCenterDO.getString("pushstatus");
        BigDecimal invoiceAmount = billCenterDO.getBigDecimal("invoice_amount");
        if ("1".equals(pushStatus) && remainAmount.compareTo(BigDecimal.ZERO) > 0 && invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6b64\u8ba2\u5355\u5df2\u90e8\u5206\u5f00\u7968\uff0c\u4e0d\u80fd\u591f\u751f\u6210\u5c0f\u7968\u7801!", (String)"HeroGourmetSysDataImpl_20", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ddh = Base64Util.encode((byte[])ddh.getBytes(StandardCharsets.UTF_8));
        logger.info("\u8d26\u5355\u4e2d\u5fc3\u6253\u5370\u7684\u52a0\u5bc6\u8ba2\u5355\u5185\u5bb9:{}", (Object)ddh);
        try {
            baseUrl = (String)ImcConfigUtil.getValue((String)"bdm_ismc_config_move").get("bdm_ismc_config_move_cloud_url");
        }
        catch (Throwable ignore) {
            baseUrl = RequestContext.get().getClientFullContextPath();
        }
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            String errorMsg = ResManager.loadKDString((String)"\u6253\u5370\u5c0f\u7968\u7801\u7684\u524d\u7f00\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6253\u5370\uff01", (String)"BillCenterPrint_0", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        return String.format("%s?businessScene=5&billSource=billCenter&sysSource=%s&ddh=%s", baseUrl, systemCode, ddh);
    }
}

