/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.billcenter.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.ParameterSetter;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;

public class JdbcUtil {
    private static final Log logger = LogFactory.getLog(JdbcUtil.class);

    public static Connection getConnection(String driverName, String dbAddress, String dbUserName, String dbPassword) throws Exception {
        Class.forName(driverName);
        Connection connection = DriverManager.getConnection(dbAddress, dbUserName, dbPassword);
        return connection;
    }

    public static Connection getConnection(DynamicObject frontSystemObject) throws Exception {
        String driverName = frontSystemObject.getString("driver_name");
        Class.forName(driverName);
        String dbAddress = frontSystemObject.getString("db_address");
        String dbUserName = frontSystemObject.getString("db_username");
        String dbPassword = frontSystemObject.getString("db_password");
        Connection connection = DriverManager.getConnection(dbAddress, dbUserName, dbPassword);
        return connection;
    }

    public static Connection getConnection(String systemCode) throws Exception {
        BillCenterOrgMappingService orgMappingService = new BillCenterOrgMappingService();
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        DynamicObject frontSystemObject = orgMappingService.loadSingle(qFilter);
        if (frontSystemObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\uff1a%1$s\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\uff01", (String)"JdbcUtil_0", (String)"imc-sim-service", (Object[])new Object[0]), systemCode));
        }
        String driverName = frontSystemObject.getString("driver_name");
        Class.forName(driverName);
        String dbAddress = frontSystemObject.getString("db_address");
        String dbUserName = frontSystemObject.getString("db_username");
        String dbPassword = frontSystemObject.getString("db_password");
        Connection connection = DriverManager.getConnection(dbAddress, dbUserName, dbPassword);
        return connection;
    }

    public static void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterSetter.set((PreparedStatement)stmt, (Object)params[i], (int)(i + 1));
            }
        }
    }

    public static void close(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception e1) {
                logger.error("\u5173\u95ed\u7ed3\u679c\u96c6\u6d41\u51fa\u73b0\u5f02\u5e38:{}", (Object)e1.getMessage());
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e2) {
                logger.error("\u5173\u95ed\u9884\u7f16\u7801\u5904\u7406\u7684\u6d41\u51fa\u73b0\u5f02\u5e38:{}", (Object)e2.getMessage());
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e3) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5904\u7406\u6d41\u51fa\u73b0\u5f02\u5e38:{}", (Object)e3.getMessage());
            }
        }
    }
}

