/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.bdm.lqpt.service.collect.InvoiceCollectionService;

public class RimLqptQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(RimLqptQueryHelper.class);

    public InvoiceStatusQueryResponse invoiceAccountingQuery(String taxNo, String invoiceType, String invoiceCode, String invoiceNo, Date issueTime) {
        try {
            JSONObject json = new JSONObject();
            json.put("nsrsbh", (Object)taxNo);
            json.put("fpdm", (Object)invoiceCode);
            json.put("fphm", (Object)invoiceNo);
            json.put("fplx", (Object)InvoiceType.getRimLqptCodeByTypeCode((String)invoiceType));
            json.put("kprq", (Object)DateUtils.format((Date)issueTime, (String)"yyyyMMdd"));
            json.put("api_type", (Object)"FPZTXXCX");
            JSONObject responseJson = new InvoiceCollectionService().send(json);
            if (ErrorType.SUCCESS.getCode().equals(responseJson.getString("errcode"))) {
                return (InvoiceStatusQueryResponse)JSONObject.parseObject((String)responseJson.getString("data"), InvoiceStatusQueryResponse.class);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u5f52\u96c6\u80fd\u529b\u53d1\u7968\u7528\u9014\u72b6\u6001\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return new InvoiceStatusQueryResponse();
    }
}

