/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DBUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.BillIssueStatus;
import kd.imc.sim.common.constant.InvoiceSource;
import kd.imc.sim.common.dto.bill.ConfrimBillInvoiceDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import org.apache.commons.lang3.StringUtils;

public class OriginalBillRelateInvoicesHelper {
    public static void showRelateInvoicesEntry(Object[] originalPks, IDataModel model) {
        QFilter qFilter;
        originalPks = Arrays.stream(originalPks).map(pk -> Long.parseLong(String.valueOf(pk))).toArray();
        ArrayList<ConfrimBillInvoiceDTO> list = new ArrayList<ConfrimBillInvoiceDTO>(OriginalBillRelateInvoicesHelper.queryWriteBackInvoice(originalPks));
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])new QFilter("sbillid", "in", (Object)originalPks).toArray());
        HashSet<Long> invoiceIds = new HashSet<Long>();
        HashSet<Long> redInfoIds = new HashSet<Long>();
        HashSet<Long> redConfirmIds = new HashSet<Long>();
        for (DynamicObject relation : relations) {
            String tableName = relation.getString("ttable");
            long tBillId = relation.getLong("tbillid");
            if ("sim_vatinvoice".equals(tableName)) {
                invoiceIds.add(relation.getLong("tbillid"));
                continue;
            }
            if ("sim_red_info".equals(tableName)) {
                redInfoIds.add(tBillId);
                continue;
            }
            if (!"sim_red_confirm_bill".equals(tableName)) continue;
            redConfirmIds.add(tBillId);
        }
        if (!CollectionUtils.isEmpty(invoiceIds)) {
            qFilter = new QFilter("id", "in", invoiceIds).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])qFilter.toArray());
            list.addAll(OriginalBillRelateInvoicesHelper.createDtoFromInvoice(invoices));
        }
        if (!CollectionUtils.isEmpty(redInfoIds)) {
            qFilter = new QFilter("id", "in", redInfoIds);
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info"), (QFilter[])qFilter.toArray());
            list.addAll(OriginalBillRelateInvoicesHelper.createDtoFromRedInfo(redInfos));
        }
        if (!CollectionUtils.isEmpty(redConfirmIds)) {
            qFilter = new QFilter("id", "in", redConfirmIds);
            DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])qFilter.toArray());
            list.addAll(OriginalBillRelateInvoicesHelper.createDtoFromRedConfirmBill(redConfirmBills));
        }
        Map<Object, Object> skipInfo = new HashMap<String, String>();
        skipInfo.put("issuedNum", "0");
        skipInfo.put("totalNum", "0");
        if (!CollectionUtils.isEmpty(list)) {
            skipInfo = OriginalBillRelateInvoicesHelper.fillInEntryEntity(model, list);
        }
        String issuedNum = (String)skipInfo.get("issuedNum");
        String totalNum = (String)skipInfo.get("totalNum");
        String invoiceAmount = null == skipInfo.get("invoiceAmount") ? "0.00" : (String)skipInfo.get("invoiceAmount");
        String totalTax = null == skipInfo.get("totalTax") ? "0.00" : (String)skipInfo.get("totalTax");
        String totalAmount = null == skipInfo.get("totalAmount") ? "0.00" : (String)skipInfo.get("totalAmount");
        model.setValue("description", (Object)ResManager.loadKDString((String)"\u5df2\u5f00\u53d1\u7968/\u53d1\u7968\u603b\u6570:", (String)"OriginalBillRelateInvoicesHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        model.setValue("billdescription", (Object)(issuedNum + "/" + totalNum));
        model.setValue("description1", (Object)ResManager.loadKDString((String)"\u5df2\u5f00\u53d1\u7968\u5408\u8ba1:", (String)"OriginalBillRelateInvoicesHelper_1", (String)"imc-sim-service", (Object[])new Object[0]));
        model.setValue("billdescription1", (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d:%1$s   \u53d1\u7968\u7a0e\u989d:%2$s   \u4ef7\u7a0e\u5408\u8ba1:%3$s", (String)"OriginalBillRelateInvoicesHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), invoiceAmount, totalTax, totalAmount));
    }

    private static List<ConfrimBillInvoiceDTO> createDtoFromRedInfo(DynamicObject[] redInfos) {
        ArrayList<ConfrimBillInvoiceDTO> result = new ArrayList<ConfrimBillInvoiceDTO>(redInfos.length);
        for (DynamicObject redInfo : redInfos) {
            ConfrimBillInvoiceDTO dto = new ConfrimBillInvoiceDTO();
            dto.setInvoiceCode(redInfo.getString("invoicecode"));
            dto.setInvoiceNo(redInfo.getString("invoiceno"));
            if (StringUtils.isNotBlank((CharSequence)redInfo.getString("invoiceno"))) {
                dto.setBillIssueStatus(BillIssueStatus.ISSUE_SUCCESS);
                QFilter invoiceFilter = InvoiceUtils.getInvoiceFilter((Object)redInfo.getString("invoicecode"), (Object)redInfo.getString("invoiceno"));
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])invoiceFilter.toArray());
                if (invoice != null) {
                    result.addAll(OriginalBillRelateInvoicesHelper.createDtoFromInvoice(new DynamicObject[]{invoice}));
                    dto.setInvoiceStatus(invoice.getString("invoicestatus"));
                    dto.setIssuetime(invoice.getDate("issuetime"));
                }
            } else {
                dto.setBillIssueStatus(BillIssueStatus.NOT_ISSUE);
            }
            dto.setIssuetime(redInfo.getDate("issuetime"));
            dto.setTotalAmount(redInfo.getBigDecimal("totalamount"));
            dto.setTotalTax(redInfo.getBigDecimal("totaltax"));
            dto.setInvoiceAmount(redInfo.getBigDecimal("invoiceamount"));
            dto.setInvoiceType(redInfo.getString("invoicetype"));
            dto.setIssueBillNo(redInfo.getString("billno"));
            dto.setBatchOrInfoId(redInfo.getPkValue());
            dto.setType(ConfrimBillInvoiceDTO.TYPE_REDINFO);
            dto.setSource(redInfo.getString("infosource"));
            result.add(dto);
        }
        return result;
    }

    private static List<ConfrimBillInvoiceDTO> createDtoFromRedConfirmBill(DynamicObject[] redConfirmBills) {
        ArrayList<ConfrimBillInvoiceDTO> result = new ArrayList<ConfrimBillInvoiceDTO>(redConfirmBills.length);
        for (DynamicObject redConfirmBill : redConfirmBills) {
            ConfrimBillInvoiceDTO dto = new ConfrimBillInvoiceDTO();
            dto.setInvoiceNo(redConfirmBill.getString("invoiceno"));
            if (StringUtils.isNotBlank((CharSequence)redConfirmBill.getString("invoiceno"))) {
                dto.setBillIssueStatus(BillIssueStatus.ISSUE_SUCCESS);
                QFilter invoiceFilter = InvoiceUtils.getInvoiceFilter((Object)"", (Object)redConfirmBill.getString("invoiceno"));
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])invoiceFilter.toArray());
                if (invoice != null) {
                    result.addAll(OriginalBillRelateInvoicesHelper.createDtoFromInvoice(new DynamicObject[]{invoice}));
                    dto.setInvoiceStatus(invoice.getString("invoicestatus"));
                    dto.setIssuetime(invoice.getDate("issuetime"));
                }
            } else {
                dto.setBillIssueStatus(BillIssueStatus.NOT_ISSUE);
            }
            dto.setTotalAmount(redConfirmBill.getBigDecimal("totalamount"));
            dto.setTotalTax(redConfirmBill.getBigDecimal("totaltax"));
            dto.setInvoiceAmount(redConfirmBill.getBigDecimal("invoiceamount"));
            dto.setInvoiceType(redConfirmBill.getString("invoicetype"));
            dto.setIssueBillNo(redConfirmBill.getString("billno"));
            dto.setBatchOrInfoId(redConfirmBill.getPkValue());
            dto.setType(ConfrimBillInvoiceDTO.TYPE_REDCONFIRMBILL);
            dto.setSource(redConfirmBill.getString("source"));
            dto.setInvoiceSource(InvoiceSource.RED_CONFIRM);
            result.add(dto);
        }
        return result;
    }

    private static List<ConfrimBillInvoiceDTO> createDtoFromInvoice(DynamicObject[] invoices) {
        ArrayList<ConfrimBillInvoiceDTO> result = new ArrayList<ConfrimBillInvoiceDTO>(invoices.length);
        for (DynamicObject invoice : invoices) {
            ConfrimBillInvoiceDTO dto = new ConfrimBillInvoiceDTO();
            dto.setInvoiceCode(invoice.getString("invoicecode"));
            dto.setInvoiceNo(invoice.getString("invoiceno"));
            dto.setInvoiceStatus(invoice.getString("invoicestatus"));
            dto.setIssuetime(invoice.getDate("issuetime"));
            dto.setTotalAmount(invoice.getBigDecimal("totalamount"));
            dto.setTotalTax(invoice.getBigDecimal("totaltax"));
            dto.setInvoiceAmount(invoice.getBigDecimal("invoiceamount"));
            dto.setType(ConfrimBillInvoiceDTO.TYPE_INVOICE);
            dto.setInvoiceType(invoice.getString("invoicetype"));
            dto.setBillIssueStatus(BillIssueStatus.ISSUE_SUCCESS);
            dto.setIssueBillNo(invoice.getString("billno"));
            dto.setBillIssueStatus(BillIssueStatus.ISSUE_SUCCESS);
            dto.setBatchOrInfoId(invoice.getPkValue());
            dto.setType(ConfrimBillInvoiceDTO.TYPE_INVOICE);
            dto.setSource(invoice.getString("buyertype"));
            result.add(dto);
        }
        return result;
    }

    private static List<ConfrimBillInvoiceDTO> queryWriteBackInvoice(Object[] originalPks) {
        QFilter filter = new QFilter("originalbillid", "in", (Object)originalPks).and(BillHelper.notCancelFilter());
        DynamicObject[] addInvoices = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)true), (QFilter[])filter.toArray());
        ArrayList<ConfrimBillInvoiceDTO> result = new ArrayList<ConfrimBillInvoiceDTO>();
        if (addInvoices.length == 0) {
            return result;
        }
        HashMap<String, ConfrimBillInvoiceDTO> invoiceDTOMap = new HashMap<String, ConfrimBillInvoiceDTO>();
        HashMap<String, DynamicObject> invoiceMap = new HashMap<String, DynamicObject>();
        for (DynamicObject addInvoice : addInvoices) {
            String invoiceCode = addInvoice.getString("invoicecode");
            String invoiceNo = addInvoice.getString("invoiceno");
            String key = invoiceCode + invoiceNo;
            ConfrimBillInvoiceDTO dto = (ConfrimBillInvoiceDTO)invoiceDTOMap.get(key);
            if (dto == null) {
                dto = new ConfrimBillInvoiceDTO();
                result.add(dto);
                dto.setTotalTax(BigDecimal.ZERO);
                dto.setTotalAmount(BigDecimal.ZERO);
                dto.setInvoiceAmount(BigDecimal.ZERO);
                invoiceDTOMap.put(key, dto);
                dto.setInvoiceType(addInvoice.getString("invoicetype"));
                dto.setIssuetime(addInvoice.getDate("issuetime"));
                dto.setInvoiceCode(addInvoice.getString("invoicecode"));
                dto.setInvoiceNo(addInvoice.getString("invoiceno"));
                dto.setBillIssueStatus(BillIssueStatus.ISSUE_SUCCESS);
                dto.setType(ConfrimBillInvoiceDTO.TYPE_INVOICE);
                OriginalBillRelateInvoicesHelper.setInvoiceStatus(invoiceMap, addInvoice, dto);
                dto.setWriteBackSerialNo(addInvoice.getString("serialno"));
                dto.setIssueBillNo(addInvoice.getString("billno"));
            }
            dto.setTotalTax(dto.getTotalTax().add(addInvoice.getBigDecimal("totaltax")));
            dto.setInvoiceAmount(dto.getInvoiceAmount().add(addInvoice.getBigDecimal("invoiceamount")));
            dto.setTotalAmount(dto.getTotalAmount().add(addInvoice.getBigDecimal("totalamount")));
        }
        return result;
    }

    private static void setInvoiceStatus(Map<String, DynamicObject> invoiceMap, DynamicObject addInvoice, ConfrimBillInvoiceDTO dto) {
        String invoicePk = addInvoice.getString("invoiceid");
        if (StringUtils.isBlank((CharSequence)invoicePk)) {
            dto.setInvoiceStatus("0");
            return;
        }
        if (StringUtils.isBlank((CharSequence)dto.getInvoiceStatus())) {
            DynamicObject invoice = invoiceMap.get(invoicePk);
            if (invoice != null) {
                dto.setInvoiceStatus(invoice.getString("invoicestatus"));
            } else {
                DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id,invoicestatus", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(invoicePk)).toArray());
                if (invoiceArray.length > 0) {
                    dto.setInvoiceStatus(invoiceArray[0].getString("invoicestatus"));
                    invoiceMap.put(invoicePk, invoiceArray[0]);
                } else {
                    dto.setInvoiceStatus("0");
                }
            }
        }
    }

    private static Map<String, String> fillInEntryEntity(IDataModel model, List<ConfrimBillInvoiceDTO> dtos) {
        HashMap<String, String> result = new HashMap<String, String>();
        int issuedNum = 0;
        int rowindex = -1;
        int totalNum = 0;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        HashSet<String> billNos = new HashSet<String>();
        if (null != dtos && dtos.size() > 0) {
            for (ConfrimBillInvoiceDTO dto : dtos) {
                model.createNewEntryRow("entryentity");
                model.setValue("billno", (Object)dto.getIssueBillNo(), ++rowindex);
                billNos.add(dto.getIssueBillNo());
                model.setValue("invoicetype", (Object)dto.getInvoiceType(), rowindex);
                if (ConfrimBillInvoiceDTO.TYPE_INVOICE.equalsIgnoreCase(dto.getType())) {
                    totalTax = totalTax.add(dto.getTotalTax());
                    totalAmount = totalAmount.add(dto.getTotalAmount());
                    invoiceAmount = invoiceAmount.add(dto.getInvoiceAmount());
                }
                model.setValue("date", (Object)dto.getIssuetime(), rowindex);
                model.setValue("issuestatus", (Object)dto.getBillIssueStatus().getStatusCode(), rowindex);
                model.setValue("invoiceno", (Object)dto.getInvoiceNo(), rowindex);
                if (StringUtils.isNotBlank((CharSequence)dto.getInvoiceNo()) && InvoiceSource.RED_INFO != dto.getInvoiceSource() && InvoiceSource.RED_CONFIRM != dto.getInvoiceSource()) {
                    ++issuedNum;
                }
                model.setValue("invoiceCode", (Object)dto.getInvoiceCode(), rowindex);
                model.setValue("invoiceamount", (Object)dto.getInvoiceAmount(), rowindex);
                model.setValue("totalamount", (Object)dto.getTotalAmount(), rowindex);
                model.setValue("totaltax", (Object)dto.getTotalTax(), rowindex);
                model.setValue("invoicestatus", (Object)dto.getInvoiceStatus(), rowindex);
                model.setValue("type", (Object)dto.getType(), rowindex);
                model.setValue("writebackno", (Object)dto.getWriteBackSerialNo(), rowindex);
                model.setValue("sourceId", dto.getBatchOrInfoId(), rowindex);
            }
        }
        totalNum = billNos.size();
        result.put("issuedNum", String.valueOf(issuedNum));
        result.put("totalNum", String.valueOf(totalNum));
        result.put("totalTax", totalTax.setScale(2, RoundingMode.HALF_UP).toPlainString());
        result.put("totalAmount", totalAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        result.put("invoiceAmount", invoiceAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        return result;
    }

    public static void showRedInfo(Object redInfoPk, AbstractFormPlugin plugin) {
        BillShowParameter listParam = new BillShowParameter();
        listParam.setPkId(redInfoPk);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.setFormId("sim_red_info");
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "sim_red_info"));
        listParam.setCustomParam("billListHyperLinkClick", (Object)"billListHyperLinkClick");
        plugin.getView().showForm((FormShowParameter)listParam);
    }

    public static void showRedConfirm(Object redConfirmPk, AbstractFormPlugin plugin) {
        BillShowParameter listParam = new BillShowParameter();
        listParam.setPkId(redConfirmPk);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.setFormId("sim_red_confirm_bill");
        listParam.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "sim_red_confirm_bill"));
        plugin.getView().showForm((FormShowParameter)listParam);
    }

    public static void invoiceShow(Object invoiceCode, Object invoiceNo, AbstractFormPlugin plugin) {
        QFilter filter = new QFilter("invoiceno", "=", invoiceNo).and(new QFilter("invoicecode", "=", invoiceCode));
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)DBUtils.getQueryFields((String[])new String[]{"id", "ofdstatus", "orderno", "salertaxno", "pdffileurl"}), (QFilter[])filter.toArray());
        if (null != invoiceArray && invoiceArray.length > 0) {
            long invoicePk = invoiceArray[0].getLong("id");
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoicePk, (String)"sim_vatinvoice");
            InvoiceQueryControl.showInvoiceView(plugin, invoice);
        }
    }
}

