/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.FiArFinArBillHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OriginSelectInvoiceControl {
    private static final Log LOGGER = LogFactory.getLog(OriginSelectInvoiceControl.class);
    public static final String INVOICE_PK = "invoicepk";
    public static final String SIM_BILL_PROCESS_REVERSE = "sim_bill_process_reverse";
    public static final String OPERATE_KEY = "operateKey";
    public static Set<String> operationSet = Sets.newHashSet((Object[])new String[]{"bill_red", "bill_red_reopen", "bill_invalid", "bill_invalid_reopen", "bill_reopen"});
    public static Set<String> invalidSet = Sets.newHashSet((Object[])new String[]{"bill_invalid", "bill_invalid_reopen"});
    public static Set<String> redSet = Sets.newHashSet((Object[])new String[]{"bill_red", "bill_red_reopen"});

    public static void initData(AbstractFormPlugin that) {
        FormShowParameter parameter = that.getView().getFormShowParameter();
        String operateKey = (String)parameter.getCustomParam(OPERATE_KEY);
        List invoiceList = (List)parameter.getCustomParam("invoiceList");
        that.getPageCache().put(OPERATE_KEY, operateKey);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            HashMap param = new HashMap(8);
            param.put("invoicePairList", new ArrayList());
            that.getView().returnDataToParent(param);
            that.getView().close();
            return;
        }
        that.getView().getModel().batchCreateNewEntryRow("entryentity", invoiceList.size());
        for (int i = 0; i < invoiceList.size(); ++i) {
            JSONObject invoice = (JSONObject)invoiceList.get(i);
            that.getView().getModel().setValue("orgid", (Object)invoice.getJSONObject("orgid").getLong("id"), i);
            that.getView().getModel().setValue(INVOICE_PK, (Object)invoice.getLong("id"), i);
            that.getView().getModel().setValue("issuestatus", (Object)IssueStatusEnum.ok.getCode(), i);
            that.getView().getModel().setValue("invoiceno", (Object)invoice.getString("invoiceno"), i);
            that.getView().getModel().setValue("invoicecode", (Object)invoice.getString("invoicecode"), i);
            that.getView().getModel().setValue("invoicetype", (Object)invoice.getString("invoicetype"), i);
            that.getView().getModel().setValue("issuetime", (Object)invoice.getString("issuetime"), i);
            that.getView().getModel().setValue("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount"), i);
            that.getView().getModel().setValue("totaltax", (Object)invoice.getBigDecimal("totaltax"), i);
            that.getView().getModel().setValue("totalamount", (Object)invoice.getBigDecimal("totalamount"), i);
            if (!"bill_reopen".equals(operateKey) || !"B".equals(invoice.getString("billsourcetype"))) continue;
            that.getView().getModel().setValue("invoiceno", (Object)invoice.getString("blueinvoiceno"), i);
            that.getView().getModel().setValue("invoicecode", (Object)invoice.getString("blueinvoicecode"), i);
            that.getView().getModel().setValue("invoicetype", (Object)invoice.getString("blueinvoicetype"), i);
            that.getView().getModel().setValue("issuetime", (Object)invoice.getString("originalissuetime"), i);
            that.getView().getModel().setValue("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount").negate(), i);
            that.getView().getModel().setValue("totaltax", (Object)invoice.getBigDecimal("totaltax").negate(), i);
            that.getView().getModel().setValue("totalamount", (Object)invoice.getBigDecimal("totalamount").negate(), i);
        }
    }

    public static List<DynamicObject> geFilterInvoice(Object[] keys, String operateKey) {
        DynamicObject[] invoices = OriginSelectInvoiceControl.getDynamicObjectByKeys(keys, operateKey);
        if ("bill_reopen".equals(operateKey)) {
            return Stream.of(invoices).collect(Collectors.toList());
        }
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            if (!IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")) || !InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus")) || invoice.getString("occupystatus").equals("1") || OriginSelectInvoiceControl.isRedOperation(operateKey) && invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0) continue;
            invoiceList.add(invoice);
        }
        return invoiceList;
    }

    public static DynamicObject[] getDynamicObjectByKeys(Object[] value, String operateKey) {
        if ("bill_reopen".equals(operateKey)) {
            return OriginSelectInvoiceControl.queryReverseBill(value);
        }
        ArrayList invoiceIds = Lists.newArrayList();
        DynamicObject[] relations = OriginSelectInvoiceControl.loadRelationByBillIds(value);
        if (relations.length == 0) {
            return new DynamicObject[0];
        }
        if (OriginSelectInvoiceControl.isInvalidOperation(operateKey)) {
            OriginSelectInvoiceControl.getRedInvoice(invoiceIds, relations);
        }
        invoiceIds.addAll(Arrays.stream(relations).map(e -> e.getLong("tbillid")).collect(Collectors.toList()));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        LOGGER.info(String.format("getDynamicObjectByKeys invoiceIds:%s", SerializationUtils.toJsonString((Object)invoiceIds)));
        return BusinessDataServiceHelper.load((Object[])invoiceIds.toArray(), (DynamicObjectType)dataEntityType);
    }

    private static DynamicObject[] queryReverseBill(Object[] value) {
        QFilter qFilter = new QFilter("sbillid", "in", (Object)value).and("relationtype", "=", (Object)"0");
        DynamicObject[] billRelation = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)"tbillid", (QFilter[])qFilter.toArray());
        if (billRelation.length == 0) {
            return new DynamicObject[0];
        }
        Object[] reverseBillId = Stream.of(billRelation).map(relation -> relation.get("tbillid")).toArray();
        qFilter = new QFilter("sbillid", "in", (Object)reverseBillId).and("relationtype", "=", (Object)"1");
        DynamicObject[] reOpenRelation = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)String.join((CharSequence)",", "tbillid", "sbillid"), (QFilter[])qFilter.toArray());
        Map<Object, Object> reOpenRelationMap = Stream.of(reOpenRelation).collect(Collectors.toMap(k -> k.get("sbillid"), v -> v.get("tbillid")));
        String[] reverseBillSourceTypeArr = new String[]{"B", "C"};
        String selectParams = String.join((CharSequence)",", "invoicecode", "invoiceno", "issuetime", "invoicetype", "blueinvoicecode", "blueinvoiceno", "originalissuetime", "blueinvoicetype", "invoiceamount", "totalamount", "totaltax", "validstate", "orgid", "billsourcetype");
        DynamicObject[] reverseBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)selectParams, (QFilter[])new QFilter("id", "in", (Object)reverseBillId).and("billsourcetype", "in", (Object)reverseBillSourceTypeArr).toArray());
        ArrayList<DynamicObject> reverseBillList = new ArrayList<DynamicObject>(reverseBills.length);
        for (DynamicObject reverseBill : reverseBills) {
            if (reOpenRelationMap.containsKey(reverseBill.getPkValue()) || !"2".equals(reverseBill.getString("validstate"))) continue;
            reverseBillList.add(reverseBill);
        }
        return reverseBillList.toArray(new DynamicObject[0]);
    }

    private static void getRedInvoice(List<Object> invoiceIds, DynamicObject[] relations) {
        List redInfoRelations = Arrays.stream(relations).filter(e -> e.getString("ttable").equals("sim_red_info")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(redInfoRelations)) {
            return;
        }
        Object[] redInfoIds = Arrays.stream(relations).map(e -> e.getLong("tbillid")).toArray();
        DynamicObject[] redInfos = BusinessDataServiceHelper.load((Object[])redInfoIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"));
        if (redInfos.length > 0) {
            List redInfoList = Arrays.stream(redInfos).filter(e -> StringUtils.isNotBlank((CharSequence)e.getString("infocode")) && StringUtils.isNotBlank((CharSequence)e.getString("invoiceno"))).collect(Collectors.toList());
            for (DynamicObject redInfo : redInfoList) {
                DynamicObject dynamicObject = OriginSelectInvoiceControl.loadInvoiceByRedInfo(redInfo);
                if (dynamicObject == null) continue;
                invoiceIds.add(dynamicObject.getPkValue());
            }
        }
    }

    private static DynamicObject loadInvoiceByRedInfo(DynamicObject redInfo) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)redInfo.getString("invoicecode"));
        qFilter.and("invoiceno", "=", (Object)redInfo.getString("invoiceno"));
        qFilter.and("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfo.get("org")));
        QFilter qFilter1 = new QFilter("invoicestatus", "=", (Object)"3");
        qFilter1.or("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray);
        qFilter.and(qFilter1);
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
    }

    private static DynamicObject[] loadRelationByBillIds(Object[] ids) {
        QFilter qFilter = new QFilter("sbillid", "in", (Object)ids);
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
    }

    private static DynamicObject[] loadRelationByInvoiceIds(Object[] ids) {
        QFilter qFilter = new QFilter("tbillid", "in", (Object)ids);
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
    }

    public static void opRedWorkbench(AbstractFormPlugin that) {
        DynamicObjectCollection entryEntity = that.getView().getModel().getEntryEntity("entryentity");
        EntryGrid grid = (EntryGrid)that.getControl("entryentity");
        String operateKey = that.getPageCache().get(OPERATE_KEY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"OriginSelectInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        ArrayList invoiceIdList = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            String invoiceNo;
            String invoiceCode;
            String errMsg;
            Date firstDateOfMonth;
            Date issueTime;
            long pk = ((DynamicObject)entryEntity.get(selectRow)).getLong(INVOICE_PK);
            if (OriginSelectInvoiceControl.isInvalidOperation(operateKey) && DateUtils.compare((Date)(issueTime = ((DynamicObject)entryEntity.get(selectRow)).getDate("issuetime")), (Date)(firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)new Date()))) < 0) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4f5c\u5e9f\u5f53\u6708\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OriginSelectInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (!"bill_reopen".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(errMsg = FiArFinArBillHelper.isCanRedOrCancelNew((String)(invoiceCode = ((DynamicObject)entryEntity.get(selectRow)).getString("invoicecode")), (String)(invoiceNo = ((DynamicObject)entryEntity.get(selectRow)).getString("invoiceno")), (String)"")))) {
                that.getView().showTipNotification(errMsg);
                return;
            }
            invoiceIdList.add(pk);
        }
        HashMap param = Maps.newHashMap();
        param.put(OPERATE_KEY, operateKey);
        param.put("orgid", DynamicObjectUtil.getDynamicObjectLongValue((Object)((DynamicObject)entryEntity.get(0)).get("orgid")));
        ArrayList<Pair> pairList = new ArrayList<Pair>(8);
        if ("bill_reopen".equals(operateKey)) {
            OriginSelectInvoiceControl.createOnlyReOpenParam(param, invoiceIdList);
        } else {
            DynamicObject[] relations;
            HashMap<Object, Long> invoiceRedInfoIdMap = new HashMap<Object, Long>();
            String selectField = String.join((CharSequence)",", "id", "totalamount", "issuetype", "invoicetype", "invoicecode", "invoiceno", "orgid");
            if (OriginSelectInvoiceControl.isInvalidOperation(operateKey)) {
                DynamicObject[] dynamicObjects;
                for (DynamicObject invoice : dynamicObjects = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selectField, (QFilter[])new QFilter("id", "in", (Object)invoiceIdList.toArray()).toArray())) {
                    if (!InvoiceUtils.isRedInfo((DynamicObject)invoice) || invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) >= 0) continue;
                    DynamicObject redInfo = OriginSelectInvoiceControl.getRedByInvoice(invoice);
                    invoiceRedInfoIdMap.put(redInfo.getPkValue(), (Long)invoice.getPkValue());
                    invoiceIdList.remove(invoice.getPkValue());
                    invoiceIdList.add(redInfo.getPkValue());
                }
            }
            if (null == (relations = OriginSelectInvoiceControl.loadRelationByInvoiceIds(invoiceIdList.toArray())) || relations.length == 0) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u53d1\u7968\u6570\u636e", (String)"OriginSelectInvoiceControl_5", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            HashSet<String> set = new HashSet<String>(8);
            for (DynamicObject relation : relations) {
                long sbillid = relation.getLong("sbillid");
                long tbillid = relation.getLong("tbillid");
                if (set.contains(sbillid + "_" + tbillid)) continue;
                Pair pair = "sim_vatinvoice".equals(relation.getString("ttable")) ? Pair.of((Object)relation.getLong("sbillid"), (Object)relation.getLong("tbillid")) : Pair.of((Object)relation.getLong("sbillid"), invoiceRedInfoIdMap.get(relation.getLong("tbillid")));
                pairList.add(pair);
                set.add(sbillid + "_" + tbillid);
            }
            param.put("invoicePairList", pairList);
        }
        LOGGER.info(String.format("OriginSelectInvoiceControl opRedWorkbench param:%s", SerializationUtils.toJsonString((Object)param)));
        that.getView().returnDataToParent((Object)param);
        that.getView().close();
    }

    private static void createOnlyReOpenParam(Map<String, Object> param, List<Object> invoiceIdList) {
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])new QFilter("tbillid", "in", invoiceIdList).toArray());
        ArrayList<Pair> pairList = new ArrayList<Pair>(8);
        for (DynamicObject billRelation : billRelations) {
            pairList.add(Pair.of((Object)billRelation.getLong("tbillid"), (Object)billRelation.getLong("sbillid")));
        }
        param.put("invoicePairList", pairList);
    }

    private static DynamicObject getRedByInvoice(DynamicObject invoice) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode"));
        qFilter.and("invoiceno", "=", (Object)invoice.getString("invoiceno"));
        qFilter.and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")));
        return BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"id", (QFilter[])qFilter.toArray());
    }

    public static boolean isReverseOperation(String operation) {
        return operationSet.contains(operation);
    }

    public static boolean isInvalidOperation(String operation) {
        return invalidSet.contains(operation);
    }

    public static boolean isRedOperation(String operation) {
        return redSet.contains(operation);
    }

    public static String getReverseOperateName(String operationKey) {
        if ("bill_red".equalsIgnoreCase(operationKey)) {
            return "\u7ea2\u51b2";
        }
        if ("bill_red_reopen".equalsIgnoreCase(operationKey)) {
            return "\u7ea2\u51b2\u91cd\u5f00";
        }
        if ("bill_invalid".equalsIgnoreCase(operationKey)) {
            return "\u4f5c\u5e9f";
        }
        if ("bill_invalid_reopen".equalsIgnoreCase(operationKey)) {
            return "\u4f5c\u5e9f\u91cd\u5f00";
        }
        if ("bill_reopen".equalsIgnoreCase(operationKey)) {
            return "\u91cd\u5f00";
        }
        return "";
    }
}

