/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillProcessTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillSplitWorkBenchUtil;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceControl;

public class BillSplitProcessTabCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillSplitProcessTabCustomEvent.class);
    private static final String PROCESSNEXTSTEP = "process/processnextstep";
    private static final String CHECK_EDIT = "process/checkEdit";

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs eventKey) {
        String event = eventKey.getEventName();
        String args = eventKey.getEventArgs();
        switch (event) {
            case "process/processnextstep": {
                this.chechBillDetailSpecialCodeRemark(that, args);
                break;
            }
            case "process/openbuyerlist": {
                new BillProcessTabCustomEvent().openBuyerList(that, args);
                break;
            }
            case "process/checkEdit": {
                this.checkEdit(that, args);
                break;
            }
            case "process/queryGoods": {
                CreateInvoiceControl.queryGoods(args, that);
                break;
            }
            case "process/nextStep": {
                this.nextStepCheck(that, args);
            }
        }
    }

    private void nextStepCheck(AbstractFormPlugin that, String args) {
        JSONObject json = JSONObject.parseObject((String)args);
        JSONObject invoices = json.getJSONObject("data");
        JSONArray invoiceArr = new JSONArray();
        for (String key : invoices.keySet()) {
            invoiceArr.addAll((Collection)invoices.getJSONArray(key));
        }
        try {
            this.checkEditInvoice(invoiceArr);
        }
        catch (Exception e) {
            that.getView().showErrorNotification(e.getMessage());
            return;
        }
        JSONArray array = json.getJSONArray("billIds");
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "totalamount", "totaltax"), (QFilter[])new QFilter("id", "in", (Object)array.toJavaList(Long.class)).toArray());
        BigDecimal billTotalAmountSum = BigDecimal.ZERO;
        BigDecimal billTaxSum = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            billTotalAmountSum = billTotalAmountSum.add(bill.getBigDecimal("totalamount"));
            billTaxSum = billTaxSum.add(bill.getBigDecimal("totaltax"));
        }
        BigDecimal invoiceAmountSum = BigDecimal.ZERO;
        BigDecimal invoiceTaxSum = BigDecimal.ZERO;
        for (Object invoiceObject : invoiceArr) {
            JSONObject invoice = (JSONObject)invoiceObject;
            invoiceAmountSum = invoiceAmountSum.add(invoice.getBigDecimal("totalamount"));
            invoiceTaxSum = invoiceTaxSum.add(invoice.getBigDecimal("totaltax"));
        }
        if (billTotalAmountSum.compareTo(invoiceAmountSum) != 0) {
            that.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BillSplitProcessTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Boolean treatmentHadEdit = json.getBoolean("treatmentHadEdit");
        if (treatmentHadEdit == Boolean.TRUE) {
            BillSplitProcessTabCustomEvent.putPageCache(that, "treatmentHadEdit", "treatmentHadEdit");
        }
        BillSplitProcessTabCustomEvent.putPageCache(that, "process/nextStep", args);
        String taxChangeMsg = "";
        if (billTaxSum.compareTo(invoiceTaxSum) != 0) {
            taxChangeMsg = String.format(ResManager.loadKDString((String)"\u603b\u7a0e\u989d\u7531%1$s\u5143\u53d8\u66f4\u4e3a%2$s\u5143\u3002", (String)"BillSplitProcessTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), billTaxSum.setScale(2, 4).toString(), invoiceTaxSum.setScale(2, 4).toString()) + System.lineSeparator();
        }
        String msg = String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4\u540e\uff0c\u672c\u6b21\u4fee\u6539\u7684\u6570\u636e\u5c06\u8986\u76d6\u5de5\u4f5c\u53f0\u7684\u53d1\u7968\u6570\u636e\uff0c\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BillSplitProcessTabCustomEvent_11", (String)"imc-sim-service", (Object[])new Object[0]), taxChangeMsg);
        ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)msg, (String)"process/nextStep");
    }

    private void checkEditInvoice(JSONArray invoiceArr) {
        for (Object invoiceObject : invoiceArr) {
            JSONObject invoice = (JSONObject)invoiceObject;
            JSONArray items = invoice.getJSONArray("items");
            for (Object itemObject : items) {
                JSONObject item = (JSONObject)itemObject;
                this.checkValIsNull(item, "amount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"BillSplitProcessTabCustomEvent_14", (String)"imc-sim-service", (Object[])new Object[0]));
                this.checkValIsNull(item, "tax", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"BillSplitProcessTabCustomEvent_15", (String)"imc-sim-service", (Object[])new Object[0]));
                this.checkValIsNull(item, "goodsname", ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"BillSplitProcessTabCustomEvent_16", (String)"imc-sim-service", (Object[])new Object[0]));
                this.checkValIsNull(item, "goodscode", ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"BillSplitProcessTabCustomEvent_17", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    private void checkValIsNull(JSONObject item, String key, String desc) {
        String str = item.getString(key);
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillSplitProcessTabCustomEvent_12", (String)"imc-sim-service", (Object[])new Object[0]), desc));
        }
    }

    private void checkEdit(AbstractFormPlugin that, String args) {
        try {
            String invoiceType;
            JSONArray ids = JSONArray.parseArray((String)args);
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.stream().map(o -> Long.parseLong(o.toString())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            BigDecimal amountSum = BigDecimal.ZERO;
            for (DynamicObject bill : bills) {
                if (!"0".equals(bill.getString("confirmstate"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u5168\u989d\u5f00\u7968\u7684\u6570\u636e\u652f\u6301\u624b\u52a8\u7f16\u8f91\uff0c\u8bf7\u5148\u9009\u53d6\u660e\u7ec6\u53ca\u5bf9\u5e94\u7533\u8bf7\u91d1\u989d\u3002", (String)"BillSplitProcessTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                amountSum = amountSum.add(bill.getBigDecimal("invoiceamount"));
            }
            if (amountSum.compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u5f53\u524d\u4e0d\u652f\u6301\u5f00\u5177\u8d1f\u6570\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u53d6\u5355\u636e\u3002", (String)"BillSplitProcessTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            String limitAmountStr = BillSplitProcessTabCustomEvent.getPageCacheVal(that, "limitAmounts");
            LimitAmountsDTO limitAmountsDTO = (LimitAmountsDTO)JSONObject.parseObject((String)limitAmountStr, LimitAmountsDTO.class);
            Map<String, BigDecimal> limitMap = AbstractBillSplitServiceImpl.getLimitMap(limitAmountsDTO);
            BigDecimal limitAmount = limitMap.get(invoiceType = bills[0].getString("invoicetype"));
            if (MathUtils.isNullOrZero((BigDecimal)limitAmount)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u9650\u989d\u4e0d\u80fd\u4e3a0", (String)"BillSplitProcessTabCustomEvent_13", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getInvoiceDescription((String)invoiceType)));
            }
            if (limitAmount.compareTo(amountSum) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u5df2\u8d85\u8fc7\u9650\u989d\uff0c\u5f53\u524d\u4e0d\u652f\u6301\u8d85\u989d\u62c6\u5206\u5f00\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u53d6\u5355\u636e\u3002", (String)"BillSplitProcessTabCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            BillSplitProcessTabCustomEvent.updateCustomControl(that, new HashMap<String, Object>(1), CHECK_EDIT);
        }
        catch (Exception e) {
            LOGGER.error("\u6821\u9a8c\u662f\u5426\u53ef\u4ee5\u7f16\u8f91\u5931\u8d25", (Throwable)e);
            BillSplitProcessTabCustomEvent.handleExcepiton(that, e);
            BillSplitProcessTabCustomEvent.updateCustomControlError(that, null, CHECK_EDIT);
        }
    }

    public void chechBillDetailSpecialCodeRemark(AbstractFormPlugin that, String ars) {
        ErrorMsgDTO errorMsgDTO = BillHelper.checkSplitSpecialGoodCodeRemark((String)ars, (String)"workbench");
        if (errorMsgDTO != null) {
            BillSplitProcessTabCustomEvent.putPageCache(that, "select_bill_next_param", ars);
            String msgKey = "bill_process_check_remark";
            String msg = String.format(ResManager.loadKDString((String)"%1$s,\u662f\u5426\u8865\u5145?", (String)"BillSplitProcessTabCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]), errorMsgDTO.getFailmsg());
            ViewUtil.openConfirm((String)msgKey, (String)msg, (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u8865\u5145", (String)"BillSplitProcessTabCustomEvent_9", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0d\u8865\u5145", (String)"BillSplitProcessTabCustomEvent_10", (String)"imc-sim-service", (Object[])new Object[0]));
        } else {
            BillSplitWorkBenchUtil.processNextStep(that, ars);
        }
    }
}

