/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.dto.BillInfo;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.dto.ReverseBillRelationDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper.WorkbenchReverseHelper;

public class BillReverseCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    protected static final Log log = LogFactory.getLog(BillReverseCustomEvent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        try {
            String event;
            that.getView().showLoading(new LocaleString());
            switch (event = e.getEventName()) {
                case "reverseBill/init": {
                    this.initData(that);
                    return;
                }
                case "reverseBill/nextStep": {
                    this.nextStep(that, e.getEventArgs());
                    return;
                }
            }
            return;
        }
        finally {
            that.getView().hideLoading();
        }
    }

    private void initData(AbstractFormPlugin that) {
        BillReverseCustomEvent.putPageCache(that, "workbenchtype", "reverseworkbench");
        JSONArray pairList = (JSONArray)that.getView().getFormShowParameter().getCustomParam("invoicePairList");
        String operateKey = (String)that.getView().getFormShowParameter().getCustomParam("operateKey");
        if ("bill_reopen".equals(operateKey)) {
            this.onlyReOpenWorkBench(that, pairList);
            return;
        }
        Map<Object, Set<Object>> invoiceBillsMap = this.fillRelation(pairList);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", invoiceBillsMap.keySet()).toArray());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)invoiceBillsMap.values().stream().flatMap(Collection::stream).toArray()).toArray());
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        HashMap billInfoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        for (DynamicObject dynamicObject : bills) {
            BillInfo billInfo = this.createBillInfo(dynamicObject);
            billInfoMap.put(dynamicObject.getPkValue(), billInfo);
            billMap.put(dynamicObject.getPkValue(), dynamicObject);
        }
        ArrayList<ReverseBillRelationDTO> oriBill2NewBillRelations = new ArrayList<ReverseBillRelationDTO>();
        ArrayList<DynamicObject> reverseBills = new ArrayList<DynamicObject>();
        HashMap<String, Map> invoicePkMap = new HashMap<String, Map>();
        for (DynamicObject invoice : invoices) {
            Set<Object> billIds = invoiceBillsMap.get(invoice.getPkValue());
            DynamicObject bill = (DynamicObject)billMap.get(billIds.toArray()[0]);
            DynamicObject reverseBill = WorkbenchReverseHelper.createReverseBill(bill, invoice, operateKey);
            reverseBills.add(reverseBill);
            Map newInvoiceMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)reverseBill, (boolean)true);
            invoicePkMap.put(String.valueOf(reverseBill.getLong("id")), newInvoiceMap);
            for (Object billId : billIds) {
                DynamicObject oriBill = (DynamicObject)billMap.get(billId);
                ReverseBillRelationDTO relation = new ReverseBillRelationDTO((Long)billId, reverseBill.getLong("id"), oriBill.getDynamicObject("orgid").getLong("id"), "0");
                oriBill2NewBillRelations.add(relation);
            }
        }
        that.getPageCache().put("billReverseBillRelation", JSONObject.toJSONString(oriBill2NewBillRelations));
        that.getPageCache().put("reverseBillList", SerializationUtils.toJsonString(reverseBills));
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        for (ReverseBillRelationDTO oriBill2NewBillRelation : oriBill2NewBillRelations) {
            Set redBillPkSet = hashMap.computeIfAbsent(String.valueOf(oriBill2NewBillRelation.getsBillId()), k -> new HashSet(4));
            redBillPkSet.add(String.valueOf(oriBill2NewBillRelation.gettBillId()));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("bills", billInfoMap.values());
        map.put("billRedInvoice", invoicePkMap);
        map.put("billReverseRelation", hashMap);
        if ("bill_red".equals(operateKey)) {
            map.put("currentDisplay", "flush");
            map.put("visibleReopen", Boolean.FALSE);
        } else if ("bill_red_reopen".equals(operateKey)) {
            map.put("currentDisplay", "flush");
            map.put("visibleReopen", Boolean.TRUE);
        } else if ("bill_invalid".equals(operateKey)) {
            map.put("currentDisplay", "invalid");
            map.put("visibleReopen", Boolean.FALSE);
        } else if ("bill_invalid_reopen".equals(operateKey)) {
            map.put("currentDisplay", "invalid");
            map.put("visibleReopen", Boolean.TRUE);
        }
        BillReverseCustomEvent.updateCustomControl(that, map, "reverseBill/init");
    }

    /*
     * WARNING - void declaration
     */
    private void onlyReOpenWorkBench(AbstractFormPlugin that, JSONArray pairList) {
        void var9_14;
        DynamicObject[] entries;
        Object orgObj = that.getView().getFormShowParameter().getCustomParam("orgid");
        ArrayList<ReverseBillRelationDTO> billReverseBillRelationList = new ArrayList<ReverseBillRelationDTO>(pairList.size());
        for (int i = 0; i < pairList.size(); ++i) {
            JSONObject reversebillPk2BillPk = pairList.getJSONObject(i);
            entries = reversebillPk2BillPk.entrySet();
            for (Map.Entry entry : entries) {
                long reverseBillPk = Long.parseLong((String)entry.getKey());
                long billPk = (Long)entry.getValue();
                billReverseBillRelationList.add(new ReverseBillRelationDTO(billPk, reverseBillPk, Long.parseLong(orgObj.toString()), "0"));
            }
        }
        DynamicObject[] reverseBills = BusinessDataServiceHelper.load((Object[])billReverseBillRelationList.stream().map(ReverseBillRelationDTO::gettBillId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        JSONArray jsonArray = new JSONArray();
        entries = reverseBills;
        int n = entries.length;
        boolean bl = false;
        while (var9_14 < n) {
            DynamicObject reverseBill = entries[var9_14];
            jsonArray.add((Object)JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reverseBill)));
            ++var9_14;
        }
        Map<String, Object> reopenView = this.createReopenView(jsonArray, billReverseBillRelationList, that);
        reopenView.put("currentDisplay", "reopen");
        reopenView.put("visibleReopen", Boolean.TRUE);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billReverseBillRelationList.stream().map(ReverseBillRelationDTO::getsBillId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        for (DynamicObject bill : bills) {
            BillInfo billInfo = this.createBillInfo(bill);
            hashMap.put(bill.getPkValue(), billInfo);
        }
        reopenView.put("bills", hashMap.values());
        BillReverseCustomEvent.updateCustomControl(that, reopenView, "reverseBill/init");
    }

    private BillInfo createBillInfo(DynamicObject bill) {
        BillInfo billInfo = new BillInfo();
        billInfo.setBillPk(String.valueOf(bill.getLong("id")));
        billInfo.setBillNo(bill.getString("billno"));
        billInfo.setInvoiceAmount(bill.getBigDecimal("invoiceamount"));
        billInfo.setTotalTax(bill.getBigDecimal("totaltax"));
        billInfo.setTotalAmount(bill.getBigDecimal("totalamount"));
        return billInfo;
    }

    private Map<Object, Set<Object>> fillRelation(JSONArray pairList) {
        HashMap invoiceBillsMap = Maps.newHashMapWithExpectedSize((int)pairList.size());
        for (int i = 0; i < pairList.size(); ++i) {
            JSONObject billPk2InvPk = pairList.getJSONObject(i);
            Set entries = billPk2InvPk.entrySet();
            for (Map.Entry entry : entries) {
                long billPk = Long.parseLong((String)entry.getKey());
                long invPk = (Long)entry.getValue();
                Set billIdSet = invoiceBillsMap.computeIfAbsent(invPk, k -> new HashSet());
                billIdSet.add(billPk);
            }
        }
        return invoiceBillsMap;
    }

    private void nextStep(AbstractFormPlugin that, String paramStr) {
        try {
            String reverseBillStr = that.getPageCache().get("reverseBillList");
            JSONArray reverseBillArr = JSONObject.parseArray((String)reverseBillStr);
            boolean isRedFlush = "B".equals(reverseBillArr.getJSONObject(0).getString("billsourcetype"));
            if (isRedFlush) {
                BillReverseCustomEvent.handlePartRedFlush(reverseBillArr, JSONObject.parseArray((String)paramStr));
                that.getPageCache().put("handle_red_bill", "handle_red_bill");
                that.getPageCache().put("reverseBillList", reverseBillArr.toJSONString());
            }
            String billReverseBillRelationStr = that.getPageCache().get("billReverseBillRelation");
            List billReverseBillRelationList = JSONObject.parseArray((String)billReverseBillRelationStr, ReverseBillRelationDTO.class);
            Map<String, Object> returnMap = this.createReopenView(reverseBillArr, billReverseBillRelationList, that);
            BillReverseCustomEvent.updateCustomControl(that, returnMap, "reverseBill/nextStep");
        }
        catch (Exception e) {
            BillReverseCustomEvent.updateCustomControlError(that, null, "reverseBill/nextStep");
        }
    }

    public static void handlePartRedFlush(JSONArray reverseBillArr, JSONArray requestReverseBills) {
        if (requestReverseBills == null) {
            return;
        }
        Map<Long, JSONObject> requestReverseBillMap = requestReverseBills.stream().map(reverseBill -> (JSONObject)reverseBill).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (int i = 0; i < reverseBillArr.size(); ++i) {
            JSONArray requestItems;
            JSONObject reverseBill2 = reverseBillArr.getJSONObject(i);
            JSONObject requestReverseBill = requestReverseBillMap.get(reverseBill2.getLong("id"));
            if (requestReverseBill == null || (requestItems = requestReverseBill.getJSONArray("sim_original_bill_item")) == null) continue;
            Map<Long, JSONObject> requestItemMap = requestItems.stream().map(item -> (JSONObject)item).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            JSONArray items = reverseBill2.getJSONArray("sim_original_bill_item");
            Iterator iterator = items.iterator();
            boolean isTax = "1".equals(reverseBill2.getString("hsbz"));
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                JSONObject item2 = (JSONObject)iterator.next();
                JSONObject requestItem = requestItemMap.get(item2.getLong("id"));
                if (requestItem == null) {
                    iterator.remove();
                    continue;
                }
                BigDecimal amount = requestItem.getBigDecimal("amount");
                if (MathUtils.isNullOrZero((BigDecimal)amount)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"BillReverseCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                item2.put("amount", (Object)amount);
                item2.put("tax", (Object)requestItem.getBigDecimal("tax"));
                item2.put("num", (Object)requestItem.getBigDecimal("num"));
                item2.put("taxamount", (Object)requestItem.getBigDecimal("amount").add(requestItem.getBigDecimal("tax")));
                item2.put("remainvalidnum", item2.get((Object)"num"));
                item2.put("remainvalidamount", (Object)amount.add(isTax ? item2.getBigDecimal("tax") : BigDecimal.ZERO));
                item2.put("remainvalidtax", item2.get((Object)"tax"));
                totalAmount = totalAmount.add(amount);
                totalTax = totalTax.add(item2.getBigDecimal("tax"));
            }
            reverseBill2.put("invoiceamount", (Object)totalAmount);
            reverseBill2.put("totaltax", (Object)totalTax);
            reverseBill2.put("totalamount", (Object)totalAmount.add(totalTax));
            reverseBill2.put("surplusamount", (Object)totalAmount);
            reverseBill2.put("surplustax", (Object)totalTax);
            reverseBill2.put("oldtotalamount", reverseBill2.get((Object)"totalamount"));
        }
        if (log.isInfoEnabled()) {
            log.info("\u90e8\u5206\u7ea2\u51b2\u5904\u7406\u540e\u6570\u636e" + SerializationUtils.toJsonString((Object)reverseBillArr));
        }
    }

    private Map<String, Object> createReopenView(JSONArray reverseBillArr, List<ReverseBillRelationDTO> billReverseBillRelationList, AbstractFormPlugin that) {
        ArrayList<DynamicObject> reIssueBillList = new ArrayList<DynamicObject>(reverseBillArr.size());
        ArrayList<ReverseBillRelationDTO> reverseBillReIssueBillRelation = new ArrayList<ReverseBillRelationDTO>(reverseBillArr.size());
        HashMap<String, Map> invoiceMap = new HashMap<String, Map>(4);
        for (int i = 0; i < reverseBillArr.size(); ++i) {
            JSONObject reverseBillJson = reverseBillArr.getJSONObject(i);
            boolean isRedFlush = "B".equals(reverseBillJson.getString("billsourcetype"));
            DynamicObject reIssueBill = WorkbenchReverseHelper.createReIssueBill(reverseBillJson, isRedFlush);
            reIssueBillList.add(reIssueBill);
            reverseBillReIssueBillRelation.add(new ReverseBillRelationDTO(reverseBillJson.getLong("id"), reIssueBill.getLong("id"), DynamicObjectUtil.getDynamicObjectLongValue((Object)reIssueBill.get("orgid")), "1"));
            for (ReverseBillRelationDTO billRelationDTO : billReverseBillRelationList) {
                if (!billRelationDTO.gettBillId().equals(reverseBillJson.getLong("id"))) continue;
                billRelationDTO.settBillId(reIssueBill.getLong("id"));
            }
            invoiceMap.put(String.valueOf(reIssueBill.getLong("id")), DynamicObjectUtil.dynamicObjectToMap((DynamicObject)reIssueBill, (boolean)true));
        }
        Map reopenBillInvoiceRelationMap = billReverseBillRelationList.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getsBillId()), TreeMap::new, Collectors.mapping(v -> String.valueOf(v.gettBillId()), Collectors.toList())));
        that.getPageCache().put("reverseBillReIssueBillRelation", JSONObject.toJSONString(reverseBillReIssueBillRelation));
        that.getPageCache().put("billReIssueBillRelation", JSONObject.toJSONString(billReverseBillRelationList));
        that.getPageCache().put("reIssueBillList", SerializationUtils.toJsonString(reIssueBillList));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("reopenBillInvoiceRelation", reopenBillInvoiceRelationMap);
        map.put("reopenInvoiceList", invoiceMap);
        return map;
    }
}

