/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;

public class WorkbenchReverseHelper {
    public static DynamicObject createReverseBill(DynamicObject bill, DynamicObject invoice, String operateKey) {
        DynamicObject reverseBill = (DynamicObject)OrmUtils.clone((Object)bill, (IDataEntityType)bill.getDataEntityType(), (boolean)true, (boolean)true);
        reverseBill.getDynamicObjectCollection("sim_original_bill_item").clear();
        if (operateKey.contains("bill_red")) {
            DynamicObject redInvoice = RedInvoiceUtil.blueInvoiceConvertToRed(invoice, true);
            WorkbenchReverseHelper.handlePartRedInvoice(redInvoice);
            DynamicObjectUtil.copyDynamicObject((DynamicObject)WorkbenchReverseHelper.convertInvoice2OriginalBill(redInvoice), (DynamicObject)reverseBill, (boolean)true, (boolean)false, (boolean)true);
            reverseBill.set("billsourcetype", (Object)"B");
            WorkbenchReverseHelper.setBillDefaultValue(reverseBill);
            BigDecimal deduction = reverseBill.getBigDecimal("deduction");
            if (!MathUtils.isZero((BigDecimal)deduction) && StringUtils.isNotBlank((Object)invoice.get("remark"))) {
                reverseBill.set("invoiceremark", (Object)WorkbenchReverseHelper.genDeductionRemark(invoice.getString("remark"), deduction));
            } else {
                reverseBill.set("invoiceremark", (Object)invoice.getString("remark"));
            }
            String invoiceCode = invoice.getString("invoicecode");
            String invoiceNo = invoice.getString("invoiceno");
            reverseBill.set("blueinvoicecode", (Object)invoiceCode);
            reverseBill.set("blueinvoiceno", (Object)invoiceNo);
            reverseBill.set("originalissuetime", invoice.get("issuetime"));
            reverseBill.set("blueinvoicetype", invoice.get("invoicetype"));
            if (BillHelper.isRedInfo((DynamicObject)reverseBill)) {
                WorkbenchReverseHelper.setRedInfo(reverseBill);
            }
            reverseBill.set("redreason", (Object)"1");
        } else {
            DynamicObjectUtil.copyDynamicObject((DynamicObject)WorkbenchReverseHelper.convertInvoice2OriginalBill(invoice), (DynamicObject)reverseBill, (boolean)true, (boolean)false, (boolean)true);
            reverseBill.set("billsourcetype", (Object)"C");
            WorkbenchReverseHelper.setBillDefaultValue(reverseBill);
            reverseBill.set("invoicecode", invoice.get("invoicecode"));
            reverseBill.set("invoiceno", invoice.get("invoiceno"));
            reverseBill.set("issuetime", invoice.get("issuetime"));
            reverseBill.set("invoicestatus", invoice.get("invoicestatus"));
            reverseBill.set("invoicedamount", invoice.get("invoiceamount"));
            reverseBill.set("invoicedtax", invoice.get("totaltax"));
            reverseBill.set("invoicedtotalamount", invoice.get("totalamount"));
        }
        if ("02".equals(invoice.getString("specialtype"))) {
            reverseBill.set("buyername", (Object)invoice.getString("salername"));
            reverseBill.set("buyertaxno", (Object)invoice.getString("salertaxno"));
            String sellerBank = invoice.getString("salerbank");
            reverseBill.set("buyerbank", (Object)sellerBank);
            reverseBill.set("oribuyerbank", (Object)sellerBank);
            String sellerAddr = invoice.getString("saleraddr");
            reverseBill.set("buyeraddr", (Object)sellerAddr);
            reverseBill.set("oribuyeraddr", (Object)sellerAddr);
            reverseBill.set("salername", (Object)invoice.getString("buyername"));
            reverseBill.set("salertaxno", (Object)invoice.getString("buyertaxno"));
            reverseBill.set("saleraddr", (Object)invoice.getString("buyeraddr"));
            reverseBill.set("salerbank", (Object)invoice.getString("buyerbank"));
        }
        reverseBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
        return reverseBill;
    }

    private static void setRedInfo(DynamicObject bill) {
        String invoiceCode = bill.getString("blueinvoicecode");
        String invoiceno = bill.getString("blueinvoiceno");
        bill.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        if (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceno)) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"))).and("originalinvoicecode", "=", (Object)invoiceCode).and("originalinvoiceno", "=", (Object)invoiceno).and("status", "=", (Object)"3").and("infosource", "!=", (Object)"5");
        DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "infocode", "applicant", "infosource"), (QFilter[])qFilter.toArray());
        if (redInfo == null || "6".equals(redInfo.getString("infosource"))) {
            return;
        }
        bill.set("infocode", (Object)redInfo.getString("infocode"));
        String applicant = redInfo.getString("applicant");
        if (StringUtils.isNotBlank((CharSequence)applicant) && !RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            bill.set("applicant", (Object)RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode());
        }
    }

    public static DynamicObject convertInvoice2OriginalBill(DynamicObject invoice) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)invoice, (DynamicObject)bill);
        bill.set("id", (Object)DBServiceHelper.genGlobalLongId());
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        for (DynamicObject invoiceItem : invoiceItems) {
            String invoiceRowType;
            boolean isNormal;
            String[] array;
            DynamicObject billItem = billItems.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)billItem);
            billItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            DynamicObject taxCode = TaxClassCodeCheckHelper.geTaxCode((String)billItem.getString("goodscode"));
            billItem.set("taxratecodeid", (Object)taxCode);
            String goodsName = billItem.getString("goodsname");
            if (goodsName.contains("*") && (array = goodsName.split("\\*")).length == 3) {
                billItem.set("goodsname", (Object)array[2]);
                billItem.set("goodssimplename", (Object)array[1]);
            }
            boolean bl = isNormal = "0".equals(invoiceRowType = invoiceItem.getString("rowtype")) || "2".equals(invoiceRowType);
            if (isNormal) {
                billItem.set("rowtype", (Object)"2");
            }
            String zzstsgl = invoiceItem.getString("zzstsgl");
            billItem.set("policycontants", (Object)zzstsgl);
            String taxPremark = invoiceItem.getString("taxpremark");
            billItem.set("policylogo", (Object)taxPremark);
            if (TaxRate.ZERO_PERCENT.getRateValue().equalsIgnoreCase(invoiceItem.getString("taxrate")) && "0".equalsIgnoreCase(taxPremark) && StringUtils.isBlank((CharSequence)zzstsgl)) {
                billItem.set("policycontants", (Object)"\u666e\u901a\u96f6\u7a0e\u7387");
            }
            billItem.set("blueinvoiceitemid", invoiceItem.get("originalinvoiceitemid"));
        }
        bill.set("taxationstyle", invoice.get("taxedtype"));
        bill.set("originbillseq", (Object)("100_" + UUID.getBatchNumber() + "_0001"));
        bill.set("invoiceremark", invoice.get("remark"));
        bill.set("taxationstyle", invoice.get("taxedtype"));
        return bill;
    }

    public static void reverseBillAmount(DynamicObject bill) {
        WorkbenchReverseHelper.reverse(bill, "totalamount");
        WorkbenchReverseHelper.reverse(bill, "invoiceamount");
        WorkbenchReverseHelper.reverse(bill, "totaltax");
        WorkbenchReverseHelper.reverse(bill, "oldtotalamount");
        WorkbenchReverseHelper.reverse(bill, "surplusamount");
        WorkbenchReverseHelper.reverse(bill, "surplustax");
        WorkbenchReverseHelper.reverse(bill, "deduction");
        WorkbenchReverseHelper.reverseItem(bill);
    }

    private static void reverse(DynamicObject obj, String keyName) {
        obj.set(keyName, (Object)obj.getBigDecimal(keyName).negate());
    }

    private static void reverseItem(DynamicObject bill) {
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            WorkbenchReverseHelper.reverse(item, "taxamount");
            WorkbenchReverseHelper.reverse(item, "tax");
            WorkbenchReverseHelper.reverse(item, "amount");
            WorkbenchReverseHelper.reverse(item, "num");
            WorkbenchReverseHelper.reverse(item, "remainvalidamount");
            WorkbenchReverseHelper.reverse(item, "remainvalidtax");
            WorkbenchReverseHelper.reverse(item, "remainvalidnum");
            WorkbenchReverseHelper.reverse(item, "orinum");
            WorkbenchReverseHelper.reverse(item, "oritaxamount");
        }
    }

    public static DynamicObject[] getDynamicObjectListFromJSONArray(JSONArray jsonArray, String entityName) {
        DynamicObject[] arr = new DynamicObject[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)jsonObject, (DynamicObject)obj, (boolean)true);
            arr[i] = obj;
        }
        return arr;
    }

    public static void overrideJsonArray2Dynamic(JSONArray billRequestArr, DynamicObject[] reverseBillList) {
        WorkbenchReverseHelper.overrideJsonArray2Dynamic(billRequestArr, reverseBillList, false);
    }

    public static void overrideJsonArray2Dynamic(JSONArray billRequestArr, DynamicObject[] reverseBillList, boolean overrideEntry) {
        DataEntityPropertyCollection properties = reverseBillList[0].getDataEntityType().getProperties();
        List entryList = properties.stream().filter(property -> property instanceof EntryProp).collect(Collectors.toList());
        Map<Long, DynamicObject> reverseBillMap = Stream.of(reverseBillList).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (int i = 0; i < billRequestArr.size(); ++i) {
            JSONObject reverseBillJson = billRequestArr.getJSONObject(i);
            DynamicObject reverseBill = reverseBillMap.get(reverseBillJson.getLong("id"));
            if (reverseBill == null) continue;
            WorkbenchReverseHelper.overrideJson2Dynamic(reverseBillJson, reverseBill, true);
            if (!overrideEntry) continue;
            for (IDataEntityProperty property2 : entryList) {
                JSONArray jsonArray = reverseBillJson.getJSONArray(property2.getName());
                if (jsonArray == null) continue;
                DynamicObjectCollection items = reverseBill.getDynamicObjectCollection(property2.getName());
                Map<Long, DynamicObject> itemMap = items.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                for (int j = 0; j < jsonArray.size(); ++j) {
                    JSONObject itemJson = jsonArray.getJSONObject(j);
                    DynamicObject item = itemMap.get(itemJson.getLong("id"));
                    if (item == null) continue;
                    WorkbenchReverseHelper.overrideJson2Dynamic(itemJson, item, true);
                }
            }
        }
    }

    public static void overrideJson2Dynamic(JSONObject reverseBillJson, DynamicObject reverseBill, boolean nullOverride) {
        DataEntityPropertyCollection properties = reverseBill.getDataEntityType().getProperties();
        Set entries = reverseBillJson.entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            IDataEntityProperty property = (IDataEntityProperty)properties.get(entry.getKey());
            if (property == null || property instanceof EntryProp || ((value = entry.getValue()) == null || StringUtils.isBlank(value)) && !nullOverride) continue;
            reverseBill.set(((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
    }

    public static String genDeductionRemark(String remark, BigDecimal deduction) {
        String blueDeducRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", deduction.negate());
        String deducRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", deduction);
        return remark.replace(blueDeducRemark, deducRemark);
    }

    public static void setBillDefaultValue(DynamicObject bill) {
        bill.set("billno", (Object)"");
        bill.set("invoicecode", null);
        bill.set("invoiceno", null);
        bill.set("issuetime", null);
        bill.set("invoicestatus", null);
        bill.set("invoicedtotalamount", (Object)BigDecimal.ZERO);
        bill.set("invoicedtax", (Object)BigDecimal.ZERO);
        bill.set("invoicedamount", (Object)BigDecimal.ZERO);
        bill.set("mainissuedamount", (Object)BigDecimal.ZERO);
        bill.set("mainissuedtax", (Object)BigDecimal.ZERO);
        bill.set("maintaxdeviation", (Object)BigDecimal.ZERO);
        bill.set("confirmamount", (Object)BigDecimal.ZERO);
        bill.set("billstatus", (Object)BillHelper.getBillStatusByTableName((String)"sim_original_bill", (String)"6"));
        bill.set("billdate", (Object)new Date());
        bill.set("createdate", (Object)new Date());
        bill.set("creator", (Object)RequestContext.get().getUserId());
        bill.set("confirmstate", (Object)"0");
        bill.set("validstate", (Object)"0");
        bill.set("split", (Object)"1");
        bill.set("priority", (Object)"0");
        bill.set("billsource", (Object)"6");
        bill.set("oldtotalamount", bill.get("totalamount"));
        if ("C".equals(bill.getString("billsourcetype"))) {
            bill.set("surplusamount", (Object)BigDecimal.ZERO);
            bill.set("surplustax", (Object)BigDecimal.ZERO);
        } else {
            bill.set("surplusamount", bill.get("invoiceamount"));
            bill.set("surplustax", bill.get("totaltax"));
        }
        bill.set("billproperties", (Object)(bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1"));
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        boolean isTax = "1".equals(bill.getString("hsbz"));
        for (DynamicObject item : items) {
            item.set("remainvalidnum", item.get("num"));
            item.set("remainvalidtax", item.get("tax"));
            item.set("remainvalidamount", item.get(isTax ? "taxamount" : "amount"));
            item.set("orinum", item.get("num"));
            item.set("oritaxamount", item.get("taxamount"));
            item.set("oriunitprice", item.get("unitprice"));
            item.set("oriunit", item.get("unit"));
            item.set("origoodsname", item.get("goodsname"));
            item.set("orispecification", item.get("specification"));
        }
    }

    public static void handlePartRedInvoice(DynamicObject redInvoice) {
        DynamicObjectCollection items = redInvoice.getDynamicObjectCollection("items");
        if (items.stream().allMatch(item -> item.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) == 0)) {
            for (DynamicObject item2 : items) {
                item2.set("originalinvoiceitemid", null);
            }
            return;
        }
        boolean isTax = "1".equals(redInvoice.getString("hsbz"));
        Iterator iterator = items.iterator();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        while (iterator.hasNext()) {
            DynamicObject item3 = (DynamicObject)iterator.next();
            BigDecimal itemRemainRedAmount = item3.getBigDecimal("itemremainredamount").negate();
            BigDecimal tax = item3.getBigDecimal("itemremainredtax").negate();
            if (itemRemainRedAmount.compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            if (itemRemainRedAmount.compareTo(item3.getBigDecimal("amount")) != 0) {
                item3.set("amount", (Object)itemRemainRedAmount);
                item3.set("tax", (Object)tax);
                item3.set("taxamount", (Object)itemRemainRedAmount.add(tax));
                if (isTax) {
                    WorkbenchReverseHelper.calcNum(item3, item3.getBigDecimal("taxamount"), item3.getBigDecimal("taxunitprice"));
                } else {
                    WorkbenchReverseHelper.calcNum(item3, item3.getBigDecimal("amount"), item3.getBigDecimal("unitprice"));
                }
            }
            totalAmount = totalAmount.add(item3.getBigDecimal("amount"));
            totalTax = totalTax.add(item3.getBigDecimal("tax"));
        }
        redInvoice.set("invoiceamount", (Object)totalAmount);
        redInvoice.set("totaltax", (Object)totalTax);
        redInvoice.set("totalamount", (Object)totalAmount.add(totalTax));
    }

    private static void calcNum(DynamicObject item, BigDecimal amount, BigDecimal price) {
        if (!MathUtils.isNullOrZero((BigDecimal)price)) {
            item.set("num", (Object)UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)price));
        }
    }

    public static DynamicObject createReIssueBill(JSONObject redBillJson, boolean isRedFlush) {
        DynamicObject reIssueBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)redBillJson, (DynamicObject)reIssueBill);
        reIssueBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
        reIssueBill.set("originbillseq", (Object)("100_" + UUID.getBatchNumber() + "_0001"));
        reIssueBill.set("billsourcetype", (Object)"D");
        DynamicObjectCollection items = reIssueBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        if (isRedFlush) {
            BillHelper.clearRedInvoiceData((DynamicObject)reIssueBill);
            WorkbenchReverseHelper.reverseBillAmount(reIssueBill);
            BigDecimal deduction = reIssueBill.getBigDecimal("deduction");
            String invoiceRemark = reIssueBill.getString("invoiceremark");
            if (!MathUtils.isZero((BigDecimal)deduction) && StringUtils.isNotBlank((CharSequence)invoiceRemark)) {
                reIssueBill.set("invoiceremark", (Object)WorkbenchReverseHelper.genDeductionRemark(invoiceRemark, deduction));
            }
        }
        WorkbenchReverseHelper.setBillDefaultValue(reIssueBill);
        reIssueBill.set("billproperties", (Object)(reIssueBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1"));
        return reIssueBill;
    }
}

