/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.merge.MergeTaxDeviationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.enums.TaxDiffEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCalcMethod;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCheckMethod;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeMethod;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillNegativeOffsetMethod;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BillMergeHelper {
    private static final Log log = LogFactory.getLog(BillMergeHelper.class);
    private Map<Long, DynamicObject> detailId2BillMap;
    private TaxDiffEnum taxDiffEnum = TaxDiffEnum.DIFF_AVG_001;
    private Map<Object, DynamicObject> mergeRuleMap = new HashMap<Object, DynamicObject>(16);
    private LimitAmountsDTO limitAmountsDTO;

    public MergeResponseDTO mergeBill(MergeRequestDTO request) {
        this.checkIsCanMergeDetail(request);
        this.taxDiffEnum = this.getTaxDiff(request.getBills()[0], request.getJqbh());
        if (!InvoiceUtils.isAllEInvoice((Object)request.getBills()[0].getString("invoicetype"))) {
            this.getTaxEquipmentLimit(DynamicObjectUtil.getDynamicObjectLongValue((Object)request.getBills()[0].get("orgid")), request.getJqbh());
        }
        this.createDetailId2BillRealtionAndInitMergeRuleMap(request.getBills());
        LinkedHashMap<String, DynamicObjectCollection> billDetailMap = this.mergeBillHead(request);
        return this.mergeBillDetail(billDetailMap, request);
    }

    private void getTaxEquipmentLimit(long orgId, String jqbh) {
        try {
            DynamicObject devObj = EquipmentUtil.getDevByCode((Long)orgId, (String)jqbh);
            this.limitAmountsDTO = new LimitAmountsDTO(devObj);
        }
        catch (Exception ignore) {
            this.limitAmountsDTO = new LimitAmountsDTO();
        }
    }

    private void checkIsCanMergeDetail(MergeRequestDTO request) {
        DynamicObject[] bills;
        if (!request.isMergeBillDetail()) {
            return;
        }
        for (DynamicObject bill : bills = request.getBills()) {
            Object mergeType;
            DynamicObject mergeRule;
            if (!"1".equals(bill.getString("confirmstate")) || (mergeRule = bill.getDynamicObject("mergerule")) == null || !"2".equals(mergeType = (mergeRule = BusinessDataServiceHelper.loadSingle((Object)mergeRule.getPkValue(), (String)"bdm_merge_rule_strategy")).get("differentrowtypemerge"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u4e3a\u90e8\u5206\u7533\u8bf7\u5355\u636e\uff0c\u6b64\u65f6\u5408\u5e76\u660e\u7ec6\u65f6\uff0c\u4e0d\u652f\u6301\u5408\u5e76\u660e\u7ec6\u6570\u91cf\u7f6e\u4e3a\u6b63\u8d1f\u4e00", (String)"BillMergeHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
        }
    }

    public TaxDiffEnum getTaxDiff(DynamicObject bill, String jqbh) {
        TaxDiffEnum taxDiffEnum = TaxDiffEnum.DIFF_AVG_001;
        if (InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype"))) {
            taxDiffEnum = EnterpriseHelper.isLqptChannel((String)bill.getString("salertaxno")) ? TaxDiffEnum.DIFF_006 : TaxDiffEnum.DIFF_RPA_001;
        } else if (InvoiceConstant.DIFFF_06.compareTo(this.getItemsMaxTaxDiff(jqbh)) == 0) {
            taxDiffEnum = TaxDiffEnum.DIFF_006;
        }
        return taxDiffEnum;
    }

    public BigDecimal getItemsMaxTaxDiff(String jqbh) {
        BigDecimal resultDiff;
        String cacheKey;
        block8: {
            cacheKey = "itemMaxTaxDiff" + jqbh;
            BigDecimal itemMaxTaxDiff = (BigDecimal)CacheHelper.getLocalCache((String)cacheKey);
            if (!MathUtils.isNullOrZero((BigDecimal)itemMaxTaxDiff)) {
                return itemMaxTaxDiff;
            }
            resultDiff = InvoiceConstant.DIFF_01;
            try {
                if (StringUtils.isBlank((CharSequence)jqbh)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"\u8bbe\u7f6e\u7a0e\u63a7\u76d8\u5355\u884c\u7a0e\u989d\u5c3e\u5dee\u5931\u8d25,\u673a\u5668\u7f16\u53f7\u4e3a\u7a7a");
                    }
                    CacheHelper.putLocalCache((String)cacheKey, (Object)resultDiff);
                    return resultDiff;
                }
                QFilter equipFilter = new QFilter("equipmentno", "=", (Object)jqbh).and("authstatus", "=", (Object)"1");
                DynamicObject equipment = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)"equipmenttype", (QFilter[])equipFilter.toArray());
                if (equipment == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("\u8bbe\u7f6e\u7a0e\u63a7\u76d8\u5355\u884c\u7a0e\u989d\u5c3e\u5dee\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u7a0e\u76d8\u4fe1\u606f\uff0c\u7a0e\u76d8\u53f7[%s]", jqbh));
                    }
                    CacheHelper.putLocalCache((String)cacheKey, (Object)resultDiff);
                    return resultDiff;
                }
                String equipmentType = equipment.getString("equipmenttype");
                if (!EquipmentType.taxDiff01Set.contains(equipmentType)) {
                    resultDiff = InvoiceConstant.DIFFF_06;
                }
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block8;
                log.info((Object)"\u8bbe\u7f6e\u7a0e\u63a7\u76d8\u5355\u884c\u7a0e\u989d\u5c3e\u5dee\u5931\u8d25,\u673a\u5668\u7f16\u53f7\u4e3a\u7a7a");
            }
        }
        CacheHelper.putLocalCache((String)cacheKey, (Object)resultDiff);
        return resultDiff;
    }

    private void createDetailId2BillRealtionAndInitMergeRuleMap(DynamicObject[] bills) {
        this.detailId2BillMap = new HashMap<Long, DynamicObject>(bills.length);
        ArrayList<Long> mergeRulePk = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                this.detailId2BillMap.put(item.getLong("id"), bill);
            }
            long mergeRuleId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("mergerule"));
            if (mergeRuleId == 0L) continue;
            mergeRulePk.add(mergeRuleId);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])mergeRulePk.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_merge_rule_strategy"));
        this.mergeRuleMap = Stream.of(load).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (v1, v2) -> v1));
    }

    private LinkedHashMap<String, DynamicObjectCollection> mergeBillHead(MergeRequestDTO request) {
        LinkedHashMap billMaps = request.isMergeBill() ? BillMergeMethod.getMergeBillMap(request.getBills(), this.mergeRuleMap) : Stream.of(request.getBills()).collect(Collectors.toMap(k -> k.getPkValue().toString(), Collections::singletonList, (k1, k2) -> k1, LinkedHashMap::new));
        LinkedHashMap<String, DynamicObjectCollection> mergeBillMap = new LinkedHashMap<String, DynamicObjectCollection>();
        billMaps.forEach((key, value) -> {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject obj : value) {
                DynamicObjectCollection details = obj.getDynamicObjectCollection("sim_original_bill_item");
                collection.addAll((Collection)details.stream().filter(this::canPushDetail).collect(Collectors.toList()));
            }
            if (CollectionUtils.isEmpty((Collection)collection) || collection.stream().allMatch(this::isZeroPush)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e[%s]\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u5168\u4e3a0", (String)"BillMergeHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), value.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
            }
            mergeBillMap.put((String)key, collection);
        });
        return mergeBillMap;
    }

    private boolean canPushDetail(DynamicObject detail) {
        if (detail.getBoolean("gift")) {
            return false;
        }
        return detail.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0 || this.isZeroPush(detail);
    }

    private boolean isZeroPush(DynamicObject detail) {
        return !"1".equals(detail.getString("zeropushflag")) && detail.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0;
    }

    private boolean isZero(DynamicObject detail) {
        return detail.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0;
    }

    private MergeResponseDTO mergeBillDetail(LinkedHashMap<String, DynamicObjectCollection> billDetailMap, MergeRequestDTO request) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(billDetailMap.size());
        ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>(billDetailMap.size());
        String newBillNoPrefix = "200_" + UUID.getBatchNumber() + '_';
        int i = 1;
        HashMap<String, String> billNoMap = new HashMap<String, String>(billDetailMap.size());
        for (DynamicObjectCollection collection : billDetailMap.values()) {
            DynamicObject tObj = this.createTargetObj(collection);
            tObj.set("jqbh", (Object)request.getJqbh());
            bills.add(tObj);
            boolean isMergeBillDetail = this.getMergeBillDetailFlag(((DynamicObject)collection.get(0)).getLong("id"), tObj, request.isMergeBillDetail());
            billNoMap.put(tObj.getString("billno"), newBillNoPrefix + BillHelper.getBatchNumbersuffix((int)i++));
            DynamicObject mergeRule = BillMergeMethod.getBillMergeRule(tObj, this.mergeRuleMap);
            boolean isMerge2Multiline = "1".equals(mergeRule.getString("deviationrule")) && "2".equals(mergeRule.getString("nodeviationmergerule"));
            LinkedHashMap<String, List<DynamicObject>> billDetailMaps = this.getBillDetailMergeMap(isMergeBillDetail, collection, mergeRule);
            Collection<List<DynamicObject>> detailLists = billDetailMaps.values();
            for (List<DynamicObject> detailList : detailLists) {
                if (isMergeBillDetail) {
                    this.createMergeItems(tObj, detailList, relations, isMerge2Multiline);
                    continue;
                }
                this.createNormalItem(tObj, detailList, relations);
            }
            BillMergeMethod.calcBillHeadAmount(tObj);
            BillCheckMethod.checkMergeAmount(tObj, relations, this.detailId2BillMap, mergeRule, isMergeBillDetail);
            BillNegativeOffsetMethod.handleNumZero(mergeRule, isMergeBillDetail, tObj, relations);
            BigDecimal taxDeviation = BillMergeMethod.adjustmentTailDifference(tObj, this.taxDiffEnum, relations);
            if (taxDeviation.compareTo(BigDecimal.ZERO) != 0 && "1".equals(mergeRule.getString("deviationrule"))) {
                throw new MsgException(request.isMergeBillDetail() ? "mergeMoreThanTaxControl" : "singleMoreThanTaxControl", Stream.of(tObj.getString("billno").split(",")).collect(Collectors.joining(System.lineSeparator())));
            }
            if (isMergeBillDetail) {
                this.dealItemNum(mergeRule, tObj);
            }
            BillMergeMethod.clearItemInfo(tObj, mergeRule);
            BillMergeMethod.calcBillHeadAmount(tObj);
            BillMergeMethod.fillInSplitRule(tObj, this.limitAmountsDTO);
        }
        BillCheckMethod.checkDeduction(bills);
        return new MergeResponseDTO(bills, relations, billNoMap);
    }

    private boolean getMergeBillDetailFlag(long DetailId, DynamicObject tObj, boolean requestMergeBillDetail) {
        boolean isCanMergeBill;
        if ("E05".equals(tObj.getString("specialtype"))) {
            return false;
        }
        DynamicObject bill = this.detailId2BillMap.get(DetailId);
        boolean bl = isCanMergeBill = !OriginalBillConstant.isSpecialSourcType((Object)bill.getString("billsourcetype")) || "D".equals(tObj.getString("billsourcetype"));
        if (!isCanMergeBill) {
            return false;
        }
        if (!"KINGDEE_FI".equals(bill.getString("systemsource"))) {
            return requestMergeBillDetail;
        }
        return "2".equals(tObj.getString("splitormergeflag")) || "3".equals(tObj.getString("splitormergeflag"));
    }

    private void dealItemNum(DynamicObject mergeRule, DynamicObject tObj) {
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)tObj.getString("invoicetype")) || "1".equals(tObj.getString("iselepaper"));
        String confirmState = tObj.getString("confirmstate");
        if ("2".equals(mergeRule.getString("samerowtypemerge"))) {
            if ("1".equals(confirmState)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5305\u542b\u90e8\u5206\u7533\u8bf7\u7684\u5355\u636e\u4e0d\u652f\u6301\u5408\u5e76\u89c4\u5219\uff1a\u6570\u91cf\u7f6e\u4e3a1\uff0c\u53cd\u7b97\u5355\u4ef7", (String)"BillMergeHelper_2", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
            tObj.set("mergelable", (Object)"1");
            for (DynamicObject item : tItems) {
                ItemMerge2OneHelper.dealNumOne((DynamicObject)item);
                BillCalcMethod.calcPrice(item, isAllEle);
            }
        }
    }

    private DynamicObject createTargetObj(DynamicObjectCollection collection) {
        DynamicObject sObj = this.detailId2BillMap.get(((DynamicObject)collection.get(0)).getLong("id"));
        DynamicObject tObj = new DynamicObject(sObj.getDynamicObjectType());
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)sObj, (DynamicObject)tObj);
        tObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        this.clearMergeBillField(tObj);
        HashSet<String> billNos = new HashSet<String>(16);
        HashSet<Long> sBillIds = new HashSet<Long>(16);
        ArrayList<String> remarks = new ArrayList<String>(16);
        ArrayList<DynamicObjectCollection> freightList = new ArrayList<DynamicObjectCollection>(16);
        for (DynamicObject sItem : collection) {
            billNos.add(this.detailId2BillMap.get(sItem.getLong("id")).getString("billno"));
            DynamicObject obj = this.detailId2BillMap.get(sItem.getLong("id"));
            if (sBillIds.contains(obj.getLong("id"))) continue;
            remarks.add(obj.getString("invoiceremark"));
            sBillIds.add(obj.getLong("id"));
            if (!"E04".equals(obj.getString("specialtype"))) continue;
            freightList.add(obj.getDynamicObjectCollection("freights"));
        }
        tObj.set("billno", (Object)String.join((CharSequence)",", billNos));
        Stream<String> remarkStream = remarks.stream().filter(StringUtils::isNotBlank);
        DynamicObject mergeRule = BillMergeMethod.getBillMergeRule(tObj, this.mergeRuleMap);
        if ("2".equals(mergeRule.getString("remarkmergetype"))) {
            remarkStream = remarkStream.distinct();
        }
        String invoiceType = tObj.getString("invoicetype");
        String invoiceRemark = remarkStream.collect(Collectors.joining(","));
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (invoiceRemark.length() > 200) {
                invoiceRemark = invoiceRemark.substring(0, 200);
            }
        } else {
            invoiceRemark = GBKUtils.cutGBKString((String)invoiceRemark, (int)(tObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 ? 180 : 230));
        }
        tObj.set("invoiceremark", (Object)invoiceRemark);
        DataEntityPropertyCollection properties = sObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp) || "sim_original_bill_item".equals(property.getName()) || "freights".equals(property.getName())) continue;
            DynamicObjectCollection sItems = sObj.getDynamicObjectCollection(property.getName());
            DynamicObjectCollection tItems = tObj.getDynamicObjectCollection(property.getName());
            for (DynamicObject sItem : sItems) {
                DynamicObject tItem = tItems.addNew();
                DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)sItem, (DynamicObject)tItem);
            }
        }
        if (CollectionUtils.isNotEmpty(freightList)) {
            DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("freights");
            tItems.clear();
            for (DynamicObjectCollection freights : freightList) {
                for (DynamicObject freight : freights) {
                    DynamicObject tItem = tItems.addNew();
                    DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)freight, (DynamicObject)tItem);
                }
            }
        }
        return tObj;
    }

    private void clearMergeBillField(DynamicObject tObj) {
        DataEntityPropertyCollection properties = tObj.getDynamicObjectType().getProperties();
        this.setPropertyVal(tObj, properties, "auditor", 0L);
        this.setPropertyVal(tObj, properties, "auditdate", null);
        this.setPropertyVal(tObj, properties, "invoicecode", "");
        this.setPropertyVal(tObj, properties, "invoiceno", "");
        this.setPropertyVal(tObj, properties, "issuetime", null);
        this.setPropertyVal(tObj, properties, "invoicestatus", "");
        this.setPropertyVal(tObj, properties, "invoicedtotalamount", BigDecimal.ZERO);
        this.setPropertyVal(tObj, properties, "invoicedtax", BigDecimal.ZERO);
        this.setPropertyVal(tObj, properties, "invoicedamount", BigDecimal.ZERO);
    }

    private void setPropertyVal(DynamicObject tObj, DataEntityPropertyCollection properties, String key, Object val) {
        if (properties.containsKey((Object)key)) {
            tObj.set(key, val);
        }
    }

    private void createNormalItem(DynamicObject tObj, List<DynamicObject> detailList, List<BillRelationDTO> relations) {
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        boolean isTax = "1".equals(tObj.getString("hsbz"));
        for (DynamicObject sItem : detailList) {
            Long sDetailId = sItem.getLong("id");
            DynamicObject sObj = this.detailId2BillMap.get(sDetailId);
            if (this.isZero(sItem)) {
                this.addNormalZeroRelation(sItem, tObj, relations);
                continue;
            }
            DynamicObject tItem = tItems.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)sItem, (DynamicObject)tItem);
            tItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            BigDecimal remainValidAmount = sItem.getBigDecimal("remainvalidamount");
            BigDecimal remainValidTax = sItem.getBigDecimal("remainvalidtax");
            BigDecimal amount = isTax ? remainValidAmount.subtract(remainValidTax) : remainValidAmount;
            tItem.set("remainvalidamount", (Object)amount.add(remainValidTax));
            BillRelationDTO billRelation = new BillRelationDTO(Long.valueOf(sObj.getLong("id")), sObj.getString("billno"), sDetailId, Long.valueOf(tObj.getLong("id")), "", Long.valueOf(tItem.getLong("id")), amount, sItem.getBigDecimal("remainvalidtax"), sItem.getBigDecimal("remainvalidnum"), sItem.getBigDecimal("unitprice"), "sim_vatinvoice");
            billRelation.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)sObj.get("orgid"))));
            relations.add(billRelation);
        }
    }

    private void createMergeItems(DynamicObject tObj, List<DynamicObject> detailList, List<BillRelationDTO> relations, boolean isMerge2Multiline) {
        int itemsNowIndex = tObj.getDynamicObjectCollection("sim_original_bill_item").size();
        boolean isSumZero = detailList.stream().filter(item -> !"1".equals(item.getString("rowtype"))).map(item -> item.getBigDecimal("remainvalidamount")).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(BigDecimal.ZERO) == 0;
        HashMap<Integer, MergeTaxDeviationDTO> taxDeviationMap = new HashMap<Integer, MergeTaxDeviationDTO>(detailList.size());
        for (int i = 0; i < detailList.size(); ++i) {
            DynamicObject beMergeItem;
            DynamicObject nowItem = detailList.get(i);
            if (isSumZero) {
                this.addNormalZeroRelation(nowItem, tObj, relations);
                continue;
            }
            if (!this.isZero(nowItem)) {
                BigDecimal taxAmount = nowItem.getBigDecimal("remainvalidamount").add("1".equals(tObj.getString("hsbz")) ? BigDecimal.ZERO : nowItem.getBigDecimal("remainvalidtax"));
                taxDeviationMap.put(i, new MergeTaxDeviationDTO(nowItem.getString("rowtype"), BillCalcMethod.getTaxDeviation(tObj, nowItem, taxAmount, nowItem.getBigDecimal("remainvalidtax"))));
            }
            if ((beMergeItem = this.findLastSameItem(tObj, itemsNowIndex, nowItem)) == null) {
                this.addNewItem(nowItem, tObj, relations, tObj.getDynamicObjectCollection("sim_original_bill_item").size());
                continue;
            }
            this.doMergeItem(beMergeItem, nowItem, tObj, relations);
        }
        if (isMerge2Multiline) {
            this.dealMergeTax(detailList, itemsNowIndex, taxDeviationMap, tObj, relations);
        }
        Map relationGroup = relations.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId, Collectors.mapping(BillRelationDTO::getsDetailId, Collectors.toSet())));
        DynamicObjectCollection mergeItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject mergeItem : mergeItems) {
            Set sDetailIds = relationGroup.get(mergeItem.getLong("id"));
            if (CollectionUtils.isEmpty(sDetailIds)) continue;
            String rowRemark = detailList.stream().filter(detail -> sDetailIds.contains(detail.getLong("id")) && StringUtils.isNotBlank((CharSequence)detail.getString("remark"))).map(detail -> detail.getString("remark")).collect(Collectors.joining(","));
            mergeItem.set("remark", (Object)GBKUtils.cutGBKString((String)rowRemark, (int)200));
        }
    }

    private void addNormalZeroRelation(DynamicObject nowItem, DynamicObject tObj, List<BillRelationDTO> relations) {
        Long sDetailId = nowItem.getLong("id");
        DynamicObject sObj = this.detailId2BillMap.get(sDetailId);
        boolean isTax = "1".equals(tObj.getString("hsbz"));
        BigDecimal amount = nowItem.getBigDecimal("remainvalidamount").subtract(isTax ? nowItem.getBigDecimal("remainvalidtax") : BigDecimal.ZERO);
        BillRelationDTO billRelation = new BillRelationDTO(Long.valueOf(sObj.getLong("id")), sObj.getString("billno"), sDetailId, Long.valueOf(tObj.getLong("id")), "", Long.valueOf(0L), amount, nowItem.getBigDecimal("remainvalidtax"), nowItem.getBigDecimal("remainvalidnum"), nowItem.getBigDecimal("unitprice"), "sim_vatinvoice");
        billRelation.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)sObj.get("orgid"))));
        billRelation.setPushZero(true);
        relations.add(billRelation);
    }

    private void dealMergeTax(List<DynamicObject> detailList, int tItemSize, Map<Integer, MergeTaxDeviationDTO> taxDeviationMap, DynamicObject tObj, List<BillRelationDTO> relations) {
        DynamicObject mergeRule = BillMergeMethod.getBillMergeRule(tObj, this.mergeRuleMap);
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        boolean isTax = "1".equals(tObj.getString("hsbz"));
        for (int nowIndex = tItemSize; nowIndex < tItems.size(); ++nowIndex) {
            Integer taxDeviationNearIndex;
            DynamicObject tItem = (DynamicObject)tItems.get(nowIndex);
            BigDecimal taxDeviation = BillCalcMethod.getTaxDeviation(tObj, tItem, tItem.getBigDecimal("remainvalidamount"), tItem.getBigDecimal("remainvalidtax"));
            if (!BigDecimalUtil.compare((BigDecimal)taxDeviation, (BigDecimal)BigDecimal.ZERO, (BigDecimal)InvoiceConstant.DIFFF_06) && BillMergeMethod.checkBwTaxDeviation(tObj, this.taxDiffEnum) && BillMergeMethod.checkRpaTaxDeviation(tObj, tItem, taxDeviation, this.taxDiffEnum) || relations.stream().filter(relation -> relation.gettDetailId().equals(tItem.getLong("id"))).count() == 1L || (taxDeviationNearIndex = this.getTaxDeviationNear(taxDeviationMap, tItem.getString("rowtype"), taxDeviation)) == null) continue;
            DynamicObject sSubItem = detailList.get(taxDeviationNearIndex);
            this.subItem(isTax, tItem, sSubItem, relations);
            taxDeviationMap.remove(taxDeviationNearIndex);
            if (!"1".equals(sSubItem.getString("rowtype")) && !BillMergeHelper.isBeDisount(detailList, mergeRule, taxDeviationNearIndex)) {
                this.addOrMergeItem(sSubItem, tObj, relations, nowIndex);
            } else if ("1".equals(sSubItem.getString("rowtype"))) {
                DynamicObject sSubBeDiscountItem = detailList.get(taxDeviationNearIndex - 1);
                if ("1".equals(sSubBeDiscountItem.getString("rowtype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5546\u54c1[%2$s]\u5b58\u5728\u6298\u6263\u884c\uff0c\u4e0d\u652f\u6301\u5408\u5e76\u89c4\u5219\u5c3e\u5dee\u5904\u7406\u4e3a\u5408\u5e76\u4e3a\u591a\u884c\uff0c\u60a8\u53ef\u4ee5\u8fdb\u5165\u53d1\u7968\u4e91\u2192\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e\u2192\u5408\u5e76\u914d\u7f6e\u4e2d\u4fee\u6539\u5c3e\u5dee\u5904\u7406\u89c4\u5219\u540e\u5f00\u7968\u3002", (String)"BillMergeHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), tObj.getString("billno"), tItem.get("goodsname")));
                }
                if (!BillMergeMethod.getMergeBillDetailKey(sSubItem, null, mergeRule, true).equals(BillMergeMethod.getMergeBillDetailKey(sSubBeDiscountItem, null, mergeRule, true))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5546\u54c1[%2$s]\u5b58\u5728\u6298\u6263\u884c\uff0c\u4e0d\u652f\u6301\u5408\u5e76\u89c4\u5219\u5c3e\u5dee\u5904\u7406\u4e3a\u5408\u5e76\u4e3a\u591a\u884c\uff0c\u60a8\u53ef\u4ee5\u8fdb\u5165\u53d1\u7968\u4e91\u2192\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e\u2192\u5408\u5e76\u914d\u7f6e\u4e2d\u4fee\u6539\u5c3e\u5dee\u5904\u7406\u89c4\u5219\u540e\u5f00\u7968\u3002", (String)"BillMergeHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), tObj.getString("billno"), tItem.get("goodsname")));
                }
                DynamicObject tBeDiscountItem = (DynamicObject)tItems.get(nowIndex - 1);
                BigDecimal remainValidAmount = BigDecimalUtil.add((BigDecimal)sSubBeDiscountItem.getBigDecimal("remainvalidamount"), (BigDecimal)(isTax ? BigDecimal.ZERO : sSubBeDiscountItem.getBigDecimal("remainvalidtax")));
                if (tBeDiscountItem.getBigDecimal("remainvalidamount").compareTo(remainValidAmount) == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u5546\u54c1[%2$s]\u5b58\u5728\u6298\u6263\u884c\uff0c\u4e0d\u652f\u6301\u5408\u5e76\u89c4\u5219\u5c3e\u5dee\u5904\u7406\u4e3a\u5408\u5e76\u4e3a\u591a\u884c\uff0c\u60a8\u53ef\u4ee5\u8fdb\u5165\u53d1\u7968\u4e91\u2192\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e\u2192\u5408\u5e76\u914d\u7f6e\u4e2d\u4fee\u6539\u5c3e\u5dee\u5904\u7406\u89c4\u5219\u540e\u5f00\u7968\u3002", (String)"BillMergeHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), tObj.getString("billno"), tItem.get("goodsname")));
                }
                this.subItem(isTax, tBeDiscountItem, sSubBeDiscountItem, relations);
                this.addOrMergeItem(sSubBeDiscountItem, sSubItem, tObj, relations, nowIndex);
                taxDeviationMap.remove(taxDeviationNearIndex - 1);
                --nowIndex;
            } else {
                DynamicObject tDiscountRow = (DynamicObject)tItems.get(nowIndex + 1);
                DynamicObject sDiscountRow = detailList.get(taxDeviationNearIndex + 1);
                this.subItem(isTax, tDiscountRow, sDiscountRow, relations);
                if (tDiscountRow.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) == 0) {
                    tItems.remove((Object)tDiscountRow);
                }
                this.addOrMergeItem(sSubItem, sDiscountRow, tObj, relations, nowIndex + 1);
                taxDeviationMap.remove(taxDeviationNearIndex + 1);
            }
            --nowIndex;
        }
    }

    private void addOrMergeItem(DynamicObject sItem, DynamicObject tObj, List<BillRelationDTO> relations, int startIndex) {
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = startIndex + 1; i < tItems.size(); ++i) {
            DynamicObject beMergeItem;
            DynamicObject tItem = (DynamicObject)tItems.get(i);
            if (!sItem.getString("rowtype").equals(tItem.getString("rowtype")) || !this.checkMergeItem(beMergeItem = (DynamicObject)OrmUtils.clone((IDataEntityBase)tItem, (boolean)false, (boolean)false), sItem, tObj) || !this.checkBwMergeItem(beMergeItem, tObj, this.taxDiffEnum, false)) continue;
            this.doMergeItem(tItem, sItem, tObj, relations);
            return;
        }
        this.addNewItem(sItem, tObj, relations, tObj.getDynamicObjectCollection("sim_original_bill_item").size());
    }

    private boolean checkBwMergeItem(DynamicObject mergeItem, DynamicObject tObj, TaxDiffEnum taxDiffEnum, boolean isAddRow) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_AVG_001) {
            return true;
        }
        DynamicObjectCollection items = tObj.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        for (DynamicObject tItem : items) {
            if (tItem.getLong("id") == mergeItem.getLong("id")) {
                taxDeviationSum = taxDeviationSum.add(BillCalcMethod.getTaxDeviation(tObj, mergeItem, mergeItem.getBigDecimal("remainvalidamount"), mergeItem.getBigDecimal("remainvalidtax")));
                continue;
            }
            taxDeviationSum = taxDeviationSum.add(BillCalcMethod.getTaxDeviation(tObj, tItem, tItem.getBigDecimal("remainvalidamount"), tItem.getBigDecimal("remainvalidtax")));
        }
        BigDecimal taxDeviation = InvoiceConstant.DIFF_01.multiply(new BigDecimal(items.size() + (isAddRow ? 1 : 0)));
        return taxDeviation.compareTo(taxDeviationSum.setScale(2, 4).abs()) >= 0;
    }

    private void addOrMergeItem(DynamicObject sBeDisountItem, DynamicObject sDiscountItem, DynamicObject tObj, List<BillRelationDTO> relations, int startIndex) {
        DynamicObject mergeRule = BillMergeMethod.getBillMergeRule(tObj, this.mergeRuleMap);
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = startIndex + 1; i < tItems.size(); ++i) {
            DynamicObject tItem = (DynamicObject)tItems.get(i);
            if ("1".equals(tItem.getString("rowtype"))) continue;
            if (BillMergeHelper.isBeDisount((List<DynamicObject>)tItems, mergeRule, i)) {
                DynamicObject discountItem = (DynamicObject)tItems.get(i + 1);
                DynamicObject beNormalMerItem = (DynamicObject)OrmUtils.clone((IDataEntityBase)tItem, (boolean)false, (boolean)false);
                DynamicObject beDiscountMergeItem = (DynamicObject)OrmUtils.clone((IDataEntityBase)discountItem, (boolean)false, (boolean)false);
                if (!this.checkMergeItem(beNormalMerItem, sBeDisountItem, tObj) || !this.checkMergeItem(beDiscountMergeItem, sDiscountItem, tObj) || !this.checkBwMergeItem(beNormalMerItem, tObj, this.taxDiffEnum, false) || !this.checkRpaDiscountMergeItem(beDiscountMergeItem, sDiscountItem, tObj)) continue;
                this.doMergeItem(tItem, sBeDisountItem, tObj, relations);
                this.doMergeItem(discountItem, sDiscountItem, tObj, relations);
                return;
            }
            DynamicObject beNormalMerItem = (DynamicObject)OrmUtils.clone((IDataEntityBase)tItem, (boolean)false, (boolean)false);
            if (!this.checkMergeItem(beNormalMerItem, sBeDisountItem, tObj) || !this.checkBwMergeItem(beNormalMerItem, tObj, this.taxDiffEnum, true)) continue;
            this.doMergeItem(tItem, sBeDisountItem, tObj, relations);
            this.addNewItem(sDiscountItem, tObj, relations, i + 1);
            return;
        }
        this.addNewItem(sBeDisountItem, tObj, relations, tObj.getDynamicObjectCollection("sim_original_bill_item").size());
        this.addNewItem(sDiscountItem, tObj, relations, tObj.getDynamicObjectCollection("sim_original_bill_item").size());
    }

    private boolean checkRpaDiscountMergeItem(DynamicObject beDiscountMergeItem, DynamicObject sDiscountItem, DynamicObject tObj) {
        this.doMergeItem(beDiscountMergeItem, sDiscountItem, tObj, null);
        return BillCheckMethod.checkItemIsMoreThanDeviation(beDiscountMergeItem, tObj, InvoiceConstant.DIFF_01);
    }

    public static boolean isBeDisount(List<DynamicObject> detailList, DynamicObject mergeRule, int taxDeviationNearIndex) {
        if (taxDeviationNearIndex + 1 == detailList.size()) {
            return false;
        }
        DynamicObject nextItem = detailList.get(taxDeviationNearIndex + 1);
        String nextItemKey = BillMergeMethod.getMergeBillDetailKey(nextItem, null, mergeRule, true);
        String itemKey = BillMergeMethod.getMergeBillDetailKey(detailList.get(taxDeviationNearIndex), null, mergeRule, true);
        return "1".equals(nextItem.getString("rowtype")) && nextItemKey.equals(itemKey);
    }

    private Integer getTaxDeviationNear(Map<Integer, MergeTaxDeviationDTO> taxDeviationMap, String rowType, BigDecimal taxDeviation) {
        Set<Map.Entry<Integer, MergeTaxDeviationDTO>> entries = taxDeviationMap.entrySet();
        List<Map.Entry<Integer, MergeTaxDeviationDTO>> taxDeviationList = entries.stream().filter(o -> ((MergeTaxDeviationDTO)o.getValue()).getRowType().equals(rowType)).collect(Collectors.toList());
        return BillMergeHelper.getTaxDeviationNear(taxDeviationList, taxDeviation);
    }

    public static Integer getTaxDeviationNear(List<Map.Entry<Integer, MergeTaxDeviationDTO>> taxDeviationList, BigDecimal taxDeviation) {
        if (taxDeviationList.size() == 0) {
            return null;
        }
        Map.Entry<Integer, MergeTaxDeviationDTO> findEntry = taxDeviationList.get(0);
        BigDecimal findDiff = taxDeviation.subtract(findEntry.getValue().getTaxDeviation()).abs();
        for (Map.Entry<Integer, MergeTaxDeviationDTO> entry : taxDeviationList) {
            BigDecimal abs = taxDeviation.subtract(entry.getValue().getTaxDeviation()).abs();
            if (abs.compareTo(findDiff) >= 0) continue;
            findDiff = abs;
            findEntry = entry;
        }
        return findEntry.getKey();
    }

    private DynamicObject findLastSameItem(DynamicObject tObj, int tItemSize, DynamicObject sItem) {
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = tItems.size() - 1; i >= tItemSize; --i) {
            DynamicObject item = (DynamicObject)tItems.get(i);
            if (!sItem.getString("rowtype").equals(item.getString("rowtype"))) continue;
            return item;
        }
        return null;
    }

    private void addNewItem(DynamicObject nowItem, DynamicObject tObj, List<BillRelationDTO> relations, int index) {
        DynamicObjectCollection tItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal remainValidAmount = nowItem.getBigDecimal("remainvalidamount");
        BigDecimal remainValidTax = nowItem.getBigDecimal("remainvalidtax");
        BigDecimal amount = "1".equals(tObj.getString("hsbz")) ? remainValidAmount.subtract(remainValidTax) : remainValidAmount;
        DynamicObject tItem = (DynamicObject)tItems.getDynamicObjectType().createInstance();
        tItems.add(index, tItem);
        DynamicObjectUtil.copyDynamicObject((DynamicObject)nowItem, (DynamicObject)tItem);
        tItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
        tItem.set("remainvalidamount", (Object)amount.add(remainValidTax));
        if (this.isZero(nowItem)) {
            tItem.set("remainvalidnum", (Object)BigDecimal.ZERO);
        }
        this.addRelation(relations, nowItem, tObj, tItem, amount);
    }

    private void addRelation(List<BillRelationDTO> relations, DynamicObject nowItem, DynamicObject tObj, DynamicObject tItem, BigDecimal amount) {
        Long sDetailId = nowItem.getLong("id");
        DynamicObject sObj = this.detailId2BillMap.get(sDetailId);
        Long sBillId = sObj.getLong("id");
        BillRelationDTO billRelation = new BillRelationDTO(sBillId, sObj.getString("billno"), sDetailId, Long.valueOf(tObj.getLong("id")), "", Long.valueOf(tItem.getLong("id")), amount, nowItem.getBigDecimal("remainvalidtax"), nowItem.getBigDecimal("remainvalidnum"), nowItem.getBigDecimal("unitprice"), "sim_vatinvoice");
        billRelation.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)sObj.get("orgid"))));
        if (nowItem.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
            billRelation.setPushZero(true);
        }
        relations.add(billRelation);
    }

    private void subItem(boolean isTax, DynamicObject item, DynamicObject subItem, List<BillRelationDTO> relations) {
        relations.removeIf(relation -> relation.getsDetailId().equals(subItem.getLong("id")));
        item.set("amount", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)subItem.getBigDecimal("amount")));
        item.set("taxamount", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("taxamount"), (BigDecimal)subItem.getBigDecimal("taxamount")));
        item.set("tax", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("tax"), (BigDecimal)subItem.getBigDecimal("tax")));
        item.set("num", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("num"), (BigDecimal)subItem.getBigDecimal("num")));
        BigDecimal remainValidAmount = BigDecimalUtil.add((BigDecimal)subItem.getBigDecimal("remainvalidamount"), (BigDecimal)(isTax ? BigDecimal.ZERO : subItem.getBigDecimal("remainvalidtax")));
        item.set("remainvalidamount", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)remainValidAmount));
        item.set("remainvalidtax", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("remainvalidtax"), (BigDecimal)subItem.getBigDecimal("remainvalidtax")));
        item.set("remainvalidnum", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("remainvalidnum"), (BigDecimal)subItem.getBigDecimal("remainvalidnum")));
        item.set("itemdeduction", (Object)BigDecimalUtil.subtract((BigDecimal)item.getBigDecimal("itemdeduction"), (BigDecimal)subItem.getBigDecimal("itemdeduction")));
    }

    private boolean checkMergeItem(DynamicObject beMergeItem, DynamicObject nowItem, DynamicObject tObj) {
        this.doMergeItem(beMergeItem, nowItem, tObj, null);
        return BillCheckMethod.checkItemIsMoreThanDeviation(beMergeItem, tObj, InvoiceConstant.DIFFF_06);
    }

    private void doMergeItem(DynamicObject beMergeItem, DynamicObject nowItem, DynamicObject tObj, List<BillRelationDTO> relations) {
        boolean isTax = "1".equals(tObj.getString("hsbz"));
        BigDecimal remainValidAmount = nowItem.getBigDecimal("remainvalidamount");
        BigDecimal remainValidTax = nowItem.getBigDecimal("remainvalidtax");
        BigDecimal amount = isTax ? remainValidAmount.subtract(remainValidTax) : remainValidAmount;
        beMergeItem.set("amount", (Object)beMergeItem.getBigDecimal("amount").add(nowItem.getBigDecimal("amount")));
        beMergeItem.set("taxamount", (Object)beMergeItem.getBigDecimal("taxamount").add(nowItem.getBigDecimal("taxamount")));
        beMergeItem.set("tax", (Object)beMergeItem.getBigDecimal("tax").add(nowItem.getBigDecimal("tax")));
        if (!this.isZero(nowItem)) {
            beMergeItem.set("num", (Object)beMergeItem.getBigDecimal("num").add(nowItem.getBigDecimal("num")));
            beMergeItem.set("remainvalidnum", (Object)beMergeItem.getBigDecimal("remainvalidnum").add(nowItem.getBigDecimal("remainvalidnum")));
        }
        beMergeItem.set("remainvalidtax", (Object)beMergeItem.getBigDecimal("remainvalidtax").add(remainValidTax));
        beMergeItem.set("remainvalidamount", (Object)beMergeItem.getBigDecimal("remainvalidamount").add(amount.add(remainValidTax)));
        beMergeItem.set("itemdeduction", (Object)beMergeItem.getBigDecimal("itemdeduction").add(nowItem.getBigDecimal("itemdeduction")));
        if (relations != null) {
            this.addRelation(relations, nowItem, tObj, beMergeItem, amount);
        }
    }

    private LinkedHashMap<String, List<DynamicObject>> getBillDetailMergeMap(boolean mergeBillDetail, DynamicObjectCollection collection, DynamicObject mergeRule) {
        LinkedHashMap<String, List<DynamicObject>> billDetailMaps = new LinkedHashMap<String, DynamicObjectCollection>(collection.size());
        if (mergeBillDetail) {
            billDetailMaps = BillMergeMethod.getMergeBillDetailMap(collection, this.detailId2BillMap, mergeRule);
        } else {
            billDetailMaps.put("no_merge", (List<DynamicObject>)collection);
        }
        return billDetailMaps;
    }
}

