/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.enums.TaxDiffEnum;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCalcMethod;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import org.apache.commons.collections.CollectionUtils;

public class BillMergeMethod {
    public static final String SEPARATOR = "\u25cf\u25c6\u25a0";
    private static Set<String> NOT_MERGE_BILL_SYSTEM_SOURCE = new HashSet<String>(16);
    private static final String[] discountMergeField;

    public static LinkedHashMap<String, List<DynamicObject>> getMergeBillMap(DynamicObject[] bills, Map<Object, DynamicObject> mergeRuleMap) {
        Map easBusinessSystems = BusinessDataServiceHelper.loadFromCache((String)"invsm_callback_config", (String)"business_system_code", (QFilter[])new QFilter("1", "=", (Object)1).toArray());
        NOT_MERGE_BILL_SYSTEM_SOURCE.addAll(easBusinessSystems.values().stream().map(eas -> eas.getString("business_system_code")).collect(Collectors.toSet()));
        LinkedHashMap<String, List> mergeGroupMap = new LinkedHashMap<String, List>(bills.length);
        for (DynamicObject bill2 : bills) {
            if (BillMergeMethod.notMergeBill(bill2)) {
                mergeGroupMap.put(bill2.getPkValue().toString(), Collections.singletonList(bill2));
                continue;
            }
            DynamicObject mergeRule = bill2.getDynamicObject("mergerule");
            List mergeList = mergeRule == null ? mergeGroupMap.computeIfAbsent("0", k -> new ArrayList()) : mergeGroupMap.computeIfAbsent(mergeRule.getPkValue().toString(), k -> new ArrayList());
            mergeList.add(bill2);
        }
        LinkedHashMap<String, List<DynamicObject>> returnMap = new LinkedHashMap<String, List<DynamicObject>>(bills.length);
        Set mergeGroupEntry = mergeGroupMap.entrySet();
        for (Map.Entry entry : mergeGroupEntry) {
            List mergeList = (List)entry.getValue();
            if (mergeList.size() == 1) {
                returnMap.put((String)entry.getKey(), (List<DynamicObject>)entry.getValue());
                continue;
            }
            LinkedHashMap collect = mergeList.stream().collect(Collectors.groupingBy(bill -> BillMergeMethod.getMergeBillKey(bill, mergeRuleMap), LinkedHashMap::new, Collectors.toList()));
            returnMap.putAll(collect);
        }
        return returnMap;
    }

    private static boolean notMergeBill(DynamicObject bill) {
        boolean isAllE;
        if (TaxedTypeEnum.deduction.getValue().equals(bill.getString("taxationstyle")) || bill.getBigDecimal("deduction").compareTo(BigDecimal.ZERO) != 0) {
            return true;
        }
        if (OriginalBillConstant.isSpecialSourcType((Object)bill.getString("billsourcetype")) && !"D".equals(bill.getString("billsourcetype"))) {
            return true;
        }
        if (NOT_MERGE_BILL_SYSTEM_SOURCE.contains(bill.getString("systemsource"))) {
            return true;
        }
        boolean bl = isAllE = InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)bill.getString("iselepaper"));
        if (!isAllE) {
            return false;
        }
        if (TaxedTypeEnum.alleTaxedTypeDeduction((String)bill.getString("taxationstyle"))) {
            return true;
        }
        return InvoiceSpecialType.allEleSpecialType((String)bill.getString("specialtype")) && !InvoiceSpecialType.allEleSpecialMerge((String)bill.getString("specialtype"));
    }

    private static String getMergeBillKey(DynamicObject obj, Map<Object, DynamicObject> mergeRuleMap) {
        DynamicObject mergeRule = BillMergeMethod.getBillMergeRule(obj, mergeRuleMap);
        ArrayList<String> list = new ArrayList<String>(50);
        list.add(obj.getString("buyername"));
        list.add(obj.getString("buyertaxno"));
        list.add(obj.getString("invoicetype"));
        list.add(obj.getString("taxationstyle"));
        list.add(obj.getString("hsbz"));
        list.add(obj.getString("applicant"));
        list.add(obj.getString("infocode"));
        list.add(obj.getString("blueinvoicecode"));
        list.add(obj.getString("blueinvoiceno"));
        list.add(DateUtils.format((Date)obj.getDate("originalissuetime"), (String)"yyyy-MM-dd"));
        list.add(obj.getString("redreason"));
        list.add(obj.getString("buyerproperty"));
        list.add(obj.getString("bizcontroltype"));
        list.add(obj.getString("operatebatch"));
        if ("00".equals(obj.getString("specialtype"))) {
            list.add("");
        } else {
            list.add(obj.getString("specialtype"));
        }
        list.add(String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("mergerule"))));
        if ("Kingdee_Excel".equals(obj.getString("systemsource"))) {
            list.add("");
        } else {
            list.add(obj.getString("systemsource"));
        }
        if ("A".equals(obj.getString("billsourcetype"))) {
            list.add("");
        } else {
            list.add(obj.getString("billsourcetype"));
        }
        String billMergeKey = mergeRule.getString("billmergekey");
        if (StringUtils.isNotBlank((CharSequence)billMergeKey)) {
            String[] billMergeFields = billMergeKey.split(",");
            BillMergeMethod.getMergeValue(list, billMergeFields, obj, "");
        }
        return String.join((CharSequence)SEPARATOR, list);
    }

    static LinkedHashMap<String, List<DynamicObject>> getMergeBillDetailMap(DynamicObjectCollection items, Map<Long, DynamicObject> detailId2BillMap, DynamicObject mergeRule) {
        DynamicObject bill = detailId2BillMap.get(((DynamicObject)items.get(0)).getLong("id"));
        String hsbz = bill.getString("hsbz");
        LinkedHashMap<String, List<DynamicObject>> returnMap = new LinkedHashMap<String, List<DynamicObject>>(items.size());
        HashMap<String, Set<String>> discountKey2ItemKeyMap = new HashMap<String, Set<String>>(items.size());
        LinkedHashMap<String, List<DynamicObject>> discountItemMap = new LinkedHashMap<String, List<DynamicObject>>(items.size());
        block8: for (int i = 0; i < items.size(); ++i) {
            DynamicObject item2 = (DynamicObject)items.get(i);
            String discountItemKey = BillMergeMethod.getMergeBillDetailKey(item2, hsbz, mergeRule, true);
            switch (item2.getString("rowtype")) {
                case "2": {
                    String mergeBillDetailKey = BillMergeMethod.getMergeBillDetailKey(item2, hsbz, mergeRule, false);
                    List dynamicObjects = returnMap.computeIfAbsent(mergeBillDetailKey, k -> new ArrayList());
                    dynamicObjects.add(item2);
                    Set discountKey2ItemKeyList = discountKey2ItemKeyMap.computeIfAbsent(discountItemKey, k -> new HashSet());
                    discountKey2ItemKeyList.add(mergeBillDetailKey);
                    continue block8;
                }
                case "1": {
                    if (i == 0) {
                        BillMergeMethod.addItemToDiscountMap(item2, discountItemMap, mergeRule);
                        continue block8;
                    }
                    DynamicObject preItem = (DynamicObject)items.get(i - 1);
                    if ("2".equals(preItem.getString("rowtype")) && BillMergeMethod.isCanMergeItems(preItem, item2, mergeRule)) {
                        String mergeBillDiscountDetailKey = BillMergeMethod.getMergeBillDetailKey((DynamicObject)items.get(i - 1), hsbz, mergeRule, false);
                        returnMap.get(mergeBillDiscountDetailKey).add(item2);
                        continue block8;
                    }
                    BillMergeMethod.addItemToDiscountMap(item2, discountItemMap, mergeRule);
                    continue block8;
                }
            }
        }
        BillMergeMethod.handleDiscountItemMap(discountItemMap, returnMap, discountKey2ItemKeyMap);
        Collection<List<DynamicObject>> discountList = discountItemMap.values();
        if (!CollectionUtils.isEmpty(discountList)) {
            discountList.stream().flatMap(Collection::stream).findFirst().ifPresent(item -> {
                DynamicObject originalBill = (DynamicObject)detailId2BillMap.get(item.getLong("id"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s],\u5546\u54c1\u540d\u79f0[%2$s],\u91d1\u989d[%3$s]\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u5546\u54c1\u884c", (String)"BillMergeMethod_0", (String)"imc-sim-service", (Object[])new Object[0]), originalBill.getString("billno"), item.get("goodsname"), item.getBigDecimal("remainvalidamount").setScale(2, 4).toString()));
            });
        }
        return returnMap;
    }

    private static void handleDiscountItemMap(Map<String, List<DynamicObject>> discountItemMap, Map<String, List<DynamicObject>> returnMap, Map<String, Set<String>> discountKey2ItemKeyMap) {
        if (discountItemMap == null || discountItemMap.size() == 0) {
            return;
        }
        Set<Map.Entry<String, List<DynamicObject>>> discountEntries = discountItemMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> discountEntry : discountEntries) {
            List<DynamicObject> discountList = discountEntry.getValue();
            Set<String> itemKeyList = discountKey2ItemKeyMap.get(discountEntry.getKey());
            if (CollectionUtils.isEmpty(itemKeyList)) continue;
            HashMap<String, BigDecimal> mergeItemKey = new HashMap<String, BigDecimal>(itemKeyList.size());
            for (String itemKey : itemKeyList) {
                List<DynamicObject> mergeItems = returnMap.get(itemKey);
                BigDecimal sumAmount = mergeItems.stream().map(item -> item.getBigDecimal("remainvalidamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (sumAmount.compareTo(BigDecimal.ZERO) < 0) continue;
                mergeItemKey.put(itemKey, sumAmount);
            }
            Iterator<DynamicObject> iterator = discountList.iterator();
            while (iterator.hasNext()) {
                DynamicObject discountItem = iterator.next();
                ArrayList mergeItemList = new ArrayList(mergeItemKey.entrySet());
                List mergeItemAmountList = mergeItemList.stream().filter(mergeItem -> ((BigDecimal)mergeItem.getValue()).add(discountItem.getBigDecimal("remainvalidamount")).compareTo(BigDecimal.ZERO) >= 0).sorted(Comparator.comparing(Map.Entry::getValue)).collect(Collectors.toList());
                if (mergeItemAmountList.size() == 0) continue;
                Map.Entry mergeItemAmount = (Map.Entry)mergeItemAmountList.get(0);
                List<DynamicObject> mergeItems = returnMap.get(mergeItemAmount.getKey());
                mergeItems.add(discountItem);
                iterator.remove();
                mergeItemKey.put((String)mergeItemAmount.getKey(), ((BigDecimal)mergeItemAmount.getValue()).add(discountItem.getBigDecimal("remainvalidamount")));
            }
        }
    }

    private static boolean isCanMergeItems(DynamicObject preItem, DynamicObject item, DynamicObject mergeRule) {
        String preItemKey = BillMergeMethod.getMergeBillDetailKey(preItem, null, mergeRule, true);
        String itemKey = BillMergeMethod.getMergeBillDetailKey(item, null, mergeRule, true);
        return preItemKey.equals(itemKey);
    }

    private static void addItemToDiscountMap(DynamicObject item, LinkedHashMap<String, List<DynamicObject>> discountItemMap, DynamicObject mergeRule) {
        String itemKey = BillMergeMethod.getMergeBillDetailKey(item, null, mergeRule, true);
        List discountList = discountItemMap.computeIfAbsent(itemKey, k -> new ArrayList());
        discountList.add(item);
    }

    static String getMergeBillDetailKey(DynamicObject item, String hsbz, DynamicObject mergeRule, boolean clearDiscountField) {
        ArrayList<String> list = new ArrayList<String>(15);
        list.add(item.getString("goodsname"));
        if (!clearDiscountField) {
            list.add(item.getString("rowtype"));
        }
        list.add(item.getString("taxrate"));
        String itemMergeKey = mergeRule.getString("itemmergekey");
        String[] itemMergeFields = clearDiscountField ? discountMergeField : (StringUtils.isNotBlank((CharSequence)itemMergeKey) ? itemMergeKey.split(",") : new String[]{});
        BillMergeMethod.getMergeValue(list, itemMergeFields, item, "1".equals(hsbz) ? item.getString("taxunitprice") : item.getString("unitprice"));
        return String.join((CharSequence)SEPARATOR, list);
    }

    public static void getMergeValue(List<String> list, String[] itemMergeFields, DynamicObject item, String price) {
        for (String itemMergeField : itemMergeFields) {
            if ("price".equals(itemMergeField)) {
                list.add(price);
                continue;
            }
            Object billValue = item.get(itemMergeField);
            if (billValue == null) {
                list.add("");
                continue;
            }
            if (billValue instanceof DynamicObject) {
                list.add(((DynamicObject)billValue).getPkValue().toString());
                continue;
            }
            if (billValue instanceof Date) {
                list.add(DateUtils.format((Date)((Date)billValue), (String)"yyyy-MM-dd"));
                continue;
            }
            list.add(String.valueOf(billValue));
        }
    }

    static void calcBillHeadAmount(DynamicObject tObj) {
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal taxAmountSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        DynamicObjectCollection items = tObj.getDynamicObjectCollection("sim_original_bill_item");
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            item.set("seq", (Object)i);
            BigDecimal remainValidAmount = item.getBigDecimal("remainvalidamount").setScale(2, 4);
            BigDecimal remainValidTax = item.getBigDecimal("remainvalidtax").setScale(2, 4);
            BigDecimal amount = remainValidAmount.subtract(remainValidTax);
            amountSum = amountSum.add(amount);
            taxAmountSum = taxAmountSum.add(remainValidAmount);
            taxSum = taxSum.add(remainValidTax);
        }
        tObj.set("totalamount", (Object)taxAmountSum);
        tObj.set("invoiceamount", (Object)amountSum);
        tObj.set("totaltax", (Object)taxSum);
        tObj.set("billproperties", (Object)(amountSum.compareTo(BigDecimal.ZERO) > 0 ? "1" : "-1"));
        if (RedConfirmHelper.isRedConfirmBill((DynamicObject)tObj)) {
            tObj.set("mergelable", (Object)"");
        }
    }

    static void fillInSplitRule(DynamicObject tObj, LimitAmountsDTO limitAmountsDTO) {
        if (tObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            tObj.set("splitrule", (Object)"imc_no_split");
            return;
        }
        if (OriginalBillConstant.isSpecialSourcType((Object)tObj.getString("billsourcetype")) && !"D".equals(tObj.getString("billsourcetype"))) {
            tObj.set("splitrule", (Object)"imc_no_split");
            return;
        }
        if (TaxedTypeEnum.deduction.getValue().equals(tObj.getString("taxationstyle"))) {
            BigDecimal limit = AbstractBillSplitServiceImpl.getLimitMap(limitAmountsDTO).get(tObj.getString("invoicetype"));
            if (limit.compareTo(tObj.getBigDecimal("invoiceamount")) >= 0) {
                tObj.set("splitrule", (Object)"imc_no_split");
            } else {
                tObj.set("splitrule", (Object)"imc_deduction_split");
            }
            return;
        }
        if (InvoiceUtils.isAllEInvoice((Object)tObj.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)tObj.getString("iselepaper"))) {
            if (InvoiceSpecialType.allEleSpecialType((String)tObj.getString("specialtype"))) {
                tObj.set("splitrule", (Object)"imc_no_split");
                return;
            }
            if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(tObj.getString("taxationstyle")) || TaxedTypeEnum.all_e_deduction.getValue().equals(tObj.getString("taxationstyle"))) {
                tObj.set("splitrule", (Object)"imc_no_split");
                return;
            }
        }
        if (StringUtils.isBlank((Object)tObj.get("splitrule"))) {
            tObj.set("splitrule", (Object)"000000_s");
        }
    }

    static BigDecimal adjustmentTailDifference(DynamicObject tObj, TaxDiffEnum taxDiffEnum, List<BillRelationDTO> relations) {
        DynamicObjectCollection items = tObj.getDynamicObjectCollection("sim_original_bill_item");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)tObj.getString("invoicetype")) || "1".equals(tObj.getString("iselepaper"));
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        BigDecimal taxDeviationSumAbs = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            BigDecimal itemTaxAmount = item.getBigDecimal("remainvalidamount");
            BigDecimal tax = item.getBigDecimal("remainvalidtax");
            BigDecimal deduction = BillCalcMethod.getDeduction(tObj, item);
            if ("1".equals(item.getString("rowtype"))) {
                deduction = BigDecimal.ZERO;
            }
            BigDecimal calcTax = BillCalcMethod.calcBillTax(itemTaxAmount, tax, deduction, item.getString("taxrate"), 1);
            if (!(TaxedTypeEnum.all_e_reduced_tax.getValue().equals(tObj.getString("taxationstyle")) || !BigDecimalUtil.compare((BigDecimal)calcTax, (BigDecimal)tax, (BigDecimal)InvoiceConstant.DIFFF_06) && BillMergeMethod.checkBwTaxDeviation(tObj, taxDiffEnum) && BillMergeMethod.checkRpaTaxDeviation(tObj, item, calcTax.subtract(tax), taxDiffEnum))) {
                calcTax = calcTax.setScale(2, 4);
                item.set("remainvalidtax", (Object)calcTax);
                BigDecimal diffAmount = tax.subtract(calcTax).setScale(2, 4);
                item.set("taxdeviation", (Object)diffAmount);
                relations.stream().filter(relation -> relation.gettDetailId().equals(item.getLong("id"))).forEach(relation -> relation.setTaxDeviation(diffAmount));
                taxDeviationSum = taxDeviationSum.add(diffAmount);
                taxDeviationSumAbs = taxDeviationSumAbs.add(diffAmount.abs());
            }
            BillCalcMethod.calcPrice(item, isAllEle);
        }
        tObj.set("maintaxdeviation", (Object)taxDeviationSum);
        return taxDeviationSumAbs;
    }

    static boolean checkBwTaxDeviation(DynamicObject tObj, TaxDiffEnum taxDiffEnum) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_AVG_001) {
            return true;
        }
        DynamicObjectCollection items = tObj.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        for (DynamicObject tItem : items) {
            taxDeviationSum = taxDeviationSum.add(BillCalcMethod.getTaxDeviation(tObj, tItem, tItem.getBigDecimal("remainvalidamount"), tItem.getBigDecimal("remainvalidtax")));
        }
        BigDecimal taxDeviation = InvoiceConstant.DIFF_01.multiply(new BigDecimal(items.size()));
        return taxDeviation.compareTo(taxDeviationSum.setScale(2, 4).abs()) >= 0;
    }

    static boolean checkRpaTaxDeviation(DynamicObject tObj, DynamicObject item, BigDecimal taxDeviation, TaxDiffEnum taxDiffEnum) {
        if (taxDiffEnum != TaxDiffEnum.DIFF_RPA_001) {
            return true;
        }
        if (!InvoiceUtils.isAllEInvoice((Object)tObj.getString("invoicetype"))) {
            return true;
        }
        if (!"1".equals(item.getString("rowtype"))) {
            return true;
        }
        return taxDeviation.abs().compareTo(InvoiceConstant.DIFF_01) <= 0;
    }

    static DynamicObject getBillMergeRule(DynamicObject tObj, Map<Object, DynamicObject> mergeRuleMap) {
        long mergeRuleId = DynamicObjectUtil.getDynamicObjectLongValue((Object)tObj.get("mergerule"));
        if (mergeRuleId == 0L) {
            return BillMergeMethod.createDefaultMergeConfig();
        }
        DynamicObject mergeRule = mergeRuleMap.get(mergeRuleId);
        return mergeRule == null ? BillMergeMethod.createDefaultMergeConfig() : mergeRule;
    }

    public static DynamicObject createDefaultMergeConfig() {
        DynamicObject mergeRule = BusinessDataServiceHelper.newDynamicObject((String)"bdm_merge_rule_strategy");
        mergeRule.set("billmergekey", (Object)String.join((CharSequence)",", "blueinvoicecode", "blueinvoiceno", "infocode"));
        mergeRule.set("itemmergekey", (Object)String.join((CharSequence)",", "specification", "unit", "policylogo", "policycontants", "price"));
        mergeRule.set("deviationrule", (Object)"2");
        return mergeRule;
    }

    static void clearItemInfo(DynamicObject tObj, DynamicObject mergeRule) {
        String clearItemKey = mergeRule.getString("clearitemkey");
        if (StringUtils.isBlank((CharSequence)clearItemKey)) {
            return;
        }
        if (InvoiceUtils.isAllEInvoice((Object)tObj.getString("invoicetype")) && tObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        DynamicObjectCollection items = tObj.getDynamicObjectCollection("sim_original_bill_item");
        if (clearItemKey.contains("num") && items.stream().anyMatch(item -> !MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("remainvalidnum")))) {
            tObj.set("mergelable", (Object)"1");
        }
        String[] itemKeyArr = clearItemKey.split(",");
        boolean vehicleSpecialInvoice = BillMergeMethod.isVehicleSpecialInvoice(tObj);
        DataEntityPropertyCollection itemProperties = ((DynamicObject)items.get(0)).getDynamicObjectType().getProperties();
        for (DynamicObject item2 : items) {
            for (String itemKey : itemKeyArr) {
                if (vehicleSpecialInvoice) continue;
                if ("price".equals(itemKey)) {
                    item2.set("unitprice", null);
                    item2.set("taxunitprice", null);
                    continue;
                }
                if ("num".equals(itemKey)) {
                    item2.set("remainvalidnum", null);
                    continue;
                }
                if (!itemProperties.containsKey((Object)itemKey)) continue;
                item2.set(itemKey, null);
            }
        }
    }

    private static boolean isVehicleSpecialInvoice(DynamicObject tObj) {
        String invoiceType = tObj.getString("invoicetype");
        String specialType = tObj.getString("specialtype");
        return InvoiceUtils.isSpecialInvoice((String)invoiceType) && "18".equals(specialType);
    }

    static {
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("YNZY_TOBACCO");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("KINGDEE_FI");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("AR_FINARBILL");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("AR_BUSBILL");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("\u8d22\u52a1\u5e94\u6536\u5355");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("KINGDEECLOUD");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("XKQJ");
        NOT_MERGE_BILL_SYSTEM_SOURCE.add("BGD_COLLECT");
        discountMergeField = new String[]{"goodscode", "policylogo", "policycontants"};
    }
}

