/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.billsplit.SplitAmountDTO;

public class BillSplitAmountAdjustHelper {
    private static final Log log = LogFactory.getLog(BillSplitAmountAdjustHelper.class);
    private static final String CACHE_KEY_NEED_FORCE_PRICE = "forceChangePrice";

    public void warpInvoiceTaxError(List<BillRelationDTO> relations, SplitAmountDTO splitAmountDTO) {
        DynamicObject invoiceItem;
        int i;
        DynamicObject invoiceDynamicObject = splitAmountDTO.getInvoiceDynamicObject();
        BigDecimal errorBigDecimal = splitAmountDTO.getAmount().subtract(invoiceDynamicObject.getBigDecimal("totalamount"));
        log.info(String.format("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u6bcf\u5f20\u53d1\u7968\u548c\u5bf9\u5e94\u586b\u7684\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c%s", errorBigDecimal));
        BigDecimal limit = new BigDecimal("0.01");
        BigDecimal needAdjustCount = errorBigDecimal.divide(limit, 2, RoundingMode.HALF_UP);
        if (needAdjustCount.signum() == -1) {
            needAdjustCount = needAdjustCount.negate();
            limit = limit.negate();
        }
        DynamicObjectCollection invoiceItems = invoiceDynamicObject.getDynamicObjectCollection("items");
        int size = needAdjustCount.intValue();
        int moreDiff = 0;
        if (size > invoiceItems.size()) {
            size = invoiceItems.size();
            moreDiff = needAdjustCount.intValue() - invoiceItems.size();
        }
        for (i = 0; i < size; ++i) {
            log.info(String.format("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u53d1\u7968\u8bef\u5dee\uff0c\u5f00\u59cb\u8c03\u6574\u7a0e\u989d\uff0c%s", i));
            invoiceItem = (DynamicObject)invoiceItems.get(i);
            this.adjustInvoiceItemTax(relations, invoiceDynamicObject, invoiceItem, limit, 0);
        }
        if (moreDiff > 0) {
            for (i = 0; i < moreDiff; ++i) {
                log.info(String.format("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u8d85\u8fc7\u53d1\u7968\u660e\u7ec6\u6570\u91cf\u7684\u8bef\u5dee\uff0c\u5f00\u59cb\u8c03\u6574\u7a0e\u989d\uff0c%s", i));
                invoiceItem = (DynamicObject)invoiceItems.get(i);
                this.adjustInvoiceItemTax(relations, invoiceDynamicObject, invoiceItem, limit, 0);
            }
        }
    }

    public void handleErrorAmount(SplitRequestDTO requestDTO, List<DynamicObject> invoiceList, List<BillRelationDTO> relations) {
        BigDecimal splitInvoiceTotalTax = BigDecimal.ZERO;
        for (DynamicObject invoice : invoiceList) {
            splitInvoiceTotalTax = splitInvoiceTotalTax.add(invoice.getBigDecimal("totaltax"));
            if (invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0) {
                invoice.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
                continue;
            }
            invoice.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        }
        try {
            DynamicObject splitConfigDynamicObject = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject((long)((Long)requestDTO.getBill().get("orgid")));
            if (splitConfigDynamicObject != null && splitConfigDynamicObject.getBoolean("adjusttax") && splitInvoiceTotalTax.compareTo(requestDTO.getBill().getBigDecimal("totaltax")) != 0) {
                this.matchingInvoiceTotalTax(requestDTO, invoiceList, relations, splitInvoiceTotalTax);
            }
        }
        catch (Exception e) {
            log.error("\u542b\u7a0e\u91d1\u989d\u62c6\u5206\uff0c\u7a0e\u989d\u8c03\u6574\u5f02\u5e38", (Throwable)e);
        }
    }

    private void matchingInvoiceTotalTax(SplitRequestDTO requestDTO, List<DynamicObject> invoices, List<BillRelationDTO> relations, BigDecimal splitInvoiceTotalTax) {
        BigDecimal errorBigDecimal = requestDTO.getBill().getBigDecimal("totaltax").subtract(splitInvoiceTotalTax);
        log.info(String.format("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u62c6\u5206\u7684\u53d1\u7968\u603b\u7a0e\u989d\u4e0d\u7b49\u4e8e\u5f00\u7968\u7533\u8bf7\u5355\u7684\u7a0e\u989d\uff0c%s", errorBigDecimal));
        BigDecimal limit = new BigDecimal("0.01");
        BigDecimal needAdjustCount = errorBigDecimal.divide(limit, 2, RoundingMode.HALF_UP);
        if (needAdjustCount.signum() == -1) {
            needAdjustCount = needAdjustCount.negate();
            limit = limit.negate();
        }
        int size = needAdjustCount.intValue();
        int count = 0;
        for (int i = 0; i < size && count != size; ++i) {
            DynamicObject invoiceDynamicObject = invoices.get(i);
            DynamicObjectCollection invoiceItems = invoiceDynamicObject.getDynamicObjectCollection("items");
            for (int j = 0; j < invoiceItems.size() && j != size - count && count != size; ++j) {
                DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(j);
                if ("1".equals(invoiceItem.getString("rowtype"))) continue;
                this.adjustInvoiceItemTax(relations, invoiceDynamicObject, invoiceItem, limit, 1);
                ++count;
            }
        }
    }

    private void adjustInvoiceItemTax(List<BillRelationDTO> relations, DynamicObject invoiceDynamicObject, DynamicObject invoiceItem, BigDecimal errorBigDecimal, int type) {
        BigDecimal oldItemTax = invoiceItem.getBigDecimal("tax");
        BigDecimal oldItemAmount = invoiceItem.getBigDecimal("amount");
        BigDecimal newItemAdjustTax = BigDecimal.ZERO;
        BigDecimal newItemAdjustAmount = BigDecimal.ZERO;
        if (type == 0) {
            newItemAdjustTax = errorBigDecimal.signum() == -1 ? oldItemTax.add(errorBigDecimal) : oldItemTax.subtract(errorBigDecimal);
            newItemAdjustAmount = oldItemAmount;
        } else if (type == 1) {
            newItemAdjustTax = oldItemTax.add(errorBigDecimal);
            newItemAdjustAmount = invoiceItem.getBigDecimal("taxamount").subtract(newItemAdjustTax);
        }
        invoiceItem.set("tax", (Object)newItemAdjustTax);
        invoiceItem.set("amount", (Object)newItemAdjustAmount);
        for (BillRelationDTO relation : relations) {
            if (!relation.gettDetailId().equals(invoiceItem.getPkValue())) continue;
            relation.setTax(newItemAdjustTax);
            relation.setAmount(newItemAdjustAmount);
            break;
        }
        BigDecimal adjustTotalTax = invoiceDynamicObject.getBigDecimal("totaltax").subtract(oldItemTax).add(newItemAdjustTax);
        invoiceDynamicObject.set("totaltax", (Object)adjustTotalTax);
        BigDecimal adjustAmount = invoiceDynamicObject.getBigDecimal("invoiceamount").subtract(oldItemAmount).add(newItemAdjustAmount);
        invoiceDynamicObject.set("invoiceamount", (Object)adjustAmount);
        if (type == 0) {
            invoiceItem.set("taxamount", (Object)newItemAdjustAmount.add(newItemAdjustTax));
            if (errorBigDecimal.signum() == -1) {
                invoiceDynamicObject.set("totalamount", (Object)invoiceDynamicObject.getBigDecimal("totalamount").add(errorBigDecimal));
            } else {
                invoiceDynamicObject.set("totalamount", (Object)invoiceDynamicObject.getBigDecimal("totalamount").subtract(errorBigDecimal));
            }
        }
    }

    public void retainNumberDigit(SplitRequestDTO requestDTO, List<DynamicObject> invoiceList) {
        DynamicObject hsConfigDynamicObject = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceList.get(0).get("orgid")));
        if (hsConfigDynamicObject == null) {
            return;
        }
        if (!"1".equals(hsConfigDynamicObject.getString("splitrule"))) {
            return;
        }
        if ("2".equals(hsConfigDynamicObject.getString("numberdigitrule"))) {
            CacheHelper.put((String)(CACHE_KEY_NEED_FORCE_PRICE + requestDTO.getBill().getPkValue()), (String)"1");
        } else {
            CacheHelper.put((String)(CACHE_KEY_NEED_FORCE_PRICE + requestDTO.getBill().getPkValue()), (String)"0");
        }
        for (DynamicObject invoiceDO : invoiceList) {
            DynamicObjectCollection invoiceItems = invoiceDO.getDynamicObjectCollection("items");
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceDO.getString("invoicetype")) || "1".equals(invoiceDO.getString("iselepaper"));
            boolean includeTaxFlag = "1".equals(invoiceDO.get("hsbz"));
            for (DynamicObject invoiceItem : invoiceItems) {
                boolean hasError;
                BigDecimal itemNum = invoiceItem.getBigDecimal("num");
                BigDecimal itemAmount = invoiceItem.getBigDecimal("amount");
                BigDecimal itemTaxAmount = invoiceItem.getBigDecimal("taxamount");
                BigDecimal itemUnitPrice = invoiceItem.getBigDecimal("unitprice");
                BigDecimal itemTaxUnitPrice = invoiceItem.getBigDecimal("taxunitprice");
                if (MathUtils.isZero((BigDecimal)itemNum)) continue;
                BigDecimal newNumForce = itemNum.setScale(hsConfigDynamicObject.getInt("numberdigit"), 4);
                log.info("BillSplitAmountHelper \u8981\u5f3a\u5236\u4fdd\u7559\u6570\u91cf\u4f4d\u6570 " + newNumForce.toPlainString());
                if (MathUtils.isZero((BigDecimal)newNumForce)) {
                    newNumForce = BigDecimal.ONE;
                }
                if (hasError = this.isErrorByForceNumScale(itemUnitPrice, itemTaxUnitPrice, includeTaxFlag, itemTaxAmount, itemAmount, newNumForce)) {
                    if ("1".equals(CacheHelper.get((String)(CACHE_KEY_NEED_FORCE_PRICE + requestDTO.getBill().getPkValue())))) {
                        itemNum = newNumForce;
                        log.info("BillSplitAmountHelper \u8981\u53cd\u7b97\u5355\u4ef7 " + itemNum);
                        invoiceItem.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)newNumForce, (boolean)isAllEle));
                        invoiceItem.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)newNumForce, (boolean)isAllEle));
                    }
                } else {
                    itemNum = newNumForce;
                    log.info("BillSplitAmountHelper \u5f3a\u5236\u53d8\u66f4\u6570\u91cf\u5c0f\u6570\u4f4d\u540e\u6ca1\u6709\u8bef\u5dee " + itemNum);
                }
                invoiceItem.set("num", (Object)itemNum);
            }
        }
    }

    public void handleNumber(SplitRequestDTO requestDTO, List<DynamicObject> invoiceDoList) {
        if (MathUtils.isZero((BigDecimal)requestDTO.getTotalBillNum())) {
            return;
        }
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceDoList.get(0).getString("invoicetype")) || "1".equals(invoiceDoList.get(0).getString("iselepaper"));
        BigDecimal invoiceTotalNum = BigDecimal.ZERO;
        for (DynamicObject invoiceDO : invoiceDoList) {
            DynamicObjectCollection invoiceItemList = invoiceDO.getDynamicObjectCollection("items");
            for (DynamicObject invoiceItem : invoiceItemList) {
                invoiceTotalNum = invoiceTotalNum.add(invoiceItem.getBigDecimal("num"));
            }
        }
        BigDecimal subtract = invoiceTotalNum.subtract(requestDTO.getTotalBillNum());
        log.info("BillSplitAmountHelper \u62c6\u5206\u540e\u603b\u6570\u91cf\u5b58\u5728\u8bef\u5dee" + subtract);
        if (!MathUtils.isZero((BigDecimal)subtract)) {
            DynamicObject changeNumItem = null;
            boolean includeTaxFlag = false;
            block2: for (int i = invoiceDoList.size() - 1; i >= 0; --i) {
                DynamicObjectCollection items = invoiceDoList.get(i).getDynamicObjectCollection("items");
                includeTaxFlag = "1".equals(invoiceDoList.get(i).get("hsbz"));
                for (int j = items.size() - 1; j >= 0; --j) {
                    DynamicObject invoiceItem = (DynamicObject)items.get(j);
                    if (MathUtils.isZero((BigDecimal)invoiceItem.getBigDecimal("num"))) continue;
                    changeNumItem = invoiceItem;
                    continue block2;
                }
            }
            if (changeNumItem != null) {
                BigDecimal newNum;
                BigDecimal itemTaxUnitPrice;
                BigDecimal itemNum = changeNumItem.getBigDecimal("num");
                BigDecimal itemAmount = changeNumItem.getBigDecimal("amount");
                BigDecimal itemTaxAmount = changeNumItem.getBigDecimal("taxamount");
                BigDecimal itemUnitPrice = changeNumItem.getBigDecimal("unitprice");
                boolean hasError = this.isErrorByForceNumScale(itemUnitPrice, itemTaxUnitPrice = changeNumItem.getBigDecimal("taxunitprice"), includeTaxFlag, itemTaxAmount, itemAmount, newNum = itemNum.subtract(subtract));
                if (hasError) {
                    if ("1".equals(CacheHelper.get((String)(CACHE_KEY_NEED_FORCE_PRICE + requestDTO.getBill().getPkValue())))) {
                        log.info("BillSplitAmountHelper \u4fdd\u8bc1\u6570\u91cf\u4e00\u81f4\uff0c\u53cd\u7b97\u5355\u4ef7:" + itemNum);
                        changeNumItem.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)newNum, (boolean)isAllEle));
                        changeNumItem.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)newNum, (boolean)isAllEle));
                        changeNumItem.set("num", (Object)newNum);
                    }
                } else {
                    changeNumItem.set("num", (Object)newNum);
                }
            }
        }
    }

    private boolean isErrorByForceNumScale(BigDecimal itemUnitPrice, BigDecimal itemTaxUnitPrice, boolean includeTaxFlag, BigDecimal itemTaxAmount, BigDecimal itemAmount, BigDecimal newNumForce) {
        boolean hasError = false;
        if (includeTaxFlag && !MathUtils.isZero((BigDecimal)itemUnitPrice)) {
            BigDecimal newHSAmountForce = newNumForce.multiply(itemTaxUnitPrice).setScale(2, 4);
            if (newHSAmountForce.compareTo(itemTaxAmount) != 0) {
                hasError = true;
            }
        } else {
            BigDecimal newBHSAmountForce = newNumForce.multiply(itemUnitPrice).setScale(2, 4);
            if (newBHSAmountForce.compareTo(itemAmount) != 0) {
                hasError = true;
            }
        }
        return hasError;
    }
}

