/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.sim.formplugin.bill.billsplit.SplitAmountDTO;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitAmountAdjustHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitAmountHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.dto.SplitOriginBillItemDTO;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;

public class SplitByAmountServiceImpl
extends AbstractBillSplitServiceImpl {
    private static final Log log = LogFactory.getLog(SplitByAmountServiceImpl.class);

    @Override
    public boolean support(SplitRequestDTO requestDTO) {
        return "imc_split_by_amount".equals(requestDTO.getRuleCode());
    }

    @Override
    public SplitResponseDTO split(SplitRequestDTO requestDTO) {
        BillSplitAmountHelper billSplitAmountHelper = new BillSplitAmountHelper();
        BillSplitAmountAdjustHelper adjustHelper = new BillSplitAmountAdjustHelper();
        List<SplitOriginBillItemDTO> splitOriginBillItemDTOList = billSplitAmountHelper.buildOriginBillItemDTO(requestDTO);
        ArrayList splitAmountDTOList = Lists.newArrayListWithCapacity((int)requestDTO.getAmounts().size());
        for (int i = 0; i < requestDTO.getAmounts().size(); ++i) {
            splitAmountDTOList.add(new SplitAmountDTO(i, (BigDecimal)requestDTO.getAmounts().get(i)));
        }
        List<BillRelationDTO> relations = billSplitAmountHelper.splitUserInputInvoiceAmount(requestDTO, splitOriginBillItemDTOList, splitAmountDTOList);
        for (SplitAmountDTO splitAmountDTO : splitAmountDTOList) {
            log.info("BillSplitAmountHelper \u8981\u62c6\u5206\u7684\u4ef7\u7a0e\u5408\u8ba1:" + splitAmountDTO.getAmount().toPlainString());
            log.info("BillSplitAmountHelper \u62c6\u5206\u7684\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1:" + splitAmountDTO.getInvoiceDynamicObject().getBigDecimal("totalamount").toPlainString());
            if (splitAmountDTO.getAmount().compareTo(splitAmountDTO.getInvoiceDynamicObject().getBigDecimal("totalamount")) == 0) continue;
            adjustHelper.warpInvoiceTaxError(relations, splitAmountDTO);
        }
        ArrayList invoiceDoList = Lists.newArrayListWithCapacity((int)splitAmountDTOList.size());
        for (int i = 0; i < splitAmountDTOList.size(); ++i) {
            for (SplitAmountDTO splitAmountDTO : splitAmountDTOList) {
                if (i != splitAmountDTO.getIndex()) continue;
                DynamicObject invoiceDynamicObject = splitAmountDTO.getInvoiceDynamicObject();
                invoiceDynamicObject.set("splitorder", (Object)(i + 1));
                invoiceDoList.add(splitAmountDTO.getInvoiceDynamicObject());
            }
        }
        adjustHelper.handleErrorAmount(requestDTO, invoiceDoList, relations);
        adjustHelper.retainNumberDigit(requestDTO, invoiceDoList);
        adjustHelper.handleNumber(requestDTO, invoiceDoList);
        return new SplitResponseDTO((List)invoiceDoList, relations);
    }
}

