/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.url.UrlService;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;

public class SimWorkbenchFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttondelete", "buttonap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("systemname");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        AbstractBillWorkbenchCustomEvent.putPageCache(this, "workbenchtype", "customcontrolap");
        if (this.getModel().getValue("org") == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
        this.setSystemName();
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, new HashMap(), (String)"customcontrolap");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ArrayList list = Lists.newArrayList();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("systemname".equals(key)) {
            if (this.getModel().getValue("org") == null) {
                list.add(new QFilter("number", "in", (Object)""));
                evt.setCustomQFilters((List)list);
                return;
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_source_targe_org_rel", (String)"system_code", (QFilter[])new QFilter("target_org_id", "=", ((DynamicObject)this.getModel().getValue("org")).get("id")).toArray());
            ArrayList<String> idList = new ArrayList<String>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                idList.add(dynamicObject.getString("system_code"));
            }
            list.add(new QFilter("number", "in", idList));
            evt.setCustomQFilters((List)list);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baritemap": {
                this.print();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "workbench": {
                IDataModel modelDetail = this.getControl("entryentity").getModel();
                int billNumber = modelDetail.getFilterEntryRowCount("entryentity");
                if (billNumber == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u4e3a\u7a7a", (String)"SimWorkbenchFormPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> idList = new ArrayList<Long>(billNumber);
                for (int i = 0; i < billNumber; ++i) {
                    idList.add(Long.parseLong((String)modelDetail.getValue("id", i)));
                }
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)true), (QFilter[])new QFilter("id", "in", idList).toArray());
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"custom_issue", (String)"sim_isomerism_bill_data", (DynamicObject[])dynamicObjects, null);
                if (operationResult.isSuccess()) {
                    HashMap<String, ArrayList<Long>> param = new HashMap<String, ArrayList<Long>>(4);
                    param.put("pks", idList);
                    ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_bill_center_process", (String)"sim_bill_center_process");
                    break;
                }
                String errorMessage = ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).toString();
                if (errorMessage.isEmpty()) {
                    this.getView().showTipNotification(operationResult.getMessage());
                    break;
                }
                this.getView().showTipNotification(errorMessage);
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "buttondelete": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                this.deleteBill(selectRows[0]);
                break;
            }
            case "buttonap": {
                this.accurateSearch();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "org": {
                this.setSystemName();
                AbstractBillWorkbenchCustomEvent.updateCustomControl(this, new HashMap<String, Object>(), "orgChanged");
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String arg = e.getEventArgs();
        switch (event) {
            case "queryList": {
                long orgId = (Long)((DynamicObject)this.getModel().getValue("org")).get("id");
                if (arg.length() >= 1) {
                    DynamicObject[] dynamicObjects = SimWorkbenchFormPlugin.checkBillsData(orgId, arg);
                    ArrayList<Map> list = new ArrayList<Map>(dynamicObjects.length);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        Map mergeBillMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject, (boolean)true);
                        list.add(mergeBillMap);
                    }
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("data", list);
                    AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "queryList");
                }
                this.getModel().setValue("sbillno", (Object)arg);
                break;
            }
            case "handleSelectValue": {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                if (arg == null || arg.isEmpty()) break;
                QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(arg));
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray());
                if (dynamicObject != null) {
                    this.writeBillsData(new DynamicObject[]{dynamicObject});
                    AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data, "handleSelectValue");
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5355\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (String)"SimWorkbenchFormPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "accurateSearch": {
                List<BillVo> billVos = this.accurateSearch();
                HashMap<String, Object> data1 = new HashMap<String, Object>(4);
                data1.put("data", billVos);
                if (billVos == null) {
                    AbstractBillWorkbenchCustomEvent.updateCustomControlError(this, data1, "accurateSearch");
                    break;
                }
                AbstractBillWorkbenchCustomEvent.updateCustomControl(this, data1, "accurateSearch");
                break;
            }
            case "print": {
                this.print();
                break;
            }
            case "invoiceOpen": {
                this.getView().invokeOperation("workbench");
            }
        }
    }

    private static DynamicObject[] checkBillsData(long orgId, String arg) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("settle_status", "=", (Object)"1");
        if (arg.isEmpty()) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray());
        } else {
            QFilter filter1 = new QFilter("custom_name", "like", (Object)("%" + arg + "%"));
            if (arg.length() >= 2) {
                filter1.or("billno", "like", (Object)("%" + arg + "%")).or("room_no", "like", (Object)("%" + arg + "%")).or("user_phone", "like", (Object)("%" + arg + "%"));
            }
            filter.and(filter1);
            dynamicObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data"), (QFilter[])filter.toArray(), (String)"id", (int)0, (int)10);
        }
        return dynamicObjects;
    }

    private void writeBillsData(DynamicObject[] bills) {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        for (DynamicObject bill : bills) {
            int billNumber = modelDetail.getFilterEntryRowCount("entryentity");
            for (int i = 0; i < billNumber; ++i) {
                if (!modelDetail.getValue("billno", i).equals(bill.get("billno"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u6dfb\u52a0", (String)"SimWorkbenchFormPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = this.getModel().createNewEntryRow("entryentity");
            modelDetail.setValue("billno", bill.get("billno"), index);
            modelDetail.setValue("total_amount", bill.get("total_amount"), index);
            modelDetail.setValue("invoicable_amount", bill.get("invoicable_amount"), index);
            modelDetail.setValue("custom_name", bill.get("custom_name"), index);
            modelDetail.setValue("room_no", bill.get("room_no"), index);
            modelDetail.setValue("user_phone", bill.get("user_phone"), index);
            modelDetail.setValue("bill_date", bill.get("bill_date"), index);
            modelDetail.setValue("billstatus", bill.get("billstatus"), index);
            modelDetail.setValue("pushstatus", bill.get("pushstatus"), index);
            modelDetail.setValue("id", bill.get("id"), index);
        }
        this.calculateAmount();
    }

    private void calculateAmount() {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        int billNumber = modelDetail.getFilterEntryRowCount("entryentity");
        this.getModel().setValue("billnumber", (Object)billNumber);
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal invoicableAmount = BigDecimal.ZERO;
        for (int i = 0; i < billNumber; ++i) {
            totalamount = totalamount.add(new BigDecimal(modelDetail.getValue("total_amount", i).toString()));
            invoicableAmount = invoicableAmount.add(new BigDecimal(modelDetail.getValue("invoicable_amount", i).toString()));
        }
        this.getModel().setValue("amount", (Object)totalamount);
        this.getModel().setValue("invoicableAmount", (Object)invoicableAmount);
    }

    private void deleteBill(int index) {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        modelDetail.deleteEntryRow("entryentity", index);
        this.calculateAmount();
    }

    private List<BillVo> accurateSearch() {
        JSONObject paramObject = new JSONObject();
        DynamicObject system = (DynamicObject)this.getModel().getValue("systemname");
        if (system == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u7cfb\u7edf\u540d\u79f0", (String)"SimWorkbenchFormPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return null;
        }
        paramObject.put("billNo", this.getModel().getValue("sbillno"));
        paramObject.put("systemCode", (Object)system.getString("number"));
        paramObject.put("opKey", (Object)"query");
        List<BillVo> billVos = ExternalSystemDataHandler.getExternalSystemData(paramObject);
        if (billVos == null || billVos.size() == 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u8d26\u5355\uff0c\u8bf7\u68c0\u67e5\u8d26\u5355\u53f7\u662f\u5426\u6b63\u786e\uff01", (String)"SimWorkbenchFormPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (BillVo billVo : billVos) {
            String billNo = billVo.getBillNo();
            QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealLoadIsomerismBillDataMethod(qFilter);
            if (dynamicObject == null) continue;
            this.writeBillsData(new DynamicObject[]{dynamicObject});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\uff01", (String)"SimWorkbenchFormPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        return billVos;
    }

    private void setSystemName() {
        if (this.getModel().getValue("org") == null) {
            this.getModel().setValue("systemname", null);
            return;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_source_targe_org_rel", (String)String.join((CharSequence)",", "system_code", "name"), (QFilter[])new QFilter("target_org_id", "=", ((DynamicObject)this.getModel().getValue("org")).get("id")).toArray());
        if (dynamicObjects.length != 0) {
            String systemName = dynamicObjects[0].getString("system_code");
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getString("name").toUpperCase().contains("OPERA")) continue;
                systemName = dynamicObject.getString("system_code");
                break;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_front_system_cfg", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_front_system_cfg"), (QFilter[])new QFilter("number", "=", (Object)systemName).toArray());
            this.getModel().setValue("systemname", (Object)dynamicObject);
        } else {
            this.getModel().setValue("systemname", null);
        }
    }

    private List<Long> getAllDataId() {
        IDataModel modelDetail = this.getControl("entryentity").getModel();
        int billNumber = modelDetail.getFilterEntryRowCount("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(billNumber);
        for (int i = 0; i < billNumber; ++i) {
            idList.add(Long.parseLong(modelDetail.getValue("id", i).toString()));
        }
        return idList;
    }

    private void print() {
        List<Long> idList = this.getAllDataId();
        if (idList.size() != 0) {
            ArrayList<Long> list = new ArrayList<Long>(idList.size());
            list.addAll(idList);
            Map templateMap = PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap("sim_isomerism_bill_data", "sim");
            String templateId = templateMap.keySet().toArray(new String[0])[0];
            PrintTask printTask = new PrintTask();
            printTask.setTplId(templateId);
            printTask.setPkIds(list);
            PrintWork printWork = new PrintWork();
            printWork.setPageId(this.getView().getPageId());
            printWork.setPrintLang(ResManager.getLanguage());
            printWork.setExpType("1");
            printWork.setTaskList(Collections.singletonList(printTask));
            PrtAttach attach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            List attachDetails = attach.getAttachDetail();
            String url = String.format("%s/api/print/download.do?taskId=%s&attachId=%s", UrlService.getDomainContextUrl(), attach.getTaskId(), ((PrtAttach.AttachDetail)attachDetails.get(0)).getAttachId());
            this.getView().openUrl(url);
        }
    }
}

