/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter.convert;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.billcenter.workhotel.dto.BillCenterHotelProcessDTO;
import kd.imc.sim.billcenter.workhotel.dto.BillCenterHotelProcessItemDTO;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.billcenter.convert.AbstractIsomerismBill2OriginalBillConvertPlugin;

public class IsomerismBill2OriginalBillWorkHotelConvertPlugin
extends AbstractIsomerismBill2OriginalBillConvertPlugin {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
    }

    private void calcBillHead(DynamicObject newBill, DynamicObjectCollection items) {
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            invoiceAmount = invoiceAmount.add(item.getBigDecimal("amount"));
            totalTax = totalTax.add(item.getBigDecimal("tax"));
            totalAmount = totalAmount.add(item.getBigDecimal("taxamount"));
        }
        newBill.set("invoiceamount", (Object)invoiceAmount);
        newBill.set("totaltax", (Object)totalTax);
        newBill.set("totalamount", (Object)totalAmount);
        newBill.set("surplusamount", (Object)invoiceAmount);
        newBill.set("surplustax", (Object)totalTax);
        newBill.set("oldtotalamount", (Object)totalAmount);
    }

    private DynamicObject createNewOriginalBill(ExtendedDataEntitySet entitySet, BillCenterHotelProcessDTO process) {
        ExtendedDataEntity extendedData = entitySet.FindByEntityKey(this.getTgtMainType().getName())[0];
        DynamicObject newBill = extendedData.getDataEntity();
        newBill.set("invoicetype", (Object)process.getInvoicetype());
        newBill.set("buyername", (Object)process.getBuyername());
        newBill.set("buyertaxno", (Object)process.getBuyertaxno());
        newBill.set("buyeraddr", (Object)process.getBuyeraddr());
        newBill.set("buyerbank", (Object)process.getBuyerbank());
        newBill.set("buyeremail", (Object)process.getBuyeremail());
        newBill.set("buyerphone", (Object)process.getBuyerphone());
        newBill.set("jqbh", (Object)process.getJqbh());
        newBill.set("terminalno", (Object)process.getTerminalno());
        newBill.set("account", (Object)process.getAccount());
        newBill.set("buyerproperty", (Object)process.getBuyerproperty());
        ((List)entitySet.getExtDataEntityMap().get("sim_original_bill")).clear();
        ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(4);
        extendedDataEntities.add(extendedData);
        entitySet.AddExtendedDataEntities("sim_original_bill", extendedDataEntities);
        return newBill;
    }

    public void afterConvert(AfterConvertEventArgs e) {
        String billStr = (String)this.getOption().getVariables().get("bills");
        if (StringUtils.isNotBlank((CharSequence)billStr)) {
            this.convertHotelData(e, billStr);
        }
        this.fillinItem(e);
        HashMap<Long, List<DynamicObject>> orgBillMaps = new HashMap<Long, List<DynamicObject>>(16);
        HashSet<String> taxNoSet = new HashSet<String>(16);
        this.fillInBill(e, orgBillMaps, taxNoSet);
        this.matchBill(orgBillMaps, taxNoSet);
    }

    private void convertHotelData(AfterConvertEventArgs e, String billStr) {
        BillCenterHotelProcessDTO process = (BillCenterHotelProcessDTO)JSONObject.parseObject((String)billStr, BillCenterHotelProcessDTO.class);
        Map<String, BillCenterHotelProcessItemDTO> itemsMap = process.getItems().stream().collect(Collectors.toMap(k -> k.getSid() + "\u25cf\u25c6\u25a0" + k.getSdetailid(), v -> v, (v1, v2) -> v1));
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        DynamicObject newBill = this.createNewOriginalBill(entitySet, process);
        Map srcfldPro = e.getFldProperties();
        ExtendedDataEntity[] itemExtendedDataEntities = entitySet.FindByEntityKey("sim_original_bill_item");
        DynamicObjectCollection items = newBill.getDynamicObjectCollection("sim_original_bill_item");
        items.clear();
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)newBill.getString("invoicetype")) || "1".equals(newBill.getString("iselepaper"));
        ArrayList<ExtendedDataEntity> extendedDataEntities = new ArrayList<ExtendedDataEntity>(items.size());
        for (ExtendedDataEntity itemExtendedDataEntity : itemExtendedDataEntities) {
            DynamicObject source = (DynamicObject)((List)itemExtendedDataEntity.getValue("ConvertSource")).get(0);
            Object sourceId = ((DynamicProperty)srcfldPro.get("id")).getValue((Object)source);
            Object sourceEntryId = ((DynamicProperty)srcfldPro.get("sim_isomerism_item_data.id")).getValue((Object)source);
            BillCenterHotelProcessItemDTO processItem = itemsMap.get(sourceId + "\u25cf\u25c6\u25a0" + sourceEntryId);
            if (processItem == null) continue;
            extendedDataEntities.add(itemExtendedDataEntity);
            DynamicObject item = itemExtendedDataEntity.getDataEntity();
            items.add((Object)item);
            item.set("taxamount", (Object)processItem.getTotalamount());
            item.set("tax", (Object)processItem.getTax());
            item.set("amount", (Object)processItem.getTotalamount().subtract(processItem.getTax()));
            item.set("remainvalidtax", (Object)processItem.getTax());
            item.set("remainvalidamount", "1".equals(newBill.getString("hsbz")) ? item.get("taxamount") : item.get("amount"));
            item.set("num", (Object)processItem.getUnpushnum());
            item.set("remainvalidnum", (Object)processItem.getUnpushnum());
            item.set("taxunitprice", (Object)processItem.getPrice());
            if (MathUtils.isNullOrZero((BigDecimal)processItem.getUnpushnum())) continue;
            item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)processItem.getUnpushnum(), (boolean)isAllEle));
        }
        this.calcBillHead(newBill, items);
        ((List)entitySet.getExtDataEntityMap().get("sim_original_bill_item")).clear();
        entitySet.AddExtendedDataEntities("sim_original_bill_item", extendedDataEntities);
        e.setTargetExtDataEntitySet(entitySet);
    }
}

