/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter.op;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class BillCenterConfirmIssueOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("sim_isomerism_item_data.orgid");
        e.getFieldKeys().add("sim_isomerism_item_data.rowpushstatus");
        e.getFieldKeys().add("sim_isomerism_item_data.invoicable_switch");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long orgCount;
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_isomerism_item_data");
                    if (items.stream().noneMatch(item -> !"1".equals(item.getString("rowpushstatus")) && "1".equals(item.getString("invoicable_switch")))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7684\u8d26\u5355\u6ca1\u6709\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\uff0c\u65e0\u6cd5\u5f00\u7968\u3002", (String)"BillCenterConfirmIssueOp_0", (String)"imc-sim-formplugin", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    if ((orgCount = items.stream().map(item -> DynamicObjectUtil.getDynamicObjectLongValue((Object)item.get("orgid"))).distinct().count()) > 1L) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u5b58\u5728\u591a\u4e2a\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u8fdb\u5165\u5de5\u4f5c\u53f0\u5904\u7406\u3002", (String)"BillCenterConfirmIssueOp_1", (String)"imc-sim-formplugin", (Object[])new Object[]{bill.getString("billno")}));
                    }
                    orgIdSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("org")));
                }
                if (orgIdSet.size() > 1) {
                    this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u8d26\u5355\u5b58\u5728\u591a\u4e2a\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u8fdb\u5165\u5de5\u4f5c\u53f0\u5904\u7406\u3002", (String)"BillCenterConfirmIssueOp_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

