/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.model.RowValue;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class TaxInvoiceImportUtil {
    private static final Log LOGGER = LogFactory.getLog(TaxInvoiceImportUtil.class);
    private String TEMPLATE_DIR = "excel_templates";
    private String INVOICE_SHEET = "INVOICE";
    private String DETAIL_SHEET = "DETAIL";
    private String[] UPDATE_FIELD = new String[]{"invoicetype", "invoicestatus", "issuetime"};
    private Map<String, Long> orgMap = null;
    private Set<String> invoiceTypeSet = new HashSet<String>(8);
    private int total = 0;
    private int success = 0;

    /*
     * Loose catch block
     */
    public int parseTaxFile(AbstractFormPlugin formPlugin, String filepath, String fileName) {
        int n;
        Throwable throwable;
        Workbook workbook;
        Throwable throwable2;
        InputStream inputStream;
        long start;
        block29: {
            block30: {
                block27: {
                    block28: {
                        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u5f00\u59cb:{}", (Object)fileName);
                        start = System.currentTimeMillis();
                        FileService service = FileServiceFactory.getAttachmentFileService();
                        inputStream = service.getInputStream(filepath);
                        throwable2 = null;
                        workbook = WorkbookFactory.create((InputStream)inputStream);
                        throwable = null;
                        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u5f00\u59cb\u89e3\u6790\u6587\u4ef6:{}", (Object)fileName);
                        int count = this.parseTaxFile(formPlugin, workbook, fileName);
                        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
                        n = count;
                        if (workbook == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    workbook.close();
                }
                if (inputStream == null) break block29;
                if (throwable2 == null) break block30;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block29;
            }
            inputStream.close();
        }
        return n;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (workbook != null) {
                                    if (throwable != null) {
                                        try {
                                            workbook.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        workbook.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (inputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable9;
                    }
                }
                catch (KDException e) {
                    formPlugin.getView().showErrorNotification(e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
                    formPlugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5904\u7406\u5931\u8d25,\u8bf7\u6c42id:%1$s", (String)"TaxInvoiceImportUtil_0", (String)"imc-sim-service", (Object[])new Object[0]), RequestContext.get().getTraceId()));
                }
            }
        }
        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        return 0;
    }

    public int parseTaxFile(AbstractFormPlugin formPlugin, Workbook workbook, String fileName) {
        long start = System.currentTimeMillis();
        HashMap<String, String> errMap = new HashMap<String, String>();
        List<Map<String, Object>> excelInvoiceList = this.resolveExcel(workbook, errMap);
        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u6587\u4ef6\u89e3\u6790\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.save(excelInvoiceList);
        LOGGER.info("\u9500\u9879\u7a0e\u5c40\u6587\u4ef6\u5bfc\u5165\uff0c\u6570\u636e\u4fdd\u5b58\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        if (formPlugin != null) {
            if (this.success < this.total) {
                ExcelHelper.showErrorResult((Workbook)workbook, (int)this.total, (int)this.success, errMap, (String)fileName, (AbstractFormPlugin)formPlugin, (String)"sim_original_bill_import", (String)"sim_inv_import_result");
            } else {
                formPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"TaxInvoiceImportUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
        return this.success;
    }

    private void save(List<Map<String, Object>> excelInvoiceList) {
        Map<String, DynamicObject> existsMap = this.queryExistsInvoice(excelInvoiceList);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(16);
        String batchbelong = UUID.getBatchNumber();
        for (Map<String, Object> invoice : excelInvoiceList) {
            DynamicObject obj = existsMap.get(this.nullToEmpty(invoice.get("invoicecode")) + this.nullToEmpty(invoice.get("invoiceno")));
            if (obj != null) {
                DynamicObject newobj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                DynamicObjectUtil.map2DynamicObject(invoice, (DynamicObject)newobj);
                this.setUpdateValue(obj, newobj);
                updateList.add(obj);
                continue;
            }
            obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.map2DynamicObject(invoice, (DynamicObject)obj);
            IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)obj);
            IssueInvoiceService.updateDiscountInfo((DynamicObject)obj);
            obj.set("batchbelong", (Object)batchbelong);
            addList.add(obj);
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if (!addList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
        }
        this.success = updateList.size() + addList.size();
    }

    private void setUpdateValue(DynamicObject oldobj, DynamicObject newobj) {
        for (String field : this.UPDATE_FIELD) {
            if (newobj.get(field) == null) continue;
            oldobj.set(field, newobj.get(field));
        }
    }

    private Map<String, DynamicObject> queryExistsInvoice(List<Map<String, Object>> list) {
        ArrayList<String> invoiceNoList = new ArrayList<String>(list.size());
        HashSet<String> keySet = new HashSet<String>(list.size());
        HashSet<String> taxSet = new HashSet<String>(list.size());
        for (Map<String, Object> map : list) {
            invoiceNoList.add((String)map.get("invoiceno"));
            taxSet.add((String)map.get("salertaxno"));
            keySet.add(this.nullToEmpty(map.get("invoicecode")) + this.nullToEmpty(map.get("invoiceno")));
        }
        QFilter filter1 = new QFilter("invoiceno", "in", invoiceNoList);
        QFilter filter2 = new QFilter("salertaxno", "in", taxSet);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id,invoicecode,invoiceno", (QFilter[])new QFilter[]{filter1, filter2});
        ArrayList idList = new ArrayList(collect.size());
        collect.forEach(obj -> {
            if (!keySet.add(this.nullToEmpty(obj.getString("invoicecode")) + this.nullToEmpty(obj.getString("invoiceno")))) {
                idList.add(obj.getLong("id"));
            }
        });
        DynamicObject[] invoices = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(invoices.length);
        for (DynamicObject obj2 : invoices) {
            map.put(this.nullToEmpty(obj2.getString("invoicecode")) + this.nullToEmpty(obj2.getString("invoiceno")), obj2);
        }
        return map;
    }

    private List<Map<String, Object>> resolveExcel(Workbook workbook, Map<String, String> errMap) {
        Iterator it = workbook.sheetIterator();
        HashMap<String, List> map = new HashMap<String, List>(4);
        while (it.hasNext()) {
            String sheetType;
            Sheet sheet = (Sheet)it.next();
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum < 1 || (sheetType = this.getSheetType(sheet.getSheetName())) == null) continue;
            List fileFieldList = ExcelHelper.readTemplate((String)this.TEMPLATE_DIR, (String)("TaxInvoice_" + sheetType + ".json"));
            List result = ExcelHelper.doParseAndWriteError((Sheet)sheet, (List)fileFieldList, (int)1, errMap);
            List oldresult = (List)map.get(sheetType);
            if (oldresult != null) {
                if (!result.isEmpty()) {
                    oldresult.addAll(result);
                }
                map.put(sheetType, oldresult);
                continue;
            }
            map.put(sheetType, result);
        }
        List list = (List)map.get(this.INVOICE_SHEET);
        if (list == null || list.isEmpty()) {
            throw new KDException(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u53d1\u7968\u6570\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u4e0a\u4f20", (String)"TaxInvoiceImportUtil_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        List<Map<String, Object>> invoiceList = this.getRigthMap((List)map.get(this.INVOICE_SHEET), this.INVOICE_SHEET);
        List<Map<String, Object>> detailList = this.getRigthMap((List)map.get(this.DETAIL_SHEET), this.DETAIL_SHEET);
        Map detail = detailList.stream().collect(Collectors.groupingBy(mapObject -> this.nullToEmpty(mapObject.get("invoicecode")) + this.nullToEmpty(mapObject.get("invoiceno")) + this.nullToEmpty(mapObject.get("alletaxinvoiceno")), HashMap::new, Collectors.toList()));
        invoiceList.forEach(mapObject -> {
            String invoiceKey = this.nullToEmpty(mapObject.get("invoicecode")) + this.nullToEmpty(mapObject.get("invoiceno")) + this.nullToEmpty(mapObject.get("alletaxinvoiceno"));
            mapObject.put("items", detail.get(invoiceKey));
        });
        return this.fullValue(invoiceList);
    }

    private List<Map<String, Object>> fullValue(List<Map<String, Object>> invoiceList) {
        ArrayList<Map<String, Object>> invoiceNewList = new ArrayList<Map<String, Object>>(invoiceList.size());
        long batch = Long.parseLong(DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        int index = 0;
        DecimalFormat decimalFormat = new DecimalFormat("000");
        for (Map<String, Object> map : invoiceList) {
            if (index >= 999) {
                ++batch;
                index = 0;
            }
            ++index;
            List detail = (List)map.get("items");
            boolean negative = BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)map.get("totalamount"))) > 0;
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)((String)map.get("invoicetype"))) || "1".equals(map.get("iselepaper"));
            this.fullDetailValue(detail, negative, isAllEle);
            map.put("orderno", UUID.randomUUID());
            map.put("buyertype", "8");
            map.put("issuestatus", "0");
            if (StringUtils.isEmpty((CharSequence)this.nullToEmpty(map.get("buyertaxno")))) {
                map.put("buyerproperty", "1");
            } else {
                map.put("buyerproperty", "0");
            }
            String remark = this.nullToEmpty(map.get("remark"));
            if (remark.length() > 230) {
                map.put("remark", remark.substring(0, 230));
            }
            map.put("hsbz", "0");
            map.put("billno", "300_" + batch + "_" + decimalFormat.format(index));
            map.put("taxedtype", TaxedTypeEnum.normal.getValue());
            this.setInvoiceType(map);
            this.setInvoiceNo(map);
            String invoiceCode = this.nullToEmpty(map.get("invoicecode"));
            if (detail == null || detail.isEmpty()) continue;
            if (StringUtils.isNotEmpty((CharSequence)invoiceCode) && detail.size() > 8) {
                map.put("inventorymark", "1");
            } else {
                map.put("inventorymark", "0");
            }
            this.setInvoiceStatus(map);
            this.setOrg(map);
            this.setSpecialtype(map);
            this.setIssuType(map);
            invoiceNewList.add(map);
        }
        return invoiceNewList;
    }

    private void setOrg(Map<String, Object> map) {
        Long orgId = this.getOrgId(this.nullToEmpty(map.get("salertaxno")));
        if (orgId <= 0L) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u672a\u914d\u7f6e\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u4f01\u4e1a\u4fe1\u606f\u4e2d\u7ef4\u62a4\u7ec4\u7ec7", (String)"TaxInvoiceImportUtil_4", (String)"imc-sim-service", (Object[])new Object[0]), this.nullToEmpty(map.get("salertaxno"))));
        }
        map.put("orgid", orgId);
    }

    private Long getOrgId(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return 0L;
        }
        if (this.orgMap == null) {
            this.orgMap = new HashMap<String, Long>(2);
        }
        if (this.orgMap.get(taxNo) == null) {
            try {
                DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo);
                this.orgMap.put(taxNo, orgDynamicObject.getLong("id"));
            }
            catch (Exception e) {
                this.orgMap.put(taxNo, 0L);
            }
        }
        return this.orgMap.get(taxNo);
    }

    private void setInvoiceStatus(Map<String, Object> map) {
        String status = this.nullToEmpty(map.get("invoicestatus"));
        status = status.indexOf("\u5e9f") >= 0 ? "6" : (status.indexOf("\u7ea2") >= 0 ? (status.indexOf("\u90e8") >= 0 ? "2" : "3") : "0");
        map.put("invoicestatus", status);
    }

    private void setInvoiceType(Map<String, Object> map) {
        String type = this.nullToEmpty(map.get("invoicetype"));
        type = type.indexOf("\u6570\u7535") >= 0 ? (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.ALL_E_SPECIAL.getTypeCode() : InvoiceType.ALL_E_NORMAL.getTypeCode()) : (type.indexOf("\u7535") >= 0 ? (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode() : InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode()) : (type.indexOf("\u4e13\u7528") >= 0 ? InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode() : InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()));
        this.invoiceTypeSet.add(type);
        map.put("invoicetype", type);
    }

    private void setInvoiceNo(Map<String, Object> detail) {
        String eInvoiceNo = this.nullToEmpty(detail.get("alletaxinvoiceno"));
        String invoiceNo = this.nullToEmpty(detail.get("invoiceno"));
        if (eInvoiceNo != null && eInvoiceNo.length() == 20 && StringUtils.isEmpty((CharSequence)invoiceNo)) {
            detail.put("invoiceno", eInvoiceNo);
            detail.put("invoicecode", "");
            detail.put("alletaxinvoiceno", "");
        }
    }

    private void fullDetailValue(List<Map<String, Object>> detailList, boolean negative, boolean isAllEle) {
        if (detailList != null) {
            ArrayList<Integer> deducIndex = new ArrayList<Integer>(8);
            for (int i = 0; i < detailList.size(); ++i) {
                Map<String, Object> map = detailList.get(i);
                String taxRate = TaxRateUtil.percent2Point((String)((String)map.get("taxrate")));
                map.put("taxrate", taxRate);
                boolean detailnegative = BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)map.get("amount"))) > 0;
                map.put("rowtype", "0");
                if (!negative && detailnegative) {
                    map.put("rowtype", "1");
                    deducIndex.add(i - 1);
                }
                map.put("taxpremark", "0");
                map.put("taxamount", BigDecimalUtil.transDecimal((Object)map.get("amount")).add(BigDecimalUtil.transDecimal((Object)map.get("tax"))));
                try {
                    BigDecimal num = BigDecimalUtil.transDecimal((Object)map.get("num"));
                    BigDecimal taxamount = BigDecimalUtil.transDecimal((Object)map.get("taxamount"));
                    BigDecimal unitPrice = BigDecimalUtil.transDecimal((Object)map.get("unitprice"));
                    BigDecimal taxUnit = PriceHelper.getTaxUnitPriceByBHS((BigDecimal)BigDecimalUtil.transDecimal((Object)taxRate), (BigDecimal)num, (BigDecimal)taxamount, (BigDecimal)unitPrice, (boolean)isAllEle);
                    map.put("taxunitprice", taxUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                map.put("seq", i);
            }
            for (Integer index : deducIndex) {
                Map<String, Object> map = detailList.get(index);
                map.put("rowtype", "2");
            }
        }
    }

    private String nullToEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    private List<Map<String, Object>> getRigthMap(List<RowValue> list, String type) {
        ArrayList<Map<String, Object>> returnlist = new ArrayList<Map<String, Object>>(8);
        int count = 0;
        if (list != null) {
            for (RowValue val : list) {
                if (val.isRight()) {
                    String goodsname;
                    HashMap valMap = new HashMap(8);
                    val.getCellList().forEach(e -> valMap.put(e.getFieldCode(), e.getFieldValue()));
                    String seq = this.nullToEmpty(valMap.get("cellSeq"));
                    if (seq.indexOf("\u5408\u8ba1") >= 0 || (goodsname = this.nullToEmpty(valMap.get("goodsname"))).indexOf("\u8be6\u89c1\u9500\u8d27\u6e05\u5355") >= 0) continue;
                    returnlist.add(valMap);
                }
                ++count;
            }
        }
        if (this.INVOICE_SHEET.equals(type)) {
            this.total = count;
        }
        return returnlist;
    }

    private void setIssuType(Map<String, Object> invoice) {
        if (BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal((Object)invoice.get("totalamount"))) > 0) {
            invoice.put("issuetype", IssueType.RED_INVOICE.getTypeCode());
        } else {
            invoice.put("issuetype", IssueType.BLUE_INVOICE.getTypeCode());
        }
    }

    private void setSpecialtype(Map<String, Object> invoice) {
        List item = (List)invoice.get("items");
        if (item == null || item.isEmpty()) {
            invoice.put("specialtype", "00");
        } else {
            String specialTypeName = this.nullToEmpty(((Map)item.get(0)).get("specialtype"));
            String specialType = null;
            specialType = specialTypeName.indexOf("\u5efa\u7b51\u670d\u52a1") >= 0 ? "E03" : (specialTypeName.indexOf("\u8d27\u7269") >= 0 ? "E04" : (specialTypeName.indexOf("\u65c5\u5ba2") >= 0 ? "E09" : (specialTypeName.indexOf("\u519c") >= 0 ? "02" : "00")));
            if (specialType != null) {
                invoice.put("specialtype", specialType);
            }
        }
    }

    private String getSheetType(String sheetName) {
        if (sheetName.indexOf("\u6c47\u603b") > 0) {
            return this.DETAIL_SHEET;
        }
        if (sheetName.indexOf("\u57fa\u7840") > 0) {
            return this.INVOICE_SHEET;
        }
        return null;
    }

    public int getTotal() {
        return this.total;
    }

    public Set<String> getInvoiceTypeSet() {
        return this.invoiceTypeSet;
    }
}

