/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.ConfigCacheHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ComboEditUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.BillConstant;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceBaseControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceCustomViewControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceEInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoicePropertyChangeControl;
import kd.imc.sim.formplugin.issuing.helper.ViewBuildInvoiceHelper;

public class CreateInvoiceWaitControl {
    private static final Log LOGGER = LogFactory.getLog(CreateInvoiceWaitControl.class);

    public static boolean isWaitNeedEditAll(String sellerTaxNo) {
        String cacheValue = ConfigCacheHelper.getCacheValue((String)"sim_wait_edit_enable");
        boolean waitNeedEditAll = false;
        try {
            if (!StringUtils.isEmpty((String)cacheValue)) {
                String[] split;
                for (String taxNo : split = cacheValue.split(",")) {
                    if (!taxNo.equals(sellerTaxNo)) continue;
                    waitNeedEditAll = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("isWaitNeedEditAll\u83b7\u53d6\u914d\u7f6e\u5931\u8d25");
        }
        return waitNeedEditAll;
    }

    public static void initBatchJumpAndView(AbstractFormPlugin plugin, IFormView view, Object fid, boolean editFlag) {
        try {
            DynamicObject waitInvoice = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"sim_vatinvoice");
            String issueType = waitInvoice.getString("issuetype");
            if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
                plugin.getPageCache().put("has_change_issue_type", "yes");
                plugin.getView().getModel().setValue("issuetype", (Object)IssueTypeEnum.red.getValue());
                if (InvoiceUtils.isSpecialInvoice((String)waitInvoice.getString("invoicetype"))) {
                    plugin.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
                }
            }
            plugin.getPageCache().put("pageCacheEquipment", waitInvoice.getString("jqbh"));
            CreateInvoiceBaseControl.showTobaccoLabel(plugin, waitInvoice, Boolean.FALSE);
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"billno"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"buyerphone"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"buyeremail"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"remark"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"payee"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"drawer"});
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"reviewer"});
            view.getModel().setValue("simpleaddress", waitInvoice.get("simpleaddress"));
            view.getModel().setValue("startleasedate", waitInvoice.get("startleasedate"));
            view.getModel().setValue("endleasedate", waitInvoice.get("endleasedate"));
            view.setEnable(Boolean.valueOf(editFlag), new String[]{"simpleaddress", "rentdate", "crosscitysign", "areaunit", "buildingname", "landtaxno", "estateid", "detailaddress", "approvedprice", "actualturnover", "estatecode"});
            ModelUtil.setModelAndEntryValueFromDynamicObject((DynamicObject)waitInvoice, (AbstractFormPlugin)plugin, (boolean)false);
            Object sellerTaxNo = view.getModel().getValue("salertaxno");
            Object jqbh = view.getModel().getValue("jqbh");
            if (EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)jqbh)) {
                view.getModel().setValue("jqbh", null);
                view.getModel().setValue("terminalno", null);
            }
            if (IssueType.RED_INVOICE.getTypeCode().equals(waitInvoice.getString("issuetype"))) {
                CreateInvoiceWaitControl.initBatchViewRedInvoice(plugin, waitInvoice);
            }
            CreateInvoiceControl.updateInvoiceTypeView(Boolean.FALSE, waitInvoice.getString("invoicetype"), view);
            HashMap<String, String> issueTypeSelectMap = new HashMap<String, String>();
            issueTypeSelectMap.put(ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968", (String)"CreateInvoiceWaitControl_0", (String)"imc-sim-service", (Object[])new Object[0]), "0");
            if (IssueType.RED_INVOICE.getTypeCode().equals(waitInvoice.getString("issuetype"))) {
                issueTypeSelectMap.put(ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968", (String)"CreateInvoiceWaitControl_1", (String)"imc-sim-service", (Object[])new Object[0]), "1");
            }
            ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"issuetype", issueTypeSelectMap);
            plugin.getView().getModel().setValue("taxedtype", (Object)(StringUtils.isEmpty((String)waitInvoice.getString("taxedtype")) ? "0" : waitInvoice.getString("taxedtype")));
            if ("2".equals(waitInvoice.getString("taxedtype"))) {
                String templateRemark = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", waitInvoice.getBigDecimal("deduction").setScale(2, RoundingMode.HALF_UP));
                view.getModel().setValue("redremark", (Object)templateRemark);
                view.getModel().setValue("taxedtype", (Object)"2");
            }
            plugin.getPageCache().put("loadTaxFlag", waitInvoice.getString("hsbz"));
            plugin.getPageCache().put("batchOrderNo", waitInvoice.getString("orderno"));
            BigDecimal taxDiff = BigDecimal.ZERO;
            if (!editFlag) {
                taxDiff = CreateInvoiceWaitControl.showTaxDiff(view, fid);
                CreateInvoiceBaseControl.setEquipmentAndTerminalNoByInvoiceDynamicObject(plugin, waitInvoice);
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"jqbh"});
                view.updateView("jqbh");
            }
            plugin.getPageCache().put("waitInvoiceJQBH", waitInvoice.getString("jqbh"));
            plugin.getPageCache().put("waitInvoiceTerminalNo", waitInvoice.getString("terminalno"));
            CreateInvoiceWaitControl.putItems2PageCache(plugin, waitInvoice);
            plugin.getPageCache().put("equipment_no", waitInvoice.getString("jqbh"));
            plugin.getPageCache().put("seller_tax_no", waitInvoice.getString("salertaxno"));
            CreateInvoiceCustomViewControl.initCustomViewData(plugin, plugin.getPageCache().get("editType"), waitInvoice.getString("issuetype"), taxDiff);
            if ("B".equals(waitInvoice.getString("issuebillstatus")) || "C".equals(waitInvoice.getString("issuebillstatus"))) {
                view.setVisible(Boolean.FALSE, new String[]{"edit"});
            }
            if ("A".equals(waitInvoice.getString("issuebillstatus")) || "B".equals(waitInvoice.getString("issuebillstatus"))) {
                view.setVisible(Boolean.FALSE, new String[]{"openinvoice"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"cancel"});
            view.setEnable(Boolean.FALSE, new String[]{"issuetype"});
            view.setEnable(Boolean.FALSE, new String[]{"hsbz"});
            view.setEnable(Boolean.FALSE, new String[]{"checkboxtobacco"});
            view.setEnable(Boolean.FALSE, new String[]{"taxedtype"});
            CreateInvoiceWaitControl.handleViewPurchase(plugin, view, waitInvoice, true);
            view.setEnable(Boolean.FALSE, new String[]{"specialtype"});
            view.setEnable(Boolean.FALSE, new String[]{"cardtype"});
            ComboEditUtil.setComboEditDefault((AbstractFormPlugin)plugin, (String)"invoicetype");
            view.setEnable(Boolean.FALSE, new String[]{"invoicetype"});
            String buyerType = waitInvoice.getString("buyertype");
            if (!"4".equals(buyerType)) {
                view.setEnable(Boolean.TRUE, new String[]{"inventorymark"});
            }
            CreateInvoiceEInvoiceControl.warpAllEData(plugin, waitInvoice);
            view.getModel().setValue("buyerproperty", (Object)waitInvoice.getString("buyerproperty"));
            if (waitInvoice.get("taxedtype").equals(TaxedTypeEnum.all_e_reduced_tax.getValue())) {
                plugin.getView().setVisible(Boolean.TRUE, new String[]{"reductiontaxtype"});
                plugin.getView().setEnable(Boolean.valueOf(editFlag), new String[]{"reductiontaxtype"});
            }
        }
        catch (KDBizException e) {
            view.showErrorNotification(e.getMessage());
            view.setVisible(Boolean.FALSE, new String[]{"custombuyername"});
            view.setVisible(Boolean.TRUE, new String[]{"flexbuyername"});
        }
    }

    public static void handleViewPurchase(AbstractFormPlugin plugin, IFormView view, DynamicObject waitInvoice, boolean needReverseBuyerSeller) {
        plugin.getView().getModel().setValue("specialtype", (Object)(StringUtils.isEmpty((String)waitInvoice.getString("specialtype")) ? "00" : waitInvoice.getString("specialtype")));
        if ("02".equals(waitInvoice.getString("specialtype"))) {
            CreateInvoicePropertyChangeControl.disposePurchase(plugin, plugin.getView().getModel(), waitInvoice.getString("salername"), needReverseBuyerSeller);
            if (needReverseBuyerSeller) {
                IssueInvoiceService.reverseBuyerSellerByPurchase((DynamicObject)waitInvoice);
            }
            view.setEnable(Boolean.FALSE, new String[]{"salertaxno"});
            view.setEnable(Boolean.FALSE, new String[]{"invoicetype"});
            plugin.getView().setVisible(Boolean.valueOf(!needReverseBuyerSeller), new String[]{"customsalername"});
            plugin.getView().setVisible(Boolean.valueOf(needReverseBuyerSeller), new String[]{"flexsalername"});
        }
    }

    public static void putItems2PageCache(AbstractFormPlugin plugin, DynamicObject waitInvoice) {
        DynamicObjectCollection vesselShipItems;
        DynamicObjectCollection travelerItems;
        DynamicObjectCollection freightsItems;
        DynamicObjectCollection deducItems = (DynamicObjectCollection)waitInvoice.get("deductions");
        if (null != deducItems && deducItems.size() > 0) {
            JSONArray deducArray = CreateInvoiceWaitControl.getDeducItemArray(deducItems);
            plugin.getPageCache().put("loadDeducItems", deducArray.toJSONString());
        }
        if (null != (freightsItems = (DynamicObjectCollection)waitInvoice.get("freights")) && freightsItems.size() > 0) {
            JSONArray freightArray = CreateInvoiceWaitControl.getFreightArray(freightsItems);
            plugin.getPageCache().put("loadFreightItems", freightArray.toJSONString());
        }
        if ((travelerItems = waitInvoice.getDynamicObjectCollection("travelers")) != null && travelerItems.size() > 0) {
            JSONArray travelerArray = CreateInvoiceWaitControl.getTravelerArray(travelerItems);
            plugin.getPageCache().put("loadTravelerItems", travelerArray.toJSONString());
        }
        if ((vesselShipItems = waitInvoice.getDynamicObjectCollection("vehichevesselships")) != null && vesselShipItems.size() > 0) {
            JSONArray vesselShipArray = CreateInvoiceWaitControl.getVesselShipArray(vesselShipItems);
            plugin.getPageCache().put("loadVesselShipItems", vesselShipArray.toJSONString());
        }
        JSONArray batchItemJsonArray = CreateInvoiceWaitControl.getBatchItemInitCustomView(waitInvoice);
        plugin.getPageCache().put("loadItems", batchItemJsonArray.toJSONString());
    }

    private static JSONArray getVesselShipArray(DynamicObjectCollection dynamicObjectCollection) {
        JSONArray vesselShipArray = new JSONArray();
        for (DynamicObject vesselShipItemObject : dynamicObjectCollection) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("policyno", (Object)vesselShipItemObject.getString("policyno"));
            jsonObject.put("perioddate", (Object)vesselShipItemObject.getString("perioddate"));
            jsonObject.put("shipsno", (Object)vesselShipItemObject.getString("shipsno"));
            jsonObject.put("vehiclecode", (Object)vesselShipItemObject.getString("vehiclecode"));
            jsonObject.put("vehiclevesselamount", (Object)vesselShipItemObject.getBigDecimal("vehiclevesselamount"));
            jsonObject.put("vehiclelateamount", (Object)vesselShipItemObject.getBigDecimal("vehiclelateamount"));
            jsonObject.put("vehicletotalamount", (Object)vesselShipItemObject.getBigDecimal("vehicletotalamount"));
            vesselShipArray.add((Object)jsonObject);
        }
        return vesselShipArray;
    }

    private static JSONArray getTravelerArray(DynamicObjectCollection travelerItems) {
        JSONArray travelerArray = new JSONArray();
        for (DynamicObject travelerItem : travelerItems) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("traveler", (Object)travelerItem.getString("traveler"));
            jsonObject.put("travelercardno", (Object)travelerItem.getString("travelercardno"));
            jsonObject.put("travelercardtype", (Object)travelerItem.getString("travelercardtype"));
            jsonObject.put("travelertransporttype", (Object)travelerItem.getString("travelertransporttype"));
            jsonObject.put("travelerstartplace", (Object)travelerItem.getString("travelerstartplace"));
            jsonObject.put("travelerendplace", (Object)travelerItem.getString("travelerendplace"));
            jsonObject.put("travelerseatclass", (Object)travelerItem.getString("travelerseatclass"));
            jsonObject.put("traveldate", (Object)DateUtils.format((Date)travelerItem.getDate("traveldate")));
            travelerArray.add((Object)jsonObject);
        }
        return travelerArray;
    }

    private static JSONArray getFreightArray(DynamicObjectCollection freightItems) {
        JSONArray freightArray = new JSONArray();
        for (DynamicObject freightItem : freightItems) {
            JSONObject item = new JSONObject();
            item.put("startplace", freightItem.get("startplace"));
            item.put("endplace", freightItem.get("endplace"));
            item.put("transporttype", freightItem.get("transporttype"));
            item.put("licenseplate", freightItem.get("licenseplate"));
            item.put("transportgoods", freightItem.get("transportgoods"));
            freightArray.add((Object)item);
        }
        return freightArray;
    }

    private static JSONArray getDeducItemArray(DynamicObjectCollection deducItems) {
        JSONArray deducArray = new JSONArray();
        for (DynamicObject deducItem : deducItems) {
            JSONObject item = new JSONObject();
            item.put("invoicedate", (Object)DateUtils.format((Date)deducItem.getDate("invoicedate"), (String)"yyyy-MM-dd"));
            item.put("deductioninvoicecode", deducItem.get("deductioninvoicecode"));
            item.put("etaxinvoiceno", deducItem.get("etaxinvoiceno"));
            item.put("deductioninvoiceno", deducItem.get("deductioninvoiceno"));
            item.put("evidenceno", deducItem.get("evidenceno"));
            item.put("evidenceamount", deducItem.get("evidenceamount"));
            item.put("deductionamount", deducItem.get("deductionamount"));
            item.put("deductionremark", deducItem.get("deductionremark"));
            item.put("orievidenceamount", deducItem.get("orievidenceamount"));
            item.put("evidencetype", deducItem.get("evidencetype"));
            deducArray.add((Object)item);
        }
        return deducArray;
    }

    private static BigDecimal showTaxDiff(IFormView view, Object fid) {
        BigDecimal taxDiff = BigDecimal.ZERO;
        QFilter filter = new QFilter("tbillid", "=", fid);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true), (QFilter[])filter.toArray());
        if (relations.length > 0) {
            Object[] sourceKey = Arrays.stream(relations).map(original -> original.getLong("sbillid")).collect(Collectors.toList()).toArray();
            List itemsId = Arrays.stream(relations).map(item -> item.getLong("sdetailid")).collect(Collectors.toList());
            DynamicObject[] sourceData = BusinessDataServiceHelper.load((Object[])sourceKey, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            ArrayList items = Lists.newArrayListWithCapacity((int)sourceData.length);
            Arrays.stream(sourceData).map(originalBill -> originalBill.getDynamicObjectCollection("sim_original_bill_item")).forEach(items::addAll);
            List diffs = items.stream().filter(o -> itemsId.contains(o.getLong("id"))).collect(Collectors.toList());
            taxDiff = diffs.stream().map(diff -> diff.getBigDecimal("taxdeviation")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (taxDiff.abs().compareTo(BigDecimal.ZERO) > 0) {
                view.setVisible(Boolean.TRUE, new String[]{"taxdiffflex"});
                view.getPageCache().put("tempTaxDiff", taxDiff.stripTrailingZeros().toPlainString());
                DecimalFormat df = new DecimalFormat("0.00");
                view.getModel().setValue("taxdiff", (Object)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7a0e\u989d\u5c3e\u5dee\uff1a%1$s", (String)"CreateInvoiceWaitControl_5", (String)"imc-sim-service", (Object[])new Object[0]), df.format(taxDiff.stripTrailingZeros())));
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"taxdiffflex"});
            }
        }
        return taxDiff;
    }

    private static void initBatchViewRedInvoice(AbstractFormPlugin plugin, DynamicObject waitInvoiceDynamicObject) {
        String templateRemark;
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"billno"});
        String originalCode = waitInvoiceDynamicObject.getString("originalinvoicecode");
        String originalNo = waitInvoiceDynamicObject.getString("originalinvoiceno");
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)originalCode, (String)originalNo);
        DynamicObject originalDynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,taxedtype,deduction,originalinvoicetype", (QFilter[])qFilter.toArray());
        if (originalDynamicObject != null) {
            String taxedType = originalDynamicObject.getString("taxedtype");
            plugin.getView().getModel().setValue("deduction", originalDynamicObject.get("deduction"));
            plugin.getView().getModel().setValue("originalinvoicetype", originalDynamicObject.get("originalinvoicetype"));
            templateRemark = "2".equals(taxedType) ? String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%1$s\u3002\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%2$s\u53f7\u7801:%3$s ", originalDynamicObject.get("deduction"), originalCode, originalNo) : String.format("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%1$s\u53f7\u7801:%2$s ", originalCode, originalNo);
        } else {
            templateRemark = String.format("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%1$s\u53f7\u7801:%2$s ", originalCode, originalNo);
        }
        if (!waitInvoiceDynamicObject.getString("remark").contains(templateRemark)) {
            plugin.getView().getModel().setValue("redremark", (Object)templateRemark);
        }
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"issuetype"});
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"taxedtype"});
        plugin.getView().getPageCache().put("qdhp", waitInvoiceDynamicObject.getString("inventorymark"));
    }

    public static JSONArray getBatchItemInitCustomView(DynamicObject invoiceBatchDynamicObject) {
        DynamicObjectCollection batchItems = invoiceBatchDynamicObject.getDynamicObjectCollection("items");
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < batchItems.size(); ++i) {
            DynamicObject itemDynamicObject = (DynamicObject)batchItems.get(i);
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("id", (Object)itemDynamicObject.getPkValue().toString());
            String mergeCode = itemDynamicObject.getString("goodscode");
            jsonItem.put("spbm", (Object)mergeCode);
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)mergeCode);
            String goodsName = itemDynamicObject.getString("goodsname");
            if (!BillConstant.TIP_ITEM_DETAIL.equals(goodsName) || !BigDecimalUtil.lessZero((BigDecimal)invoiceBatchDynamicObject.getBigDecimal("invoiceamount"))) {
                if (taxClassCode == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6570\u636e\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728", (String)"CreateInvoiceWaitControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                String simpleName = taxClassCode.getString("simplename");
                simpleName = String.format("*%s*", simpleName);
                jsonItem.put("spmc", (Object)simpleName);
                if (!goodsName.contains(simpleName)) {
                    goodsName = simpleName + goodsName;
                }
            } else {
                jsonItem.put("spmc", (Object)"");
            }
            jsonItem.put("xmmc", (Object)goodsName);
            jsonItem.put("xmlx", itemDynamicObject.get("rowtype"));
            jsonItem.put("xmdw", itemDynamicObject.get("unit"));
            String yhzcbs = itemDynamicObject.getString("taxpremark");
            String yhzcnr = itemDynamicObject.getString("zzstsgl");
            String slText = itemDynamicObject.getString("taxrate");
            if ("0.1".equals(slText)) {
                slText = "0.10";
            } else if ("0.00".equals(slText) || "0.0".equals(slText) || "0".equals(slText)) {
                slText = "0.00Z3";
            }
            jsonItem.put("slText", (Object)slText);
            jsonItem.put("sl", (Object)("0.00Z3".equals(slText) ? "0" : slText));
            if ("1".equals(yhzcbs)) {
                if ("\u51fa\u53e3\u9000\u7a0e".equals(yhzcnr) || "\u51fa\u53e3\u96f6\u7a0e".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.00Z0");
                } else if ("\u514d\u7a0e".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.00Z1");
                } else if ("\u4e0d\u5f81\u7a0e".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.00Z2");
                } else if ("\u63093%\u7b80\u6613\u5f81\u6536".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.03");
                    jsonItem.put("zzstsgl", (Object)yhzcnr);
                } else if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.015");
                    jsonItem.put("zzstsgl", (Object)yhzcnr);
                } else if ("\u63095%\u7b80\u6613\u5f81\u6536".equals(yhzcnr)) {
                    jsonItem.put("slText", (Object)"0.05");
                    jsonItem.put("zzstsgl", (Object)yhzcnr);
                } else {
                    jsonItem.put("zzstsgl", (Object)yhzcnr);
                }
            } else {
                jsonItem.put("zzstsgl", (Object)"");
            }
            jsonItem.put("ggxh", itemDynamicObject.get("specification"));
            jsonItem.put("kce", invoiceBatchDynamicObject.get("deduction"));
            jsonItem.put("se", (Object)String.valueOf(itemDynamicObject.getBigDecimal("tax").setScale(2, RoundingMode.HALF_UP)));
            jsonItem.put("xmje", (Object)itemDynamicObject.getBigDecimal("amount").setScale(2, 4).toString());
            jsonItem.put("xmjehs", (Object)itemDynamicObject.getBigDecimal("taxamount").setScale(2, 4).toString());
            BigDecimal num = itemDynamicObject.getBigDecimal("num");
            jsonItem.put("xmsl", BigDecimal.ZERO.compareTo(num) == 0 ? "" : new BigDecimal(num.stripTrailingZeros().toPlainString()));
            BigDecimal unitPriceBigDecimal = itemDynamicObject.getBigDecimal("unitprice");
            if (BigDecimal.ZERO.compareTo(unitPriceBigDecimal) != 0) {
                jsonItem.put("xmdj", (Object)itemDynamicObject.getBigDecimal("unitprice"));
                jsonItem.put("xmdjhs", (Object)itemDynamicObject.getBigDecimal("taxunitprice"));
            } else {
                jsonItem.put("xmdj", (Object)"");
                jsonItem.put("xmdjhs", (Object)"");
            }
            jsonItem.put("billsourceid", (Object)itemDynamicObject.getString("billsourceid"));
            jsonArray.add((Object)jsonItem);
        }
        return jsonArray;
    }

    public void batchEditSave(AbstractFormPlugin plugin) {
        try {
            DynamicObject waitInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(plugin.getPageCache().get("invoiceBatchFid")), (String)"sim_vatinvoice");
            CreateInvoiceWaitControl.batchEditBuildInvoiceDynamicObject(plugin, plugin.getView(), waitInvoiceDynamicObject, 0);
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"CreateInvoiceWaitControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            plugin.getView().invokeOperation("refresh");
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"jqbh"});
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"terminalno"});
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"buyerproperty"});
        }
        catch (MsgException e) {
            plugin.getView().showErrorNotification(e.getErrorMsg());
        }
    }

    public static DynamicObject batchEditBuildInvoiceDynamicObject(AbstractFormPlugin plugin, IFormView view, DynamicObject waitInvoiceDynamicObject, int type) {
        if (type == 1) {
            String errMsg = InvoiceCheckService.checkParams((DynamicObject)waitInvoiceDynamicObject, (boolean)false);
            if (!StringUtils.isBlank((String)errMsg)) {
                throw new MsgException(errMsg);
            }
            String itemJsonArray = plugin.getPageCache().get("issueItemData");
            if (itemJsonArray != null) {
                JSONArray itemJSONArray = JSON.parseArray((String)itemJsonArray);
                CreateInvoiceWaitControl.setInventoryRemark(view, waitInvoiceDynamicObject, itemJSONArray);
            }
            return waitInvoiceDynamicObject;
        }
        String itemJsonArray = plugin.getPageCache().get("issueItemData");
        CreateInvoiceWaitControl.updateWaitInvoiceMainData(plugin, view, waitInvoiceDynamicObject, itemJsonArray);
        DynamicObjectCollection waitInvoiceItems = waitInvoiceDynamicObject.getDynamicObjectCollection("items");
        JSONArray itemJSONArray = JSON.parseArray((String)itemJsonArray);
        if ("1".equals(waitInvoiceDynamicObject.get("buyertype"))) {
            CreateInvoiceWaitControl.deleteInvoiceItem(waitInvoiceDynamicObject, waitInvoiceItems, itemJSONArray);
        } else {
            HashSet<Object> allItemPkSet = new HashSet<Object>();
            for (int i = 0; i < itemJSONArray.size(); ++i) {
                JSONObject jsonItem = (JSONObject)itemJSONArray.get(i);
                boolean isUpdate = false;
                for (DynamicObject waitInvoiceItem : waitInvoiceItems) {
                    if (!waitInvoiceItem.getPkValue().toString().equals(jsonItem.get((Object)"id"))) continue;
                    allItemPkSet.add(waitInvoiceItem.getPkValue());
                    ViewBuildInvoiceHelper.buildItemData(i, (DynamicObject)waitInvoiceItems.get(i), jsonItem);
                    isUpdate = true;
                }
                if (isUpdate) continue;
                long globalLongId = DBServiceHelper.genGlobalLongId();
                DynamicObject newItem = waitInvoiceItems.addNew();
                ViewBuildInvoiceHelper.buildItemData(i, newItem, jsonItem);
                newItem.set("id", (Object)globalLongId);
                allItemPkSet.add(globalLongId);
            }
            waitInvoiceItems.removeIf(item -> !allItemPkSet.contains(item.getPkValue()));
        }
        ViewBuildInvoiceHelper.dealCEZSItems(plugin, waitInvoiceDynamicObject);
        ViewBuildInvoiceHelper.dealFreightItems(plugin, waitInvoiceDynamicObject);
        ViewBuildInvoiceHelper.dealTravelrItems(plugin, waitInvoiceDynamicObject);
        ViewBuildInvoiceHelper.dealVesselShipItems(plugin, waitInvoiceDynamicObject);
        CreateInvoiceWaitControl.setInventoryRemark(view, waitInvoiceDynamicObject, itemJSONArray);
        ImcSaveServiceHelper.save((DynamicObject)waitInvoiceDynamicObject);
        return waitInvoiceDynamicObject;
    }

    private static void setInventoryRemark(IFormView view, DynamicObject waitInvoiceDynamicObject, JSONArray itemJSONArray) {
        String inventoryMark = null;
        try {
            inventoryMark = (String)view.getModel().getValue("inventorymark");
        }
        catch (Exception e) {
            return;
        }
        if (itemJSONArray.size() > 8) {
            inventoryMark = "1";
        }
        waitInvoiceDynamicObject.set("inventorymark", (Object)inventoryMark);
    }

    public static void deleteInvoiceItem(DynamicObject waitInvoiceDynamicObject, DynamicObjectCollection waitInvoiceItems, JSONArray itemJSONArray) {
        DeleteServiceHelper.delete((IDataEntityType)waitInvoiceItems.getDynamicObjectType(), (Object[])waitInvoiceItems.stream().map(DataEntityBase::getPkValue).toArray());
        DynamicObjectCollection dynamicObjectCollection = waitInvoiceDynamicObject.getDynamicObjectCollection("items");
        waitInvoiceItems.clear();
        for (int i = 0; i < itemJSONArray.size(); ++i) {
            JSONObject jsonItem = (JSONObject)itemJSONArray.get(i);
            ViewBuildInvoiceHelper.buildItemData(i, dynamicObjectCollection.addNew(), jsonItem);
        }
    }

    public static void updateWaitInvoiceMainData(AbstractFormPlugin plugin, IFormView view, DynamicObject waitInvoiceDynamicObject, String itemJsonArray) {
        ViewBuildInvoiceHelper viewBuildInvoiceHelper = new ViewBuildInvoiceHelper();
        DynamicObject buildInvoiceDynamicObjectByView = viewBuildInvoiceHelper.buildInvoiceByView(plugin, view, itemJsonArray, "sim_vatinvoice");
        waitInvoiceDynamicObject.set("invoiceamount", buildInvoiceDynamicObjectByView.get("invoiceamount"));
        waitInvoiceDynamicObject.set("totaltax", buildInvoiceDynamicObjectByView.get("totaltax"));
        waitInvoiceDynamicObject.set("totalamount", buildInvoiceDynamicObjectByView.get("totalamount"));
        waitInvoiceDynamicObject.set("buyername", buildInvoiceDynamicObjectByView.get("buyername"));
        waitInvoiceDynamicObject.set("buyertaxno", buildInvoiceDynamicObjectByView.get("buyertaxno"));
        waitInvoiceDynamicObject.set("buyeraddr", buildInvoiceDynamicObjectByView.get("buyeraddr"));
        waitInvoiceDynamicObject.set("buyerbank", buildInvoiceDynamicObjectByView.get("buyerbank"));
        waitInvoiceDynamicObject.set("buyerphone", buildInvoiceDynamicObjectByView.get("buyerphone"));
        waitInvoiceDynamicObject.set("buyeremail", buildInvoiceDynamicObjectByView.get("buyeremail"));
        waitInvoiceDynamicObject.set("saleraddr", buildInvoiceDynamicObjectByView.get("saleraddr"));
        waitInvoiceDynamicObject.set("salerbank", buildInvoiceDynamicObjectByView.get("salerbank"));
        waitInvoiceDynamicObject.set("remark", buildInvoiceDynamicObjectByView.get("remark"));
        waitInvoiceDynamicObject.set("jqbh", buildInvoiceDynamicObjectByView.get("jqbh"));
        waitInvoiceDynamicObject.set("simpleaddress", buildInvoiceDynamicObjectByView.get("simpleaddress"));
        waitInvoiceDynamicObject.set("detailaddress", buildInvoiceDynamicObjectByView.get("detailaddress"));
        waitInvoiceDynamicObject.set("crosscitysign", buildInvoiceDynamicObjectByView.get("crosscitysign"));
        waitInvoiceDynamicObject.set("areaunit", buildInvoiceDynamicObjectByView.get("areaunit"));
        waitInvoiceDynamicObject.set("startleasedate", buildInvoiceDynamicObjectByView.get("startleasedate"));
        waitInvoiceDynamicObject.set("endleasedate", buildInvoiceDynamicObjectByView.get("endleasedate"));
        waitInvoiceDynamicObject.set("buildingname", buildInvoiceDynamicObjectByView.get("buildingname"));
        waitInvoiceDynamicObject.set("landtaxno", buildInvoiceDynamicObjectByView.get("landtaxno"));
        waitInvoiceDynamicObject.set("estateid", buildInvoiceDynamicObjectByView.get("estateid"));
        waitInvoiceDynamicObject.set("terminalno", buildInvoiceDynamicObjectByView.get("terminalno"));
        waitInvoiceDynamicObject.set("invoicetype", buildInvoiceDynamicObjectByView.get("invoicetype"));
        waitInvoiceDynamicObject.set("billno", view.getModel().getValue("billno"));
        waitInvoiceDynamicObject.set("drawer", view.getModel().getValue("drawer"));
        waitInvoiceDynamicObject.set("reviewer", view.getModel().getValue("reviewer"));
        waitInvoiceDynamicObject.set("payee", view.getModel().getValue("payee"));
        waitInvoiceDynamicObject.set("buyerproperty", view.getModel().getValue("buyerproperty"));
    }
}

