/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillSpecialGoodsRemarkCheckHelper;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillInvoiceRelationHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class IssueInvoiceControlHelper {
    private static final Log LOGGER = LogFactory.getLog(IssueInvoiceControlHelper.class);

    public ErrorMsgDTO checkSpecialTypeRemark(IFormView view, String itemJsonArray) {
        if (StringUtils.isBlank((String)itemJsonArray)) {
            return null;
        }
        JSONArray itemJSONArray = JSON.parseArray((String)itemJsonArray);
        if (CollectionUtils.isEmpty((Collection)itemJSONArray)) {
            return null;
        }
        for (int i = 0; i < itemJSONArray.size(); ++i) {
            ErrorMsgDTO errorMsgDTO;
            JSONObject itemObj = itemJSONArray.getJSONObject(i);
            String goodCode = itemObj.getString("spbm");
            if (StringUtils.isBlank((String)goodCode)) {
                goodCode = itemObj.getString("goodscode");
            }
            if (StringUtils.isBlank((String)goodCode) || (errorMsgDTO = BillSpecialGoodsRemarkCheckHelper.checkSpecialGoodCodeRemark((int)(i + 1), (String)goodCode, (String)(view.getModel().getValue("remark") == null ? "" : String.valueOf(view.getModel().getValue("remark"))))) == null) continue;
            return errorMsgDTO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> issueInvoice(DynamicObject[] bills, String deviceNo, String terminalNo, String account, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList invoiceList = Lists.newArrayList();
        ArrayList redInfoList = Lists.newArrayList();
        ArrayList redConfirmList = Lists.newArrayList();
        HashMap failedInfo = Maps.newHashMap();
        List billNos = Arrays.stream(bills).map(e -> e.getString("billno")).collect(Collectors.toList());
        if (!StringUtils.isEmpty((String)terminalNo)) {
            Arrays.stream(bills).forEach(e -> e.set("terminalno", (Object)terminalNo));
        }
        LOGGER.info(String.format("IssueInvoiceHelper issueInvoice billNos:%s", SerializationUtils.toJsonString(billNos)));
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills[0].get("orgid"));
        try {
            HashMap hashMap;
            BillOperationLockUtil.getBillsLock(billNos, (boolean)false, (long)orgId);
            if (bills.length <= 0) {
                throw new KDBizException(new ErrorCode("50001", ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_0", (String)"imc-sim-service", (Object[])new Object[0])), new Object[0]);
            }
            MergeRequestDTO billRequest = new MergeRequestDTO.Builder().mergeBill(isMergeBill).mergeBillDetail(isMergeBillDetail).setJqbh(deviceNo).bills(bills).build();
            MergeResponseDTO mergeResponseDTO = new BillMergeHelper().mergeBill(billRequest);
            Map<String, String> errorMap = IssueInvoiceControlHelper.checkMerge(bills, mergeResponseDTO);
            LOGGER.info(String.format("issueInvoice errorMap:%s", SerializationUtils.toJsonString(errorMap)));
            for (String message : errorMap.values()) {
                String billNo = message.split(":")[0];
                bills = (DynamicObject[])Arrays.stream(bills).filter(o -> !o.getString("billno").equals(billNo)).toArray(DynamicObject[]::new);
                if (!StringUtils.isNotBlank((String)billNo)) continue;
                failedInfo.put(billNo, message);
                LOGGER.info(String.format("issueInvoice mergeResponseDTO.getRelations:%s,billNo:%s", SerializationUtils.toJsonString((Object)mergeResponseDTO.getRelations()), billNo));
                mergeResponseDTO.getRelations().removeIf(e -> e.getsBillNo().equals(billNo));
                LOGGER.info(String.format("issueInvoice mergeResponseDTO.getBills:%s,billNo:%s", SerializationUtils.toJsonString((Object)mergeResponseDTO.getBills()), billNo));
                mergeResponseDTO.getBills().removeIf(e -> e.getString("billno").contains(billNo));
            }
            Map<Long, List<BillRelationDTO>> mergeRelationMap = mergeResponseDTO.getRelations().stream().collect(Collectors.groupingBy(BillRelationDTO::gettBillId));
            List billList = mergeResponseDTO.getBills();
            LOGGER.info(String.format("issueInvoice merge success billList:%s", SerializationUtils.toJsonString((Object)billList)));
            ArrayList splitSuccessBill = Lists.newArrayList();
            ArrayList billRelations = Lists.newArrayList();
            ArrayList invoiceRelationList = Lists.newArrayList();
            SplitRequestDTO splitRequest = new SplitRequestDTO();
            Iterator iterator = billList.iterator();
            while (iterator.hasNext()) {
                Iterator<Long> invoice2;
                DynamicObject bill2 = (DynamicObject)iterator.next();
                try {
                    splitRequest.setBill(bill2);
                    splitRequest.setBillNoMap(mergeResponseDTO.getBillNoMap());
                    SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill(splitRequest, StringUtils.isBlank((String)deviceNo) ? bill2.getString("jqbh") : deviceNo);
                    invoiceRelationList.addAll(splitResponseDTO.getRelations());
                    if (BillHelper.isRedInfo((DynamicObject)bill2)) {
                        redInfoList.addAll(splitResponseDTO.getInvoices());
                    } else if (BillHelper.isAllERedConfirm((DynamicObject)bill2)) {
                        if (!OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equals(account)) {
                            for (Iterator<Long> invoice2 : splitResponseDTO.getInvoices()) {
                                invoice2.set("account", account);
                            }
                        }
                        redConfirmList.addAll(splitResponseDTO.getInvoices());
                    } else {
                        List invoices = splitResponseDTO.getInvoices();
                        invoice2 = invoices.iterator();
                        while (invoice2.hasNext()) {
                            DynamicObject invoice3 = (DynamicObject)invoice2.next();
                            if (!OpenApiInterfaceCodeEnum.BILL_PUSH.getCode().equals(account)) {
                                invoice3.set("account", (Object)account);
                            }
                            if (!StringUtils.isNotBlank((String)bill2.getString("mergelable"))) continue;
                            invoice3.set("mergelable", (Object)"1");
                        }
                        invoiceList.addAll(splitResponseDTO.getInvoices());
                    }
                    billRelations.addAll((Collection)mergeRelationMap.get(bill2.getLong("id")));
                }
                catch (Exception e2) {
                    iterator.remove();
                    Set<Long> failBillIds = mergeRelationMap.get(bill2.getLong("id")).stream().collect(Collectors.groupingBy(BillRelationDTO::getsBillId)).keySet();
                    invoice2 = failBillIds.iterator();
                    while (invoice2.hasNext()) {
                        Long failBillId = invoice2.next();
                        failedInfo.put(failBillId.toString(), e2.getMessage());
                    }
                    LOGGER.error("IssueInvoiceHelper issueInvoice invoke", (Throwable)e2);
                }
            }
            Set<Long> successBillIds = billRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::getsBillId)).keySet();
            List<DynamicObject> origSuccessBills = Arrays.stream(bills).filter(bill -> successBillIds.contains(bill.getLong("id"))).collect(Collectors.toList());
            IssueInvoiceControlHelper.doOriginalTaxDeviation(mergeResponseDTO.getBills(), billRelations, invoiceRelationList);
            List<BillRelationDTO> invRelation = BillInvoiceRelationHelper.mergeRelation(billRelations, invoiceRelationList);
            try (TXHandle tx = TX.requiresNew();){
                BillProcessTabUtil.fillInvoiceInfoFromBill(bills, invRelation, invoiceList);
                IssueInvoiceControlHelper.setOriginalBillByInvRelation(origSuccessBills, invRelation);
                List<DynamicObject> invRelationDOList = IssueInvoiceControlHelper.saveInvRelation(invRelation);
                if (CollectionUtils.isNotEmpty((Collection)invoiceList)) {
                    InvoiceUtils.dealInvoicesListMark(new HashMap(), (List)invoiceList);
                    ImcSaveServiceHelper.save((List)invoiceList);
                }
                if (CollectionUtils.isNotEmpty((Collection)redInfoList)) {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_info", (DynamicObject[])redInfoList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    if (!operationResult.isSuccess()) {
                        throw new KDBizException(operationResult.getMessage());
                    }
                    for (DynamicObject redInfo : redInfoList) {
                        if (!"3".equals(redInfo.get("status"))) continue;
                        DynamicObject waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo);
                        ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                        invoiceList.add(waitInvoice);
                    }
                } else if (CollectionUtils.isNotEmpty((Collection)redConfirmList)) {
                    for (DynamicObject invoiceDO : redConfirmList) {
                        DynamicObject redConfirmBill = BillProcessTabUtil.warpRedAllEInvoiceData(invRelationDOList, invoiceDO);
                        DynamicObject waitInvoice = RedConfirmBillHelper.createWaitInvoice(redConfirmBill);
                        waitInvoice.set("buyertype", (Object)"4");
                        waitInvoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
                        waitInvoice.set("batchbelong", (Object)invoiceDO.getString("batchbelong"));
                        waitInvoice.set("buyerphone", (Object)invoiceDO.getString("buyerphone"));
                        waitInvoice.set("buyeremail", (Object)invoiceDO.getString("buyeremail"));
                        ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                        invoiceList.add(waitInvoice);
                    }
                }
                LOGGER.info(String.format("issueInvoice origSuccessBills:%s", SerializationUtils.toJsonString(origSuccessBills)));
                DynamicObject[] invoices = IssueInvoiceControlHelper.getAllInvoices(invRelation);
                ItemMerge2OneHelper.dealOriginalBillNumDifference((DynamicObject[])invoices);
            }
            if (autoInvoice == 1 && CollectionUtils.isNotEmpty((Collection)invoiceList)) {
                if (CollectionUtils.isEmpty((Collection)invoiceList)) {
                    hashMap = resultMap;
                    return hashMap;
                }
                LOGGER.info(String.format("submitInvoice2MQ invoiceList:%s", SerializationUtils.toJsonString((Object)invoiceList)));
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
                IssueInvoiceControlHelper.callBackThirdApiSystem(invoiceList);
            }
            resultMap.put("splitSuccessBill", splitSuccessBill);
            resultMap.put("failedInfo", failedInfo);
            resultMap.put("invoiceList", invoiceList);
            hashMap = resultMap;
            return hashMap;
        }
        finally {
            BillOperationLockUtil.unOperationLook((String)String.valueOf(orgId), billNos);
        }
    }

    private static void callBackThirdApiSystem(List<DynamicObject> invoiceList) {
        try {
            boolean hasField = DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)invoiceList.get(0), (String)"textfield1");
            for (DynamicObject dynamicObject : invoiceList) {
                String systemSource = dynamicObject.getString("systemsource");
                if (!"BILL_CENTER".equals(systemSource) || !hasField) continue;
                String systemCode = dynamicObject.getString("textfield1");
                LOGGER.info("callBackThirdApiSystem, systemSource:{}, systemCode:{}", (Object)systemSource, (Object)systemCode);
                if (!"FuShiImage".equals(systemCode) && !"9999".equals(systemCode)) continue;
                dynamicObject.set("systemsource", (Object)systemCode);
                new ExternalSystemDataHandler().dealUpdateOpenInvoiceStatus(dynamicObject, null);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static DynamicObject[] getAllInvoices(List<BillRelationDTO> invRelation) {
        ArrayList<Long> invoicePks = new ArrayList<Long>();
        for (BillRelationDTO billRelationDTO : invRelation) {
            invoicePks.add(billRelationDTO.gettBillId());
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"mergelable", (QFilter[])new QFilter("id", "in", (Object)invoicePks.toArray()).toArray());
    }

    private static void doOriginalTaxDeviation(List<DynamicObject> mergeBills, List<BillRelationDTO> billRelationList, List<BillRelationDTO> invoiceRelationList) {
        Map<Long, List<BillRelationDTO>> billRelationMap = billRelationList.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId));
        List invoiceRelations = invoiceRelationList.stream().filter(relation -> relation.getTaxDeviation().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        for (BillRelationDTO invoiceRelation : invoiceRelations) {
            List<BillRelationDTO> billRelations = billRelationMap.get(invoiceRelation.getsDetailId());
            if (CollectionUtils.isEmpty(billRelations)) continue;
            billRelations.stream().max(Comparator.comparing(BillRelationDTO::getTax)).ifPresent(relation -> {
                relation.setTax(relation.getTax().subtract(invoiceRelation.getTaxDeviation()));
                relation.setAmount(relation.getAmount().add(invoiceRelation.getTaxDeviation()));
            });
        }
        for (DynamicObject mergeBill : mergeBills) {
            DynamicObjectCollection mergeBillItems = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject mergeBillItem : mergeBillItems) {
                List<BillRelationDTO> relations;
                BigDecimal taxdeviation = mergeBillItem.getBigDecimal("taxdeviation");
                if (taxdeviation.compareTo(BigDecimal.ZERO) == 0 || CollectionUtils.isEmpty(relations = billRelationMap.get(mergeBillItem.getLong("id")))) continue;
                relations.stream().max(Comparator.comparing(BillRelationDTO::getTax)).ifPresent(relation -> {
                    relation.setTax(relation.getTax().subtract(taxdeviation));
                    relation.setAmount(relation.getAmount().add(taxdeviation));
                });
            }
        }
    }

    private static Map<String, String> checkMerge(DynamicObject[] bills, MergeResponseDTO mergeResponseDTO) {
        Map<String, DynamicObject> origBillMap = Arrays.stream(bills).collect(Collectors.groupingBy(e -> e.getString("billno"), Collectors.collectingAndThen(Collectors.toList(), v -> (DynamicObject)v.get(0))));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        for (DynamicObject bill : mergeResponseDTO.getBills()) {
            String[] split;
            if (!BigDecimalUtil.lessZero((BigDecimal)bill.getBigDecimal("totalamount"))) continue;
            String billNos = bill.getString("billno");
            for (String billNo : split = StringUtils.split((String)billNos, (char)',')) {
                DynamicObject errorBill = origBillMap.get(billNo);
                String showTip = "";
                String billProperties = errorBill.getString("billproperties");
                String invoiceType = errorBill.getString("invoicetype");
                if ("-1".equals(billProperties) && !BillHelper.isFilledBlue((DynamicObject)errorBill)) {
                    if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                        showTip = String.format(ResManager.loadKDString((String)"%1$s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\uff0c\u8d1f\u6570\u6570\u7535\u9700\u8981\u8865\u5145\u539f\u84dd\u7968\u4fe1\u606f\u3002%2$s", (String)"IssueInvoiceControlHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), errorBill.getString("billno"), "<br>");
                    } else if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
                        showTip = String.format(ResManager.loadKDString((String)"%1$s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\uff0c\u8d1f\u6570\u666e\u7968\u9700\u8981\u8865\u5145\u539f\u84dd\u7968\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u3002%2$s", (String)"IssueInvoiceControlHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), errorBill.getString("billno"), "<br>");
                    } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                        String applicant = errorBill.getString("applicant");
                        if (StringUtils.isNotBlank((String)applicant)) {
                            if (RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode().equals(applicant)) {
                                showTip = String.format(ResManager.loadKDString((String)"%1$s:\u8d2d\u65b9\u7533\u8bf7\u7684\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u5199\u7ea2\u5b57\u4fe1\u606f\u7f16\u53f7\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                            } else if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
                                showTip = String.format(ResManager.loadKDString((String)"%1$s:\u9500\u65b9\u7533\u8bf7\u7684\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u5199\u7ea2\u5b57\u4fe1\u606f\u8868\u6807\u53f7\u6216\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_4", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                            }
                        } else {
                            showTip = String.format(ResManager.loadKDString((String)"%1$s:\u8d1f\u6570\u4e13\u7968\u5355\u636e\u5fc5\u987b\u586b\u7533\u8bf7\u65b9\u4ee5\u53ca\u3010\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7/\u7ea2\u5b57\u786e\u8ba4\u5355\u3011\u6216\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u4fe1\u606f\u624d\u80fd\u5f00\u7968\u3002%2$s", (String)"IssueInvoiceControlHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno"), "<br>");
                        }
                    }
                    resultMap.put(billNo, showTip);
                    continue;
                }
                if (!"1".equals(errorBill.getString("billproperties"))) continue;
                showTip = String.format(ResManager.loadKDString((String)"%s:\u6b63\u8d1f\u6570\u5355\u636e\u5408\u5e76\u6210\u8d1f\u6570\u5355\u636e\u5931\u8d25\u3002", (String)"IssueInvoiceControlHelper_6", (String)"imc-sim-service", (Object[])new Object[0]), billNo);
                resultMap.put(billNo, showTip);
            }
        }
        return resultMap;
    }

    public static List<DynamicObject> saveInvRelation(List<BillRelationDTO> invRelation) {
        return IssueInvoiceControlHelper.saveInvRelation(invRelation, "sim_bill_inv_relation");
    }

    public static List<DynamicObject> saveInvRelation(List<BillRelationDTO> invRelation, String tableId) {
        ArrayList<DynamicObject> relation = new ArrayList<DynamicObject>(invRelation.size());
        if (invRelation.size() > 0) {
            for (BillRelationDTO billRelationDTO : invRelation) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)tableId);
                DynamicObjectUtil.bean2DynamicObject((Object)billRelationDTO, (DynamicObject)dynamicObject);
                relation.add(dynamicObject);
            }
            ImcSaveServiceHelper.save(relation);
        }
        return relation;
    }

    public static void issueInvoice(DynamicObject[] bills, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail, String channelType) {
        if (bills.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u6570\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_7", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        LOGGER.info("issueInvoice, bills:{}, channelType:{}", (Object)bills.length, (Object)channelType);
        Map<String, List<DynamicObject>> billMap = Stream.of(bills).collect(Collectors.groupingBy(k -> k.getString("jqbh")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = billMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            Map<String, Object> resultMap = IssueInvoiceControlHelper.issueInvoice(entry.getValue().toArray(new DynamicObject[0]), entry.getKey(), null, "", autoInvoice, isMergeBill, isMergeBillDetail);
            if (!resultMap.containsKey("failedInfo")) continue;
            Map failedInfoMap = (Map)resultMap.get("failedInfo");
            for (Map.Entry entryObject : failedInfoMap.entrySet()) {
                String message = (String)entryObject.getValue();
                if (!StringUtils.isNotEmpty((String)message)) continue;
                throw new KDBizException(message);
            }
        }
    }

    public static void issueInvoice(DynamicObject[] bills, Integer autoInvoice, boolean isMergeBill, boolean isMergeBillDetail) {
        if (bills.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u6570\u636e\u4e0d\u5b58\u5728", (String)"IssueInvoiceControlHelper_7", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        Map<String, List<DynamicObject>> billMap = Stream.of(bills).collect(Collectors.groupingBy(k -> k.getString("jqbh")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = billMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            IssueInvoiceControlHelper.issueInvoice(entry.getValue().toArray(new DynamicObject[0]), entry.getKey(), null, OpenApiInterfaceCodeEnum.BILL_PUSH.getCode(), autoInvoice, isMergeBill, isMergeBillDetail);
        }
    }

    public static DynamicObject[] findRelateInvoice(List<Long> pkList) {
        QFilter isCancelFilter = new QFilter("iscancel", "!=", (Object)BillRelateInvoicesConstant.IsCancelEnum.YES);
        DynamicObject[] dbRelate = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)"serialno", (QFilter[])new QFilter("originalbillid", "in", (Object)pkList.toArray()).and(isCancelFilter).toArray());
        HashSet<String> typeSet = new HashSet<String>(4);
        if (dbRelate != null && dbRelate.length > 0) {
            for (DynamicObject invoice : dbRelate) {
                typeSet.add(invoice.getString("serialno"));
            }
        }
        if (typeSet.size() > 0) {
            return BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)String.join((CharSequence)",", "id", "originalbillid"), (QFilter[])new QFilter("serialno", "in", (Object)typeSet.toArray()).and(BillHelper.notCancelFilter()).toArray());
        }
        return null;
    }

    public static void setOriginalBillByInvRelation(List<DynamicObject> origSuccessBills, List<BillRelationDTO> invRelations) {
        if (CollectionUtils.isEmpty(origSuccessBills) || CollectionUtils.isEmpty(invRelations)) {
            return;
        }
        Map<Long, List<BillRelationDTO>> billRelationMap = invRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::getsDetailId));
        for (DynamicObject origBill : origSuccessBills) {
            boolean isTax = "1".equals(origBill.getString("hsbz"));
            boolean isRelation = invRelations.stream().filter(Relation -> Relation.getsBillId().equals(origBill.getPkValue())).anyMatch(relation -> "-1".equals(relation.getPushType()));
            if (isRelation) {
                IssueInvoiceControlHelper.setOriginalAllConfirmed(origBill);
                continue;
            }
            BigDecimal confirmAmount = origBill.getBigDecimal("confirmamount");
            BigDecimal mainTaxDeviation = origBill.getBigDecimal("maintaxdeviation");
            DynamicObjectCollection items = origBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                BigDecimal amountSum = BigDecimal.ZERO;
                BigDecimal numSum = BigDecimal.ZERO;
                BigDecimal taxSum = BigDecimal.ZERO;
                List<BillRelationDTO> relations = billRelationMap.get(item.getLong("id"));
                if (CollectionUtils.isNotEmpty(relations)) {
                    for (BillRelationDTO relation2 : relations) {
                        confirmAmount = confirmAmount.add(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                        amountSum = amountSum.add(relation2.getAmount());
                        numSum = numSum.add(relation2.getNum());
                        taxSum = taxSum.add(relation2.getTax());
                    }
                }
                BigDecimal remainValidAmount = item.getBigDecimal("remainvalidamount").subtract(isTax ? item.getBigDecimal("remainvalidtax") : BigDecimal.ZERO);
                item.set("amountdeviation", (Object)item.getBigDecimal("amountdeviation").add(remainValidAmount.subtract(amountSum)));
                item.set("numdeviation", (Object)item.getBigDecimal("numdeviation").add(item.getBigDecimal("remainvalidnum").subtract(numSum)));
                BigDecimal taxDeviation = item.getBigDecimal("remainvalidtax").subtract(taxSum);
                item.set("taxdeviation", (Object)item.getBigDecimal("taxdeviation").add(taxDeviation));
                item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
                if (!item.getBoolean("gift") && item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                    item.set("zeropushflag", (Object)"1");
                }
                mainTaxDeviation = mainTaxDeviation.add(taxDeviation);
            }
            origBill.set("maintaxdeviation", (Object)mainTaxDeviation);
            origBill.set("confirmamount", (Object)confirmAmount);
            origBill.set("confirmstate", (Object)"2");
            IssueInvoiceControlHelper.foreignCurrencyDeviation(origBill);
        }
        ImcSaveServiceHelper.update(origSuccessBills);
    }

    private static void foreignCurrencyDeviation(DynamicObject bill) {
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        if (!CurrencyHelper.isFrom((Object)fromCurr)) {
            return;
        }
        BigDecimal formTaxDeviationSum = BigDecimal.ZERO;
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            BigDecimal taxDeviation = item.getBigDecimal("taxdeviation");
            if (MathUtils.isNullOrZero((BigDecimal)taxDeviation)) continue;
            BigDecimal fromTax = item.getBigDecimal("fromtax");
            BigDecimal fromTaxDeviation = fromTax.multiply(taxDeviation.divide(item.getBigDecimal("tax"), 100, 4)).setScale(fromCurr.getInt("amtprecision"), 4);
            item.set("fromtaxdeviation", (Object)fromTaxDeviation);
            formTaxDeviationSum = formTaxDeviationSum.add(fromTaxDeviation);
        }
        bill.set("foreigntaxdifference", (Object)formTaxDeviationSum);
    }

    public static void setOriginalAllConfirmed(DynamicObject bill) {
        boolean isTax = "1".equals(bill.getString("hsbz"));
        bill.set("confirmamount", (Object)bill.getBigDecimal(isTax ? "totalamount" : "invoiceamount"));
        bill.set("confirmstate", (Object)"2");
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("remainvalidamount", (Object)BigDecimal.ZERO);
            item.set("remainvalidtax", (Object)BigDecimal.ZERO);
            item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            if (item.getBoolean("gift") || item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) continue;
            item.set("zeropushflag", (Object)"1");
        }
    }

    public static void setSplitOriginalBillByInvRelation(List<DynamicObject> origSuccessBills, List<BillRelationDTO> invRelation) {
        if (CollectionUtils.isEmpty(origSuccessBills) || CollectionUtils.isEmpty(invRelation)) {
            return;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])origSuccessBills.stream().map(bill -> bill.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        if (invRelation.stream().anyMatch(relation -> relation.getsDetailId() == null)) {
            for (DynamicObject bill2 : bills) {
                IssueInvoiceControlHelper.setOriginalAllConfirmed(bill2);
            }
            ImcSaveServiceHelper.update((DynamicObject[])bills);
            return;
        }
        Map<Long, List<BillRelationDTO>> billRelationMap = invRelation.stream().collect(Collectors.groupingBy(BillRelationDTO::getsDetailId));
        for (DynamicObject origBill : bills) {
            boolean isTax = "1".equals(origBill.getString("hsbz"));
            BigDecimal confirmamount = origBill.getBigDecimal("confirmamount");
            DynamicObjectCollection items = origBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                List<BillRelationDTO> relations = billRelationMap.get(item.getLong("id"));
                BigDecimal remainValidAmount = item.getBigDecimal("remainvalidamount");
                BigDecimal remainValidTax = item.getBigDecimal("remainvalidtax");
                BigDecimal remainValidNum = item.getBigDecimal("remainvalidnum");
                if (CollectionUtils.isNotEmpty(relations)) {
                    for (BillRelationDTO relation2 : relations) {
                        confirmamount = confirmamount.add(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                        remainValidTax = remainValidTax.subtract(relation2.getTax());
                        remainValidNum = remainValidNum.subtract(relation2.getNum());
                        remainValidAmount = remainValidAmount.subtract(relation2.getAmount().add(isTax ? relation2.getTax() : BigDecimal.ZERO));
                    }
                }
                item.set("remainvalidamount", (Object)remainValidAmount);
                item.set("remainvalidtax", (Object)remainValidTax);
                item.set("remainvalidnum", (Object)remainValidNum);
            }
            origBill.set("confirmamount", (Object)confirmamount);
            BigDecimal confirmAmountTax = confirmamount.add(isTax ? BigDecimal.ZERO : origBill.getBigDecimal("totaltax"));
            if (confirmAmountTax.abs().compareTo(origBill.getBigDecimal("totalamount").abs()) >= 0) {
                origBill.set("confirmstate", (Object)"2");
                continue;
            }
            origBill.set("confirmstate", (Object)"1");
        }
        ImcSaveServiceHelper.update((DynamicObject[])bills);
    }
}

