/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.model.TailCheckResult;

public class TailDifferenceHelper {
    public static TailCheckResult checkTailDifference(AbstractFormPlugin plugin, JSONArray invoiceItems) {
        TailCheckResult tailCheckResult = TailDifferenceHelper.checkItems(invoiceItems);
        if (!tailCheckResult.isCheckSuccess()) {
            return tailCheckResult;
        }
        return TailDifferenceHelper.checkTotal(tailCheckResult);
    }

    private static TailCheckResult checkItems(JSONArray invoiceItems) {
        TailCheckResult tailCheckResult = new TailCheckResult();
        BigDecimal itemTaxTotalDifference = BigDecimal.ZERO;
        for (int i = 0; i < invoiceItems.size(); ++i) {
            JSONObject itemObj = invoiceItems.getJSONObject(i);
            String kce = itemObj.getString("kce");
            String xmje = itemObj.getString("xmje");
            BigDecimal amount = new BigDecimal(xmje);
            if (StringUtils.isNotBlank((CharSequence)kce) && amount.compareTo(BigDecimal.ZERO) > 0) {
                amount = amount.subtract(new BigDecimal(kce));
            }
            String se = itemObj.getString("se");
            String taxRate = itemObj.getString("slText");
            if (null == taxRate || taxRate.startsWith("0.00")) {
                taxRate = "0";
            }
            BigDecimal editTax = new BigDecimal(se);
            BigDecimal orginalTaxRate = TailDifferenceHelper.calculateOriginalTax("0", amount, taxRate);
            BigDecimal subtract = orginalTaxRate.subtract(editTax);
            BigDecimal abs = subtract.abs().setScale(2, 4);
            itemTaxTotalDifference = itemTaxTotalDifference.add(abs);
            if (abs.compareTo(new BigDecimal("0.06")) <= 0) continue;
            tailCheckResult.setRowIndex(Integer.valueOf(i));
            tailCheckResult.setFailDescription(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u5408\u6cd5[\u7b2c%s\u884c\uff0c\u7a0e\u989d\u8bef\u5dee\u5927\u4e8e0.06]", (String)"TailDifferenceHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), i + 1));
            tailCheckResult.setCheckSuccess(false);
            return tailCheckResult;
        }
        tailCheckResult.setRowTailDifferenceTotal(itemTaxTotalDifference);
        tailCheckResult.setCheckSuccess(true);
        return tailCheckResult;
    }

    private static BigDecimal calculateOriginalTax(String hsbz, BigDecimal amount, String taxRate) {
        BigDecimal rateDecimalValue = new BigDecimal(taxRate);
        if ("1".equals(hsbz)) {
            return amount.divide(BigDecimal.ONE.add(rateDecimalValue), 8, 4).multiply(rateDecimalValue).setScale(2, 4);
        }
        return amount.multiply(rateDecimalValue).setScale(2, 4);
    }

    private static TailCheckResult checkTotal(TailCheckResult itemCheckResult) {
        boolean totalCheck;
        boolean bl = totalCheck = new BigDecimal("1.27").compareTo(itemCheckResult.getRowTailDifferenceTotal()) >= 0;
        if (totalCheck) {
            return itemCheckResult;
        }
        itemCheckResult.setCheckSuccess(false);
        itemCheckResult.setFailDescription(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u5408\u6cd5[\u5408\u8ba1\u7a0e\u989d\u8bef\u5dee\u5927\u4e8e1.27]", (String)"TailDifferenceHelper_1", (String)"imc-sim-service", (Object[])new Object[0]));
        return itemCheckResult;
    }
}

