/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.formplugin.match.dto.VerifyQFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ConditionMatchHelper {
    private static final Log log = LogFactory.getLog(ConditionMatchHelper.class);

    private static boolean evalScript(String script) {
        Context context = Context.enter();
        ScriptableObject scope = context.initSafeStandardObjects();
        return (Boolean)context.evaluateString((Scriptable)scope, script, null, 0, null);
    }

    public static boolean verify(String filterStr, DynamicObject bill) {
        if (StringUtils.isBlank((CharSequence)filterStr)) {
            return true;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        List listFilterRow = filterCondition.getFilterRow();
        if (CollectionUtils.isEmpty((Collection)listFilterRow)) {
            return true;
        }
        ArrayList<VerifyQFilter> filterList = new ArrayList<VerifyQFilter>(listFilterRow.size());
        for (int i = 0; i < listFilterRow.size(); ++i) {
            String fieldName;
            SimpleFilterRow row = (SimpleFilterRow)listFilterRow.get(i);
            VerifyQFilter rowFilter = new VerifyQFilter();
            if (i == 0) {
                rowFilter.setLeftBracket(StringUtils.trimToEmpty((String)row.getLeftBracket()) + "(");
            } else {
                rowFilter.setLeftBracket(row.getLeftBracket());
            }
            if (i == listFilterRow.size() - 1) {
                rowFilter.setRightBracket(StringUtils.trimToEmpty((String)row.getRightBracket()) + ")");
            } else {
                rowFilter.setRightBracket(row.getRightBracket());
            }
            rowFilter.setLogic(row.getLogic());
            List filterValueList = row.getValue();
            if (filterValueList != null) {
                List baseDataIds = row.getBaseDataIds();
                if (!CollectionUtils.isEmpty((Collection)baseDataIds)) {
                    filterValueList = baseDataIds;
                }
                ArrayList<Object> filterValues = new ArrayList<Object>(filterValueList.size());
                for (FilterValue value : filterValueList) {
                    filterValues.add(value.getValue());
                }
                rowFilter.setValue(filterValues);
            }
            rowFilter.setProperty((fieldName = row.getFieldName()).contains(".") ? fieldName.substring(0, fieldName.indexOf(46)) : fieldName);
            rowFilter.setCp(row.getCompareType());
            filterList.add(rowFilter);
        }
        return ConditionMatchHelper.compare(filterList, bill);
    }

    private static boolean compare(List<VerifyQFilter> filterList, DynamicObject bill) {
        Object invoiceValue;
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        HashMap<String, String> itemKeyMaps = new HashMap<String, String>(properties.size());
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            ((EntryProp)property).getItemType().getProperties().forEach(itemProperty -> itemKeyMaps.put(itemProperty.getName(), property.getName()));
        }
        if (filterList.size() == 1) {
            VerifyQFilter filter = filterList.get(0);
            invoiceValue = ConditionMatchHelper.getInvoiceValue(itemKeyMaps, bill, filter.getProperty());
            Object compareValue = filter.getValue();
            return ConditionMatchHelper.compare(invoiceValue, filter.getCp(), compareValue, bill);
        }
        StringBuilder resutSb = new StringBuilder();
        for (VerifyQFilter filter : filterList) {
            if (StringUtils.isNotEmpty((CharSequence)filter.getLeftBracket())) {
                resutSb.append(filter.getLeftBracket());
            }
            invoiceValue = ConditionMatchHelper.getInvoiceValue(itemKeyMaps, bill, filter.getProperty());
            Object compareValue = filter.getValue();
            resutSb.append(ConditionMatchHelper.compare(invoiceValue, filter.getCp(), compareValue, bill));
            if (StringUtils.isNotEmpty((CharSequence)filter.getRightBracket())) {
                resutSb.append(filter.getRightBracket());
            }
            switch (filter.getLogic()) {
                case "0": {
                    resutSb.append("&&");
                    break;
                }
                case "1": {
                    resutSb.append("||");
                }
            }
        }
        String resutlStr = resutSb.toString();
        if (resutlStr.endsWith("&&") || resutlStr.endsWith("||")) {
            resutlStr = resutlStr.substring(0, resutlStr.length() - 2);
        }
        try {
            return ConditionMatchHelper.evalScript(resutlStr);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean compare(Object invoiceValue, String cp, Object compareValue, DynamicObject bill) {
        if (CompareTypeEnum.EQUAL.getId().equals(cp) || "110".equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            if (invoiceValue instanceof List) {
                List list = (List)invoiceValue;
                return list.contains(value);
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result != 0) return false;
            return true;
        }
        if (CompareTypeEnum.NOTEQUAL.getId().equals(cp) || "114".equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) {
                if (null != value) return true;
            }
            if (null != invoiceValue && null == value) {
                return true;
            }
            if (null == invoiceValue) {
                return false;
            }
            if (invoiceValue instanceof List) {
                List list = (List)invoiceValue;
                if (list.contains(value)) return false;
                return true;
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result == 0) return false;
            return true;
        }
        if (CompareTypeEnum.IN.getId().equals(cp) || "111".equals(cp)) {
            if (null == invoiceValue) return false;
            if (compareValue == null) {
                return false;
            }
            if (compareValue.getClass().isArray()) {
                Object[] array;
                Object[] result = array = (Object[])compareValue;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = result[n2];
                    if (obj.equals(invoiceValue)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (!(compareValue instanceof List)) return invoiceValue.toString().equals(compareValue.toString());
            List list = (List)compareValue;
            if (invoiceValue instanceof List) {
                List invoicelist = (List)invoiceValue;
                Iterator iterator = list.iterator();
                block1: while (true) {
                    Object obj2;
                    if (!iterator.hasNext()) return false;
                    Object obj1 = iterator.next();
                    Iterator obj = invoicelist.iterator();
                    do {
                        if (!obj.hasNext()) continue block1;
                    } while (!obj1.equals(obj2 = obj.next()));
                    break;
                }
                return true;
            }
            if (!(list.get(0) instanceof String)) return list.contains(invoiceValue);
            invoiceValue = String.valueOf(invoiceValue);
            return list.contains(invoiceValue);
        }
        if (CompareTypeEnum.NOTIN.getId().equals(cp) || "115".equals(cp)) {
            if (null == invoiceValue) {
                if (null != compareValue) return true;
            }
            if (null != invoiceValue && null == compareValue) {
                return true;
            }
            if (null == invoiceValue) {
                return false;
            }
            if (compareValue.getClass().isArray()) {
                Object[] array;
                Object[] invoicelist = array = (Object[])compareValue;
                int n = invoicelist.length;
                int obj1 = 0;
                while (obj1 < n) {
                    Object obj = invoicelist[obj1];
                    if (obj.equals(invoiceValue)) {
                        return false;
                    }
                    ++obj1;
                }
                return true;
            }
            if (compareValue instanceof List) {
                List list = (List)compareValue;
                if (invoiceValue instanceof List) {
                    List invoicelist = (List)invoiceValue;
                    Iterator iterator = list.iterator();
                    block4: while (true) {
                        Object obj2;
                        if (!iterator.hasNext()) return false;
                        Object obj1 = iterator.next();
                        Iterator obj = invoicelist.iterator();
                        do {
                            if (!obj.hasNext()) continue block4;
                        } while (!obj1.equals(obj2 = obj.next()));
                        break;
                    }
                    return false;
                }
                if (list.get(0) instanceof String) {
                    invoiceValue = String.valueOf(invoiceValue);
                }
                if (list.contains(invoiceValue)) return false;
                return true;
            }
            if (invoiceValue.toString().equals(compareValue.toString())) return false;
            return true;
        }
        if (CompareTypeEnum.BETWEEN.getId().equals(cp)) {
            if (null == invoiceValue) return false;
            if (compareValue == null) {
                return false;
            }
            Object startValue = null;
            Object endValue = null;
            if (compareValue.getClass().isArray()) {
                Object[] array = (Object[])compareValue;
                startValue = ConditionMatchHelper.getCollectionValue(array, 0);
                endValue = ConditionMatchHelper.getCollectionValue(array, 1);
            } else if (compareValue instanceof List) {
                List list = (List)compareValue;
                startValue = ConditionMatchHelper.getCollectionValue(list, 0);
                endValue = ConditionMatchHelper.getCollectionValue(list, 1);
            }
            if (!ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.GREATEROREQUAL.getId(), startValue, bill)) return false;
            if (!ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.LESSOREQUAL.getId(), endValue, bill)) return false;
            return true;
        }
        if (CompareTypeEnum.ISNULL.getId().equals(cp)) {
            if (null == invoiceValue) return true;
            if (!"".equals(invoiceValue.toString())) return false;
            return true;
        }
        if (CompareTypeEnum.ISNOTNULL.getId().equals(cp)) {
            if (null == invoiceValue) return false;
            if ("".equals(invoiceValue.toString())) return false;
            return true;
        }
        if (CompareTypeEnum.LIKE.getId().equals(cp)) {
            return (Boolean)ConditionMatchHelper.compareLike(invoiceValue, compareValue).getLeft();
        }
        if (CompareTypeEnum.NOTLIKE.getId().equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) {
                if (null != value) return true;
            }
            if (null != invoiceValue && null == value) {
                return true;
            }
            if (null == invoiceValue) {
                return false;
            }
            if (invoiceValue.toString().contains(value.toString())) return false;
            return true;
        }
        if (CompareTypeEnum.LEFTLIKE.getId().equals(cp)) {
            Object obj1;
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            if (!(invoiceValue instanceof List)) return invoiceValue.toString().startsWith(value.toString());
            List invoicelist = (List)invoiceValue;
            Iterator list = invoicelist.iterator();
            do {
                if (!list.hasNext()) return invoiceValue.toString().startsWith(value.toString());
            } while (!String.valueOf(obj1 = list.next()).startsWith(value.toString()));
            return true;
        }
        if (CompareTypeEnum.RIGHTLIKE.getId().equals(cp)) {
            Object obj1;
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            if (!(invoiceValue instanceof List)) return invoiceValue.toString().endsWith(value.toString());
            List invoicelist = (List)invoiceValue;
            Iterator list = invoicelist.iterator();
            do {
                if (!list.hasNext()) return invoiceValue.toString().endsWith(value.toString());
            } while (!String.valueOf(obj1 = list.next()).endsWith(value.toString()));
            return true;
        }
        if (CompareTypeEnum.GREATER.getId().equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result <= 0) return false;
            return true;
        }
        if (CompareTypeEnum.LESS.getId().equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.GREATEROREQUAL.getId().equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result < 0) return false;
            return true;
        }
        if (CompareTypeEnum.LESSOREQUAL.getId().equals(cp)) {
            Object value = ConditionMatchHelper.getFirst(compareValue);
            if (null == invoiceValue) return false;
            if (null == value) {
                return false;
            }
            Integer result = ConditionMatchHelper.comare(invoiceValue, value);
            if (result == null) return false;
            if (result > 0) return false;
            return true;
        }
        if (CompareTypeEnum.TODAY.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            return DateUtils.format((Date)new Date()).equals(DateUtils.format((Date)date));
        }
        if (CompareTypeEnum.YESTERDAY.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date date2 = DateUtils.addDay((Date)new Date(), (int)-1);
            return DateUtils.format((Date)date2).equals(DateUtils.format((Date)date));
        }
        if (CompareTypeEnum.THISWEEK.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int week = calendar.get(7);
            calendar.add(5, 1 - week);
            Date start = DateUtils.trunc((Date)calendar.getTime());
            calendar.add(5, 7);
            Date end = DateUtils.trunc((Date)calendar.getTime());
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.LASTWEEK.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int week = calendar.get(7);
            calendar.add(5, -6 - week);
            Date start = DateUtils.trunc((Date)calendar.getTime());
            calendar.add(5, 7);
            Date end = DateUtils.trunc((Date)calendar.getTime());
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.THISMONTH.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.getFirstDateOfMonth((Date)new Date());
            Date end = DateUtils.getLastDateOfMonth((Date)start);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) > 0) return false;
            return true;
        }
        if (CompareTypeEnum.LASTMONTH.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date firstDate = DateUtils.getFirstDateOfMonth((Date)new Date());
            Date start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addDay((Date)firstDate, (int)-1));
            Date end = DateUtils.getLastDateOfMonth((Date)start);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) > 0) return false;
            return true;
        }
        if (CompareTypeEnum.LASTTHREEMONTH.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date end = new Date();
            Date start = DateUtils.addMonth((Date)end, (int)-3);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) > 0) return false;
            return true;
        }
        if (CompareTypeEnum.THISQUARTER.getId().equals(cp) || CompareTypeEnum.LASTQUARTER.getId().equals(cp) || CompareTypeEnum.NEXTQUARTER.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date quarter = ConditionMatchHelper.getQuarter();
            if (CompareTypeEnum.THISQUARTER.getId().equals(cp)) {
                Date end = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)quarter, (int)3));
                if (date.compareTo(quarter) < 0) return false;
                if (date.compareTo(end) >= 0) return false;
                return true;
            }
            if (CompareTypeEnum.NEXTQUARTER.getId().equals(cp)) {
                Date start = DateUtils.addMonth((Date)quarter, (int)3);
                Date end = DateUtils.addMonth((Date)start, (int)3);
                if (date.compareTo(start) < 0) return false;
                if (date.compareTo(end) >= 0) return false;
                return true;
            }
            Date start = DateUtils.addMonth((Date)quarter, (int)-3);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(quarter) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.THISYEAR.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.getFirstDateOfYear((Date)new Date());
            Date end = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)start, (int)1));
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.LASTYEAR.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date end = DateUtils.getFirstDateOfYear((Date)new Date());
            Date start = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)end, (int)-1));
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.TOMORROW.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.trunc((Date)DateUtils.addDay((Date)new Date(), (int)1));
            Date end = DateUtils.addDay((Date)start, (int)1);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.NEXTWEEK.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.trunc((Date)DateUtils.addDay((Date)new Date(), (int)1));
            Date end = DateUtils.addDay((Date)start, (int)1);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.NEXTMONTH.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)1));
            Date end = DateUtils.addMonth((Date)start, (int)1);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if ("26".equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = new Date();
            Date end = DateUtils.addMonth((Date)start, (int)3);
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.NEXTYEAR.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)1));
            Date end = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)start, (int)1));
            if (date.compareTo(start) < 0) return false;
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.TODAYBEFORE.getId().equals(cp) || CompareTypeEnum.LESSTHANOREQUALTODAY.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date end = DateUtils.trunc((Date)DateUtils.addDay((Date)new Date(), (int)1));
            if (date.compareTo(end) >= 0) return false;
            return true;
        }
        if (CompareTypeEnum.TODAYAFTER.getId().equals(cp) || CompareTypeEnum.MORETHANOREQUALTODAY.getId().equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date start = DateUtils.trunc((Date)new Date());
            if (date.compareTo(start) < 0) return false;
            return true;
        }
        if ("newYearMonth".equals(cp)) {
            if (!(invoiceValue instanceof Date)) return false;
            Date date = (Date)invoiceValue;
            Date endDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)date, (int)1));
            int mon = BigDecimalUtil.transDecimal((Object)compareValue).intValue();
            if (new Date().compareTo(endDate = DateUtils.addMonth((Date)endDate, (int)mon)) <= 0) return false;
            return true;
        }
        if (CompareTypeEnum.FIELDEQUAL.getId().equals(cp)) {
            Object field = ConditionMatchHelper.getFirst(compareValue);
            if (field == null) return false;
            Object compareValue2 = bill.get(field.toString());
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.EQUAL.getId(), compareValue2, bill);
        }
        if (CompareTypeEnum.FIELDNOTEQUAL.getId().equals(cp)) {
            Object field = ConditionMatchHelper.getFirst(compareValue);
            if (field == null) return false;
            Object compareValue2 = bill.get(field.toString());
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.NOTEQUAL.getId(), compareValue2, bill);
        }
        if (CompareTypeEnum.FIELDGREATER.getId().equals(cp)) {
            Object field = ConditionMatchHelper.getFirst(compareValue);
            if (field == null) return false;
            Object compareValue2 = bill.get(field.toString());
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.GREATER.getId(), compareValue2, bill);
        }
        if (CompareTypeEnum.FIELDGREATEROREQUAL.getId().equals(cp)) {
            Object field = ConditionMatchHelper.getFirst(compareValue);
            if (field == null) return false;
            Object compareValue2 = bill.get(field.toString());
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.GREATEROREQUAL.getId(), compareValue2, bill);
        }
        if (CompareTypeEnum.CHECKBOXEQUAL.getId().equals(cp)) {
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.EQUAL.getId(), compareValue, bill);
        }
        if (CompareTypeEnum.CHECKBOXNOTEQUAL.getId().equals(cp)) {
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.NOTEQUAL.getId(), compareValue, bill);
        }
        if (CompareTypeEnum.CHECKBOXIN.getId().equals(cp)) {
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.IN.getId(), compareValue, bill);
        }
        if (CompareTypeEnum.CHECKBOXNOTIN.getId().equals(cp)) {
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.NOTIN.getId(), compareValue, bill);
        }
        if (CompareTypeEnum.COMBOBOXISNULL.getId().equals(cp)) {
            return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.ISNULL.getId(), compareValue, bill);
        }
        if (!CompareTypeEnum.COMBOBOXISNOTNULL.getId().equals(cp)) return false;
        return ConditionMatchHelper.compare(invoiceValue, CompareTypeEnum.ISNOTNULL.getId(), compareValue, bill);
    }

    private static Object getFirst(Object compareValue) {
        return ConditionMatchHelper.getCollectionValue(compareValue, 0);
    }

    private static Object getCollectionValue(Object compareValue, int index) {
        if (null == compareValue) {
            return null;
        }
        if (compareValue.getClass().isArray()) {
            Object[] array = (Object[])compareValue;
            if (array.length > index) {
                return array[index];
            }
        } else if (compareValue instanceof List) {
            List list = (List)compareValue;
            if (list.size() > index) {
                return list.get(index);
            }
        } else {
            return compareValue;
        }
        return null;
    }

    private static Object getInvoiceValue(Map<String, String> itemKeyMaps, DynamicObject obj, String property) {
        String itemKey = itemKeyMaps.get(property);
        if (StringUtils.isBlank((CharSequence)itemKey)) {
            if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)obj, (String)property)) {
                return ConditionMatchHelper.getValue(obj.get(property));
            }
            return null;
        }
        DynamicObjectCollection items = obj.getDynamicObjectCollection(itemKey);
        if (!CollectionUtils.isEmpty((Collection)items)) {
            ArrayList<Object> list = new ArrayList<Object>(items.size());
            for (DynamicObject item : items) {
                if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)item, (String)property)) {
                    list.add(ConditionMatchHelper.getValue(item.get(property)));
                    continue;
                }
                list.add(null);
            }
            return list;
        }
        return null;
    }

    private static Object getValue(Object value) {
        if (value instanceof DynamicObject) {
            return DynamicObjectUtil.getDynamicObjectLongValue((Object)value);
        }
        return value;
    }

    private static Integer comare(Object value1, Object value2) {
        if (value1 != null && value2 != null) {
            if (ConditionMatchHelper.isNumberType(value1).booleanValue()) {
                return BigDecimalUtil.transDecimal((Object)value1).compareTo(BigDecimalUtil.transDecimal((Object)value2));
            }
            if (StringUtils.isNumeric((CharSequence)value1.toString()) && StringUtils.isNumeric((CharSequence)value2.toString())) {
                return BigDecimalUtil.transDecimal((Object)value1).compareTo(BigDecimalUtil.transDecimal((Object)value2));
            }
            if (value1 instanceof Date) {
                Date invoiceDate = (Date)value1;
                if (value2 instanceof Date) {
                    return invoiceDate.compareTo((Date)value2);
                }
                try {
                    Date date = DateUtils.stringToDate((String)value2.toString());
                    return invoiceDate.compareTo(date);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            return value1.toString().compareTo(value2.toString());
        }
        return null;
    }

    private static Boolean isNumberType(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal;
    }

    private static Pair<Boolean, String> compareLike(Object invoiceValue, Object compareValue) {
        Object value = ConditionMatchHelper.getFirst(compareValue);
        if (null == invoiceValue || null == value) {
            return Pair.of((Object)Boolean.FALSE, (Object)"");
        }
        if (compareValue.getClass().isArray()) {
            Object[] array = (Object[])compareValue;
            StringBuilder sb = new StringBuilder();
            for (Object obj : array) {
                if (!invoiceValue.toString().contains(obj.toString())) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(obj);
            }
            return Pair.of((Object)(sb.length() > 0 ? 1 : 0), (Object)sb.toString());
        }
        if (compareValue instanceof List) {
            List list = (List)compareValue;
            StringBuilder sb = new StringBuilder();
            for (Object obj : list) {
                if (!invoiceValue.toString().contains(obj.toString())) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(obj);
            }
            return Pair.of((Object)(sb.length() > 0 ? 1 : 0), (Object)sb.toString());
        }
        return Pair.of((Object)invoiceValue.toString().contains(value.toString()), (Object)value.toString());
    }

    private static Date getQuarter() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        if (month <= 2) {
            calendar.set(2, 0);
        } else if (month <= 5) {
            calendar.set(2, 3);
        } else if (month <= 8) {
            calendar.set(2, 6);
        } else {
            calendar.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth((Date)calendar.getTime());
    }
}

