/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchBillRequest;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.dto.minusbill.QueryInvoiceDTO;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.formplugin.match.AbstractMinusBillMatchHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelperOld;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MinusBillMatchHelper
extends AbstractMinusBillMatchHelper {
    private static final Log logger = LogFactory.getLog(MinusBillMatchHelper.class);

    public void match(MinusBillDTO billDTO) {
        this.setParam(billDTO);
        logger.info("\u5339\u914d\u5355\u636e:{}", (Object)billDTO.getBillNo());
        if (this.detailLog) {
            logger.info("\u5339\u914d\u5355\u636e\u8bf7\u6c42\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString((Object)this.minusBillDTO));
        }
        this.check(this.minusBillDTO);
        if (this.config.getIgnorePrice().booleanValue() || this.config.getDiscountMatchPrice().booleanValue() && RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason())) {
            this.config.setUnitPriceAffectType("none");
        }
        long start = System.currentTimeMillis();
        if (this.isOldMatch) {
            new MinusBillMatchHelperOld().match(billDTO);
            return;
        }
        this.matchBlueInvoice();
        if (this.detailLog) {
            logger.info("\u5339\u914d\u5355\u636e\u8bf7\u6c42\u5339\u914d\u4e4b\u540e:{}", (Object)SerializationUtils.toJsonString((Object)this.minusBillDTO));
        }
        logger.info("\u5339\u914d\u5355\u636e:{}\u8017\u65f6:{}", (Object)this.minusBillDTO.getBillNo(), (Object)(System.currentTimeMillis() - start));
    }

    private void matchBlueInvoice() {
        QFilter invoicefilter = this.getInvoiceQFilterList(this.minusBillDTO);
        String orderBy = this.getOrderBy();
        if (this.detailLog) {
            logger.info("\u5339\u914d\u5355\u636e:{}\u8868\u5934\u8fc7\u6ee4\u6761\u4ef6{}\u6392\u5e8f{}", new Object[]{this.minusBillDTO.getBillNo(), invoicefilter.toString(), orderBy});
        }
        ArrayList<MinusBillItemDTO> items = new ArrayList<MinusBillItemDTO>(this.minusBillDTO.getItems().size());
        for (MinusBillItemDTO item : this.minusBillDTO.getItems()) {
            if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(item.getMatchStatus())) continue;
            items.add(item);
        }
        HashSet<Long> matchItemIds = new HashSet<Long>(items.size());
        Set matchInvoiceItems = this.minusBillDTO.getMatchInvoiceItems();
        for (String matchInvoiceItem : matchInvoiceItems) {
            String[] split = matchInvoiceItem.split("\u25cf\u25c6\u25a0");
            matchItemIds.add(Long.parseLong(split[1]));
        }
        HashSet<Object> matchedMinusItemId = new HashSet<Object>(items.size());
        HashMap<Long, Pair> invoiceExistCount = new HashMap<Long, Pair>(items.size() * 50);
        HashMap<Long, Set<MinusBillItemDTO>> invoiceId2ItemMap = new HashMap<Long, Set<MinusBillItemDTO>>(items.size() * 50);
        HashMap<Object, List<String>> matchItemId2InvoiceKeyMap = new HashMap<Object, List<String>>(items.size() * 50);
        HashMap<String, QueryInvoiceDTO> idQueryInvoiceMap = new HashMap<String, QueryInvoiceDTO>(items.size() * 50);
        for (MinusBillItemDTO minusBillItemDTO : items) {
            if (matchedMinusItemId.contains(minusBillItemDTO.getMatchOrMergeItemId())) continue;
            QFilter qFilter = this.getItemQFilter(minusBillItemDTO).and(invoicefilter);
            ArrayList<String> querInvoiceIds = new ArrayList<String>(70);
            this.queryData(qFilter, matchItemIds, orderBy, 1, idQueryInvoiceMap, querInvoiceIds);
            if (CollectionUtils.isEmpty(querInvoiceIds)) {
                if (this.detailLog) {
                    logger.info("\u5339\u914d\u5355\u636e\u660e\u7ec6\u672a\u5339\u914d\u5230\u84dd\u7968\uff0c\u660e\u7ec6\u4fe1\u606f:" + SerializationUtils.toJsonString((Object)minusBillItemDTO));
                }
                matchedMinusItemId.add(minusBillItemDTO.getMatchOrMergeItemId());
                continue;
            }
            if (this.detailLog) {
                logger.info("\u5339\u914d\u5355\u636e\u660e\u7ec6\u5339\u914d\u5230\u84dd\u7968\uff0c\u660e\u7ec6\u4fe1\u606f:" + SerializationUtils.toJsonString((Object)minusBillItemDTO));
            }
            for (String querInvoiceId : querInvoiceIds) {
                List item2Invoice = matchItemId2InvoiceKeyMap.computeIfAbsent(minusBillItemDTO.getMatchOrMergeItemId(), k -> new ArrayList());
                item2Invoice.add(querInvoiceId);
                QueryInvoiceDTO queryInvoice = (QueryInvoiceDTO)idQueryInvoiceMap.get(querInvoiceId);
                Pair integerQueryInvoicePair = (Pair)invoiceExistCount.get(queryInvoice.getInvoiceid());
                Integer count = 0;
                if (integerQueryInvoicePair != null) {
                    count = (Integer)integerQueryInvoicePair.getKey();
                }
                count = count + 1;
                invoiceExistCount.put(queryInvoice.getInvoiceid(), Pair.of((Object)count, (Object)queryInvoice));
                Set minusBillItems = invoiceId2ItemMap.computeIfAbsent(queryInvoice.getInvoiceid(), k -> new LinkedHashSet());
                minusBillItems.add(minusBillItemDTO);
            }
        }
        if (this.detailLog) {
            Set entries = invoiceExistCount.entrySet();
            for (Map.Entry entry : entries) {
                Pair value = (Pair)entry.getValue();
                logger.info(String.format("\u53d1\u7968\u53f7\u7801%s\u5339\u914d\u5230\u7684\u6b21\u6570\u662f%s,\u5f00\u7968\u65f6\u95f4\u662f%s\uff0c\u91d1\u989d\u662f%s", ((QueryInvoiceDTO)value.getValue()).getInvoiceno(), value.getKey(), DateUtils.format((Date)((QueryInvoiceDTO)value.getValue()).getIssueTime(), (String)"yyyy-MM-dd HH:mm:ss"), ((QueryInvoiceDTO)value.getValue()).getInvoiceAmount().setScale(2, 4)));
            }
        }
        Comparator comparator = (v1, v2) -> {
            if (((Integer)((Pair)v2.getValue()).getKey()).compareTo((Integer)((Pair)v1.getValue()).getKey()) == 0) {
                switch (this.config.getBlueOrder()) {
                    case "timefar": {
                        return ((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getIssueTime().compareTo(((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getIssueTime());
                    }
                    case "timenear": {
                        return ((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getIssueTime().compareTo(((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getIssueTime());
                    }
                    case "amountsmall": {
                        return ((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getInvoiceAmount().compareTo(((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getInvoiceAmount());
                    }
                    case "amountbig": {
                        return ((QueryInvoiceDTO)((Pair)v2.getValue()).getValue()).getInvoiceAmount().compareTo(((QueryInvoiceDTO)((Pair)v1.getValue()).getValue()).getInvoiceAmount());
                    }
                }
                return 1;
            }
            return ((Integer)((Pair)v2.getValue()).getKey()).compareTo((Integer)((Pair)v1.getValue()).getKey());
        };
        while (matchedMinusItemId.size() < items.size() && invoiceExistCount.size() != 0) {
            ArrayList arrayList = new ArrayList(invoiceExistCount.entrySet());
            arrayList.sort(comparator);
            Map.Entry entry = (Map.Entry)arrayList.get(0);
            if (this.detailLog) {
                logger.info("\u5f53\u524d\u6700\u591a\u6b21\u5339\u914d\u5230\u7684\u53d1\u7968\u662f " + ((QueryInvoiceDTO)((Pair)entry.getValue()).getValue()).getInvoiceno());
            }
            this.beginMatch((Long)entry.getKey(), invoiceId2ItemMap, matchItemId2InvoiceKeyMap, idQueryInvoiceMap, matchedMinusItemId);
            invoiceExistCount.remove(entry.getKey());
        }
    }

    private void beginMatch(Long invoiceId, Map<Long, Set<MinusBillItemDTO>> invoiceId2ItemMap, Map<Object, List<String>> matchItemId2InvoiceKeyMap, Map<String, QueryInvoiceDTO> idQueryInvoiceMap, Set<Object> matchedMinusItemId) {
        Set<MinusBillItemDTO> minusBillItems = invoiceId2ItemMap.get(invoiceId);
        block0: for (MinusBillItemDTO item : minusBillItems) {
            List queryInvoiceList;
            List<String> matchItemId2InvoiceKeyList;
            if (matchedMinusItemId.contains(item.getMatchOrMergeItemId()) || CollectionUtils.isEmpty(matchItemId2InvoiceKeyList = matchItemId2InvoiceKeyMap.get(item.getMatchOrMergeItemId())) || CollectionUtils.isEmpty(queryInvoiceList = matchItemId2InvoiceKeyList.stream().map(idQueryInvoiceMap::get).filter(invoiceDto -> invoiceDto != null && invoiceId.equals(invoiceDto.getInvoiceid())).collect(Collectors.toList()))) continue;
            for (QueryInvoiceDTO invoiceDto2 : queryInvoiceList) {
                BigDecimal matchAmountOrNum;
                if (this.minusBillDTO.getMatchInvoiceItems().contains(invoiceDto2.getInvoiceid() + "\u25cf\u25c6\u25a0" + invoiceDto2.getItemid()) || BigDecimal.ZERO.compareTo(invoiceDto2.getRemainMatchAmountOrNum()) >= 0) continue;
                BigDecimal unMatchAmountOrNum = this.config.getAmountStandard() == false ? item.getNum().abs().subtract(item.getMatchAmountOrNum()) : item.getAmount().abs().subtract(item.getMatchAmountOrNum());
                BigDecimal remainAmountOrNum = invoiceDto2.getRemainMatchAmountOrNum();
                if (remainAmountOrNum.compareTo(unMatchAmountOrNum) >= 0) {
                    remainAmountOrNum = remainAmountOrNum.subtract(unMatchAmountOrNum);
                    matchAmountOrNum = unMatchAmountOrNum;
                } else {
                    matchAmountOrNum = remainAmountOrNum;
                    remainAmountOrNum = BigDecimal.ZERO;
                }
                invoiceDto2.setRemainMatchAmountOrNum(remainAmountOrNum);
                MatchInvoiceDTO matchdto = this.createMatchInvoiceDTO(invoiceDto2, matchAmountOrNum);
                if (matchdto == null) continue;
                item.setMatchAmountOrNum(item.getMatchAmountOrNum().add(matchAmountOrNum));
                item.getInvoiceList().add(matchdto);
                this.minusBillDTO.getMatchInvoiceItems().add(matchdto.getInvoiceid() + "\u25cf\u25c6\u25a0" + matchdto.getItemid());
                BigDecimal compareAmountOrNum = item.getAmount();
                if (!this.config.getAmountStandard().booleanValue()) {
                    compareAmountOrNum = item.getNum();
                }
                if (compareAmountOrNum.abs().compareTo(item.getMatchAmountOrNum()) == 0) {
                    item.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                    matchedMinusItemId.add(item.getMatchOrMergeItemId());
                    continue block0;
                }
                if (this.config.getMatchMultiRow().booleanValue() || item.getInvoiceList().size() != 1) continue;
                matchedMinusItemId.add(item.getMatchOrMergeItemId());
                continue block0;
            }
        }
    }

    private QFilter getItemQFilter(MinusBillItemDTO item) {
        QFilter qFilter = new QFilter("items.taxrate", "=", (Object)item.getTaxRate());
        boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
        if (!this.config.getMatchMultiRow().booleanValue() && !MathUtils.isNullOrZero((BigDecimal)item.getAmount())) {
            if (salesDiscount) {
                qFilter.and("items.remaindiscountamount", ">=", (Object)item.getAmount().abs());
            } else {
                qFilter.and("items.itemremainredamount", ">=", (Object)item.getAmount().abs());
            }
        } else if (salesDiscount) {
            qFilter.and("items.remaindiscountamount", ">", (Object)BigDecimal.ZERO);
        } else {
            qFilter.and("items.itemremainredamount", ">", (Object)BigDecimal.ZERO);
        }
        if (!this.config.getAmountStandard().booleanValue()) {
            qFilter.and("items.itemremainrednum", ">=", (Object)item.getNum().abs());
        }
        if (!"none".equals(this.config.getUnitPriceAffectType())) {
            if (MathUtils.isNullOrZero((BigDecimal)item.getUnitprice())) {
                qFilter.and("items.unitprice", "=", (Object)BigDecimal.ZERO);
            } else {
                Pair<BigDecimal, BigDecimal> priceAffect = this.getUnitPriceAffect(item.getUnitprice());
                if (priceAffect != null) {
                    qFilter.and("items.unitprice", ">=", priceAffect.getLeft()).and("items.unitprice", "<=", priceAffect.getRight());
                }
            }
        }
        EntryProp itemsProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice").getProperty("items");
        DynamicObjectType itemsObjectType = itemsProp.getDynamicCollectionItemPropertyType();
        JSONObject itemExtJson = item.getItemExtJson();
        Set entries = itemExtJson.entrySet();
        for (Map.Entry entry : entries) {
            if ("unitprice".equals(entry.getKey()) || "taxunitprice".equals(entry.getKey()) || !this.config.getItemField().contains((CharSequence)entry.getKey()) || itemsObjectType.getProperty((String)entry.getKey()) == null) continue;
            qFilter.and("items." + (String)entry.getKey(), "=", entry.getValue());
        }
        return qFilter;
    }

    private void queryData(QFilter filter, Set<Long> matchItemIds, String order, int page, Map<String, QueryInvoiceDTO> idQueryInvoiceMap, List<String> querInvoices) {
        if (page == 6) {
            return;
        }
        ORM orm = ORM.create();
        try (DataSet ds = this.queryInvoice(orm, page, order, filter);){
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_vatinvoice");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return;
            }
            boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
            for (DynamicObject obj : collection) {
                if (!MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainredamount")) && !MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("unitprice")) && MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainrednum")) || matchItemIds.contains(obj.getLong("itemid"))) continue;
                String invoiceKey = obj.getLong("id") + "\u25cf\u25c6\u25a0" + obj.getLong("itemid");
                if (!idQueryInvoiceMap.containsKey(invoiceKey)) {
                    QueryInvoiceDTO invoiceDto = this.createQueryInvoiceDTO(obj, salesDiscount);
                    idQueryInvoiceMap.put(invoiceKey, invoiceDto);
                }
                querInvoices.add(invoiceKey);
                if (querInvoices.size() != 50) continue;
                return;
            }
            if (collection.size() == this.pageSize) {
                this.queryData(filter, matchItemIds, order, ++page, idQueryInvoiceMap, querInvoices);
            }
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u62a5\u9519", (Throwable)e);
        }
    }

    private QFilter getInvoiceQFilterList(MinusBillDTO minusBillDTO) {
        Pair<Date, Date> invoiceDates = this.getInvoceDate(new Date());
        QFilter qFilter = new QFilter("salertaxno", "=", (Object)minusBillDTO.getSalerTaxNo());
        if (StringUtils.isNotBlank((CharSequence)minusBillDTO.getBuyerTaxNo())) {
            qFilter.and("buyertaxno", "=", (Object)minusBillDTO.getBuyerTaxNo());
        } else {
            qFilter.and("buyername", "=", (Object)minusBillDTO.getBuyerName());
        }
        qFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        if (StringUtils.isNotBlank((CharSequence)this.config.getHeadField()) && this.config.getHeadField().contains("invoicetype")) {
            qFilter.and("invoicetype", "in", (Object)this.getBlueInvoiceType(minusBillDTO, this.config));
        } else {
            qFilter.and("invoicetype", "in", (Object)new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.ALL_E_SPECIAL.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()});
        }
        qFilter.and("issuetime", ">=", invoiceDates.getLeft()).and("issuetime", "<", invoiceDates.getRight()).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("remainredamount", ">", (Object)BigDecimal.ZERO).and("occupystatus", "!=", (Object)"1").and("specialtype", "in", (Object)new String[]{"00", ""});
        if (CollectionUtils.isNotEmpty((Collection)minusBillDTO.getMatchInvoiceIds())) {
            qFilter.and("id", "not in", (Object)minusBillDTO.getMatchInvoiceIds());
        }
        JSONObject headExtJson = minusBillDTO.getHeadExtJson();
        headExtJson.remove((Object)"invoicetype");
        if (headExtJson.isEmpty()) {
            return qFilter;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        Set entries = headExtJson.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!this.config.getHeadField().contains(key) || dataEntityType.getProperty(key) == null) continue;
            qFilter.and(key, "=", entry.getValue());
        }
        return qFilter;
    }

    public static DynamicObject createMatchBillByOriginalBill(DynamicObject originalBill, String matchBatch) {
        DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
        DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)originalBill, (DynamicObject)matchBill);
        matchBill.set("matchbatch", (Object)matchBatch);
        matchBill.set("billno", (Object)MinusBillMatchHelper.getMergeBillNoFirst(matchBill.getString("billno")));
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            DynamicObject matchItem = matchItems.addNew();
            DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)item, (DynamicObject)matchItem);
            SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)item);
            matchItem.set("goodsname", (Object)item.getString("goodsname"));
            matchItem.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        }
        matchBill.set("applyamount", (Object)originalBill.getBigDecimal("invoiceamount"));
        matchBill.set("applytax", (Object)originalBill.getBigDecimal("totaltax"));
        matchBill.set("applytotalamount", (Object)originalBill.getBigDecimal("totalamount"));
        matchBill.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
        matchBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        matchBill.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")));
        matchBill.set("matchrule", null);
        matchBill.set("remark", (Object)originalBill.getString("invoiceremark"));
        matchBill.set("pushdownstatus", (Object)"0");
        matchBill.set("matchtime", (Object)new Date());
        matchBill.set("matchstatus", (Object)"");
        matchBill.set("matchtarget", (Object)"");
        return matchBill;
    }

    public static String getMergeBillNoFirst(String billNo) {
        try {
            String[] billNos = billNo.split(",");
            return billNos[0];
        }
        catch (Exception e) {
            return billNo;
        }
    }

    public MinusBillDTO createMinusBillByMatchBill(MinusBillMatchConfig matchConfig, DynamicObject matchBill) {
        MinusBillDTO minusBill = new MinusBillDTO();
        minusBill.setBillNo(matchBill.getString("billno"));
        minusBill.setBuyerTaxNo(matchBill.getString("buyertaxno"));
        minusBill.setBuyerName(matchBill.getString("buyername"));
        minusBill.setInvoiceType(matchBill.getString("invoicetype"));
        minusBill.setSalerTaxNo(matchBill.getString("salertaxno"));
        minusBill.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org"))));
        minusBill.setMergebillId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.getPkValue())));
        minusBill.setHeadExtJson(MinusBillMatchHelper.getExtJson(matchConfig.getHeadField(), matchBill));
        Set matchInvoiceItems = minusBill.getMatchInvoiceItems();
        ArrayList<MinusBillItemDTO> items = new ArrayList<MinusBillItemDTO>();
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject matchItem : matchItems) {
            String itemMatchstatus = matchItem.getString("itemmatchstatus");
            DynamicObjectCollection oriInvoiceItems = matchItem.getDynamicObjectCollection("subentryentity");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal num = BigDecimal.ZERO;
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                amount = amount.add(oriInvoiceItem.getBigDecimal("oriitemamount"));
                num = num.add(oriInvoiceItem.getBigDecimal("oriitemnum"));
                matchInvoiceItems.add(oriInvoiceItem.get("oriinvoiceid") + "\u25cf\u25c6\u25a0" + oriInvoiceItem.get("oriitemid"));
            }
            if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(itemMatchstatus)) continue;
            MinusBillItemDTO item = new MinusBillItemDTO();
            item.setMatchOrMergeItemId((Object)matchItem.getLong("id"));
            item.setTaxRate(matchItem.getString("taxrate"));
            item.setRowtype("2");
            item.setGoodsname(matchItem.getString("goodsname"));
            item.setGoodscode(matchItem.getString("goodscode"));
            item.setSpbm(matchItem.getString("spbm"));
            item.setUnitprice(matchItem.getBigDecimal("unitprice"));
            item.setAmount(matchItem.getBigDecimal("amount").add(amount));
            item.setNum(matchItem.getBigDecimal("num").add(num));
            item.setItemExtJson(MinusBillMatchHelper.getExtJson(matchConfig.getItemField(), matchItem));
            items.add(item);
        }
        minusBill.setMatchInvoiceItems(matchInvoiceItems);
        minusBill.setItems(items);
        return minusBill;
    }

    public static JSONObject getExtJson(String headField, DynamicObject mergeBill) {
        JSONObject json = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)headField)) {
                String[] keys;
                for (String key : keys = headField.split(",")) {
                    if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)mergeBill, (String)key)) continue;
                    Object val = mergeBill.get(key);
                    if (val instanceof DynamicObject) {
                        json.put(key, ((DynamicObject)val).getPkValue());
                        continue;
                    }
                    json.put(key, mergeBill.get(key));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public void updateMatchBill(MinusBillDTO minusBill, DynamicObject matchBill, Set<Long> oriInvoiceIdSet) {
        matchBill.set("matchtype", (Object)"1");
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        Map<Object, DynamicObject> matchItemMap = matchItems.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v, (v1, v2) -> v1));
        HashSet<Long> invoiceSet = new HashSet<Long>(10);
        List minusBillItems = minusBill.getItems();
        Set matchItemIdSet = minusBillItems.stream().map(MinusBillItemDTO::getMatchOrMergeItemId).collect(Collectors.toSet());
        Set<String> matchFlagSet = matchItems.stream().filter(matchItem -> !matchItemIdSet.contains(matchItem.get("id"))).map(matchItem -> matchItem.getString("itemmatchstatus")).collect(Collectors.toSet());
        for (MinusBillItemDTO minusBillItem : minusBillItems) {
            DynamicObject matchItem2 = matchItemMap.get(minusBillItem.getMatchOrMergeItemId());
            DynamicObjectCollection oriInvoices = matchItem2.getDynamicObjectCollection("subentryentity");
            if (!MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(minusBillItem.getMatchStatus())) {
                if (minusBillItem.getInvoiceList().size() > 0 || oriInvoices.size() > 0) {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
                } else {
                    minusBillItem.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                }
            }
            matchItem2.set("itemmatchstatus", (Object)minusBillItem.getMatchStatus());
            matchFlagSet.add(minusBillItem.getMatchStatus());
            List invoiceList = minusBillItem.getInvoiceList();
            for (MatchInvoiceDTO matchInvoice : invoiceList) {
                this.createOriInvoice(oriInvoices, matchInvoice, minusBillItem);
                oriInvoiceIdSet.add(matchInvoice.getInvoiceid());
                if (matchInvoice.getInvoiceid() != null && matchInvoice.getInvoiceid() != 0L) {
                    invoiceSet.add(matchInvoice.getInvoiceid());
                }
                matchBill.set("matchamount", (Object)matchBill.getBigDecimal("matchamount").add(matchInvoice.getItemAmount().negate()));
                matchBill.set("matchtax", (Object)matchBill.getBigDecimal("matchtax").add(matchInvoice.getItemTax().negate()));
            }
        }
        matchBill.set("matchtotalamount", (Object)matchBill.getBigDecimal("matchamount").add(matchBill.getBigDecimal("matchtax")));
        matchBill.set("matchinvoicenum", (Object)(matchBill.getInt("matchinvoicenum") + invoiceSet.size()));
        if (matchFlagSet.size() == 1) {
            matchBill.set("matchstatus", (Object)matchFlagSet.toArray(new String[0])[0]);
        } else {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
        matchBill.set("matchrule", (Object)minusBill.getConfig().getId());
        matchBill.set("redreason", (Object)minusBill.getRedreason());
        matchBill.set("matchtime", (Object)new Date());
        NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
    }

    public DynamicObject createOriInvoice(DynamicObjectCollection oriInvoices, MatchInvoiceDTO matchInvoice, MinusBillItemDTO minusBillItem) {
        DynamicObject oriInvoice = oriInvoices.addNew();
        oriInvoice.set("oriinvoiceid", (Object)matchInvoice.getInvoiceid());
        oriInvoice.set("oriinvoicecode", (Object)matchInvoice.getInvoicecode());
        oriInvoice.set("oriinvoiceno", (Object)matchInvoice.getInvoiceno());
        oriInvoice.set("oriitemid", (Object)matchInvoice.getItemid());
        oriInvoice.set("oriitemseq", (Object)matchInvoice.getItemseq());
        oriInvoice.set("oriitemamount", (Object)matchInvoice.getItemAmount());
        oriInvoice.set("oriitemtax", (Object)matchInvoice.getItemTax());
        oriInvoice.set("oritaxrate", (Object)minusBillItem.getTaxRate());
        oriInvoice.set("oriitemnum", (Object)matchInvoice.getItemNum());
        oriInvoice.set("oriitemunitprice", (Object)matchInvoice.getItemUnitprice());
        oriInvoice.set("oriitemtaxunitprice", (Object)matchInvoice.getItemTaxUnitprice());
        oriInvoice.set("oriitemgoodsname", (Object)matchInvoice.getGoodsName());
        oriInvoice.set("oriitemspecification", (Object)matchInvoice.getSpecification());
        oriInvoice.set("oriitemunit", (Object)matchInvoice.getUnit());
        oriInvoice.set("pushstatus", (Object)"-1");
        return oriInvoice;
    }

    public void updateInvoiceOccupyStatus(Collection<Long> oriInvoiceIdSet, String occupyStatus, String billFormId) {
        DynamicObject[] invoiceOrRedConfirms;
        if (oriInvoiceIdSet.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", oriInvoiceIdSet);
        for (DynamicObject obj : invoiceOrRedConfirms = BusinessDataServiceHelper.load((String)billFormId, (String)"occupystatus", (QFilter[])qFilter.toArray())) {
            obj.set("occupystatus", (Object)occupyStatus);
        }
        ImcSaveServiceHelper.save((DynamicObject[])invoiceOrRedConfirms);
    }

    public void saveCreateMatchBills(List<DynamicObject> createMatchBills, MatchBillRequest matchBillRequest, Map<Long, String> matchBillStatus) {
        HashMap<Long, String> billidNoMap = new HashMap<Long, String>(createMatchBills.size());
        for (DynamicObject matchBill : createMatchBills) {
            billidNoMap.put(matchBill.getLong("id"), matchBill.getString("billno"));
        }
        List relations = matchBillRequest.getRelations();
        HashMap<Long, Long> bill2MatchBill = new HashMap<Long, Long>(relations.size());
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>(relations.size());
        for (BillRelationDTO relation : relations) {
            relation.settBillNo((String)billidNoMap.get(relation.gettBillId()));
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_matchbill_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationList.add(relationObj);
            bill2MatchBill.put(relation.getsBillId(), relation.gettBillId());
        }
        ImcSaveServiceHelper.save(relationList);
        matchBillRequest.getNoMatchOriginalBills().forEach(bill -> {
            bill.set("matchstatus", matchBillStatus.get(bill2MatchBill.get(bill.getLong("id"))));
            bill.set("confirmstate", (Object)"2");
            bill.set("confirmamount", bill.get("1".equals(bill.getString("hsbz")) ? "totalamount" : "invoiceamount"));
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                item.set("remainvalidamount", (Object)BigDecimal.ZERO);
                item.set("remainvalidtax", (Object)BigDecimal.ZERO);
                item.set("remainvalidnum", (Object)BigDecimal.ZERO);
            }
        });
        ImcSaveServiceHelper.save(createMatchBills);
    }
}

