/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redinfo.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.redinfo.service.AbstractInitRedInfoService;

public class AddInitRedInfoService
extends AbstractInitRedInfoService {
    @Override
    protected DynamicObjectCollection buildRedInfoItems(DynamicObject obj, AbstractFormPlugin plugin) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("items");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return null;
        }
        return RedInfoHelper.convertItemsBlueToRed((DynamicObject)obj);
    }

    @Override
    protected DynamicObject initRedInfo(AbstractFormPlugin plugin, SaleInfo saleInfo) {
        Map customParams = plugin.getView().getFormShowParameter().getCustomParams();
        String applicant = (String)customParams.get("applicant");
        plugin.getView().getModel().setValue("infodate", (Object)new Date());
        plugin.getView().getModel().setValue("applicant", (Object)applicant);
        plugin.getView().getModel().setValue("originalinvoicecode", customParams.get("originalinvoicecode"));
        plugin.getView().getModel().setValue("originalinvoiceno", customParams.get("originalinvoiceno"));
        plugin.getView().getModel().setValue("originalissuetime", customParams.get("originalissuetime"));
        plugin.getView().getModel().setValue("billno", customParams.get("billno"));
        plugin.getView().getModel().setValue("systemsource", customParams.get("systemsource"));
        plugin.getView().getModel().setValue("infotype", customParams.get("infotype"));
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            this.isSaler = true;
        }
        try {
            Object id = customParams.get("id");
            if (null == id) {
                this.fillInBuyerRedInfo(saleInfo, plugin);
                return BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            }
            if (!RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
                DynamicObject rimInvoice = BusinessDataServiceHelper.loadSingle((String)"rim_inv_special", (String)"", (QFilter[])new QFilter("id", "=", id).toArray());
                if (rimInvoice == null) {
                    this.fillInBuyerRedInfo(saleInfo, plugin);
                    return BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                }
                rimInvoice = BusinessDataServiceHelper.loadSingle(id, (String)"rim_inv_special");
                DynamicObject invoiceByRim = this.createInvoiceByRim(rimInvoice);
                invoiceByRim.set("buyername", (Object)saleInfo.getSaleName());
                invoiceByRim.set("buyertaxno", (Object)saleInfo.getSaleTaxNo());
                RedInfoHelper.fillInOriginalInvoice((AbstractFormPlugin)plugin, (DynamicObject)invoiceByRim);
                this.isFind = true;
                return invoiceByRim;
            }
        }
        catch (Exception e) {
            plugin.getView().showErrorNotification(e.getMessage());
            return BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        }
        this.isFind = true;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(customParams.get("id"), (String)"sim_vatinvoice");
        if (TaxedTypeEnum.deduction.getValue().equals(dynamicObject.getString("taxedtype"))) {
            this.isDeduction = true;
        }
        dynamicObject.set("salername", (Object)saleInfo.getSaleName());
        dynamicObject.set("salertaxno", (Object)saleInfo.getSaleTaxNo());
        RedInfoHelper.fillInOriginalInvoice((AbstractFormPlugin)plugin, (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private DynamicObject createInvoiceByRim(DynamicObject rimInvoice) {
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        invoice.set("issuetime", rimInvoice.get("invoice_date"));
        DynamicObject invoiceType = rimInvoice.getDynamicObject("invoice_type");
        if (invoiceType != null) {
            invoice.set("invoicetype", (Object)InvoiceType.getInvoiceTypeCodeByBaseCode((String)invoiceType.getString("number")));
        }
        invoice.set("salertaxno", rimInvoice.get("saler_tax_no"));
        invoice.set("salername", rimInvoice.get("saler_name"));
        invoice.set("salerbank", rimInvoice.get("saler_account"));
        invoice.set("saleraddr", rimInvoice.get("saler_address_phone"));
        invoice.set("buyertaxno", rimInvoice.get("buyer_tax_no"));
        invoice.set("buyername", rimInvoice.get("buyer_name"));
        invoice.set("buyerbank", rimInvoice.get("buyer_account"));
        invoice.set("buyeraddr", rimInvoice.get("buyer_address_phone"));
        invoice.set("hsbz", (Object)"0");
        invoice.set("remark", rimInvoice.get("remark"));
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        DynamicObjectCollection rimItems = rimInvoice.getDynamicObjectCollection("items");
        String specialType = "00";
        for (int i = 0; i < rimItems.size(); ++i) {
            DynamicObject rimItem = (DynamicObject)rimItems.get(i);
            DynamicObject item = invoiceItems.addNew();
            item.set("goodsname", rimItem.get("goods_name"));
            item.set("goodscode", rimItem.get("goods_code"));
            item.set("specification", rimItem.get("spec_model"));
            item.set("unitprice", rimItem.get("unit_price"));
            BigDecimal num = rimItem.getBigDecimal("num");
            item.set("num", (Object)num);
            item.set("taxrate", (Object)rimItem.getBigDecimal("tax_rate").stripTrailingZeros().toString());
            item.set("unit", rimItem.get("unit"));
            item.set("amount", rimItem.get("detail_amount"));
            item.set("tax", rimItem.get("tax_amount"));
            item.set("taxamount", (Object)item.getBigDecimal("amount").add(item.getBigDecimal("tax")));
            if (!MathUtils.isNullOrZero((BigDecimal)num)) {
                item.set("taxunitprice", (Object)item.getBigDecimal("taxamount").divide(num, 8, 4));
            }
            if (item.getString("goodscode").startsWith("1030402")) {
                specialType = "11";
            }
            if (item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0) {
                item.set("rowtype", (Object)"0");
                continue;
            }
            item.set("rowtype", (Object)"1");
            ((DynamicObject)invoiceItems.get(i - 1)).set("rowtype", (Object)"2");
        }
        if (invoiceItems.size() > 8) {
            invoice.set("inventorymark", (Object)"1");
        } else {
            invoice.set("inventorymark", (Object)"0");
        }
        invoice.set("specialtype", (Object)specialType);
        return invoice;
    }

    private void fillInBuyerRedInfo(SaleInfo saleInfo, AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        DynamicObject dynamicObject = TaxUtils.getSaleAddrBankByOrg((SaleInfo)saleInfo);
        if (this.isSaler) {
            view.getModel().setValue("salername", (Object)saleInfo.getSaleName());
            view.getModel().setValue("salertaxno", (Object)saleInfo.getSaleTaxNo());
            if (dynamicObject != null) {
                view.getModel().setValue("saleraddr", (Object)dynamicObject.getString("invoiceaddr"));
                view.getModel().setValue("salerbank", (Object)dynamicObject.getString("openuserbank"));
            }
        } else {
            view.getModel().setValue("buyername", (Object)saleInfo.getSaleName());
            view.getModel().setValue("buyertaxno", (Object)saleInfo.getSaleTaxNo());
            if (dynamicObject != null) {
                view.getModel().setValue("buyeraddr", (Object)dynamicObject.getString("invoiceaddr"));
                view.getModel().setValue("buyerbank", (Object)dynamicObject.getString("openuserbank"));
            }
        }
    }
}

