/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.imsc.dmw.engine.eas.MigrateActionProcessor;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.MigrateCheckItemAction;
import kd.imsc.dmw.engine.eas.action.impl.MigrateExecAction;
import kd.imsc.dmw.engine.eas.action.impl.MigrateRepairAction;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemRequestParam;
import kd.imsc.dmw.engine.eas.core.param.MigrateRequestParam;
import kd.imsc.dmw.engine.eas.core.param.RepairRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.engine.eas.core.progress.MigrateProgress;

public class MigrateActionFactory {
    public static MigrateActionProcessor getCheckItemProcessor(long projectId, List<Long> checkItemIds, String batch, Long dbLink, String taskId) {
        MigrateProgress progressController = new MigrateProgress(taskId, 20);
        CheckItemRequestParam param = new CheckItemRequestParam(checkItemIds, dbLink);
        MigrateContext migrateContext = new MigrateContext();
        migrateContext.setBatch(batch);
        migrateContext.setDbLinkId(dbLink);
        migrateContext.setProjectId(projectId);
        migrateContext.setTaskId(taskId);
        migrateContext.setProgressController(progressController);
        ArrayList<AbstractMigrateAction> actions = new ArrayList<AbstractMigrateAction>(4);
        actions.add(new MigrateCheckItemAction(migrateContext, param, new ActionProgress(80, progressController, checkItemIds.size())));
        return MigrateActionProcessor.build(actions, migrateContext);
    }

    public static MigrateActionProcessor getRePairProcessor(Map<String, Object> params) {
        Long dbLink = (Long)params.get("dbLinkId");
        List repairIds = (List)params.get("repairIds");
        MigrateProgress progressController = new MigrateProgress((String)params.get("taskId"), 20);
        CheckItemLog checkItemLog = (CheckItemLog)JSONObject.parseObject((String)((String)params.get("checkItemLog")), CheckItemLog.class);
        RepairRequestParam repairParam = new RepairRequestParam(repairIds, dbLink, (String)params.get("checkresult"), (String)params.get("checkdetail"), checkItemLog);
        MigrateContext migrateContext = new MigrateContext();
        String batch = UUID.randomUUID().toString().replace("-", "");
        migrateContext.setBatch(batch);
        migrateContext.setDbLinkId(dbLink);
        String projectId = String.valueOf(params.get("projectId"));
        migrateContext.setProjectId(Long.parseLong(projectId));
        migrateContext.setTaskId((String)params.get("taskId"));
        migrateContext.setProgressController(progressController);
        ArrayList<AbstractMigrateAction> actions = new ArrayList<AbstractMigrateAction>(4);
        actions.add(new MigrateRepairAction(migrateContext, repairParam, new ActionProgress(80, progressController, repairIds.size())));
        return MigrateActionProcessor.build(actions, migrateContext);
    }

    public static MigrateActionProcessor getMigrateProcessor(Map<String, Object> map, String taskId) {
        long dbLinkId = (Long)map.get("dblinkid");
        List migrateEntryIds = (List)map.get("migrateEntryIds");
        Map migOldStatus = (Map)map.get("migOldStatus");
        MigrateProgress migrateProgress = new MigrateProgress(taskId, 20);
        MigrateContext context = new MigrateContext();
        context.setProjectId((Long)map.get("projectid"));
        context.setProgressController(migrateProgress);
        context.setDbLinkId(dbLinkId);
        context.setTaskId(taskId);
        MigrateRequestParam param = new MigrateRequestParam(migrateEntryIds, dbLinkId, migOldStatus);
        ArrayList<AbstractMigrateAction> actions = new ArrayList<AbstractMigrateAction>(16);
        actions.add(new MigrateExecAction(context, param, new ActionProgress(80, migrateProgress, migrateEntryIds.size())));
        return MigrateActionProcessor.build(actions, context);
    }
}

