/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.migrate.IscSchemeGroupDeal;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.param.MigrateRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.utils.OperationUtils;

public class MigrateExecAction
extends AbstractMigrateAction {
    private static final Log log = LogFactory.getLog(MigrateExecAction.class);
    private final MigrateRequestParam param;

    public MigrateExecAction(MigrateContext executeContext, MigrateRequestParam param, ActionProgress progress) {
        this.setExecuteContext(executeContext);
        this.setProgress(progress);
        this.param = param;
    }

    @Override
    public void doExec() {
        try {
            Map<Long, Map<Long, List<MigrateIscSchemeConfig>>> migrateIscSchemeConfs = this.getMigrateIscSchemeConf();
            this.getProgress().updateComplete(10);
            boolean isHasFail = false;
            ArrayList<Map<Long, List<MigrateIscSchemeConfig>>> cofigList = new ArrayList<Map<Long, List<MigrateIscSchemeConfig>>>(migrateIscSchemeConfs.values());
            for (Map map : cofigList) {
                if (this.getExecuteContext().isTerminate()) break;
                try {
                    IscSchemeGroupDeal schemeGroup = new IscSchemeGroupDeal(this.getExecuteContext(), map, this.getProgress());
                    List<String> groupResults = schemeGroup.deal();
                    isHasFail = groupResults.stream().anyMatch(MigrateExecAction::hasFail);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u96c6\u6210\u65b9\u6848\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    isHasFail = true;
                }
                if (!isHasFail) {
                    this.getProgress().addComplete(map.size());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u8fc1\u79fb\u5931\u8d25,", (Throwable)e);
            this.rollbackStatus();
            throw e;
        }
        this.updateProjectStatus();
        this.getProgress().complete();
    }

    private void rollbackStatus() {
        HashSet<Long> migrateEntryIds = this.param.getMigrateEntryIdSet();
        Map<Long, Object> migOldStatus = this.param.getMigOldStatus();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getExecuteContext().getProjectId(), (String)"dmw_project_eas");
        DynamicObjectCollection execEntrys = project.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : execEntrys) {
            String entryStatus = entry.getString("migratestatus");
            if (!migrateEntryIds.contains((Long)entry.getPkValue()) || !"F".equals(entryStatus) && !"A".equals(entryStatus)) continue;
            Object oldStatus = migOldStatus.get((Long)entry.getPkValue());
            entry.set("migratestatus", oldStatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
    }

    private void updateProjectStatus() {
        this.rollbackStatus();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getExecuteContext().getProjectId(), (String)"dmw_project_eas");
        DynamicObjectCollection execObjects = project.getDynamicObjectCollection("treeentryentity");
        boolean matchResult = execObjects.stream().anyMatch(n -> !"C".equals(n.getString("migratestatus")) && !"G".equals(n.getString("migratestatus")));
        if (matchResult) {
            project.set("projectstatus", (Object)"G");
        }
        ArrayList<String> successList = new ArrayList<String>(16);
        ArrayList<String> noStartList = new ArrayList<String>(16);
        for (DynamicObject dyna : execObjects) {
            String migStatus = dyna.getString("migratestatus");
            if ("C".equals(migStatus) || "G".equals(migStatus)) {
                successList.add(migStatus);
                continue;
            }
            if (!"A".equals(migStatus)) continue;
            noStartList.add(migStatus);
        }
        if (successList.size() == execObjects.size()) {
            project.set("projectstatus", (Object)"G");
        } else if (!successList.isEmpty() && successList.size() + noStartList.size() == execObjects.size()) {
            project.set("projectstatus", (Object)"H");
        } else {
            project.set("projectstatus", (Object)"F");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
    }

    private static boolean hasFail(String status) {
        return "D".equals(status) || "E".equals(status);
    }

    private Map<Long, Map<Long, List<MigrateIscSchemeConfig>>> getMigrateIscSchemeConf() {
        List<DynamicObject> migrateEntryList = this.loadNeededSchemeEntrys();
        ArrayList<Long> triggerIds = new ArrayList<Long>(16);
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        HashSet<Object> dbLinks = new HashSet<Object>(16);
        for (DynamicObject dyo : migrateEntryList) {
            String schemeType = dyo.getString("integrattype");
            DynamicObject startScheme = dyo.getDynamicObject("startscheme");
            if ("isc_data_copy_trigger".equals(schemeType)) {
                triggerIds.add((Long)startScheme.getPkValue());
                continue;
            }
            if (!"isc_service_flow".equals(schemeType)) continue;
            flowIds.add((Long)startScheme.getPkValue());
        }
        Map triggers = BusinessDataServiceHelper.loadFromCache((String)"isc_data_copy_trigger", (String)"number, name,data_copy,params_entryentity.params_name,params_entryentity.params_value,params_entryentity.params_data_type", (QFilter[])new QFilter("id", "in", triggerIds).toArray());
        List dataCopyIds = triggers.values().stream().map(n -> n.getDynamicObject("data_copy").getPkValue()).collect(Collectors.toList());
        Map iscDataCopy = BusinessDataServiceHelper.loadFromCache((String)"isc_data_copy", (String)"id,data_source", (QFilter[])new QFilter("id", "in", dataCopyIds).toArray());
        Set dataSourceIds = iscDataCopy.values().stream().map(n -> n.getDynamicObject("data_source").getPkValue()).collect(Collectors.toSet());
        dbLinks.addAll(dataSourceIds);
        Map flows = BusinessDataServiceHelper.loadFromCache((String)"isc_service_flow", (String)"number, name,variables.var_name,variables.default_value,variables.is_input_param,resources.res_category,resources.res_ref", (QFilter[])new QFilter("id", "in", flowIds).toArray());
        for (Object flow : flows.values()) {
            DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
            for (DynamicObject resource : resources) {
                if (!"isc_data_source".equals(resource.getString("res_category"))) continue;
                DynamicObject resRef = resource.getDynamicObject("res_ref");
                dbLinks.add(resRef.getPkValue());
            }
        }
        Map dbLinksMap = BusinessDataServiceHelper.loadFromCache((Object[])dbLinks.toArray(), (String)"isc_data_source");
        for (DynamicObject source : dbLinksMap.values()) {
            String connectionType;
            DynamicObject dblink = source.getDynamicObject("dblink");
            if (dblink != null && this.param.getMigrateDataLink().equals(dblink.getPkValue()) || !"eas".equalsIgnoreCase(connectionType = source.getString("connection_type"))) continue;
            source.set("dblink", (Object)this.param.getMigrateDataLink());
        }
        OperationUtils.OperateSingleDynamic("save", "isc_data_source", dbLinksMap.values());
        Map<Long, Map<Long, List<MigrateIscSchemeConfig>>> groupData = this.getGroupData(migrateEntryList, triggers, flows);
        return groupData;
    }

    private Map<Long, Map<Long, List<MigrateIscSchemeConfig>>> getGroupData(List<DynamicObject> migrateEntryList, Map<Object, DynamicObject> triggers, Map<Object, DynamicObject> flows) {
        LinkedHashMap<Long, Map<Long, List<MigrateIscSchemeConfig>>> migrateObjConfigList = new LinkedHashMap<Long, Map<Long, List<MigrateIscSchemeConfig>>>(16);
        migrateObjConfigList.putIfAbsent(0L, new HashMap(16));
        Map longListMap = (Map)migrateObjConfigList.get(0L);
        for (DynamicObject entry : migrateEntryList) {
            DynamicObject migOb = entry.getDynamicObject("migrateobject");
            MigrateIscSchemeConfig schemeConfig = this.buildSchemeConfig(entry, triggers, flows);
            if (schemeConfig == null) continue;
            DynamicObject group = migOb.getDynamicObject("group");
            longListMap.putIfAbsent(0L, new ArrayList());
            List migrateIscSchemeConfigs = (List)longListMap.get(0L);
            migrateIscSchemeConfigs.add(schemeConfig);
        }
        return migrateObjConfigList;
    }

    private MigrateIscSchemeConfig buildSchemeConfig(DynamicObject entry, Map<Object, DynamicObject> triggers, Map<Object, DynamicObject> flows) {
        long entryId = (Long)entry.getPkValue();
        long schemeId = (Long)entry.getDynamicObject("startscheme").getPkValue();
        String schemeType = entry.getString("integrattype");
        if (StringUtils.isEmpty((CharSequence)schemeType)) {
            return null;
        }
        MigrateIscSchemeConfig config = null;
        if ("isc_data_copy_trigger".equals(schemeType)) {
            DynamicObject trigger = triggers.get(schemeId);
            config = MigrateIscSchemeConfig.build(trigger, schemeType, entryId);
        } else if ("isc_service_flow".equals(schemeType)) {
            DynamicObject flow = flows.get(schemeId);
            config = MigrateIscSchemeConfig.build(flow, schemeType, entryId);
        }
        return config;
    }

    private List<DynamicObject> loadNeededSchemeEntrys() {
        long projectId = this.getExecuteContext().getProjectId();
        HashSet<Long> migrateEntryIds = this.param.getMigrateEntryIdSet();
        ArrayList<DynamicObject> migrateEntryList = new ArrayList<DynamicObject>(16);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"dmw_project_eas");
        DynamicObjectCollection treeEntryList = dynamicObject.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : treeEntryList) {
            if (!migrateEntryIds.contains((Long)entry.getPkValue())) continue;
            migrateEntryList.add(entry);
        }
        return migrateEntryList;
    }
}

