/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.repair.RepairExecMicroImpl;
import kd.imsc.dmw.engine.eas.action.impl.repair.RepairExecPluginImpl;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.RepairLog;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.param.RepairRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.helper.lock.BizLocker;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateRepairAction
extends AbstractMigrateAction {
    private RepairRequestParam requestParam;

    public MigrateRepairAction(MigrateContext executeContext, RepairRequestParam requestParam, ActionProgress progress) {
        super.setExecuteContext(executeContext);
        super.setProgress(progress);
        this.requestParam = requestParam;
    }

    @Override
    public void doExec() {
        try (BizLocker bizLocker = BizLocker.create().doLock(this.requestParam.getMigrateCheckRepair());){
            this.doRepair();
        }
    }

    private void doRepair() {
        block4: {
            RepairLog repairLog = null;
            try {
                DynamicObjectCollection checkConfMap = this.getRepairConfMap();
                repairLog = this.getExecuteContext().getRepairLog();
                for (DynamicObject repair : checkConfMap) {
                    String repairMethod = repair.getString("entryentity.repairmethod");
                    if ("A".equals(repairMethod)) {
                        RepairExecMicroImpl repairExec = new RepairExecMicroImpl(this.requestParam.getMigrateDataLink(), repair, repairLog);
                        repairExec.doRepair();
                        continue;
                    }
                    RepairPluginParam param = new RepairPluginParam();
                    param.setDbLinkId(this.requestParam.getMigrateDataLink());
                    param.setProjectId(super.getExecuteContext().getProjectId());
                    param.setRepairId(this.requestParam.getMigrateCheckRepair());
                    param.setCheckItemLog(this.requestParam.getCheckItemLog());
                    RepairExecPluginImpl repairExec = new RepairExecPluginImpl(repair.getString("entryentity.repairplugin"), param, repairLog);
                    repairExec.doRepair();
                }
                this.addResponseParam();
                repairLog.saveLog();
            }
            catch (Exception e) {
                String errMsg = ResManager.loadKDString((String)"\u4fee\u590d\u6570\u636e\u51fa\u9519\uff1a", (String)"MigrateRepairAction_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                log.error(errMsg, (Throwable)e);
                if (repairLog == null) break block4;
                repairLog.setStatus("B");
                repairLog.setlogDetail(errMsg + e.getMessage());
                repairLog.saveLog();
            }
        }
    }

    private void addResponseParam() {
        HashMap<String, Object> repairResponseData = new HashMap<String, Object>(8);
        repairResponseData.put("repairstatus", this.getExecuteContext().getRepairLog().getValue("repairstatus"));
        repairResponseData.put("repairlog", this.getExecuteContext().getRepairLog().getValue("repairlog_tag"));
        repairResponseData.put("repairlogid", this.getExecuteContext().getRepairLog().getValue("id"));
        this.getProgress().getParentProgress().feedbackCustData(repairResponseData);
    }

    private DynamicObjectCollection getRepairConfMap() {
        QFilter qFilter = new QFilter("entryentity.id", "in", this.requestParam.getMigrateCheckRepair());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"dmw_checkitem_eas", (String)"id,entryentity.id,entryentity.repairmethod,entryentity.checkrepairtype,entryentity.repairplugin,entryentity.repairillust,entryentity.repairmicro", (QFilter[])qFilter.toArray());
        for (DynamicObject check : query) {
            RepairLog repairLog = this.getExecuteContext().getRepairLog();
            repairLog.setValue("checkitem", check.get("id"));
            repairLog.setValue("repairtype", check.get("entryentity.checkrepairtype"));
            repairLog.setValue("repairillust", check.get("entryentity.repairillust"));
            repairLog.setValue("repairplugin", check.get("entryentity.repairplugin"));
            repairLog.setValue("migrateproject", this.getExecuteContext().getProjectId());
            repairLog.setValue("checkstatus", this.requestParam.getCheckStatus());
            String checkDetail = this.requestParam.getCheckDetail();
            repairLog.setValue("checkdetail", StringUtil.subDataDeal(checkDetail, 50));
            repairLog.setValue("checkdetail_tag", checkDetail);
        }
        return query;
    }
}

