/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.checkitem;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.eas.action.impl.checkitem.exec.CheckItemExecMicroImpl;
import kd.imsc.dmw.engine.eas.action.impl.checkitem.exec.CheckItemExecPluginImpl;
import kd.imsc.dmw.engine.eas.core.config.MigrateCheckItemConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import kd.imsc.dmw.entity.CheckTaskParam;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateCheckItemTask
implements Callable<CheckItemLog> {
    private static final Log logger = LogFactory.getLog(MigrateCheckItemTask.class);
    private MigrateCheckItemConfig checkItemConfig;
    private MigrateContext context;

    public MigrateCheckItemTask(MigrateCheckItemConfig checkItemConfig, MigrateContext context) {
        this.checkItemConfig = checkItemConfig;
        this.context = context;
    }

    @Override
    public CheckItemLog call() {
        CheckItemLog checkItemLog;
        try {
            if (this.context.isTerminate()) {
                String msg = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"IscFlowCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                checkItemLog = new CheckItemLog(false, msg);
            } else {
                this.updateCheckItemStatus("B", StringUtils.getEmpty());
                checkItemLog = this.doExcute();
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u68c0\u67e5\u9879\u9519\u8bef,", (Throwable)e);
            String msg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            checkItemLog = new CheckItemLog(false, msg);
        }
        this.updateProjectData(checkItemLog);
        return checkItemLog;
    }

    private CheckItemLog doExcute() {
        CheckItemLog checkItemLog = new CheckItemLog(false, StringUtils.getEmpty());
        if (!this.context.isTerminate()) {
            String callMethod = this.checkItemConfig.getObj().getString("callmethod");
            if ("B".equals(callMethod)) {
                CheckTaskParam checkTaskParam = new CheckTaskParam();
                checkTaskParam.setBatch(this.context.getBatch());
                checkTaskParam.setDbLinkId(this.context.getDbLinkId());
                checkTaskParam.setProjectId(this.context.getProjectId());
                checkTaskParam.setTaskId(this.context.getTaskId());
                CheckItemExecMicroImpl exec = new CheckItemExecMicroImpl(this.checkItemConfig, checkTaskParam);
                checkItemLog = exec.doCheck();
            } else {
                CheckItemPluginParam param = new CheckItemPluginParam();
                param.setDbLinkId(this.context.getDbLinkId());
                CheckItemExecPluginImpl exec = new CheckItemExecPluginImpl(this.checkItemConfig.getPlugin(), param);
                checkItemLog = exec.doCheck();
            }
        }
        return checkItemLog;
    }

    private void updateProjectData(CheckItemLog checkItemLog) {
        try {
            String checkResultResponse = JSON.toJSONString((Object)checkItemLog);
            if (this.context.getProjectId() == 0L) {
                this.context.getProgressController().feedbackCustData("checkResultResponse", checkResultResponse);
            } else if (checkItemLog.isSuccess()) {
                this.updateCheckItemStatus("D", StringUtils.getEmpty());
            } else {
                String sql = "update t_dmw_project_eas_check set fcheckstatus = ?,fcheckdetail = ?, fcheckdetail_tag = ?, fcheckresultresponse_tag = ? where fid = ? and fcheckitem = ?";
                String subValidate = StringUtil.isEmpty(checkItemLog.getSubValidateInfo()) ? " " : checkItemLog.getSubValidateInfo();
                DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fcheckstatus", 12, (Object)"C"), new SqlParameter(":fcheckdetail", 12, (Object)subValidate), new SqlParameter(":fcheckdetail_tag", 12, (Object)checkItemLog.getValidateInfo()), new SqlParameter(":fcheckresultresponse_tag", 12, (Object)checkResultResponse), new SqlParameter(":fid", -5, (Object)this.context.getProjectId()), new SqlParameter(":fcheckitem", -5, (Object)this.checkItemConfig.getObjId())});
            }
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u6267\u884c\u68c0\u67e5\u9879\u811a\u672c\u66f4\u65b0\u5f02\u5e38\uff1a", (String)"MigrateCheckItemTask_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            logger.error(errMsg, (Throwable)e);
            this.updateCheckItemStatus("C", errMsg + e.getMessage());
            throw new DmwBizException(errMsg, (Throwable)e);
        }
    }

    private void updateCheckItemStatus(String status, String msg) {
        if (this.context.getProjectId() == 0L) {
            return;
        }
        String errorMsg = StringUtil.subDataDeal(msg, 255);
        String sql = "update t_dmw_project_eas_check set fcheckstatus = ?,fchecktime = ?,fcheckdetail = ?,fcheckdetail_tag = ? where fid = ? and fcheckitem = ?";
        DB.execute((DBRoute)DBRoute.of((String)"imsc"), (String)sql, (Object[])new Object[]{new SqlParameter(":fcheckstatus", 12, (Object)status), new SqlParameter(":fchecktime", 91, (Object)new Date()), new SqlParameter(":fcheckdetail", 12, (Object)errorMsg), new SqlParameter(":fcheckdetail_tag", 12, (Object)msg), new SqlParameter(":fid", -5, (Object)this.context.getProjectId()), new SqlParameter(":fcheckitem", -5, (Object)this.checkItemConfig.getObjId())});
    }
}

