/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.checkitem.exec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imsc.dmw.consts.DealMethodEnum;
import kd.imsc.dmw.engine.eas.action.impl.checkitem.exec.ICheckItemExec;
import kd.imsc.dmw.engine.eas.core.config.MigrateCheckItemConfig;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.entity.CheckTaskParam;

public class CheckItemExecMicroImpl
implements ICheckItemExec {
    private static final String[] BOS_CLOUD = new String[]{"WFS", "DEV", "EIP", "SYS"};
    private static final String STATUS_SUCCESS = "A";
    private static final String STATUS_FAIL = "B";
    private MigrateCheckItemConfig checkItemConfig;
    private CheckTaskParam checkTaskParam;

    public CheckItemExecMicroImpl(MigrateCheckItemConfig checkItemConfig, CheckTaskParam checkTaskParam) {
        this.checkItemConfig = checkItemConfig;
        this.checkTaskParam = checkTaskParam;
    }

    @Override
    public CheckItemLog doCheck() {
        Map<String, Object> paramMap = this.buildRequestParams();
        List<String> bosCloudList = Arrays.asList(BOS_CLOUD);
        Object result = null;
        result = bosCloudList.contains(this.checkItemConfig.getCloudNumber()) ? DispatchServiceHelper.invokeBOSService((String)this.checkItemConfig.getAppNumber(), (String)this.checkItemConfig.getServiceName(), (String)this.checkItemConfig.getMethod(), (Object[])new Object[]{paramMap}) : DispatchServiceHelper.invokeBizService((String)this.checkItemConfig.getCloudNumber(), (String)this.checkItemConfig.getAppNumber(), (String)this.checkItemConfig.getServiceName(), (String)this.checkItemConfig.getMethod(), (Object[])new Object[]{paramMap});
        Map map = (Map)result;
        Boolean isSuccess = (Boolean)map.get("isSuccess");
        CheckItemLog log = new CheckItemLog();
        if (isSuccess.booleanValue()) {
            log.setStatus(STATUS_SUCCESS);
            log.setValidateInfo((String)map.get("validateInfo"));
        } else {
            log.setStatus(STATUS_FAIL);
            log.setValidateInfo((String)map.get("validateInfo"));
        }
        return log;
    }

    private DealMethodEnum dealMethodMapping(String method) {
        DealMethodEnum[] values;
        for (DealMethodEnum value : values = DealMethodEnum.values()) {
            if (!value.getCode().equals(method)) continue;
            return value;
        }
        return null;
    }

    private Map<String, Object> buildRequestParams() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("dbLinkId", this.checkTaskParam.getDbLinkId());
        paramMap.put("checkObjectIds", this.checkItemConfig.getCheckObjectIds());
        List<Map<String, Object>> custormParams = this.checkItemConfig.getCustormParams();
        if (!CollectionUtils.isEmpty(custormParams)) {
            for (Map<String, Object> custormParam : custormParams) {
                String key = (String)custormParam.get("key");
                String value = (String)custormParam.get("val");
                paramMap.put(key, value);
            }
        }
        return paramMap;
    }
}

