/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.migrate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller.AbstractIscScheme;
import kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller.IscSchemeCallerFactory;
import kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller.SchemeAndFlowCaller;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.errorcode.DmwBizException;

public class IscSchemeGroupDeal {
    private static final Log logger = LogFactory.getLog(IscSchemeGroupDeal.class);
    private static final ThreadPool CACHED_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"MigrateIscSchemeExcutePool", (int)8, (int)16);
    private final MigrateContext context;
    private final Map<Long, List<MigrateIscSchemeConfig>> iscSchemeConfigs;
    private ActionProgress progress;

    public IscSchemeGroupDeal(MigrateContext context, Map<Long, List<MigrateIscSchemeConfig>> iscSchemeConfigs, ActionProgress progress) {
        this.context = context;
        this.iscSchemeConfigs = iscSchemeConfigs;
        this.progress = progress;
    }

    public List<String> deal() {
        ArrayList<String> results = new ArrayList<String>(this.iscSchemeConfigs.size());
        ArrayList<Future> futures = new ArrayList<Future>(16);
        for (List<MigrateIscSchemeConfig> config : this.iscSchemeConfigs.values()) {
            List<AbstractIscScheme> schemeCaller = IscSchemeCallerFactory.getSchemeCaller(config, this.context);
            SchemeAndFlowCaller schemeAndFlowCaller = new SchemeAndFlowCaller(schemeCaller);
            Future future = CACHED_THREAD_POOL.submit((Callable)schemeAndFlowCaller);
            futures.add(future);
        }
        int complete = 0;
        while (complete != futures.size()) {
            int endCount = Math.toIntExact(futures.stream().filter(Future::isDone).count());
            if (endCount <= complete) continue;
            complete = endCount;
            this.progress.updateComplete(this.progress.getComplete() + complete);
        }
        futures.forEach(f -> {
            try {
                results.addAll((Collection)f.get());
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error((Throwable)e);
                throw new DmwBizException(ResManager.loadKDString((String)"\u6267\u884c\u96c6\u6210\u65b9\u6848\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38", (String)"IscSchemeGroupDeal_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e);
            }
        });
        return results;
    }
}

