/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller.AbstractIscScheme;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.errorcode.DmwBizException;

public class IscDataCopyTrigger
extends AbstractIscScheme {
    private static final Log logger = LogFactory.getLog(IscDataCopyTrigger.class);

    protected IscDataCopyTrigger(String schemeType, MigrateIscSchemeConfig config, MigrateContext context) {
        super(schemeType, config, context);
    }

    @Override
    public String doExcute() {
        String resultStatus = "D";
        try {
            resultStatus = this.DataCopyTrigDeal();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u96c6\u6210\u65b9\u6848\u5931\u8d25:", (Throwable)e);
            this.updateExcutionStatus(resultStatus, e.getMessage());
        }
        return resultStatus;
    }

    private String DataCopyTrigDeal() {
        if (this.checkTerminate()) {
            logger.info("checkTerm end");
            this.updateExcutionStatus("D", ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"IscFlowCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return "D";
        }
        HashMap<String, Object> schemeParam = new HashMap<String, Object>(8);
        schemeParam.put("begindate", this.context.getBeginDate());
        schemeParam.put("beginperiodyear", this.context.getBeginPeriodYear());
        schemeParam.put("beginperiodmonth", this.context.getBeginPeriodMonth());
        schemeParam.put("easorgrange", this.context.getEasOrgRange());
        DynamicObjectCollection params = this.config.getObj().getDynamicObjectCollection("params_entryentity");
        for (DynamicObject param : params) {
            String name = param.getString("params_name");
            String dataType = param.getString("params_data_type");
            String value = param.getString("params_value");
            schemeParam.put(name, value);
        }
        this.updateExcutionStatus("B", "");
        String resultStatus = "D";
        Map invokeResult = null;
        invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{this.config.getSchemeNumber(), schemeParam, null});
        Boolean success = null;
        if (invokeResult != null) {
            success = (Boolean)invokeResult.get("success");
        }
        if (success != null) {
            if (success.booleanValue()) {
                String executionNumber = (String)invokeResult.get("execution_number");
                this.setInstanceId(executionNumber);
                this.updateExcutionId();
                Tuple<String, String> result = this.wait2End();
                resultStatus = (String)result.item1;
                String realMsg = this.getDataExecLog(resultStatus, (String)result.item2);
                this.updateExcutionStatus(resultStatus, realMsg);
            } else {
                String msg = (String)invokeResult.get("msg");
                this.updateExcutionStatus(resultStatus, msg);
            }
        } else {
            this.updateExcutionStatus(resultStatus, String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u542f\u52a8\u65b9\u6848\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a%s", (String)"IscDataCopyTriggerCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), invokeResult));
        }
        return resultStatus;
    }

    private String getDataExecLog(String resultStatus, String msg) {
        msg = msg == null ? "" : msg;
        StringBuilder msgBuilder = new StringBuilder(msg);
        if ("D".equals(resultStatus) || "E".equals(resultStatus)) {
            QFilter filter = new QFilter("data_copy_execution", "=", (Object)this.instanceId);
            filter.and("state", "=", (Object)"F");
            DynamicObjectCollection iscLogObjs = QueryServiceHelper.query((String)"isc_data_copy_exec_log", (String)"message", (QFilter[])filter.toArray(), (String)"created_time desc", (int)5);
            for (DynamicObject iscLogObj : iscLogObjs) {
                msgBuilder.append(iscLogObj.getString("message")).append('\n');
            }
            msgBuilder.append(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u8bf7\u70b9\u51fb\u201c\u67e5\u770b\u65e5\u5fd7\u201d\u6309\u94ae\u67e5\u770b", (String)"IscDataCopyTriggerCaller_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return msgBuilder.toString();
    }

    private void setInstanceId(String executionNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)executionNumber)};
        List executionIds = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_execution", (QFilter[])qFilters, null, (int)-1);
        this.instanceId = (Long)executionIds.get(0);
    }

    @Override
    public Tuple<String, String> wait2End() {
        int sleepSecond = 500;
        long startTime = System.currentTimeMillis();
        int interruptedCount = 0;
        while (true) {
            block12: {
                if (this.checkTerminate()) {
                    return new Tuple((Object)"D", (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"IscFlowCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
                Map<String, Object> execution = null;
                try {
                    execution = this.doCallIscService();
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u96c6\u6210\u4e91\u8bf7\u6c42\u5931\u8d25:", (Throwable)e);
                    return new Tuple((Object)"D", (Object)e.getMessage());
                }
                String state = (String)execution.get("state");
                if ("C".equals(state)) {
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        String message = String.format(ResManager.loadKDString((String)"%s\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u521b\u5efa\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c", (String)"IscDataCopyTriggerCaller_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), this.instanceId);
                        return new Tuple((Object)"D", (Object)message);
                    }
                } else {
                    if ("X".equals(state) || "F".equals(state)) {
                        String errorMsg = (String)execution.get("remark");
                        return new Tuple((Object)"D", (Object)errorMsg);
                    }
                    if ("P".equals(state)) {
                        return new Tuple((Object)"E", (Object)"");
                    }
                    if ("S".equals(state)) {
                        return new Tuple((Object)"C", (Object)"");
                    }
                }
                try {
                    Thread.sleep(sleepSecond);
                }
                catch (InterruptedException e) {
                    logger.error("\u4efb\u52a1\u7ec8\u6b62InterruptedException", (Throwable)e);
                    int n = interruptedCount;
                    interruptedCount = (byte)(interruptedCount + 1);
                    if (n <= 3) break block12;
                    String message = ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u7ecf\u88ab\u591a\u6b21\u4e2d\u65ad\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %2$s", (String)"IscDataCopyTriggerCaller_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    throw new DmwBizException(String.format(message, this.instanceId, e.getMessage()), (Throwable)e);
                }
            }
            sleepSecond = IscDataCopyTrigger.getDynamicSleepSecond(sleepSecond, 5000);
        }
    }

    private Map<String, Object> doCallIscService() {
        Map execution = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"getExecutionStateById", (Object[])new Object[]{this.instanceId});
        return execution;
    }

    @Override
    public boolean checkTerminate() {
        Map result;
        boolean success;
        boolean isTerminate = this.context.isTerminate();
        if (isTerminate && this.instanceId != 0L && !(success = ((Boolean)(result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"cancelExecution", (Object[])new Object[]{this.instanceId})).get("success")).booleanValue())) {
            String msg = (String)result.get("message");
            logger.warn(String.format("\u542f\u52a8\u65b9\u6848\u5df2\u5728\u6267\u884c\uff0c\u6267\u884c\u7ed3\u679cid\uff1a%1$s\uff0c\u7ec8\u6b62\u5931\u8d25, \u539f\u56e0\uff1a%2$s", this.instanceId, msg));
        }
        return isTerminate;
    }

    static class IscDataCopyStatus {
        public static final String CREATED = "C";
        public static final String RUNING = "R";
        public static final String SUCCESS = "S";
        public static final String FAILED = "F";
        public static final String CANCELED = "X";
        public static final String PART_SUCCESS = "P";

        IscDataCopyStatus() {
        }
    }
}

