/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.migrate.isccaller.AbstractIscScheme;
import kd.imsc.dmw.engine.eas.core.config.MigrateIscSchemeConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;

public class IscServiceFlow
extends AbstractIscScheme {
    private static final Log logger = LogFactory.getLog(IscServiceFlow.class);

    protected IscServiceFlow(String schemeType, MigrateIscSchemeConfig config, MigrateContext context) {
        super(schemeType, config, context);
    }

    @Override
    public String doExcute() {
        String resultStatus = "D";
        try {
            resultStatus = this.iscFlowDeal();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u96c6\u6210\u670d\u52a1\u5931\u8d25:", (Throwable)e);
            this.updateExcutionStatus(resultStatus, e.getMessage());
        }
        return resultStatus;
    }

    private String iscFlowDeal() {
        if (this.checkTerminate()) {
            this.updateExcutionStatus("D", ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"IscFlowCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return "D";
        }
        LinkedHashMap<String, String> schemeParam = new LinkedHashMap<String, String>(8);
        DynamicObjectCollection params = this.config.getObj().getDynamicObjectCollection("variables");
        for (DynamicObject param : params) {
            if (!param.getBoolean("is_input_param")) continue;
            String name = param.getString("var_name");
            String value = param.getString("default_value");
            schemeParam.put(name, value);
        }
        this.updateExcutionStatus("B", "");
        String resultStatus = "D";
        Object invokeResult = null;
        invokeResult = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{this.config.getSchemeNumber(), new ArrayList(schemeParam.values())});
        if (invokeResult != null) {
            this.instanceId = (Long)invokeResult;
            this.updateExcutionId();
            Tuple<String, String> result = this.wait2End();
            resultStatus = (String)result.item1;
            this.updateExcutionStatus((String)result.item1, (String)result.item2);
        } else {
            this.updateExcutionStatus(resultStatus, ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u670d\u52a1\u6d41\u7a0b\u8fdc\u7a0b\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u624b\u5de5\u542f\u52a8\u670d\u52a1\u6d41\u7a0b", (String)"IscFlowCaller_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return resultStatus;
    }

    @Override
    public Tuple<String, String> wait2End() {
        int sleepSecond = 500;
        long startTime = System.currentTimeMillis();
        int interruptedCount = 0;
        while (true) {
            block12: {
                if (this.checkTerminate()) {
                    return new Tuple((Object)"D", (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"IscFlowCaller_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                }
                Map<String, Object> execution = this.doIscService();
                String state = (String)execution.get("state");
                if ("Created".equals(state) || "Waiting".equals(state)) {
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        String message = String.format(ResManager.loadKDString((String)"%s\u4efb\u52a1\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u521b\u5efa\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8c03\u5ea6\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u8f6c", (String)"IscFlowCaller_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), this.instanceId);
                        return new Tuple((Object)"D", (Object)message);
                    }
                } else {
                    if ("Terminated".equals(state)) {
                        String errorMsg = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab\u7ec8\u6b62", (String)"IscFlowCaller_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"CONTROL"), new QFilter("proc_inst", "=", (Object)this.instanceId)};
                        DynamicObjectCollection logObjs = QueryServiceHelper.query((String)"isc_sf_proc_log", (String)"id, content", (QFilter[])qFilters, (String)"created_time desc", (int)1);
                        if (!logObjs.isEmpty()) {
                            errorMsg = ((DynamicObject)logObjs.get(0)).getString("content");
                        }
                        return new Tuple((Object)"D", (Object)errorMsg);
                    }
                    if ("Failed".equals(state)) {
                        String errorMsg = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u5931\u8d25", (String)"IscFlowCaller_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"ERROR"), new QFilter("proc_inst", "=", (Object)this.instanceId)};
                        DynamicObjectCollection logObjs = QueryServiceHelper.query((String)"isc_sf_proc_log", (String)"id, content", (QFilter[])qFilters, (String)"created_time desc", (int)1);
                        if (!logObjs.isEmpty()) {
                            errorMsg = ((DynamicObject)logObjs.get(0)).getString("content");
                        }
                        return new Tuple((Object)"D", (Object)errorMsg);
                    }
                    if ("Complete".equals(state)) {
                        return new Tuple((Object)"C", (Object)"");
                    }
                }
                try {
                    Thread.sleep(sleepSecond);
                }
                catch (InterruptedException e) {
                    int n = interruptedCount;
                    interruptedCount = (byte)(interruptedCount + 1);
                    if (n <= 3) break block12;
                    String message = ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u7ecf\u88ab\u591a\u6b21\u4e2d\u65ad\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %2$s", (String)"IscFlowCaller_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    KDBizException exception = new KDBizException(String.format(message, this.instanceId, e.getMessage()));
                    exception.addSuppressed((Throwable)e);
                    throw exception;
                }
            }
            sleepSecond = IscServiceFlow.getDynamicSleepSecond(sleepSecond, 5000);
        }
    }

    private Map<String, Object> doIscService() {
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{this.instanceId});
    }

    @Override
    public boolean checkTerminate() {
        boolean success;
        boolean isTerminate = this.context.isTerminate();
        if (isTerminate && this.instanceId != 0L && !(success = ((Boolean)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"terminate", (Object[])new Object[]{this.instanceId})).booleanValue())) {
            logger.warn(String.format("\u6d41\u7a0b\u5b9e\u4f8b[%1$s]\u5df2\u7ecf\u7ed3\u675f\u6216\u7ec8\u6b62\uff0c\u65e0\u6cd5\u518d\u6267\u884c\u7ec8\u6b62", this.instanceId));
        }
        return isTerminate;
    }

    static class IscFlowStatus {
        public static final String CREATED = "Created";
        public static final String WAITING = "Waiting";
        public static final String RUNNING = "Running";
        public static final String FAILED = "Failed";
        public static final String COMPLETE = "Complete";
        public static final String TERMINATED = "Terminated";

        IscFlowStatus() {
        }
    }
}

