/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.repair;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.repair.IRepairExec;
import kd.imsc.dmw.engine.eas.core.log.RepairLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.plugin.ICheckRepairPlugin;
import kd.imsc.dmw.utils.PluginInstanceUtil;

public class RepairExecPluginImpl
implements IRepairExec {
    private static final Log logger = LogFactory.getLog(RepairExecPluginImpl.class);
    private String pluginName;
    private RepairPluginParam param;
    private RepairLog repairLog;

    public RepairExecPluginImpl(String pluginName, RepairPluginParam param, RepairLog log) {
        this.pluginName = pluginName;
        this.param = param;
        this.repairLog = log;
    }

    @Override
    public RepairResponse doRepair() {
        try {
            ICheckRepairPlugin repairPlugin = (ICheckRepairPlugin)PluginInstanceUtil.newStrategy(this.pluginName);
            RepairResponse repairResponse = repairPlugin.doExecute(this.param);
            if (repairResponse != null) {
                logger.info("\u63d2\u4ef6\u4fee\u590d\u8fd4\u56de\u7ed3\u679c\u4e3a:" + JSONObject.toJSONString((Object)repairResponse));
                this.repairLog.setValue("successcount", repairResponse.getSuccessCount());
                this.repairLog.setValue("failcount", repairResponse.getFailCount());
                this.repairLog.setValue("repairstatus", repairResponse.getStauts());
                this.repairLog.setlogDetail(repairResponse.getDetail());
                this.setUserGuideRepairStatus(repairResponse.getStauts());
            }
        }
        catch (Exception e) {
            this.repairLog.setValue("repairstatus", "B");
            this.repairLog.setlogDetail(e.getMessage());
            this.setUserGuideRepairStatus("B");
        }
        return null;
    }

    private void setUserGuideRepairStatus(String repairStatus) {
        try {
            DynamicObject migrateProject = BusinessDataServiceHelper.loadSingle((Object)this.param.getProjectId(), (String)"dmw_project_eas");
            DynamicObjectCollection checkEntryEntity = migrateProject.getDynamicObjectCollection("checktreeentryentity");
            List<Long> repairIds = this.param.getRepairId();
            for (DynamicObject checkEntry : checkEntryEntity) {
                Long repairId = checkEntry.getLong("repairids");
                if (!repairIds.contains(repairId)) continue;
                checkEntry.set("repairstatus", (Object)repairStatus);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{migrateProject});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

