/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.config;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imsc.dmw.engine.eas.core.config.AbstractObjConfig;
import kd.imsc.dmw.utils.StringUtils;

public class MigrateCheckItemConfig
extends AbstractObjConfig {
    private Map<String, Object> microMap = new HashMap<String, Object>(16);

    public MigrateCheckItemConfig(DynamicObject obj) {
        super(obj);
    }

    public String getPlugin() {
        return this.getObj().getString("plugin");
    }

    public String getCloudNumber() {
        return ((String)this.microMap.get("cloud")).toLowerCase();
    }

    public String getAppNumber() {
        return (String)this.microMap.get("appid");
    }

    public List<Object> getCheckObjectIds() {
        String[] split;
        DynamicObject migObj = this.getObj().getDynamicObject("migrationobject");
        if (migObj == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> iscObjPks = new ArrayList<Object>(16);
        String easObject = migObj.getString("easobjectid");
        if (StringUtils.isEmpty(easObject)) {
            return iscObjPks;
        }
        for (String id : split = easObject.split(";")) {
            iscObjPks.add(Long.valueOf(id));
        }
        return iscObjPks;
    }

    public List<Map<String, Object>> getCustormParams() {
        return (List)this.microMap.get("params");
    }

    public String getServiceName() {
        return (String)this.microMap.get("servicename");
    }

    public String getMethod() {
        return (String)this.microMap.get("method");
    }

    public static MigrateCheckItemConfig build(DynamicObject obj) {
        MigrateCheckItemConfig migrateCheckItemConfig = new MigrateCheckItemConfig(obj);
        String micro = migrateCheckItemConfig.getObj().getString("micro");
        if (StringUtils.isNotEmpty(micro)) {
            Map map = (Map)JSONObject.parseObject((String)micro, Map.class);
            migrateCheckItemConfig.setMicroMap(map);
        }
        return migrateCheckItemConfig;
    }

    private void setMicroMap(Map<String, Object> microMap) {
        this.microMap = microMap;
    }
}

