/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.core.config.isc.IscService;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.plugin.IMigrateCheckItemPlugin;
import kd.imsc.dmw.utils.DbUtil;

public abstract class AbstractCheckPlugin
implements IMigrateCheckItemPlugin {
    protected String tableNameXh;
    protected String tableNameEas;
    private Map<String, Object> paramMap = new HashMap<String, Object>(2);
    private Map<String, List<Object>> errorEasIdsMap = new HashMap<String, List<Object>>(16);
    private Set<Object> xhNoPassIdSet = new HashSet<Object>(8);
    private StringBuilder errMsgBuild = new StringBuilder();

    public AbstractCheckPlugin() {
    }

    public AbstractCheckPlugin(String tableNameEas) {
        this.tableNameEas = tableNameEas;
    }

    public AbstractCheckPlugin(String tableNameXh, String tableNameEas) {
        this.tableNameEas = tableNameEas;
        this.tableNameXh = tableNameXh;
    }

    protected HashMap<String, List<Object>> queryXhData(Set<String> fieldList, QFilter[] qFilters) {
        String fields = String.join((CharSequence)",", fieldList);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(fieldList.size());
        DynamicObjectCollection dataArray = QueryServiceHelper.query((String)this.tableNameXh, (String)fields, (QFilter[])qFilters);
        for (String field : fieldList) {
            map.put(field, new ArrayList());
        }
        for (DynamicObject data : dataArray) {
            for (String field : fieldList) {
                map.get(field).add(data.getString(field));
            }
        }
        return map;
    }

    protected List<Map<String, Object>> executeQuery(IscService service, String sql) {
        Object iscDataResult = service.executeQuerySql(sql, null, null, 1000L);
        return (List)iscDataResult;
    }

    protected List<Map<String, Object>> executePageQuery(IscService service, String sql) {
        String templateSql = DbUtil.buildPaginationSql(sql);
        String countSql = DbUtil.buildCountSql(sql);
        return service.pageQuery(templateSql, countSql, null, null, 1000L);
    }

    protected List<Map<String, Object>> executePageQuery(IscService service, String templateSql, String countSql) {
        return service.pageQuery(templateSql, countSql, null, null, 1000L);
    }

    protected void buildCheckItemLog(CheckItemLog checkItemLog) {
        if (this.errMsgBuild.length() > 0) {
            checkItemLog.setStatus("B");
            checkItemLog.setEasTableName(this.tableNameEas);
            checkItemLog.setErrorEasIds(this.errorEasIdsMap);
            checkItemLog.setXhNoPassIds(new ArrayList<Object>(this.xhNoPassIdSet));
            this.errMsgBuild.deleteCharAt(this.errMsgBuild.length() - 1);
            checkItemLog.setValidateInfo(this.errMsgBuild.toString());
        } else {
            checkItemLog.setStatus("A");
        }
    }

    protected void buildOneTouchCheckItemLog(CheckItemLog checkItemLog) {
        if (this.errMsgBuild.length() > 0) {
            checkItemLog.setStatus("B");
            checkItemLog.setParamMap(this.paramMap);
            this.errMsgBuild.deleteCharAt(this.errMsgBuild.length() - 1);
            checkItemLog.setValidateInfo(this.errMsgBuild.toString());
        } else {
            checkItemLog.setStatus("A");
        }
    }

    protected void buildReturnData(List<Map<String, Object>> resultList, String detailErrMsg) {
        if (!resultList.isEmpty()) {
            List<Object> easIdList = new ArrayList(2);
            if (this.errorEasIdsMap.containsKey(detailErrMsg)) {
                easIdList = this.errorEasIdsMap.get(detailErrMsg);
            }
            for (Map<String, Object> result : resultList) {
                easIdList.add(result.get("fid"));
            }
            this.errorEasIdsMap.put(detailErrMsg, easIdList);
            if (!this.errMsgBuild.toString().contains(detailErrMsg)) {
                this.errMsgBuild.append(detailErrMsg).append('\n');
            }
        }
    }

    protected void buildReturnData(List<Map<String, Object>> resultList, List<Object> xhNoPassIdList, String detailErrMsg) {
        this.buildReturnData(resultList, detailErrMsg);
        this.xhNoPassIdSet.addAll(xhNoPassIdList);
    }

    protected void buildReturnData(String detailMsg, Object easId) {
        if (!this.errMsgBuild.toString().contains(detailMsg)) {
            this.errMsgBuild.append(detailMsg).append('\n');
        }
        List<Object> easIdList = new ArrayList<Object>(2);
        if (this.errorEasIdsMap.containsKey(detailMsg)) {
            easIdList = this.errorEasIdsMap.get(detailMsg);
        }
        easIdList.add(easId);
        this.errorEasIdsMap.put(detailMsg, easIdList);
    }

    private void buildReturnData(String detailMsg, Object easId, Object xhId) {
        this.buildReturnData(detailMsg, easId);
        this.xhNoPassIdSet.add(xhId);
    }

    protected void verifyDataDuplicateEas(List<Object> originalFieldList, Object verifiedField, Object easId, String fieldName) {
        if (originalFieldList.contains(verifiedField)) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u91cd\u590d\u3002", (String)"AbstractCheckPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildReturnData(detailMsg, easId);
        }
    }

    protected boolean verifyDataIsNull(Object verifiedField, Object easId, String fieldName) {
        if (verifiedField == null) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e3a\u7a7a\u3002", (String)"AbstractCheckPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildReturnData(detailMsg, easId);
            return true;
        }
        return false;
    }

    protected void verifyDataCompliance(Object verifiedField, Object easId, String fieldName, Pattern pattern) {
        String name = (String)verifiedField;
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e0d\u5408\u89c4\u3002", (String)"AbstractCheckPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildReturnData(detailMsg, easId);
        }
    }

    protected void verifyDataDuplicate(List<Object> originalFieldList, List<Object> idListXh, Object verifiedField, Object easId, String fieldName) {
        if (originalFieldList.contains(verifiedField)) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e0e\u661f\u701a\u7cfb\u7edf\u6570\u636e\u91cd\u590d\u3002", (String)"AbstractCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildReturnData(detailMsg, easId, idListXh.get(originalFieldList.indexOf(verifiedField)));
        }
    }
}

