/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class CostCenterCheckPlugin
extends AbstractCheckPlugin {
    private static final String SQL = "select FID,FNUMBER,FNAME_L2,FISCOSTORGUNIT from T_ORG_BaseUnit where FID='00000000-0000-0000-0000-000000000000CCE7AED4'";

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        List<Map<String, Object>> resultList = this.executePageQuery(service, SQL);
        ArrayList<Object> xhNoPassIdList = new ArrayList<Object>(8);
        if (CollectionUtils.isNotEmpty(resultList)) {
            Map<String, Object> map = resultList.get(0);
            Object id = map.get("fid");
            String number = (String)map.get("fnumber");
            String name = (String)map.get("fname_l2");
            boolean isCostEas = this.getOrgBoolean(map.get("fiscostorgunit"));
            StringBuilder errMsg = new StringBuilder();
            if (isCostEas) {
                this.verifyCostCenter(id, number, name, xhNoPassIdList, errMsg);
            }
            if (StringUtils.isNotEmpty((String)errMsg.toString())) {
                checkItemLog.setStatus("B");
                checkItemLog.setValidateInfo(errMsg.toString());
                checkItemLog.setXhNoPassIds(xhNoPassIdList);
                return checkItemLog;
            }
        }
        checkItemLog.setStatus("A");
        return checkItemLog;
    }

    private boolean getOrgBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        String str = obj.toString();
        return "1".equals(str);
    }

    private void verifyCostCenter(Object id, String number, String name, List<Object> xhNoPassIdList, StringBuilder errMsg) {
        QFilter costFilter = new QFilter("parent", "=", (Object)0L);
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingle((String)"bos_costcenter", (String)"id,number,name", (QFilter[])new QFilter[]{costFilter});
        if (costCenter == null) {
            String msg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u6839\u8282\u70b9\u5b58\u5728\u6210\u672c\u4e2d\u5fc3\u804c\u80fd\u7c7b\u578b\u4f46\u661f\u701a\u4e2d\u4e0d\u5b58\u5728", (String)"AbstractOrgIscScheCheckPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            errMsg.append(msg).append('\n');
        } else {
            Object idXh = costCenter.get("id");
            String numberXh = costCenter.getString("number");
            String nameXh = costCenter.getString("name");
            if (!numberXh.equals(number) || !nameXh.equals(name)) {
                String msg = ResManager.loadKDString((String)"\u661f\u701a\u7cfb\u7edf\u7684\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u3001\u540d\u79f0\u4e0eEAS\u7684\u4e0d\u4e00\u81f4\u3002", (String)"AbstractOrgIscScheCheckPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                errMsg.append(msg).append('\n');
                xhNoPassIdList.add(idXh);
            }
        }
    }
}

