/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.permission.util.IDCardCommonUtil;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import kd.imsc.dmw.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class UserIDNumCheckPlugin
extends AbstractCheckPlugin {
    public UserIDNumCheckPlugin() {
        super("bos_user", "T_BD_Person");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        String sql;
        CheckItemLog checkItemLog = new CheckItemLog();
        Long dbLinkId = param.getDbLinkId();
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql = "SELECT FID,FNUMBER,FIDCARDNO FROM T_BD_Person as a where FIDCARDNO is not null");
        if (CollectionUtils.isNotEmpty(resultList)) {
            String easNumberName = ResManager.loadKDString((String)"\u4eba\u5458\u7f16\u7801", (String)"AbstractComplianceCheckPlugin_19", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            String easFieldName = ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7", (String)"AbstractComplianceCheckPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (Map<String, Object> result : resultList) {
                Object easId = result.get("fid");
                Object num = result.get("fnumber");
                Object idCard = result.get("fidcardno");
                if (this.verifyDataIsNull(num, easId, easNumberName)) continue;
                this.verifyDataCompliance(idCard, easId, easFieldName, null);
            }
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }

    @Override
    protected void verifyDataCompliance(Object verifiedField, Object easId, String fieldName, Pattern pattern) {
        String idCard = (String)verifiedField;
        IDCardCommonUtil idCardUtil = new IDCardCommonUtil(idCard);
        if (StringUtils.isNotBlank(idCardUtil.getErrorMsg())) {
            String detailMsg = ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d%s\u4e0d\u5408\u89c4\u3002", (String)"AbstractCheckPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[]{fieldName});
            this.buildReturnData(detailMsg, easId);
        }
    }
}

