/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class UserMailCheckPlugin
extends AbstractCheckPlugin {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([a-zA-Z0-9_\\-\\.\\/]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,6}|[0-9]{1,3})(\\]?)$");

    public UserMailCheckPlugin() {
        super("bos_user", "T_BD_Person");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        String sql;
        CheckItemLog checkItemLog = new CheckItemLog();
        Long dbLinkId = param.getDbLinkId();
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql = "SELECT FID,FNUMBER ,FEMAIL  FROM T_BD_Person as a where FEMAIL is not null");
        if (CollectionUtils.isNotEmpty(resultList)) {
            String easNumberName = ResManager.loadKDString((String)"\u4eba\u5458\u7f16\u7801", (String)"AbstractComplianceCheckPlugin_19", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            String easFieldName = ResManager.loadKDString((String)"\u90ae\u7bb1\u53f7\u7801", (String)"AbstractComplianceCheckPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (Map<String, Object> result : resultList) {
                Object easId = result.get("fid");
                Object num = result.get("fnumber");
                Object idCard = result.get("femail");
                if (this.verifyDataIsNull(num, easId, easNumberName)) continue;
                this.verifyDataCompliance(idCard, easId, easFieldName, EMAIL_PATTERN);
            }
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }
}

