/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.base;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.param.ParameterReader;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import org.apache.commons.collections.CollectionUtils;

public class UserNameComplianceCheckPlugin
extends AbstractCheckPlugin {
    private static final Pattern NAME_PATTERN = Pattern.compile("^(?!_)[\\u4e00-\\u9fa5a-zA-Z0-9_]+(?<![_])$");

    public UserNameComplianceCheckPlugin() {
        super("bos_user", "T_BD_Person");
    }

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        String sql;
        CheckItemLog checkItemLog = new CheckItemLog();
        DynamicObject bosUser = ParameterReader.getBillParameter((String)"bos_user");
        boolean isCheck = bosUser.getBoolean("enableusernamecheck");
        if (!isCheck) {
            checkItemLog.setStatus("A");
            return checkItemLog;
        }
        Long dbLinkId = param.getDbLinkId();
        IscServiceImpl service = new IscServiceImpl(dbLinkId);
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql = "SELECT FID,FNUMBER,FNAME_L2 FROM T_BD_Person as a");
        if (CollectionUtils.isNotEmpty(resultList)) {
            String easNumberName = ResManager.loadKDString((String)"\u4eba\u5458\u7f16\u7801", (String)"AbstractComplianceCheckPlugin_19", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            String easFieldName = ResManager.loadKDString((String)"\u7528\u6237\u540d", (String)"AbstractComplianceCheckPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            for (Map<String, Object> result : resultList) {
                Object easId = result.get("fid");
                Object num = result.get("fnumber");
                Object idCard = result.get("fname_l2");
                if (this.verifyDataIsNull(num, easId, easNumberName)) continue;
                this.verifyDataCompliance(idCard, easId, easFieldName, NAME_PATTERN);
            }
        }
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }
}

