/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.checkitems.fi.gl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.dmw.engine.eas.core.config.isc.IscService;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.utils.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class AcctAsstactitemCheckPlugin
extends AbstractCheckPlugin {
    private static final Log logger = LogFactory.getLog(AcctAsstactitemCheckPlugin.class);
    private static final String asstSql = "SELECT a.fid,d.FASSTACTTYPEID as asstid FROM T_BD_ASSTACCOUNT a left join T_BD_ASSTACTGROUPDETAIL d on a.fid = d.FASSTACCOUNTID";
    private static final String SAME_ORG_ASST_SQL = "SELECT a.fid,a.FCAA fcaa,b.FCAA parentfcaa FROM T_BD_ACCOUNTVIEW a left join T_BD_ACCOUNTVIEW b on a.FPARENTID = b.fid where a.FPARENTID  is not null and  ((b.FCAA is not null and a.FCAA  is null) or (b.FCAA is not null and a.FCAA != b.FCAA))";
    private static final String SAME_ACCT_SQL = "SELECT a.fid,a.FCAA fcaa,m.FCAA parentfcaa FROM T_BD_AccountView a left join T_ORG_COMPANY  g on g.fid = a.FCOMPANYID left join T_BD_AccountView  m on m.fnumber = a.fnumber and m.FCOMPANYID = g.FPARENTID where m.fcaa is not null and (a.FCAA is null or a.FCAA != m.FCAA)";

    @Override
    public CheckItemLog doExecute(CheckItemPluginParam param) {
        String msg;
        CheckItemLog checkItemLog = new CheckItemLog();
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        List<Object> sameOrgList = this.getAsstErroList(service, SAME_ORG_ASST_SQL);
        List<Object> sameAcctList = this.getAsstErroList(service, SAME_ACCT_SQL);
        Map<String, List<Object>> errorEasIds = checkItemLog.getErrorEasIds();
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(sameOrgList)) {
            msg = ResManager.loadKDString((String)"EAS\u4e2d\u540c\u4e00\u7ec4\u7ec7\u4e0b\u7ea7\u79d1\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u5fc5\u987b\u5305\u542b\u4e0a\u7ea7\u79d1\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AcctAsstactitemCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            errorEasIds.put(msg, sameOrgList);
            builder.append(msg);
        }
        if (CollectionUtils.isNotEmpty(sameAcctList)) {
            msg = ResManager.loadKDString((String)"EAS\u4e2d\u4e0d\u540c\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6838\u7b97\u7ef4\u5ea6\u5fc5\u987b\u5305\u542b\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AcctAsstactitemCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            errorEasIds.put(msg, sameAcctList);
            builder.append(msg);
        }
        sameOrgList.addAll(sameAcctList);
        if (CollectionUtils.isNotEmpty(sameOrgList)) {
            checkItemLog.setStatus("B");
            checkItemLog.setValidateInfo(builder.toString());
            checkItemLog.setEasTableName("T_BD_ACCOUNTVIEW");
            return checkItemLog;
        }
        checkItemLog.setStatus("A");
        return checkItemLog;
    }

    private List<Object> getAsstErroList(IscService service, String sql) {
        Map<String, List<String>> asstMapping = this.getAsstMapping(service);
        ArrayList<Object> easIdList = new ArrayList<Object>(16);
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql);
        for (Map<String, Object> acctMap : resultList) {
            String fcaa = (String)acctMap.get("fcaa");
            String parentFcaa = (String)acctMap.get("parentfcaa");
            String acctId = (String)acctMap.get("fid");
            List fcaaAsstList = asstMapping.getOrDefault(fcaa, new ArrayList(1));
            List parentfcaaAsstList = asstMapping.getOrDefault(parentFcaa, new ArrayList(1));
            if (StringUtil.isNotEmpty(fcaa) && CollectionUtils.isEmpty((Collection)fcaaAsstList) || StringUtil.isNotEmpty(parentFcaa) && CollectionUtils.isEmpty((Collection)parentfcaaAsstList)) {
                logger.info("\u5f53\u524d\u79d1\u76ee\u7ef4\u5ea6\u4e3a\uff1a" + fcaa + "\uff0c\u4e0a\u7ea7\u79d1\u76ee\u7ef4\u5ea6\u4e3a\uff1a" + parentFcaa);
                String msg = ResManager.loadKDString((String)"\u67e5\u627e\u8f85\u52a9\u8d26\u7c7b\u578b\u5f02\u5e38\u3002", (String)"AcctAsstactitemCheckPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                throw new DmwBizException(msg);
            }
            if (parentfcaaAsstList.size() > fcaaAsstList.size()) {
                easIdList.add(acctId);
                continue;
            }
            HashSet asstSet = new HashSet(fcaaAsstList);
            asstSet.addAll(parentfcaaAsstList);
            if (asstSet.size() <= fcaaAsstList.size()) continue;
            easIdList.add(acctId);
        }
        return easIdList;
    }

    private Map<String, List<String>> getAsstMapping(IscService service) {
        HashMap<String, List<String>> asstMapping = new HashMap<String, List<String>>(16);
        List<Map<String, Object>> resultList = this.executePageQuery(service, asstSql);
        for (Map<String, Object> asstMap : resultList) {
            String fcaa = (String)asstMap.get("fid");
            String asstId = (String)asstMap.get("asstid");
            asstMapping.putIfAbsent(fcaa, new ArrayList(16));
            ((List)asstMapping.get(fcaa)).add(asstId);
        }
        return asstMapping;
    }
}

