/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.progress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.executor.ExecutorService;
import kd.imsc.dmw.engine.eas.core.progress.Progress;

public class MigrateProgress
extends Progress {
    private static final int PROGRESS_100 = 100;
    private final String taskId;
    private String desc;
    private Map<String, Object> custData = new HashMap<String, Object>(8);
    private final List<Progress> subProgress = new ArrayList<Progress>(8);
    private int allProgress;

    public MigrateProgress(String taskId, int weight) {
        super(weight);
        this.taskId = taskId;
    }

    public void addSubProgress(Progress e) {
        this.subProgress.add(e);
    }

    @Override
    public void update(int progres) {
        super.update(progres);
        this.notice();
    }

    @Override
    public void complete() {
        super.complete();
    }

    public void feedbackProgress(int progress, String desc, Map<String, Object> data) {
        this.setProgres(progress);
        this.desc = desc;
        if (data != null) {
            this.custData.putAll(data);
        }
        this.commit();
    }

    public void feedbackProgress(String desc) {
        this.desc = desc;
        this.commit();
    }

    public void feedbackProgress(int progress, String desc) {
        this.setProgres(progress);
        this.desc = desc;
        this.commit();
    }

    public void feedbackCustData(Map<String, Object> data) {
        if (data != null) {
            this.custData.putAll(data);
            this.commit();
        }
    }

    public void feedbackCustData(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(key, value);
        this.feedbackCustData(map);
    }

    public void fail(String failMessage) {
        if (StringUtils.isBlank((CharSequence)failMessage)) {
            return;
        }
        if (this.custData == null) {
            this.custData = new HashMap<String, Object>(2);
        }
        this.custData.put("fail", Boolean.TRUE);
        this.custData.put("failmessage", failMessage);
        this.commit();
    }

    public void commit() {
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.allProgress, this.desc, this.custData);
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, this.custData);
        }
    }

    @Override
    public void notice() {
        super.notice();
        int weightSum = this.subProgress.stream().mapToInt(Progress::getWeight).sum() + this.getWeight();
        int newProgress = this.getProgres() * this.getWeight() / weightSum;
        for (Progress subp : this.subProgress) {
            int p = subp.getProgres() * subp.getWeight() / weightSum;
            newProgress += p;
        }
        this.allProgress = newProgress;
        this.commit();
    }

    public int getAllProgres() {
        this.notice();
        return this.allProgress;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDesc() {
        return this.desc;
    }

    public Map<String, Object> getCustData() {
        return this.custData;
    }
}

