/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.SimpleImportServiceCallable;
import kd.imsc.dmw.engine.multiimport.helper.ExcelConvertHelper;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.engine.multiimport.helper.TaskExcuteReportHelper;
import kd.imsc.dmw.engine.multiimport.model.AllEntityDataInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldMappingInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelSheetMappingModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.StdTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.SubDataConfigureInfo;
import kd.imsc.dmw.engine.multiimport.result.ImportSimpleResult;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskDetailExecResult;
import kd.imsc.dmw.engine.multiimport.result.MultiImpTaskExecResult;
import kd.imsc.dmw.enums.ImpFailCodeEnum;
import kd.imsc.dmw.enums.MultiImpTaskEntryStatusEnum;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.ImportExcelReadHelper;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.StdTemplateReadHelper;
import kd.imsc.dmw.plugin.formplugin.datacollect.ProjectAllBaseUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;

public class MultiImportServiceTaskImpl
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MultiImportServiceTaskImpl.class);
    public static final String FCODE = "FCODE";
    public static final String MSG = "MSG";
    public static final int TASK_CODE_ERROR = -1;
    public static final int TASK_CODE_DOWNLOAD = 100;
    public static final int TASK_CODE_DOWNLOAD_ERROR = 102;
    public static final int TASK_IMPORT_START = 200;
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)MultiImportServiceTaskImpl.class.getSimpleName(), (int)4, (int)8);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        long startTime = System.currentTimeMillis();
        logger.info("TaskId {} Start Service Lang {}", (Object)this.taskId, (Object)Lang.get());
        HashMap<String, Object> importMap = new HashMap<String, Object>(16);
        if (params == null || params.isEmpty()) {
            logger.info("params is null");
            importMap.put(FCODE, -1);
            importMap.put(MSG, "params is null");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        logger.info("params {}", (Object)JSON.toJSONString(params));
        Object dataObj = params.get("std_im_t_t");
        if (dataObj == null) {
            logger.info("dataObj is null");
            importMap.put(FCODE, -1);
            importMap.put(MSG, "dataObj is null");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        String fileStr = (String)params.get("im_f_i");
        if (StringUtils.isEmpty((String)fileStr)) {
            logger.info("fileStr is null");
            importMap.put(FCODE, -1);
            importMap.put(MSG, "fileStr is null");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        List infoList = JSON.parseArray((String)((String)dataObj), SubDataConfigureInfo.class);
        if (infoList == null || infoList.isEmpty()) {
            importMap.put(FCODE, -1);
            importMap.put(MSG, "infoList is null");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        Long importTaskId = (Long)params.get("im_t_id");
        DynamicObject taskObj = MultiImpTaskHelper.getTaskById(importTaskId);
        if (taskObj == null) {
            importMap.put(FCODE, -1);
            importMap.put(MSG, "taskObj is null");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        JSONObject fileInfoObj = JSON.parseObject((String)fileStr);
        File file = null;
        try {
            importMap.put(FCODE, 100);
            this.feedbackCustomdata(importMap);
            long t = System.currentTimeMillis();
            file = MultiImpAttachmentHelper.downloadFile(fileInfoObj.getString("url"), fileInfoObj.getString("name"), fileInfoObj.getString("format"));
            logger.info("MultiImpAttachmentHelper.downloadFile:" + (System.currentTimeMillis() - t));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (file == null || !file.exists()) {
            logger.info("file is not exist!");
            importMap.put(FCODE, 102);
            importMap.put(MSG, "file is not exist!");
            this.feedbackCustomdata(importMap);
            this.checkIsStop();
            return;
        }
        try {
            int totalTargetSize = infoList.size();
            int finishSize = 0;
            ImportTemplateReadInfoModel infoModel = (ImportTemplateReadInfoModel)JSON.parseObject((String)taskObj.getString("modelinfo_tag"), ImportTemplateReadInfoModel.class);
            importMap.put(FCODE, 200);
            HashMap<String, List> codeGroupMap = new HashMap<String, List>(4);
            ArrayList<ExcelSheetMappingModel> sheetMappingList = new ArrayList<ExcelSheetMappingModel>(16);
            for (SubDataConfigureInfo info : infoList) {
                String code = info.getInstallInfo().getCode();
                List codeList = codeGroupMap.getOrDefault(code, new ArrayList());
                codeList.add(info);
                codeGroupMap.put(code, codeList);
                ExcelSheetMappingModel sheetMappingInfo = this.createExcelSheetMappingModel(taskObj, info, infoModel);
                sheetMappingList.add(sheetMappingInfo);
            }
            AllEntityDataInfoModel allEntityDataInfo = ImportExcelReadHelper.batchReadRowContentByFile(file, sheetMappingList);
            logger.info("ImportExcelReadHelper.batchReadRowContentByFile end:" + (System.currentTimeMillis() - startTime));
            List codeList = codeGroupMap.keySet().stream().sorted(String::compareTo).collect(Collectors.toList());
            String status = "A";
            for (int i = 0; i < codeList.size(); ++i) {
                Object info2;
                List list = (List)codeGroupMap.get(codeList.get(i));
                int impSize = list.size();
                ArrayList<Future> futureList = new ArrayList<Future>(impSize);
                for (Object info2 : list) {
                    Future submit = threadPool.submit((Callable)new SimpleImportServiceCallable(file, importTaskId, (SubDataConfigureInfo)info2, infoModel, allEntityDataInfo.getSheetDataInfoModelByFormId(((SubDataConfigureInfo)info2).getInstallInfo().getFormId())));
                    futureList.add(submit);
                }
                boolean success = true;
                info2 = futureList.iterator();
                while (info2.hasNext()) {
                    Future future = (Future)info2.next();
                    SubDataConfigureInfo info3 = (SubDataConfigureInfo)list.get(futureList.indexOf(future));
                    long impStartTime = System.currentTimeMillis();
                    try {
                        long t = System.currentTimeMillis();
                        ImportSimpleResult simpleResult = (ImportSimpleResult)future.get();
                        this.feedbackProgress(this.calcProgress(++finishSize, totalTargetSize));
                        if (simpleResult.getFailCode() != ImpFailCodeEnum.SUCCESS) {
                            status = "B";
                        }
                        success = success && simpleResult.getFailCode() == ImpFailCodeEnum.SUCCESS;
                        importMap.put(info3.getInstallInfo().getFormId(), simpleResult);
                        this.feedbackCustomdata(importMap);
                        logger.info(simpleResult.getFormId() + "->SimpleImportServiceCallable end:" + (System.currentTimeMillis() - t));
                    }
                    catch (Exception e) {
                        success = false;
                        this.feedbackProgress(this.calcProgress(++finishSize, totalTargetSize));
                        logger.error("future.get() error end:", (Throwable)e);
                        ImportSimpleResult simpleResult = new ImportSimpleResult(null, info3.getTotal(), info3.getTotal(), true, 1L, ImpFailCodeEnum.IMPFAIL);
                        simpleResult.setStartTime(impStartTime);
                        simpleResult.setEndTime(System.currentTimeMillis());
                        importMap.put(info3.getInstallInfo().getFormId(), simpleResult);
                        this.feedbackCustomdata(importMap);
                    }
                }
                if (this.isStop() || !success) break;
            }
            if (!this.isStop()) {
                ArrayList<MultiImpTaskDetailExecResult> failResultList = new ArrayList<MultiImpTaskDetailExecResult>(8);
                for (int i = 0; i < infoList.size(); ++i) {
                    String formId = ((SubDataConfigureInfo)infoList.get(i)).getInstallInfo().getFormId();
                    if (importMap.containsKey(formId)) continue;
                    failResultList.add(this.buildSimpleExecFailResult(formId, 0, 0, ResManager.loadKDString((String)"\u56e0\u4f9d\u8d56\u4e1a\u52a1\u5bf9\u8c61\u6ca1\u5bfc\u5165\u5bfc\u81f4\u672c\u4e1a\u52a1\u5bf9\u8c61\u672a\u5bfc\u5165\u3002", (String)"MultiImportServiceTaskImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0])));
                }
                this.feedbackTaskEntryResult(importTaskId, failResultList);
            }
            HashMap<String, Object> headObjMap = new HashMap<String, Object>(4);
            headObjMap.put("im_t_id", importTaskId);
            headObjMap.put("impstatus", status);
            headObjMap.put("impdatetime", startTime);
            headObjMap.put("endtime", System.currentTimeMillis());
            DynamicObject reportDynObj = TaskExcuteReportHelper.save(headObjMap, importMap);
            QFilter filter = new QFilter("id", "=", (Object)importTaskId);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"dmw_imptask", (QFilter[])new QFilter[]{filter});
            String taskStatus = MultiImpTaskHelper.getTaskStatusByEntryStatus(task);
            task.set("impstatus", (Object)taskStatus);
            SaveServiceHelper.update((DynamicObject)task);
            Long detailResultId = (Long)params.get("detailresult_id");
            if (detailResultId != null) {
                ProjectAllBaseUtil.updateDataCollectStatusByScheme(detailResultId, reportDynObj.getLong("id"), importTaskId, taskStatus);
                if (!"C".equals(taskStatus)) {
                    DynamicObject taskDynObj = MultiImpTaskHelper.getTaskById(importTaskId);
                    MultiImpTaskHelper.terminateTasks(new DynamicObject[]{taskDynObj});
                }
            }
            this.feedbackProgress(99);
            logger.info("SimpleImportServiceCallable->execute end:" + (System.currentTimeMillis() - startTime));
        }
        finally {
            boolean delete = file.delete();
            logger.info("\u91ca\u653e\u8d44\u6e90\uff0c\u5220\u9664\u6587\u4ef6{}", (Object)delete);
        }
    }

    private ExcelSheetMappingModel createExcelSheetMappingModel(DynamicObject taskDynObj, SubDataConfigureInfo info, ImportTemplateReadInfoModel infoModel) {
        List taskEntryList;
        DynamicObjectCollection entries = taskDynObj.getDynamicObjectCollection("entryentity");
        if (StringUtil.isNotEmpty(entries) && StringUtil.isNotEmpty(info.getInstallInfo().getFormId()) && !CommonUtils.isNull(taskEntryList = entries.stream().filter(entry -> info.getInstallInfo().getFormId().equals(DynamicObjectUtils.getDynamicObjectStringValue(entry, "billentity", "target_formid"))).collect(Collectors.toList()))) {
            DynamicObject entryTargetObj = (DynamicObject)taskEntryList.get(0);
            String targetId = entryTargetObj.getDynamicObject("billentity").getString("target_formid");
            String targetName = entryTargetObj.getDynamicObject("billentity").getString("name");
            StdTemplateReadInfoModel stdImportSchemeTemplate = null;
            try {
                stdImportSchemeTemplate = StdTemplateReadHelper.getStdImportSchemeTemplate(targetId, targetName);
            }
            catch (DmwImptException e) {
                logger.error("createExcelSheetMappingModel", (Throwable)e);
                return null;
            }
            if (stdImportSchemeTemplate == null || stdImportSchemeTemplate.getKeyFieldList() == null || stdImportSchemeTemplate.getKeyFieldList().isEmpty()) {
                return null;
            }
            String sourceSheetNames = entryTargetObj.getString("sourcesheet");
            Map<String, String> fieldMappingMap = ExcelConvertHelper.buildStdKeyMapping(entryTargetObj.getDynamicObjectCollection("subentryentity"));
            Tuple<Boolean, String> mainSheetResp = ExcelConvertHelper.confirmMainSheet(sourceSheetNames, stdImportSchemeTemplate.getKeyFieldList(), fieldMappingMap);
            if (sourceSheetNames.startsWith(",")) {
                sourceSheetNames = sourceSheetNames.replaceFirst(",", "");
            }
            String[] sheetNameArray = sourceSheetNames.split(",");
            ArrayList<String> relSheetNameList = new ArrayList<String>(sheetNameArray.length);
            String mainSheet = (String)mainSheetResp.item2;
            for (String relSheetName : sheetNameArray) {
                if (mainSheet.equals(relSheetName)) continue;
                relSheetNameList.add(relSheetName);
            }
            String relSheetField = entryTargetObj.getString("relpropname");
            ExcelSheetMappingModel sheetMappingInfo = new ExcelSheetMappingModel(mainSheet, targetId, relSheetField, relSheetNameList);
            for (String sheetName : sheetNameArray) {
                sheetMappingInfo.putFormIdMap(sheetName, targetId);
            }
            Map<String, List<ExcelFieldMappingInfoModel>> customFieldMap = ExcelConvertHelper.createcustomFieldMap(entryTargetObj, stdImportSchemeTemplate, infoModel, mainSheetResp);
            sheetMappingInfo.setCustomFieldMap(customFieldMap);
            return sheetMappingInfo;
        }
        return null;
    }

    private int calcProgress(int curSize, int totalSize) {
        int progress = curSize * 100 / totalSize;
        return progress >= 100 ? 99 : progress;
    }

    private void feedbackTaskEntryResult(long taskId, List<MultiImpTaskDetailExecResult> failResultList) {
        if (failResultList == null || failResultList.isEmpty()) {
            return;
        }
        MultiImpTaskExecResult importExecResult = new MultiImpTaskExecResult();
        importExecResult.setTaskId(taskId);
        importExecResult.setDetailResults(failResultList);
        logger.info("\u53cd\u9988\u5bfc\u5165\u7ed3\u679c {}", (Object)JSON.toJSONString((Object)importExecResult));
        MultiImpTaskHelper.updateExecuteResult(importExecResult);
    }

    private MultiImpTaskDetailExecResult buildSimpleExecFailResult(String formId, int total, int fail, String failReason) {
        MultiImpTaskDetailExecResult detailExecResult = new MultiImpTaskDetailExecResult(formId, total, fail < 0 ? 0 : fail, MultiImpTaskEntryStatusEnum.FAIL, null);
        detailExecResult.setFailReason(failReason);
        return detailExecResult;
    }
}

