/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.OrgProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldMappingInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ExcelRowInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.engine.multiimport.model.SheetDataInfoModel;
import kd.imsc.dmw.engine.multiimport.model.StdTemplateReadInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.StdTemplateReadHelper;
import kd.imsc.dmw.helper.TemplateMappingHelper;
import kd.imsc.dmw.helper.modifier.FieldModifierBuilderFactory;
import kd.imsc.dmw.helper.modifier.IFieldModifier;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.ImptFileUtils;
import kd.imsc.dmw.utils.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelConvertHelper {
    private static final Log logger = LogFactory.getLog(ExcelConvertHelper.class);
    private static final String XLSX = ".xlsx";

    private ExcelConvertHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<File, Integer> doTemplateConvertAction(DynamicObject entryTargetObj, Map<String, ExcelFieldInfoModel> sheetColumnValueMap, File dataExcel, SheetDataInfoModel sheetDataInfo) throws DmwImptException {
        if (entryTargetObj == null || dataExcel == null || !dataExcel.exists() || !dataExcel.getName().endsWith(XLSX)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u5165\u53c2\u5f02\u5e38!", (String)"ExcelConvertHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), 5001);
        }
        String targetId = entryTargetObj.getDynamicObject("billentity").getString("target_formid");
        String targetName = entryTargetObj.getDynamicObject("billentity").getString("name");
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new DmwImptException(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25!", (String)"ExcelConvertHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 5001);
        }
        if (dataEntityType == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25!", (String)"ExcelConvertHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), 5001);
        }
        Map<String, String> fieldMappingMap = ExcelConvertHelper.buildStdKeyMapping(entryTargetObj.getDynamicObjectCollection("subentryentity"));
        if (fieldMappingMap.isEmpty()) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u5206\u5f55\u65e0\u4efb\u4f55\u7684\u5339\u914d\u5b57\u6bb5!", (String)"ExcelConvertHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), 5001);
        }
        String sourceSheetNames = entryTargetObj.getString("sourcesheet");
        if (StringUtils.isEmpty((String)sourceSheetNames)) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u672a\u914d\u7f6e\u4efb\u4f55Excel\u9875\u7b7e!", (String)"ExcelConvertHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), 5001);
        }
        StdTemplateReadInfoModel stdImportSchemeTemplate = StdTemplateReadHelper.getStdImportSchemeTemplate(targetId, targetName);
        if (stdImportSchemeTemplate == null || stdImportSchemeTemplate.getKeyFieldList() == null || stdImportSchemeTemplate.getKeyFieldList().isEmpty()) {
            throw new DmwImptException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u8fc7\u7a0b\u5f02\u5e38\uff1a\u83b7\u53d6[%1$s] [%2$s]\u7684\u5168\u91cf\u6a21\u677f\u5931\u8d25!", (String)"ExcelConvertHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), targetId, targetName), 5001);
        }
        long startTime = System.currentTimeMillis();
        SXSSFWorkbook workbook = null;
        try {
            workbook = StdTemplateReadHelper.getStdImportTemplateStream(targetId, targetName);
            String relSheetField = entryTargetObj.getString("relpropname");
            List<ExcelFieldInfoModel> fieldInfoModelList = ExcelConvertHelper.doStdKeyFieldModifierAction(stdImportSchemeTemplate, targetId);
            SXSSFSheet sheetAt = workbook.getSheetAt(0);
            ExcelConvertHelper.setCellByStdKeyFieldModifierAction(sheetAt, fieldInfoModelList);
            int writeIndex = 4;
            int count = 0;
            long time = System.currentTimeMillis();
            List<ExcelRowInfoModel> mainRowList = sheetDataInfo.getMainSheetDataRowList();
            Map propertyMap = dataEntityType.getAllFields();
            List<Object> batchesRowList = new ArrayList(100000);
            int size = mainRowList.size();
            if (size > 100000) {
                for (ExcelRowInfoModel rowInfo : mainRowList) {
                    batchesRowList.add(rowInfo);
                    if (++count % 100000 != 0) continue;
                    writeIndex = ExcelConvertHelper.createRowByBatchesRowList(sheetAt, batchesRowList, sheetDataInfo.getRelSheetRowFieldMap(), targetId, writeIndex, relSheetField, propertyMap);
                    batchesRowList.clear();
                    logger.info("totalcount:" + count + "createRowByRelSheet end:" + (System.currentTimeMillis() - time));
                    time = System.currentTimeMillis();
                }
            } else {
                batchesRowList = mainRowList;
            }
            if (!batchesRowList.isEmpty()) {
                writeIndex = ExcelConvertHelper.createRowByBatchesRowList(sheetAt, batchesRowList, sheetDataInfo.getRelSheetRowFieldMap(), targetId, writeIndex, relSheetField, propertyMap);
            }
            int totalCount = writeIndex - 4;
            File dFile = ExcelConvertHelper.writeWorkbook(workbook, targetId, targetName);
            logger.info("createRow:" + totalCount + "doTemplateConvertAction->writeWorkbook end:" + (System.currentTimeMillis() - startTime));
            Tuple tuple = Tuple.create((Object)dFile, (Object)totalCount);
            return tuple;
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                logger.error("doTemplateConvertAction workbook.close():", (Throwable)e);
            }
        }
    }

    private static int createRowByBatchesRowList(SXSSFSheet sheetAt, List<ExcelRowInfoModel> batchesRowList, Map<String, Map<String, List<ExcelRowInfoModel>>> relSheetRowFieldMap, String targetId, int writeIndex, String relSheetField, Map<String, IDataEntityProperty> propertyMap) {
        long time = System.currentTimeMillis();
        ArrayList<ExcelRowInfoModel> rowInfoList = new ArrayList<ExcelRowInfoModel>(batchesRowList);
        if (!CommonUtils.isNull(relSheetRowFieldMap)) {
            for (Map.Entry<String, Map<String, List<ExcelRowInfoModel>>> map : relSheetRowFieldMap.entrySet()) {
                Map<String, List<ExcelRowInfoModel>> relSheetMap = map.getValue();
                for (Map.Entry<String, List<ExcelRowInfoModel>> mapEntry : relSheetMap.entrySet()) {
                    rowInfoList.addAll((Collection<ExcelRowInfoModel>)mapEntry.getValue());
                }
            }
        }
        Map<String, Map<String, List<DynamicObject>>> baseDataValueMap = ExcelConvertHelper.createbaseDataFieldValueMap(targetId, rowInfoList, propertyMap, relSheetRowFieldMap, relSheetField);
        logger.info("createbaseDataFieldValueMap end:" + (System.currentTimeMillis() - time));
        HashMap<String, List<ExcelRowInfoModel>> relSheetMap = new HashMap<String, List<ExcelRowInfoModel>>(16);
        HashMap<String, List<ExcelRowInfoModel>> formualRelSheetMap = new HashMap<String, List<ExcelRowInfoModel>>(16);
        for (ExcelRowInfoModel excelRowInfo : batchesRowList) {
            List<ExcelFieldMappingInfoModel> excelFieldInfoModelList = excelRowInfo.getExcelFieldInfoModelList();
            String relValue = ExcelConvertHelper.getRelSheetMap(excelRowInfo, relSheetRowFieldMap, excelFieldInfoModelList, relSheetField, relSheetMap);
            ExcelConvertHelper.putFormualRelSheetMap(formualRelSheetMap, excelRowInfo, relSheetMap, relValue, excelFieldInfoModelList.get(0).getSheetName());
            for (ExcelFieldMappingInfoModel fieldMapInfo : excelFieldInfoModelList) {
                SXSSFCell cell;
                String value = excelRowInfo.getFieldValue(fieldMapInfo, formualRelSheetMap);
                if (!StringUtils.isNotEmpty((String)value) || StringUtil.isEmpty(fieldMapInfo.getStdFieldKey())) continue;
                IDataEntityProperty property = propertyMap.get(fieldMapInfo.getStdFieldKey().split("\\.")[0]);
                ExcelFieldInfoModel excelModel = ExcelConvertHelper.buildWriteExcelInfoModel(targetId, writeIndex, fieldMapInfo.getStdColumnIndex(), value, property, fieldMapInfo.getStdFieldKey(), baseDataValueMap);
                SXSSFRow createRow = sheetAt.getRow(excelModel.getRow());
                if (createRow == null) {
                    createRow = sheetAt.createRow(excelModel.getRow());
                }
                if ((cell = createRow.getCell(excelModel.getColumn())) == null) {
                    cell = createRow.createCell(excelModel.getColumn());
                }
                cell.setCellValue(excelModel.getValue());
            }
            if (!relSheetMap.isEmpty()) {
                int maxRows = ExcelConvertHelper.createRowByRelSheet(writeIndex, relSheetMap, sheetAt, targetId, propertyMap, baseDataValueMap, formualRelSheetMap);
                writeIndex += maxRows;
                relSheetMap.clear();
            }
            ++writeIndex;
        }
        return writeIndex;
    }

    private static String getRelSheetMap(ExcelRowInfoModel excelRowInfo, Map<String, Map<String, List<ExcelRowInfoModel>>> relSheetRowFieldMap, List<ExcelFieldMappingInfoModel> excelFieldInfoModelList, String relSheetField, Map<String, List<ExcelRowInfoModel>> relSheetMap) {
        String relValue = "";
        relSheetMap.clear();
        for (ExcelFieldMappingInfoModel fieldMapInfo : excelFieldInfoModelList) {
            String customFieldKey = fieldMapInfo.getCustomFieldKey();
            if (!StringUtils.isNotEmpty((String)customFieldKey) || !customFieldKey.split("\\.")[1].equals(relSheetField) || !StringUtils.isNotEmpty((String)(relValue = excelRowInfo.getFieldValue(fieldMapInfo, null))) || !relSheetRowFieldMap.containsKey(relValue)) continue;
            relSheetMap.putAll(relSheetRowFieldMap.get(relValue));
            break;
        }
        return relValue;
    }

    private static void putFormualRelSheetMap(Map<String, List<ExcelRowInfoModel>> formualRelSheetMap, ExcelRowInfoModel excelRowInfo, Map<String, List<ExcelRowInfoModel>> relSheetMap, String relValue, String sheetName) {
        formualRelSheetMap.clear();
        if (!CommonUtils.isNull(relSheetMap)) {
            formualRelSheetMap.put(ExcelConvertHelper.buildSheetValueMapKey(sheetName, relValue), Collections.singletonList(excelRowInfo));
            formualRelSheetMap.putAll(relSheetMap);
        }
    }

    private static Map<String, Map<String, List<DynamicObject>>> createbaseDataFieldValueMap(String targetId, List<ExcelRowInfoModel> batchesRowList, Map<String, IDataEntityProperty> propertyMap, Map<String, Map<String, List<ExcelRowInfoModel>>> relSheetRowFieldMap, String relSheetField) {
        if (CommonUtils.isNull(batchesRowList)) {
            return new HashMap<String, Map<String, List<DynamicObject>>>(0);
        }
        HashMap baseDataFieldValueMap = new HashMap(100);
        Iterator<ExcelRowInfoModel> iterator = batchesRowList.iterator();
        ArrayList<ExcelFieldMappingInfoModel> baseDataFieldMappingList = new ArrayList<ExcelFieldMappingInfoModel>(100);
        HashMap<String, List<ExcelRowInfoModel>> relSheetMap = new HashMap<String, List<ExcelRowInfoModel>>(16);
        HashMap<String, List<ExcelRowInfoModel>> formualRelSheetMap = new HashMap<String, List<ExcelRowInfoModel>>(16);
        while (iterator.hasNext()) {
            ExcelRowInfoModel excelRowInfo = iterator.next();
            List<ExcelFieldMappingInfoModel> excelFieldInfoModelList = excelRowInfo.getExcelFieldInfoModelList();
            String relValue = ExcelConvertHelper.getRelSheetMap(excelRowInfo, relSheetRowFieldMap, excelFieldInfoModelList, relSheetField, relSheetMap);
            ExcelConvertHelper.putFormualRelSheetMap(formualRelSheetMap, excelRowInfo, relSheetMap, relValue, excelFieldInfoModelList.get(0).getSheetName());
            for (ExcelFieldMappingInfoModel fieldMapInfo : excelFieldInfoModelList) {
                IDataEntityProperty property;
                if (StringUtil.isEmpty(fieldMapInfo.getStdFieldKey()) || !((property = propertyMap.get(fieldMapInfo.getStdFieldKey().split("\\.")[0])) instanceof IBasedataField)) continue;
                String entityId = ((IBasedataField)property).getBaseEntityId();
                String value = excelRowInfo.getFieldValue(fieldMapInfo, formualRelSheetMap);
                if (StringUtil.isEmpty(value)) continue;
                if (!baseDataFieldValueMap.containsKey(entityId)) {
                    baseDataFieldMappingList.add(fieldMapInfo);
                    HashSet<String> valueSet = new HashSet<String>(10000);
                    valueSet.add(value);
                    baseDataFieldValueMap.put(entityId, valueSet);
                    continue;
                }
                ((Set)baseDataFieldValueMap.get(entityId)).add(value);
            }
        }
        HashMap<String, Map<String, List<DynamicObject>>> baseDataValueMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        for (ExcelFieldMappingInfoModel fieldMapInfo : baseDataFieldMappingList) {
            String nameProp;
            BasedataEntityType baseDataEntityType;
            String numberProp;
            Map<String, List<DynamicObject>> baseDataMap;
            IDataEntityProperty property = propertyMap.get(fieldMapInfo.getStdFieldKey().split("\\.")[0]);
            String entityId = ((IBasedataField)property).getBaseEntityId();
            Set valueSet = (Set)baseDataFieldValueMap.get(entityId);
            if (baseDataValueMap.containsKey(entityId) || CommonUtils.isNull(baseDataMap = ExcelConvertHelper.getBaseDataByNumberOrName(targetId, entityId, valueSet, property, numberProp = StringUtils.isEmpty((String)(baseDataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId)).getNumberProperty()) ? "number" : baseDataEntityType.getNumberProperty(), nameProp = StringUtils.isEmpty((String)baseDataEntityType.getNameProperty()) ? "name" : baseDataEntityType.getNameProperty()))) continue;
            baseDataValueMap.put(entityId, baseDataMap);
        }
        return baseDataValueMap;
    }

    private static List<String> parseSheetList(String sheetNames) {
        if (sheetNames.startsWith(",")) {
            sheetNames = sheetNames.replaceFirst(",", "");
        }
        return Arrays.asList(sheetNames.split(","));
    }

    public static Map<String, List<ExcelFieldMappingInfoModel>> createcustomFieldMap(DynamicObject entryTargetObj, StdTemplateReadInfoModel stdImportSchemeTemplate, ImportTemplateReadInfoModel templateReadInfoModel, Tuple<Boolean, String> mainSheetResp) {
        List<String> sheetList = ExcelConvertHelper.parseSheetList(entryTargetObj.getString("sourcesheet"));
        Map<String, ExcelFieldInfoModel> sheetColumnValueMap = ExcelConvertHelper.diyTemplateDataPrepare(templateReadInfoModel, sheetList);
        Map<String, ExcelFieldInfoModel> sheetformulaColumnMap = ExcelConvertHelper.diyTemplateDataPrepareByFormula(templateReadInfoModel, sheetList);
        HashMap<String, List<ExcelFieldMappingInfoModel>> customFieldMap = new HashMap<String, List<ExcelFieldMappingInfoModel>>(stdImportSchemeTemplate.getKeyFieldList().size());
        DynamicObjectCollection subEntryColl = entryTargetObj.getDynamicObjectCollection("subentryentity");
        String targetId = entryTargetObj.getDynamicObject("billentity").getString("target_formid");
        for (DynamicObject fieldMappingObj : subEntryColl) {
            String cutomeField = fieldMappingObj.getString("textfield");
            String expression = fieldMappingObj.getString("formula_tag");
            if (StringUtils.isEmpty((String)cutomeField) && StringUtils.isEmpty((String)expression)) continue;
            ExcelFieldMappingInfoModel mappinfoModel = ExcelFieldMappingInfoModel.getInstance();
            String sheetName = cutomeField.split("\\.")[0].trim();
            if (!StringUtils.isEmpty((String)cutomeField)) {
                if (!((Boolean)mainSheetResp.item1).booleanValue()) {
                    sheetName = (String)mainSheetResp.item2;
                    cutomeField = ExcelConvertHelper.buildSheetValueMapKey(sheetName, cutomeField);
                }
                ExcelFieldInfoModel fieldMode = sheetColumnValueMap.get(cutomeField);
                mappinfoModel.setExcelFieldMappingInfoModel(cutomeField, fieldMode.getColumn(), "");
                mappinfoModel.setSheetName(fieldMode.getSheetName());
            } else if (!StringUtils.isEmpty((String)expression)) {
                sheetName = (String)mainSheetResp.item2;
                CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)expression, CRFormula.class);
                expression = formula.getExpression();
                String[] vars = FormulaEngine.extractVariables((String)expression);
                HashMap<String, List<ExcelFieldMappingInfoModel>> expressionFieldMap = new HashMap<String, List<ExcelFieldMappingInfoModel>>(16);
                for (String var : vars) {
                    List<ExcelFieldMappingInfoModel> expressionFieldList;
                    if (!sheetformulaColumnMap.containsKey(var)) continue;
                    ExcelFieldInfoModel fieldMode = sheetformulaColumnMap.get(var);
                    String formulaSheetName = fieldMode.getSheetName();
                    if (!expressionFieldMap.containsKey(formulaSheetName)) {
                        expressionFieldList = new ArrayList(16);
                        expressionFieldMap.put(formulaSheetName, expressionFieldList);
                    } else {
                        expressionFieldList = (List)expressionFieldMap.get(formulaSheetName);
                    }
                    ExcelFieldMappingInfoModel formulaMappinfoModel = ExcelFieldMappingInfoModel.getInstance();
                    formulaMappinfoModel.setExcelFieldMappingInfoModel(var, fieldMode.getColumn(), expression);
                    formulaMappinfoModel.setSheetName(fieldMode.getSheetName());
                    expressionFieldList.add(formulaMappinfoModel);
                }
                mappinfoModel.setExpressionFieldMap(expressionFieldMap);
                mappinfoModel.setExcelFieldMappingInfoModel("", 0, expression);
                mappinfoModel.setSheetName(sheetName);
            }
            String standardField = fieldMappingObj.getString("fieldnumber");
            for (ExcelFieldInfoModel stdFieldInfo : stdImportSchemeTemplate.getKeyFieldList()) {
                String stdKeyId = stdFieldInfo.getValue().split("\\.")[0];
                if (!standardField.equals(stdKeyId)) continue;
                mappinfoModel.setStdFieldKey(stdFieldInfo.getValue());
                mappinfoModel.setStdFieldName(fieldMappingObj.getString("fieldname"));
                mappinfoModel.setStdColumnIndex(stdFieldInfo.getColumn());
                mappinfoModel.setFieldEntry(stdImportSchemeTemplate.isFieldEntry(targetId, stdFieldInfo));
                break;
            }
            if (customFieldMap.containsKey(sheetName)) {
                ((List)customFieldMap.get(sheetName)).add(mappinfoModel);
                continue;
            }
            ArrayList<ExcelFieldMappingInfoModel> list = new ArrayList<ExcelFieldMappingInfoModel>(subEntryColl.size());
            list.add(mappinfoModel);
            customFieldMap.put(sheetName, list);
        }
        for (Map.Entry mapEntry : customFieldMap.entrySet()) {
            String customFieldKey;
            String relSheetField = entryTargetObj.getString("relpropname");
            if (!StringUtil.isNotEmpty(relSheetField) || !sheetColumnValueMap.containsKey(customFieldKey = ExcelConvertHelper.buildSheetValueMapKey((String)mapEntry.getKey(), relSheetField))) continue;
            int columnIndex = sheetColumnValueMap.get(customFieldKey).getColumn();
            ExcelFieldMappingInfoModel relMappinfoModel = ExcelFieldMappingInfoModel.getInstance();
            relMappinfoModel.setExcelFieldMappingInfoModel(customFieldKey, columnIndex, "");
            ((List)mapEntry.getValue()).add(relMappinfoModel);
        }
        return customFieldMap;
    }

    private static File writeWorkbook(SXSSFWorkbook workbook, String targetId, String targetName) throws DmwImptException {
        try {
            String dirName = String.format("%s_%s", targetId, String.valueOf(System.currentTimeMillis()));
            File downloadDir = ImptFileUtils.createTempDir(dirName);
            File dFile = new File(downloadDir.getAbsolutePath() + File.separator + targetId + "_" + targetName + "_" + System.currentTimeMillis() + XLSX);
            if (dFile.exists()) {
                FileUtils.delete((File)dFile);
            }
            dFile.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(dFile);){
                workbook.write((OutputStream)fos);
            }
            return dFile;
        }
        catch (Exception e) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u5199\u5165\u5168\u91cf\u6570\u636e\u6a21\u677f\u5931\u8d25\u3002", (String)"ExcelConvertHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), 3001);
        }
    }

    private static void setCellByStdKeyFieldModifierAction(SXSSFSheet sheetAt, List<ExcelFieldInfoModel> fieldInfoModelList) {
        for (ExcelFieldInfoModel excelModel : fieldInfoModelList) {
            SXSSFCell cell;
            int rowIndex = excelModel.getRow();
            int columnIndex = excelModel.getColumn();
            String value = excelModel.getValue();
            SXSSFRow row = sheetAt.getRow(rowIndex);
            if (row == null) {
                row = sheetAt.createRow(rowIndex);
            }
            if ((cell = row.getCell(columnIndex)) == null) {
                cell = row.createCell(columnIndex);
            }
            cell.setCellValue(value);
        }
    }

    private static int createRowByRelSheet(int writeIndex, Map<String, List<ExcelRowInfoModel>> relSheetMap, SXSSFSheet sheetAt, String targetFormId, Map<String, IDataEntityProperty> propertyMap, Map<String, Map<String, List<DynamicObject>>> baseDataValueMap, Map<String, List<ExcelRowInfoModel>> formualRelSheetMap) {
        int maxRows = 0;
        for (Map.Entry<String, List<ExcelRowInfoModel>> mapEntry : relSheetMap.entrySet()) {
            List<ExcelRowInfoModel> relRowInfoList = mapEntry.getValue();
            int relWriteIndex = writeIndex;
            for (ExcelRowInfoModel rowInfo : relRowInfoList) {
                boolean isFieldEntry = false;
                List<ExcelFieldMappingInfoModel> excelFieldInfoModelList = rowInfo.getExcelFieldInfoModelList();
                for (ExcelFieldMappingInfoModel fieldMapInfo : excelFieldInfoModelList) {
                    SXSSFCell cell;
                    if (StringUtil.isEmpty(fieldMapInfo.getStdFieldKey())) continue;
                    IDataEntityProperty property = propertyMap.get(fieldMapInfo.getStdFieldKey().split("\\.")[0]);
                    ExcelFieldInfoModel excelModel = ExcelConvertHelper.buildWriteExcelInfoModel(targetFormId, relWriteIndex, fieldMapInfo.getStdColumnIndex(), rowInfo.getFieldValue(fieldMapInfo, formualRelSheetMap), property, fieldMapInfo.getStdFieldKey(), baseDataValueMap);
                    SXSSFRow createRow = sheetAt.getRow(excelModel.getRow());
                    if (createRow == null) {
                        createRow = sheetAt.createRow(excelModel.getRow());
                    }
                    if ((cell = createRow.getCell(excelModel.getColumn())) == null) {
                        cell = createRow.createCell(excelModel.getColumn());
                    }
                    cell.setCellValue(excelModel.getValue());
                    isFieldEntry = fieldMapInfo.isFieldEntry();
                }
                if (!isFieldEntry) continue;
                ++relWriteIndex;
                maxRows = Math.max(maxRows, relRowInfoList.size() - 1);
            }
        }
        return maxRows;
    }

    public static Map<String, ExcelFieldInfoModel> diyTemplateDataPrepare(ImportTemplateReadInfoModel infoModel, List<String> sheetNameList) {
        if (infoModel == null || infoModel.getSheetTemplateMap() == null || infoModel.getSheetTemplateMap().isEmpty() || sheetNameList == null || sheetNameList.isEmpty()) {
            return new HashMap<String, ExcelFieldInfoModel>(0);
        }
        HashMap<String, ExcelFieldInfoModel> sheetColumnValueMap = new HashMap<String, ExcelFieldInfoModel>(16);
        for (Map.Entry<String, List<ExcelFieldInfoModel>> entry : infoModel.getSheetTemplateMap().entrySet()) {
            String sheetName = entry.getKey();
            if (!sheetNameList.contains(sheetName)) continue;
            for (ExcelFieldInfoModel columnEntry : entry.getValue()) {
                String columnValueKey = ExcelConvertHelper.buildSheetValueMapKey(sheetName, columnEntry.getValue());
                sheetColumnValueMap.put(columnValueKey, columnEntry);
            }
        }
        return sheetColumnValueMap;
    }

    private static Map<String, ExcelFieldInfoModel> diyTemplateDataPrepareByFormula(ImportTemplateReadInfoModel infoModel, List<String> sheetNameList) {
        if (infoModel == null || infoModel.getSheetTemplateMap() == null || infoModel.getSheetTemplateMap().isEmpty() || sheetNameList == null || sheetNameList.isEmpty()) {
            return new HashMap<String, ExcelFieldInfoModel>(0);
        }
        HashMap<String, ExcelFieldInfoModel> sheetColumnValueMap = new HashMap<String, ExcelFieldInfoModel>(16);
        for (Map.Entry<String, List<ExcelFieldInfoModel>> entry : infoModel.getSheetTemplateMap().entrySet()) {
            String sheetName = entry.getKey();
            if (!sheetNameList.contains(sheetName)) continue;
            for (ExcelFieldInfoModel columnEntry : entry.getValue()) {
                String columnValueKey = ExcelConvertHelper.buildSheetValueMapKey(columnEntry.getSheetNumber(), columnEntry.getColumnLetter());
                sheetColumnValueMap.put(columnValueKey, columnEntry);
            }
        }
        return sheetColumnValueMap;
    }

    public static String buildSheetValueMapKey(String sheetName, String value) {
        return String.join((CharSequence)".", sheetName, value);
    }

    public static Map<String, String> buildStdKeyMapping(DynamicObjectCollection fieldMappingCollection) {
        HashMap<String, String> keyFiledMap = new HashMap<String, String>(fieldMappingCollection.size());
        for (DynamicObject fieldMappingObj : fieldMappingCollection) {
            keyFiledMap.put(fieldMappingObj.getString("fieldnumber"), fieldMappingObj.getString("textfield"));
        }
        return keyFiledMap;
    }

    public static Tuple<Boolean, String> confirmMainSheet(String sheetNames, List<ExcelFieldInfoModel> keyFieldModelList, Map<String, String> fieldMappingMap) {
        String[] sheetNameArray;
        if (sheetNames.startsWith(",")) {
            sheetNames = sheetNames.replaceFirst(",", "");
        }
        if ((sheetNameArray = sheetNames.split(",")).length == 1) {
            return Tuple.create((Object)Boolean.FALSE, (Object)sheetNameArray[0]);
        }
        for (int i = 0; i < keyFieldModelList.size(); ++i) {
            ExcelFieldInfoModel model = keyFieldModelList.get(i);
            String docValue = fieldMappingMap.get(model.getValue().split("\\.")[0]);
            if (StringUtils.isEmpty((String)docValue)) continue;
            return Tuple.create((Object)Boolean.TRUE, (Object)docValue.split("\\.")[0]);
        }
        return Tuple.create((Object)Boolean.FALSE, (Object)sheetNames);
    }

    private static Map<String, List<DynamicObject>> getBaseDataByNumberOrName(String formId, String entityId, Set<String> valueSet, IDataEntityProperty keyProperty, String numberProp, String nameProp) {
        if (CommonUtils.isNull(valueSet)) {
            return new HashMap<String, List<DynamicObject>>(0);
        }
        String selectFields = String.join((CharSequence)",", numberProp, nameProp);
        QFilter filter = new QFilter(numberProp, "in", valueSet);
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])filter.toArray());
        HashMap<String, List<DynamicObject>> baseDataMap = new HashMap<String, List<DynamicObject>>(1000);
        if (!CommonUtils.isNull(dynColl)) {
            for (DynamicObject dynamicObject : dynColl) {
                valueSet.remove(dynamicObject.getString(numberProp));
            }
            baseDataMap.putAll(dynColl.stream().collect(Collectors.groupingBy(o -> o.getString(numberProp))));
        }
        if (!CommonUtils.isNull(valueSet)) {
            filter = new QFilter(nameProp, "in", valueSet);
            if (keyProperty instanceof OrgProp) {
                String orgFunc = ((OrgProp)keyProperty).getOrgFunc();
                int structureView = 15;
                if ("01".equals(orgFunc)) {
                    structureView = 1;
                }
                filter = filter.and(new QFilter("structure.view", "=", (Object)structureView));
            } else if ("bd_address".equals(formId) && "bos_org".equals(entityId)) {
                filter = filter.and(new QFilter("structure.view", "=", (Object)15));
            }
            DynamicObjectCollection dynDataColl = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])filter.toArray());
            baseDataMap.putAll(dynDataColl.stream().collect(Collectors.groupingBy(o -> o.getString(nameProp))));
        }
        return baseDataMap;
    }

    public static ExcelFieldInfoModel buildWriteExcelInfoModel(String targetId, int writeRowIndex, int writeColumnIndex, String fillValue, IDataEntityProperty property, String keyField, Map<String, Map<String, List<DynamicObject>>> baseDataValueMap) {
        ExcelFieldInfoModel writeFieldInfoModel = ExcelFieldInfoModel.getInstance();
        writeFieldInfoModel.setRow(writeRowIndex);
        writeFieldInfoModel.setColumn(writeColumnIndex);
        if (property instanceof IBasedataField && !StringUtil.isEmpty(fillValue)) {
            String baseDataField = keyField.split("\\.")[1].trim();
            String entityId = ((IBasedataField)property).getBaseEntityId();
            BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
            String numberProp = StringUtils.isEmpty((String)dataEntityType.getNumberProperty()) ? "number" : dataEntityType.getNumberProperty();
            List<DynamicObject> baseDataValueList = null;
            if (baseDataValueMap.containsKey(entityId)) {
                baseDataValueList = baseDataValueMap.get(entityId).get(fillValue);
            }
            if (baseDataValueList == null || CommonUtils.isNull(baseDataValueList)) {
                if (baseDataField.equals(numberProp)) {
                    writeFieldInfoModel.setValue(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6b63\u786e[%1$s]\u57fa\u7840\u8d44\u6599\u7f16\u7801\uff0c\u627e\u5230[%2$d]\u4e2a[%3$s]\u7684\u57fa\u7840\u8d44\u6599", (String)"ExcelConvertHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), fillValue, 0, fillValue));
                } else {
                    writeFieldInfoModel.setValue(fillValue);
                }
                return writeFieldInfoModel;
            }
            if (baseDataValueList.size() > 1) {
                if (baseDataField.equals(numberProp)) {
                    String confirmNumber = ExcelConvertHelper.confirmNumber(baseDataValueList, numberProp);
                    if (StringUtils.isEmpty((String)confirmNumber)) {
                        writeFieldInfoModel.setValue(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6b63\u786e[%1$s]\u57fa\u7840\u8d44\u6599\u7f16\u7801\uff0c\u627e\u5230[%2$d]\u4e2a[%3$s]\u7684\u57fa\u7840\u8d44\u6599", (String)"ExcelConvertHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), fillValue, baseDataValueList.size(), fillValue));
                    } else {
                        writeFieldInfoModel.setValue(confirmNumber);
                    }
                } else {
                    writeFieldInfoModel.setValue(String.valueOf(baseDataValueList.get(0).get(baseDataField)));
                }
                return writeFieldInfoModel;
            }
            fillValue = String.valueOf(baseDataValueList.get(0).get(baseDataField));
        }
        writeFieldInfoModel.setValue(fillValue);
        return writeFieldInfoModel;
    }

    private static String confirmNumber(List<DynamicObject> dataValueList, String numberProp) {
        if (dataValueList == null || dataValueList.isEmpty()) {
            return null;
        }
        String resp = null;
        for (DynamicObject dataValue : dataValueList) {
            String tempResp = String.valueOf(dataValue.getString(numberProp));
            if (resp == null) {
                resp = tempResp;
                continue;
            }
            if (resp.equals(tempResp)) continue;
            return null;
        }
        return resp;
    }

    private static List<ExcelFieldInfoModel> doStdKeyFieldModifierAction(StdTemplateReadInfoModel stdImportSchemeTemplate, String formId) {
        List<ExcelFieldInfoModel> keyFieldList = stdImportSchemeTemplate.getKeyFieldList();
        if (keyFieldList == null || keyFieldList.isEmpty()) {
            return new ArrayList<ExcelFieldInfoModel>(0);
        }
        DynamicObject impTargetDyObj = TemplateMappingHelper.getImportTargetDyByFormId(formId);
        if (impTargetDyObj == null) {
            return new ArrayList<ExcelFieldInfoModel>(0);
        }
        IFieldModifier iFieldModifier = FieldModifierBuilderFactory.getDataCheckerWithClassName(impTargetDyObj.getString("importcode").split("\\.")[0]);
        if (iFieldModifier == null) {
            return new ArrayList<ExcelFieldInfoModel>(0);
        }
        ArrayList<ExcelFieldInfoModel> modifierKeyFieldList = new ArrayList<ExcelFieldInfoModel>(4);
        List<ExcelFieldInfoModel> nameFieldList = stdImportSchemeTemplate.getNameFieldList();
        int size = keyFieldList.size();
        for (int i = 0; i < size; ++i) {
            String stdKeyId = keyFieldList.get(i).getValue().split("\\.")[0];
            Tuple tupleResult = iFieldModifier.needModify(formId, stdKeyId);
            if (tupleResult == null || tupleResult.item1 == null || !(tupleResult.item1 instanceof Boolean) || !((Boolean)tupleResult.item1).booleanValue() || tupleResult.item2 == null || !(tupleResult.item2 instanceof Boolean)) continue;
            boolean needRecord = (Boolean)tupleResult.item2;
            ExcelFieldInfoModel model = nameFieldList.get(i);
            if (needRecord) {
                model.setValue("*" + model.getValue());
            } else {
                model.setValue(model.getValue().replaceFirst("\\*", ""));
            }
            modifierKeyFieldList.add(model);
        }
        return modifierKeyFieldList;
    }
}

