/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.result.ImportSimpleResult;
import kd.imsc.dmw.engine.multiimport.result.ImportTotalResult;

public class ImportServiceManagerHelper {
    private static final Log logger = LogFactory.getLog(ImportServiceManagerHelper.class);
    private static final ThreadLocal<Long> threadLocal = new ThreadLocal();

    public static String createAndCommitTaskJob(String appId, String taskName, String taskClassName, Map<String, Object> params) {
        JobInfo jobInfo = ImportServiceManagerHelper.buildJobInfo(appId, taskName, taskClassName, params);
        if (jobInfo == null) {
            return null;
        }
        return ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    public static JobInfo buildJobInfo(String appId, String taskName, String taskClassName) {
        return ImportServiceManagerHelper.buildJobInfo(appId, taskName, taskClassName, null);
    }

    public static void buildAndCommitJobFormInfo(IFormView iFormView, long takeId, String appId, String taskName, String taskClassName, String clickClassName, Map<String, Object> params, CloseCallBack closeCallBack) {
        threadLocal.set(takeId);
        JobFormInfo jobFormInfo = ImportServiceManagerHelper.buildJobFormInfo(appId, taskName, taskClassName, clickClassName, params, closeCallBack);
        ImportServiceManagerHelper.dispatchJobFromInfo(jobFormInfo, iFormView);
        threadLocal.remove();
    }

    private static JobFormInfo buildJobFormInfo(String appId, String taskName, String taskClassName, String clickClassName, Map<String, Object> params, CloseCallBack closeCallBack) {
        JobInfo jobInfo = ImportServiceManagerHelper.buildJobInfo(appId, taskName, taskClassName, params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(clickClassName);
        jobFormInfo.setCloseCallBack(closeCallBack);
        return jobFormInfo;
    }

    private static void dispatchJobFromInfo(JobFormInfo jobFormInfo, IFormView view) {
        if (view == null) {
            return;
        }
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("dmw_impserviceprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((String)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isNotEmpty((String)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("im_j_i", jobInfoStr);
        showParameter.getCustomParams().put("im_t_id", threadLocal.get());
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    public static JobInfo buildJobInfo(String appId, String taskName, String taskClassName, Map<String, Object> params) {
        if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)taskName) || StringUtils.isEmpty((String)taskClassName)) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setAppId(appId);
        jobInfo.setName(taskName);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        if (params != null && !params.isEmpty()) {
            jobInfo.setParams(params);
        }
        return jobInfo;
    }

    public static void stopTaskById(String taskId) {
        if (StringUtils.isEmpty((String)taskId)) {
            return;
        }
        ScheduleServiceHelper.stopTask((String)taskId);
    }

    public static TaskInfo getTaskInfoById(String taskId) {
        if (StringUtils.isEmpty((String)taskId)) {
            return null;
        }
        return ScheduleServiceHelper.queryTask((String)taskId);
    }

    public static ImportTotalResult getImportResultByTaskId(String taskId) {
        TaskInfo taskInfo = ImportServiceManagerHelper.getTaskInfoById(taskId);
        if (taskInfo == null) {
            return null;
        }
        ImportTotalResult result = new ImportTotalResult();
        result.setTotalProgress(taskInfo.getProgress());
        String infoData = taskInfo.getData();
        if (StringUtils.isEmpty((String)infoData)) {
            if (taskInfo.getProgress() == 100) {
                result.setCode(-1);
                result.setMsg("FeedInfoData is null!");
                return result;
            }
            result.setCode(200);
            return result;
        }
        result.setCode(200);
        try {
            JSONObject dataObj = JSON.parseObject((String)infoData);
            Object fCode = dataObj.remove((Object)"FCODE");
            Object msg = dataObj.remove((Object)"MSG");
            result.setCode(fCode == null ? 200 : (Integer)fCode);
            result.setMsg(msg == null ? "" : (String)msg);
            Set entries = dataObj.entrySet();
            HashMap<String, ImportSimpleResult> resp = new HashMap<String, ImportSimpleResult>(entries.size());
            for (Map.Entry entry : entries) {
                JSONObject value = (JSONObject)entry.getValue();
                ImportSimpleResult simpleResult = (ImportSimpleResult)value.toJavaObject(ImportSimpleResult.class);
                resp.put((String)entry.getKey(), simpleResult);
            }
            result.setImportMap(resp);
        }
        catch (Exception e) {
            logger.warn("infoData {}", (Object)infoData);
        }
        return result;
    }
}

