/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;

public class DynamicFlexPanelControlProxy {
    public static final String FBASEDATAID = "fbasedataid";
    private static final String MAPPING_PRE = "mapping#";
    private static final String MAPPING_VIEW_INIT = "init#";

    public static Tuple<List<String>, List<String>> spiltControlKeys(List<String> curControlList, List<String> selectedControlList) {
        if (curControlList == null || curControlList.isEmpty()) {
            return Tuple.create(null, null);
        }
        if (selectedControlList == null || selectedControlList.isEmpty()) {
            return Tuple.create(curControlList, new ArrayList());
        }
        ArrayList<String> deleteKeyList = new ArrayList<String>(curControlList.size());
        ArrayList<String> saveKeyList = new ArrayList<String>(curControlList.size());
        for (String controlKey : curControlList) {
            if (!selectedControlList.contains(controlKey)) {
                deleteKeyList.add(controlKey);
                continue;
            }
            saveKeyList.add(controlKey);
        }
        return Tuple.create(deleteKeyList, saveKeyList);
    }

    public static List<String> getSelectControlKeys(DynamicObjectCollection collection) {
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> keyList = new ArrayList<String>(collection.size());
        for (DynamicObject target : collection) {
            DynamicObject targetInfoObj = target.getDynamicObject(FBASEDATAID);
            String labelKey = DynamicFlexPanelControlProxy.getLabelTemplateKey(targetInfoObj.getString("target_formid"));
            String mappingKey = DynamicFlexPanelControlProxy.getMappingTemplateKey(targetInfoObj.getString("target_formid"));
            keyList.add(labelKey);
            keyList.add(mappingKey);
        }
        return keyList;
    }

    public static String getLabelTemplateKey(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return "";
        }
        return String.format("label_%s", formId);
    }

    public static String getMappingTemplateKey(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return "";
        }
        return String.format("%s%s", MAPPING_PRE, formId);
    }

    public static String getFormIdWithMappingTemplateKey(String templateKey) {
        if (StringUtils.isEmpty((String)templateKey)) {
            return "";
        }
        if (!templateKey.startsWith(MAPPING_PRE)) {
            return templateKey;
        }
        return templateKey.replaceFirst(MAPPING_PRE, "");
    }

    public static String getFormIdInitEndKey(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return "";
        }
        return String.format("%s%s", MAPPING_VIEW_INIT, formId);
    }
}

