/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.util.StringUtils;

public class MigrateLogTableHelper {
    private static final String INSERT_SQL = "insert into t_dmw_checklog (fid,fcreatetime,fbatch,fkey,fvalue,ftranceid) values (?,?,?,?,?,?)";
    private static final String SELECT_SQL = "select fid,fbatch,fkey,fvalue from t_dmw_checklog where fbatch = ? ";
    private static final String DELETE_SQL = "delete from  t_dmw_checklog where  fbatch = ? ";

    public static void insertBatch(List<Object[]> list) {
        DB.executeBatch((DBRoute)new DBRoute("imsc"), (String)INSERT_SQL, list);
    }

    public static List<String> query(String batchKey) {
        if (StringUtils.isEmpty((String)batchKey)) {
            return Collections.emptyList();
        }
        return (List)DB.query((DBRoute)new DBRoute("imsc"), (String)SELECT_SQL, (Object[])new Object[]{batchKey}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet resultSet) throws Exception {
                ArrayList<String> list = new ArrayList<String>(16);
                while (resultSet.next()) {
                    String value = resultSet.getString("fvalue");
                    list.add(value);
                }
                return list;
            }
        });
    }

    public static void delete(String batchKey) {
        if (StringUtils.isEmpty((String)batchKey)) {
            return;
        }
        DB.execute((DBRoute)new DBRoute("imsc"), (String)DELETE_SQL, (Object[])new Object[]{batchKey});
    }
}

