/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.engine.multiimport.model.ImportTargetSchemeInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.alerter.DataAlerterFactory;
import kd.imsc.dmw.helper.alerter.FieldModifyAlerter;
import kd.imsc.dmw.helper.alerter.IDataAlerter;
import kd.imsc.dmw.helper.checker.DataCheckerBuilderFactory;
import kd.imsc.dmw.helper.checker.DataTemplatePostChecker;
import kd.imsc.dmw.helper.checker.FieldMustMidChecker;
import kd.imsc.dmw.helper.checker.FieldValuePreChecker;
import kd.imsc.dmw.helper.checker.IDataChecker;
import kd.imsc.dmw.helper.checker.ImportFieldMidChecker;

public class MulImportCheckerProxy {
    private static final Log logger = LogFactory.getLog(MulImportCheckerProxy.class);
    private static final List<String> preDataCheckList = new ArrayList<String>();
    private static final List<String> midDataCheckList = new ArrayList<String>();
    private static final List<String> postDataCheckList = new ArrayList<String>();
    private static final List<String> dataAlertList = new ArrayList<String>();

    private MulImportCheckerProxy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImportTemplateReadInfoModel parseTemplateInfoByUrlWithTempFileCache(String url, int rowIndex) throws DmwImptException {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        try (InputStream inputStream = MultiImpAttachmentHelper.getAttachmentInputStreamFromUrl(url);){
            ImportTemplateReadInfoModel importTemplateReadInfoModel = MulImportCheckerProxy.getImportTemplateReadInfoModel(rowIndex, inputStream);
            return importTemplateReadInfoModel;
        }
        catch (IOException e) {
            throw new DmwImptException(String.format("Download [%1s] exception [%2s]", url, e.getMessage()), (Throwable)e, 2001);
        }
    }

    public static ImportTemplateReadInfoModel parseTemplateInfoByUrlWithAttachFileCache(String url, int rowIndex) throws DmwImptException {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        return MulImportCheckerProxy.parseTemplateInfoByUrlWithTempFileCache(url, rowIndex);
    }

    /*
     * Exception decompiling
     */
    private static ImportTemplateReadInfoModel getImportTemplateReadInfoModel(int rowIndex, InputStream inputStream) throws DmwImptException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static BizOperationResult invokeSchemeMidDataCheck(String tarObj, DynamicObject fieldMappingObj) {
        BizOperationResult result = new BizOperationResult(true);
        StringBuilder checkMsg = new StringBuilder();
        for (String checkerName : midDataCheckList) {
            try {
                IDataChecker midChecker = DataCheckerBuilderFactory.getDataCheckerWithClassName(checkerName);
                midChecker.dataCheck(fieldMappingObj);
            }
            catch (DmwImptException e) {
                result.setSuccess(false);
                checkMsg.append(tarObj).append(": ").append(e.getMessage()).append("\r\n");
            }
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    public static BizOperationResult invokePostDataChecker(InputStream inputStream, String temInfo) {
        BizOperationResult result = new BizOperationResult(true);
        StringBuilder checkMsg = new StringBuilder();
        for (String checkerName : postDataCheckList) {
            try {
                Tuple tuple = Tuple.create((Object)inputStream, (Object)temInfo);
                IDataChecker postChecker = DataCheckerBuilderFactory.getDataCheckerWithClassName(checkerName);
                postChecker.dataCheck(tuple);
            }
            catch (DmwImptException e) {
                result.setSuccess(false);
                checkMsg.append(e.getMessage()).append("\r\n");
            }
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    public static BizOperationResult invokeDataAlerter(List<ImportTargetSchemeInfoModel> infoModelList) {
        BizOperationResult result = new BizOperationResult(true);
        if (infoModelList == null || infoModelList.isEmpty()) {
            return result;
        }
        HashMap<String, List> alertResultMap = new HashMap<String, List>(1);
        for (ImportTargetSchemeInfoModel infoModel : infoModelList) {
            for (String alerterName : dataAlertList) {
                IDataAlerter dataAlerter = DataAlerterFactory.getDataAlerterWithClassName(alerterName);
                Object resp = dataAlerter.dataAlert(infoModel);
                if (resp == null || StringUtils.isEmpty((String)((String)resp))) continue;
                List alertList = alertResultMap.getOrDefault(alerterName, new ArrayList());
                alertList.add(String.format("%1$s#%2$s", infoModel.getFormName(), resp));
                alertResultMap.put(alerterName, alertList);
                result.setSuccess(false);
            }
        }
        if (result.getSuccess()) {
            return result;
        }
        StringBuilder checkMsg = new StringBuilder();
        for (String alerterName : dataAlertList) {
            IDataAlerter dataAlerter = DataAlerterFactory.getDataAlerterWithClassName(alerterName);
            String msgFormat = dataAlerter.alertFormat((List)alertResultMap.get(alerterName));
            if (StringUtils.isEmpty((String)msgFormat)) continue;
            if (checkMsg.length() > 0) {
                checkMsg.append("\r\n");
            }
            checkMsg.append(msgFormat);
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    static {
        preDataCheckList.add(FieldValuePreChecker.class.getName());
        midDataCheckList.add(ImportFieldMidChecker.class.getName());
        midDataCheckList.add(FieldMustMidChecker.class.getName());
        postDataCheckList.add(DataTemplatePostChecker.class.getName());
        dataAlertList.add(FieldModifyAlerter.class.getName());
    }
}

